/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.dimension;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.EntityCtrlViewHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.DynamicControlHelper;
import kd.hr.hrcs.bussiness.util.PermPageCacheUtil;
import kd.hr.hrcs.common.constants.perm.DimGrpModel;
import kd.hr.hrcs.common.constants.perm.DimModel;
import kd.hr.hrcs.common.constants.perm.RoleDataPermModel;
import org.apache.commons.lang3.tuple.Pair;

@ExcludeFromJacocoGeneratedReport
public class DimensionHelper {
    private static final Log LOGGER = LogFactory.getLog(DimensionHelper.class);

    public static void initDimGrp(IFormView formView, String groupKey, List<String> dimNumberList, String hrbuFunc) {
        PageCache pageCache = new PageCache(formView.getPageId(), false);
        PermPageCacheUtil pageCacheUtil = new PermPageCacheUtil((IPageCache)pageCache);
        Map<String, RoleDataPermModel> roleDataPermModelMap = pageCacheUtil.getDataPermMap();
        List<DynamicObject> dimObjList = DynamicControlHelper.loadDimensionData(dimNumberList);
        RoleDataPermModel roleDataPermModel = roleDataPermModelMap.get(hrbuFunc);
        if (Objects.isNull(roleDataPermModel)) {
            roleDataPermModel = new RoleDataPermModel();
        }
        roleDataPermModel.setHrBuCaFunc(Long.parseLong(hrbuFunc));
        Map dimGroupMap = roleDataPermModel.getDimGroupMap();
        DimGrpModel dimGrpModel = (DimGrpModel)dimGroupMap.get(groupKey);
        if (CollectionUtils.isEmpty((Map)dimGroupMap) || Objects.isNull(dimGrpModel)) {
            dimGrpModel = new DimGrpModel();
            TreeMap<String, DimModel> dimMap = new TreeMap<String, DimModel>();
            dimGrpModel.setDimGroup(groupKey);
            dimGrpModel.setDimMap(dimMap);
            int i = 0;
            for (DynamicObject dimObj : dimObjList) {
                String dimId = dimObj.getString("id");
                String dimNumber = dimObj.getString("number");
                DimModel dimModel = new DimModel();
                dimModel.setSeq(i + 1);
                dimModel.setDimNumber(dimNumber);
                dimModel.setDimId(dimId);
                dimMap.put(dimNumber, dimModel);
                ++i;
            }
            dimGroupMap.put(groupKey, dimGrpModel);
        }
        roleDataPermModel.setDimGroupMap(dimGroupMap);
        pageCacheUtil.setDataPerm(roleDataPermModelMap);
    }

    public static void initDataPerm(IFormView formView, Map<String, RoleDataPermModel> roleDataPermMap) {
        PermPageCacheUtil pageCacheUtil = new PermPageCacheUtil(formView, false);
        Map<String, RoleDataPermModel> permDataMap = pageCacheUtil.getDataPermMap();
        roleDataPermMap.forEach((key, value) -> {
            RoleDataPermModel roleDataPermModel = (RoleDataPermModel)permDataMap.get(key);
            if (Objects.isNull(roleDataPermModel)) {
                permDataMap.put((String)key, (RoleDataPermModel)value);
            }
        });
        pageCacheUtil.setDataPerm(permDataMap);
    }

    public static String getHrbuFunc(IPageCache pageCache) {
        return pageCache.get("currentHRbuCaFunc");
    }

    public static void cacheDim(IFormView formView, String currentHRbuFunc, String dimensionGroup, String dimId, Map<String, Map<String, Object>> dimensionValue, Boolean notLimit) {
        DimensionHelper.cacheDim(formView, currentHRbuFunc, dimensionGroup, dimId, dimensionValue, notLimit, null);
    }

    public static void cacheDim(IFormView formView, String currentHRbuFunc, String dimensionGroup, String dimId, Map<String, Map<String, Object>> dimensionValue, Boolean notLimit, BiConsumer<DimModel, Map<String, Map<String, Object>>> consumer) {
        DimModel dimModel;
        boolean valueNull = Objects.isNull(notLimit) && Objects.isNull(dimensionValue);
        boolean keyNull = HRStringUtils.isEmpty((String)currentHRbuFunc) || HRStringUtils.isEmpty((String)dimensionGroup) || HRStringUtils.isEmpty((String)dimId);
        LOGGER.info("Cache dim. CurrentHRbuFunc: {}, dimensionGroup: {}, dimId: {}, dimensionValue: {}, notLimit: {}, valueNull: {}, keyNull: {}.", new Object[]{currentHRbuFunc, dimensionGroup, dimId, dimensionValue, notLimit, valueNull, keyNull});
        if (valueNull || keyNull) {
            return;
        }
        PermPageCacheUtil pageCacheUtil = new PermPageCacheUtil(formView, false);
        Map<String, RoleDataPermModel> dataPermMap = pageCacheUtil.getDataPermMap();
        RoleDataPermModel roleDataPermModel = dataPermMap.get(currentHRbuFunc);
        Map<String, Map<String, Object>> dimInfoMap = pageCacheUtil.getAssignedDimInfo();
        Map<String, Object> dimInfo = dimInfoMap.get(dimId);
        String dimNumber = (String)dimInfo.get("dimensionNumber");
        LOGGER.info("Got dataPermMap: {}, dimInfo: {}.", dataPermMap, dimInfo);
        if (Objects.isNull(roleDataPermModel)) {
            roleDataPermModel = new RoleDataPermModel();
            HashMap dimGroupMap = Maps.newHashMapWithExpectedSize((int)1);
            roleDataPermModel.setDimGroupMap((Map)dimGroupMap);
            DimGrpModel dimGrpModel = new DimGrpModel();
            dimGroupMap.put(dimensionGroup, dimGrpModel);
            TreeMap dimMap = Maps.newTreeMap();
            dimModel = new DimModel();
            dimModel.setDimId(dimId);
            dimModel.setDimNumber(dimNumber);
            dimMap.put(dimNumber, dimModel);
            dimGrpModel.setDimMap(dimMap);
        } else {
            Map dimGroupMap = roleDataPermModel.getDimGroupMap();
            DimGrpModel dimGrpModel = dimGroupMap.computeIfAbsent(dimensionGroup, key -> new DimGrpModel());
            TreeMap dimModelMap = Optional.ofNullable(dimGrpModel.getDimMap()).orElseGet(() -> new TreeMap());
            dimModel = (DimModel)dimModelMap.get(dimInfo.get("dimensionNumber"));
            if (dimModel == null) {
                dimModel = new DimModel();
                dimModel.setDimId(dimId);
                dimModel.setDimNumber(dimNumber);
                dimModelMap.put(dimNumber, dimModel);
                dimGrpModel.setDimMap(dimModelMap);
            }
        }
        if (HRStringUtils.isEmpty((String)dimModel.getDimNumber())) {
            dimModel.setDimNumber(dimNumber);
        }
        if (null != consumer) {
            consumer.accept(dimModel, dimensionValue);
        }
        if (Objects.nonNull(dimensionValue)) {
            dimModel.setDimValues(dimensionValue);
        }
        if (Objects.nonNull(notLimit)) {
            dimModel.setLimit(notLimit != false ? "1" : "0");
            if (notLimit.booleanValue()) {
                dimModel.setDimValues(null);
            }
        }
        dimModel.setDimId((String)dimInfo.get("dimId"));
        pageCacheUtil.setDataPerm(dataPermMap);
    }

    public static void deleteDimGrp(IFormView formView) {
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        String mainPageId = (String)formShowParameter.getCustomParam("mainPageId");
        IFormView mainFormView = formView.getView(mainPageId);
        PermPageCacheUtil pageCacheUtil = new PermPageCacheUtil(mainFormView, false);
        String dimensionGroup = (String)formShowParameter.getCustomParam("dimensionGroup");
        String currentHRbuFunc = (String)formShowParameter.getCustomParam("currentHRbuCaFunc");
        Map<String, RoleDataPermModel> roleDataPermMap = pageCacheUtil.getDataPermMap();
        roleDataPermMap.get(currentHRbuFunc).getDimGroupMap().remove(dimensionGroup);
        pageCacheUtil.setDataPerm(roleDataPermMap);
    }

    public static void addDimGrp(IFormView formView, String containerId) {
        String groupPanelId = DynamicControlHelper.genControlId("group");
        DimensionHelper.addDimGrp(formView, containerId, groupPanelId);
    }

    public static void addDimGrp(IFormView formView, String containerId, String groupPanelId) {
        String mainPageId = (String)formView.getFormShowParameter().getCustomParam("mainPageId");
        String currentHRbuFunc = (String)formView.getFormShowParameter().getCustomParam("currentHRbuCaFunc");
        String roleId = (String)formView.getFormShowParameter().getCustomParam("roleId");
        IFormView mainFormView = formView.getParentView();
        LOGGER.info("Got main page id: {}, main form view id: {}, currentHRbuFunc: {}.", new Object[]{mainPageId, mainFormView.getPageId(), currentHRbuFunc});
        PermPageCacheUtil permPageCacheUtil = new PermPageCacheUtil(mainFormView, false);
        Map<String, RoleDataPermModel> dataPermMap = permPageCacheUtil.getDataPermMap();
        RoleDataPermModel roleDataPermModel = dataPermMap.computeIfAbsent(currentHRbuFunc, key -> new RoleDataPermModel());
        Map roleDimRelatMap = roleDataPermModel.getRoleDimRelatDisableMap();
        Map<String, Map<String, Map<String, Object>>> assignedHrBuCaDim = permPageCacheUtil.getAssignedHrBuCaDim();
        Map<String, Map<String, Object>> dimMap = assignedHrBuCaDim.get(currentHRbuFunc);
        if (dimMap == null || CollectionUtils.isEmpty(dimMap.values())) {
            formView.setVisible(Boolean.FALSE, new String[]{"advconap1"});
            LOGGER.info("there is no available dimension.");
            return;
        }
        LOGGER.info("Got assignedHrBuCaDim: {}, dimMap: {}.", assignedHrBuCaDim, dimMap);
        Pair<Set<String>, List<String>> dimResult = DimensionHelper.getDimResult(dimMap, roleDimRelatMap, currentHRbuFunc, permPageCacheUtil, roleId);
        Set dimIds = (Set)dimResult.getKey();
        List dimNumberList = (List)dimResult.getValue();
        permPageCacheUtil.setDimResultSet(dimIds);
        if (dimNumberList.isEmpty()) {
            formView.setVisible(Boolean.FALSE, new String[]{"advconap1"});
            LOGGER.info("All dimension is disabled.");
            return;
        }
        LOGGER.info("Filter dimNumber result: {}.", (Object)dimNumberList);
        Container mainPanel = (Container)formView.getControl(containerId);
        FlexPanelAp groupPanel = DynamicControlHelper.createRowFlexPanelAp(groupPanelId, 1);
        groupPanel.setJustifyContent("flex-start");
        groupPanel.setAlignItems("flex-start");
        groupPanel.setWrap(false);
        String fieldPanelId = groupPanelId + "fieldPanel";
        FlexPanelAp fieldPanel = DynamicControlHelper.createRowFlexPanelAp(fieldPanelId, 1);
        ArrayList items = Lists.newArrayListWithExpectedSize((int)1);
        String controlPanelId = DynamicControlHelper.genControlId("flexpanelapsub");
        fieldPanel.setWidth(new LocaleString("90%"));
        groupPanel.getItems().add(fieldPanel);
        String viewStatus = (String)formView.getFormShowParameter().getCustomParam("viewStatus");
        LOGGER.info("Got view status: [{}].", (Object)viewStatus);
        if (!HRStringUtils.equals((String)"1", (String)viewStatus)) {
            FlexPanelAp controlPanel = DynamicControlHelper.createRowFlexPanelAp(groupPanelId + "controlpanel", 0);
            Map<String, Map<String, Object>> controlMap = permPageCacheUtil.getControlMap();
            HashMap control = Maps.newHashMapWithExpectedSize((int)4);
            control.put("dimensionGroup", groupPanelId);
            HashMap tempControlMap = Maps.newHashMapWithExpectedSize((int)2);
            tempControlMap.put("labelcopy" + controlPanelId, control);
            tempControlMap.put("labelremove" + controlPanelId, control);
            LOGGER.info("Current control map: {}, controlPanelId: {}, main page id: {}, main form view id: {}, currentHRbuFunc: {}.", new Object[]{controlMap, controlPanelId, mainPageId, mainFormView.getPageId(), currentHRbuFunc});
            controlMap.putAll(tempControlMap);
            permPageCacheUtil.setControlMap(controlMap);
            Map<String, List<String>> grpControlMap = permPageCacheUtil.getGrpControlMap();
            grpControlMap.put(groupPanelId, new ArrayList(tempControlMap.keySet()));
            permPageCacheUtil.setGrpControlMap(grpControlMap);
            controlPanel.setWrap(false);
            controlPanel.setJustifyContent("center");
            controlPanel.setAlignItems("center");
            controlPanel.setWidth(new LocaleString("120px"));
            Style style = new Style();
            Margin margin = new Margin();
            margin.setLeft("20px");
            style.setMargin(margin);
            controlPanel.setStyle(style);
            DynamicControlHelper.addLabelControl(controlPanelId, controlPanel);
            controlPanel.setGrow(1);
            controlPanel.setWidth(new LocaleString("10%"));
            controlPanel.setShrink(1);
            groupPanel.getItems().add(controlPanel);
        }
        items.add(groupPanel.createControl());
        mainPanel.addControls((List)items);
        formView.updateView(containerId);
        DimensionHelper.initDimGrp(mainFormView, groupPanelId, dimNumberList, currentHRbuFunc);
        LOGGER.info("Current dimNumberList: {}.", (Object)dimNumberList);
        HashMap customParams = Maps.newHashMapWithExpectedSize((int)3);
        customParams.put("dimension", dimNumberList);
        customParams.put("dimensionGroup", groupPanelId);
        customParams.put("mainPageId", mainPageId);
        customParams.put("currentHRbuCaFunc", currentHRbuFunc);
        customParams.put("viewStatus", viewStatus);
        customParams.put("custom_parent_f7_prop", "hrcs_role_f7");
        DimensionHelper.showFormInContainer(formView, "hrcs_dimgrpcontainer", fieldPanelId, customParams);
    }

    private static Pair<Set<String>, List<String>> getDimResult(Map<String, Map<String, Object>> dimMap, Map<String, Set<String>> roleDimRelatMap, String currentHRbuFunc, PermPageCacheUtil permPageCacheUtil, String roleId) {
        HashSet dimIds = new HashSet(dimMap.size());
        List dimNumberList = dimMap.values().stream().filter(it -> {
            String dimId = it.get("dimId").toString();
            Set disableEntitySet = roleDimRelatMap.getOrDefault(dimId, new HashSet(16));
            HashMap entityCtrlMap = Maps.newHashMapWithExpectedSize((int)16);
            EntityCtrlViewHelper.prepareDataForJudgement(currentHRbuFunc, Long.parseLong(dimId), entityCtrlMap, permPageCacheUtil, roleId);
            Set items = entityCtrlMap.entrySet().stream().map(item -> (String)((Map)item.getValue()).get("app") + ((String)item.getKey()).split("#")[0] + ((String)item.getKey()).split("#")[1]).collect(Collectors.toSet());
            return !disableEntitySet.containsAll(items);
        }).map(item -> {
            dimIds.add((String)item.get("dimId"));
            return (String)item.get("dimensionNumber");
        }).collect(Collectors.toList());
        return Pair.of(dimIds, dimNumberList);
    }

    public static Map<String, Set<String>> getDimIdResults(PermPageCacheUtil permPageCacheUtil, String roleId) {
        HashMap<String, Set<String>> results = new HashMap<String, Set<String>>(16);
        Map<String, Map<String, Map<String, Object>>> assignedHrBuCaDim = permPageCacheUtil.getAssignedHrBuCaDim();
        for (Map.Entry<String, Map<String, Map<String, Object>>> entry : assignedHrBuCaDim.entrySet()) {
            String currentHRbuFunc = entry.getKey();
            Map<String, Map<String, Object>> dimMap = assignedHrBuCaDim.get(currentHRbuFunc);
            if (dimMap == null || CollectionUtils.isEmpty(dimMap.values())) {
                LOGGER.info("there is no available dimension.");
                continue;
            }
            Map<String, RoleDataPermModel> dataPermMap = permPageCacheUtil.getDataPermMap();
            RoleDataPermModel roleDataPermModel = dataPermMap.computeIfAbsent(currentHRbuFunc, key -> new RoleDataPermModel());
            Map roleDimRelatMap = roleDataPermModel.getRoleDimRelatDisableMap();
            Pair<Set<String>, List<String>> pair = DimensionHelper.getDimResult(dimMap, roleDimRelatMap, currentHRbuFunc, permPageCacheUtil, roleId);
            results.put(currentHRbuFunc, (Set<String>)pair.getKey());
        }
        return results;
    }

    public static void showFormInContainer(IFormView formView, String formId, String containerKey, Map<String, Object> customParams) {
        HashMap param = Maps.newHashMapWithExpectedSize((int)1);
        param.put("formId", formId);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter((Map)param);
        if (!CollectionUtils.isEmpty(customParams)) {
            showParameter.setCustomParams(customParams);
        }
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(containerKey);
        formView.showForm(showParameter);
    }

    public static Map<String, RoleDataPermModel> getDataPermMap(IFormView formView) {
        PermPageCacheUtil pageCacheUtil = new PermPageCacheUtil(formView, false);
        return pageCacheUtil.getDataPermMap();
    }

    public static void addDimCardEntry(String entryContainerId, IFormView formView, PermPageCacheUtil permPageCacheUtil) {
        Map<String, Map<String, Object>> assignedHrBuCaMap = permPageCacheUtil.getAssignedHrBuCaMap();
        HRPageCache pageCache = new HRPageCache(formView);
        Container container = (Container)formView.getControl(entryContainerId);
        ArrayList items = Lists.newArrayListWithExpectedSize((int)1);
        Map<String, Map<String, Map<String, Object>>> realTimeBuCaFuncDim = permPageCacheUtil.getRealTimeBuCaFuncDim();
        List lastCtrlKeys = (List)pageCache.get("lastCtrlKeys", List.class);
        if (CollectionUtils.isEmpty((Collection)lastCtrlKeys)) {
            lastCtrlKeys = Lists.newArrayListWithExpectedSize((int)16);
        }
        String viewStatus = formView.getPageCache().get("viewStatus");
        String roleId = (String)formView.getFormShowParameter().getCustomParam("roleId");
        String mainPageId = formView.getPageId();
        LOGGER.info("Got Dim card info with assignedHrBuCaMap:[{}], realTimeBuCaFuncDim:[{}].", assignedHrBuCaMap, realTimeBuCaFuncDim);
        for (Map.Entry<String, Map<String, Object>> hrBuCaFuncEntry : assignedHrBuCaMap.entrySet()) {
            String hrBuCaFuncId = hrBuCaFuncEntry.getKey();
            Map<String, Object> buCaFuncInfo = hrBuCaFuncEntry.getValue();
            Map<String, Map<String, Object>> dimInfo = realTimeBuCaFuncDim.get(hrBuCaFuncId);
            if (CollectionUtils.isEmpty(dimInfo) || null == buCaFuncInfo) {
                LOGGER.info("Ignore null dimInfo with hrBuCaFuncId:[{}].", (Object)hrBuCaFuncId);
                continue;
            }
            String hrBuCaFuncName = (String)buCaFuncInfo.get("name");
            String cardEntryId = DynamicControlHelper.genControlId("dimsetting");
            FlexPanelAp fieldPanel = DynamicControlHelper.createRowFlexPanelAp(cardEntryId, 1, "column", "stretch", false);
            fieldPanel.setOverflow("visible");
            items.add(fieldPanel.createControl());
            HashMap customParams = Maps.newHashMapWithExpectedSize((int)3);
            customParams.put("mainPageId", mainPageId);
            customParams.put("roleId", roleId);
            customParams.put("currentHRbuCaFunc", hrBuCaFuncId);
            customParams.put("currentHRbuCaFuncName", hrBuCaFuncName);
            customParams.put("viewStatus", viewStatus);
            DimensionHelper.showFormInContainer(formView, "hrcs_dimcard", cardEntryId, customParams);
            lastCtrlKeys.add(cardEntryId);
        }
        pageCache.put("lastCtrlKeys", (Object)lastCtrlKeys);
        container.deleteControls(lastCtrlKeys.toArray(new String[0]));
        container.addControls((List)items);
        if (items.size() > 0) {
            formView.setVisible(Boolean.FALSE, new String[]{"tipspanel"});
            formView.setVisible(Boolean.TRUE, new String[]{"dimpanel"});
        } else {
            formView.setVisible(Boolean.TRUE, new String[]{"tipspanel"});
            formView.setVisible(Boolean.FALSE, new String[]{"dimpanel"});
        }
    }

    public static void loadRoleDimData(IFormView formView, String roleId, PermPageCacheUtil permPageCacheUtil) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_roledimension");
        DynamicObject[] roleDims = helper.query("bucafunc,dimension,dimension.name,dimension.number,dimension.showtype,dimension.datasource", new QFilter[]{new QFilter("role", "=", (Object)roleId)});
        HashMap buCaFuncDim = Maps.newHashMapWithExpectedSize((int)16);
        HashMap assignedHrBuCaDim = Maps.newHashMapWithExpectedSize((int)16);
        HashMap assignedDimInfo = Maps.newHashMapWithExpectedSize((int)16);
        HashMap buCaFuncDimTemp = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject roleDim : roleDims) {
            String buCaFuncId = roleDim.getString("bucafunc.id");
            String dimId = roleDim.getString("dimension.id");
            LOGGER.info("Got dim[id:{}, buCaFuncId: {}] from db with role[{}].", new Object[]{dimId, buCaFuncId, roleId});
            if (HRStringUtils.isEmpty((String)dimId)) continue;
            String dimNumber = roleDim.getString("dimension.number");
            String dimName = roleDim.getString("dimension.name");
            String dimDataSource = roleDim.getString("dimension.datasource");
            Map stringMapMap = assignedHrBuCaDim.computeIfAbsent(buCaFuncId, k -> Maps.newHashMapWithExpectedSize((int)16));
            HashMap tempMap = Maps.newHashMapWithExpectedSize((int)2);
            tempMap.put("dimensionNumber", dimNumber);
            tempMap.put("dimId", dimId);
            tempMap.put("dimensionName", dimName);
            tempMap.put("dataSource", dimDataSource);
            String showType = roleDim.getString("dimension.showtype");
            tempMap.put("showType", showType);
            if (HRStringUtils.equals((String)"checkbox", (String)showType)) {
                DynamicObjectCollection dimEnumColl = roleDim.getDynamicObjectCollection("dimension.entry");
                List valueList = dimEnumColl.stream().map(enumItem -> enumItem.getString("value")).collect(Collectors.toList());
                List idList = dimEnumColl.stream().map(enumItem -> enumItem.getLong("id")).collect(Collectors.toList());
                tempMap.put("enumList", valueList);
                tempMap.put("enumIdList", idList);
            }
            stringMapMap.put(dimId, tempMap);
            assignedDimInfo.put(dimId, tempMap);
            Set dimSet = buCaFuncDim.computeIfAbsent(buCaFuncId, k -> Sets.newHashSetWithExpectedSize((int)16));
            dimSet.add(dimId);
        }
        LOGGER.info("Generate assignedHrBuCaDim: {}.", (Object)assignedHrBuCaDim);
        permPageCacheUtil.setRoleDimData(buCaFuncDim);
        permPageCacheUtil.setAssignedHrBuCaDim(assignedHrBuCaDim);
        permPageCacheUtil.setAssignedDimIntoCache(assignedDimInfo);
        buCaFuncDim.forEach((hrbuca, dimid) -> buCaFuncDimTemp.put(hrbuca, dimid));
        Map<String, RoleDataPermModel> dataPermMap = permPageCacheUtil.getDataPermMap();
        dataPermMap.forEach((hrbuca, roleDataPermModel) -> {
            if (CollectionUtils.isEmpty((Map)buCaFuncDimTemp)) {
                return;
            }
            Set dimIdSet = (Set)buCaFuncDimTemp.get(hrbuca);
            if (CollectionUtils.isEmpty((Collection)dimIdSet)) {
                return;
            }
            Map dimGroupMap = roleDataPermModel.getDimGroupMap();
            dimGroupMap.forEach((grop, dimGrpModel) -> {
                TreeMap dimMap = dimGrpModel.getDimMap();
                dimMap.forEach((dimnumber, dimModel) -> {
                    String dimId = dimModel.getDimId();
                    dimIdSet.remove(dimId);
                });
            });
            if (!CollectionUtils.isEmpty((Collection)dimIdSet)) {
                dimGroupMap.forEach((grop, dimGrpModel) -> {
                    for (String dimId : dimIdSet) {
                        TreeMap dimMap = dimGrpModel.getDimMap();
                        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dimension");
                        DynamicObject dimDyObj = serviceHelper.queryOne("id,number,name", new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(dimId))});
                        DimModel dimModel = new DimModel();
                        dimModel.setLimit("0");
                        dimModel.setDimNumber(dimDyObj.getString("number"));
                        dimModel.setDimId(dimId);
                        dimModel.setDimValues(new HashMap());
                        dimMap.put(dimDyObj.getString("number"), dimModel);
                    }
                });
            }
        });
        permPageCacheUtil.setDataPerm(dataPermMap);
    }
}

