/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.dimension;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.ChoiceFieldPageCustomQueryService;
import kd.hr.hrcs.bussiness.servicehelper.HRCloudServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRBuCaServiceHelper;
import kd.hr.hrcs.common.constants.perm.log.DimRoleInfoModel;
import org.apache.commons.lang3.tuple.Pair;

@ExcludeFromJacocoGeneratedReport
public class EntityCtrlServiceHelper {
    private static final Log LOG = LogFactory.getLog(EntityCtrlServiceHelper.class);

    public static Map<String, Pair<String, String>> getEntityFieldMapFormula(DynamicObject entity) {
        String entityNum = entity.getString("number");
        return EntityCtrlServiceHelper.getEntityFieldMapFormula(entityNum);
    }

    public static Map<String, Pair<String, String>> getEntityFieldMapFormula(String entityNum) {
        ChoiceFieldPageCustomQueryService customQuery = new ChoiceFieldPageCustomQueryService();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        List<Map<String, String>> propertyList = customQuery.parsePropertyFormula((IDataEntityType)mainEntityType, new ArrayList<String>(16), new HashMap<String, Object>(16));
        LinkedHashMap result = Maps.newLinkedHashMapWithExpectedSize((int)propertyList.size());
        for (Map<String, String> map : propertyList) {
            result.put(map.get("field_id"), Pair.of((Object)map.get("field_name"), (Object)map.get("field_dataType")));
        }
        return result;
    }

    public static Map<String, String> getEntityFieldMap(DynamicObject entity) {
        String entityNum = entity.getString("number");
        if (EntityCtrlServiceHelper.checkModelType(entity)) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dynaformctrl");
            DynamicObject ctrl = serviceHelper.queryOne("entryentity.propkey,entryentity.propname", new QFilter[]{new QFilter("entitytype", "=", (Object)entityNum)});
            if (null == ctrl) {
                return new HashMap<String, String>(16);
            }
            DynamicObjectCollection collection = ctrl.getDynamicObjectCollection("entryentity");
            return collection.stream().collect(Collectors.toMap(row -> row.getString("propkey"), row -> row.getString("propname"), (newVal, oldVal) -> newVal));
        }
        ChoiceFieldPageCustomQueryService customQuery = new ChoiceFieldPageCustomQueryService();
        try {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
            List<Map<String, String>> propertyList = customQuery.parsePropertySub((IDataEntityType)mainEntityType, new ArrayList<String>(16), new HashMap<String, Object>(16), null, new ArrayList<String>(10));
            HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)propertyList.size());
            propertyList.forEach(tempMap -> {
                String cfr_ignored_0 = (String)fieldMap.put(tempMap.get("field_id"), tempMap.get("field_name"));
            });
            LOG.info("EntityCtrlServiceHelper,getEntityFieldMap result is {} ", (Object)((Object)fieldMap).toString());
            return fieldMap;
        }
        catch (KDException exception) {
            LOG.error("kd.hr.hrcs.bussiness.servicehelper.perm.dimension.EntityCtrlServiceHelper.getEntityFieldMap error :{}", (Object)exception.getMessage());
            return new HashMap<String, String>(16);
        }
    }

    public static boolean checkModelType(String entityNumber) {
        HRBaseServiceHelper entityHelper = new HRBaseServiceHelper("bos_entityobject");
        DynamicObject entityType = entityHelper.queryOriginalOne("modeltype", new QFilter("id", "=", (Object)entityNumber));
        return EntityCtrlServiceHelper.checkModelType(entityType);
    }

    public static boolean checkModelType(DynamicObject entityType) {
        String modelType = entityType.getString("modeltype");
        return HRStringUtils.equals((String)modelType, (String)"DynamicFormModel") || HRStringUtils.equals((String)modelType, (String)"ReportFormModel");
    }

    public static DataSet getRoles(long dimensionId) {
        String algoKeyPrefix = EntityCtrlServiceHelper.class.getClass().getName() + ".getRoles.";
        HRBaseServiceHelper roleDimensionHelper = new HRBaseServiceHelper("hrcs_roledimension");
        QFilter filter = new QFilter("dimension", "=", (Object)dimensionId);
        DataSet rows = roleDimensionHelper.queryDataSet(algoKeyPrefix, "role.id", new QFilter[]{filter});
        Iterator iterator = rows.copy().iterator();
        HashSet<String> roleIds = new HashSet<String>();
        while (iterator.hasNext()) {
            Row next = (Row)iterator.next();
            roleIds.add(next.getString("role.id"));
        }
        HRBaseServiceHelper hrcsRoleRoleHelper = new HRBaseServiceHelper("hrcs_role");
        QFilter filter1 = new QFilter("id", "in", roleIds);
        DataSet rows1 = hrcsRoleRoleHelper.queryDataSet(algoKeyPrefix, "id,rolegrp,property,isintersection", new QFilter[]{filter1});
        DataSet var1 = rows.join(rows1).on("role.id", "id").select(new String[]{"role.id"}, new String[]{"rolegrp", "property", "isintersection"}).finish();
        HRBaseServiceHelper permRoleHelper = new HRBaseServiceHelper("perm_role");
        QFilter filter2 = new QFilter("id", "in", roleIds);
        DataSet var2 = permRoleHelper.queryDataSet(algoKeyPrefix, "id,number,name,roletype,group,enable", new QFilter[]{filter2});
        return var1.join(var2).on("role.id", "id").select(new String[]{"rolegrp", "property", "isintersection"}, new String[]{"id", "number", "name", "roletype", "group", "enable"}).finish();
    }

    public static Map<String, String> queryEntityPermItems(DynamicObject entity) {
        return EntityCtrlServiceHelper.queryEntityPermItems(entity.getString("number"));
    }

    public static Map<String, String> queryEntityPermItems(String entityNum) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_functionperm");
        QFilter filter = new QFilter("entitytype.number", "=", (Object)entityNum);
        DynamicObject[] dys = serviceHelper.query("permitem", new QFilter[]{filter});
        HashMap<String, String> res = new HashMap<String, String>(dys.length);
        for (DynamicObject dy : dys) {
            DynamicObject permItem = dy.getDynamicObject("permitem");
            if (permItem == null) continue;
            res.put(permItem.getString("number"), permItem.getString("name"));
        }
        return res;
    }

    public static Map<String, String> queryEntityPermItemIdNum(DynamicObject entity) {
        String entityNum = entity.getString("number");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_functionperm");
        QFilter filter = new QFilter("entitytype.number", "=", (Object)entityNum);
        DynamicObject[] dys = serviceHelper.query("permitem", new QFilter[]{filter});
        HashMap<String, String> res = new HashMap<String, String>(dys.length);
        for (DynamicObject dy : dys) {
            DynamicObject permItem = dy.getDynamicObject("permitem");
            if (permItem == null) continue;
            res.put(permItem.getString("id") + "#" + permItem.getString("number"), permItem.getString("name"));
        }
        return res;
    }

    public static List<ComboItem> setAppComboForPerm(DynamicObject entityType, Map<String, List<String>> forBidAppEntity, Set<String> forBidApps) {
        DynamicObject bizApp = entityType.getDynamicObject("bizappid");
        String bizAppId = bizApp.getString("id");
        bizAppId = EntityCtrlServiceHelper.getOriginAppId(bizAppId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_bizobjapp");
        String entityTypeId = entityType.getString("id");
        QFilter filter = new QFilter("bizobj", "=", (Object)entityTypeId);
        DynamicObject[] bizObjApps = serviceHelper.query("bizapp", new QFilter[]{filter});
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(bizObjApps.length + 1);
        if (!(forBidApps.contains(bizAppId) || forBidAppEntity.get(bizAppId) != null && forBidAppEntity.get(bizAppId).contains(entityTypeId))) {
            data.add(new ComboItem(new LocaleString(bizApp.getString("name")), bizAppId));
        }
        for (DynamicObject bizObjApp : bizObjApps) {
            DynamicObject app = bizObjApp.getDynamicObject("bizapp");
            String appId = app.getString("id");
            if (forBidApps.contains(appId) || bizAppId.equals(appId) || forBidAppEntity.get(appId) != null && forBidAppEntity.get(appId).contains(entityTypeId)) continue;
            data.add(new ComboItem(new LocaleString(app.getString("name")), EntityCtrlServiceHelper.getOriginAppId(appId)));
        }
        return data;
    }

    private static String getOriginAppId(String extAppId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        DynamicObject dynamicObject = serviceHelper.queryOne("id,masterid", (Object)extAppId);
        return HRStringUtils.isNotEmpty((String)dynamicObject.getString("masterid")) ? dynamicObject.getString("masterid") : extAppId;
    }

    public static Set<String> getEntityRelatedApps(DynamicObject entityType) {
        DynamicObject bizApp = entityType.getDynamicObject("bizappid");
        String bizAppId = bizApp.getString("id");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_bizobjapp");
        QFilter filter = new QFilter("bizobj", "=", (Object)entityType.getString("id"));
        QFilter qFilter = filter.and(new QFilter("bizapp", "not in", (Object)bizAppId));
        DynamicObject[] bizObjApps = serviceHelper.query("bizapp", new QFilter[]{qFilter});
        HashSet<String> ret = new HashSet<String>(16);
        ret.add(bizAppId);
        for (DynamicObject bizObjApp : bizObjApps) {
            DynamicObject app = bizObjApp.getDynamicObject("bizapp");
            if (app.getString("id") == null) continue;
            ret.add(app.getString("id"));
        }
        return EntityCtrlServiceHelper.getOriginAppIds(ret);
    }

    private static Set<String> getOriginAppIds(Set<String> appIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        DynamicObject[] dynamicObjects = serviceHelper.query("id,masterid", new QFilter[]{new QFilter("id", "in", appIds)});
        HashSet<String> originAppIds = new HashSet<String>(dynamicObjects.length);
        for (DynamicObject app : dynamicObjects) {
            String id = app.getString("id");
            String masterId = app.getString("masterid");
            if (HRStringUtils.isNotEmpty((String)masterId)) {
                originAppIds.add(masterId);
                continue;
            }
            originAppIds.add(id);
        }
        return originAppIds;
    }

    public static QFilter buildFilterForF7(boolean filterForBidApp) {
        HashSet<String> entities = new HashSet<String>(16);
        EntityCtrlServiceHelper.queryEntityForBidInfo(entities, null, null);
        return new QFilter("bizappid.id", "in", EntityCtrlServiceHelper.getHRApps(filterForBidApp)).and("istemplate", "=", (Object)"0").and("number", "not in", entities);
    }

    public static Set<String> getHRApps(boolean filterForBidApp) {
        Set<String> allHRCloudId = HRCloudServiceHelper.getAllHRCloudId();
        HRBaseServiceHelper appHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        QFilter filter = new QFilter("bizcloud.id", "in", allHRCloudId);
        DynamicObject[] apps = appHelper.query("id", new QFilter[]{filter});
        Set<String> appIds = Arrays.stream(apps).map(it -> it.getString("id")).collect(Collectors.toSet());
        if (filterForBidApp) {
            HashSet<String> forBidAppIds = new HashSet<String>(16);
            EntityCtrlServiceHelper.queryEntityForBidInfo(null, forBidAppIds, null);
            appIds.removeAll(forBidAppIds);
        }
        return appIds;
    }

    public static void queryEntityForBidInfo(Set<String> entities, Set<String> apps, Map<String, List<String>> appEntity) {
        DynamicObject[] dys;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_entityforbid");
        block10: for (DynamicObject dy : dys = serviceHelper.queryOriginalArray("id,entitytypeid,app,forbidtype", new QFilter[0])) {
            String forBidType = dy.getString("forbidtype");
            String entityNum = dy.getString("entitytypeid");
            String appId = dy.getString("app");
            switch (forBidType) {
                case "1": {
                    if (entities == null || !HRStringUtils.isNotEmpty((String)entityNum)) continue block10;
                    entities.add(entityNum);
                    continue block10;
                }
                case "2": {
                    if (apps == null || !HRStringUtils.isNotEmpty((String)appId)) continue block10;
                    apps.add(appId);
                    continue block10;
                }
                case "3": {
                    if (appEntity == null || !HRStringUtils.isNotEmpty((String)appId) || !HRStringUtils.isNotEmpty((String)entityNum)) continue block10;
                    List entityList = appEntity.computeIfAbsent(appId, k -> new ArrayList(16));
                    entityList.add(entityNum);
                }
            }
        }
    }

    public static void queryExistedForBidInfo(IFormView view) {
        ArrayList entityNums = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList apps = Lists.newArrayListWithExpectedSize((int)10);
        HashMap appEntity = Maps.newHashMapWithExpectedSize((int)16);
        HashMap entityPerm = Maps.newHashMapWithExpectedSize((int)16);
        HashMap appEntityPerm = Maps.newHashMapWithExpectedSize((int)16);
        EntityCtrlServiceHelper.queryEntityForBidInfo(entityNums, apps, appEntity, entityPerm, appEntityPerm);
        IPageCache pageCache = view.getPageCache();
        pageCache.put("entityNums", SerializationUtils.toJsonString((Object)entityNums));
        pageCache.put("apps", SerializationUtils.toJsonString((Object)apps));
        pageCache.put("appEntity", SerializationUtils.toJsonString((Object)appEntity));
        pageCache.put("entityPerm", SerializationUtils.toJsonString((Object)entityPerm));
        pageCache.put("appEntityPerm", SerializationUtils.toJsonString((Object)appEntityPerm));
    }

    public static void queryEntityForBidInfo(List<String> entities, List<String> apps, Map<String, List<String>> appEntity, Map<String, List<String>> entityPerm, Map<String, Map<String, List<String>>> appEntityPerm) {
        DynamicObject[] dys;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_entityforbid");
        block14: for (DynamicObject dy : dys = serviceHelper.queryOriginalArray("id,entitytypeid,app,permitem,forbidtype", new QFilter[0])) {
            String forBidType = dy.getString("forbidtype");
            String entityNum = dy.getString("entitytypeid");
            String appId = dy.getString("app");
            String permItemId = dy.getString("permitem");
            boolean entityNotEmpty = HRStringUtils.isNotEmpty((String)entityNum);
            boolean appNotEmpty = HRStringUtils.isNotEmpty((String)appId);
            boolean permNotEmpty = HRStringUtils.isNotEmpty((String)permItemId);
            switch (forBidType) {
                case "1": {
                    if (entities == null || !entityNotEmpty) continue block14;
                    entities.add(entityNum);
                    continue block14;
                }
                case "2": {
                    if (apps == null || !appNotEmpty) continue block14;
                    apps.add(appId);
                    continue block14;
                }
                case "3": {
                    if (appEntity == null || !appNotEmpty || !entityNotEmpty) continue block14;
                    List entityList = appEntity.computeIfAbsent(appId, k -> Lists.newArrayListWithExpectedSize((int)16));
                    entityList.add(entityNum);
                    continue block14;
                }
                case "4": {
                    if (!entityNotEmpty || !permNotEmpty) continue block14;
                    List permItemList = entityPerm.computeIfAbsent(entityNum, key -> Lists.newArrayListWithExpectedSize((int)10));
                    permItemList.add(permItemId);
                    continue block14;
                }
                case "5": {
                    if (!appNotEmpty || !entityNotEmpty || !permNotEmpty) continue block14;
                    Map entityPermMap = appEntityPerm.computeIfAbsent(appId, key -> Maps.newHashMapWithExpectedSize((int)16));
                    List permItemList = entityPermMap.computeIfAbsent(entityNum, key -> new ArrayList(10));
                    permItemList.add(permItemId);
                }
            }
        }
    }

    public static void getAllForBidEntityInApp(Set<String> entities, Map<String, List<String>> appEntity, String appId) {
        if (appEntity.get(appId) != null) {
            entities.addAll((Collection<String>)appEntity.get(appId));
        }
    }

    public static QFilter filterNoPermEntity(IFormView view) {
        Set entityNums;
        String entityNumsStr = view.getPageCache().get("hasPermEntityNums");
        if (null == entityNumsStr) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_functionperm");
            DynamicObject[] query = serviceHelper.queryOriginalArray("entitytype.number", new QFilter[0]);
            entityNums = Arrays.stream(query).filter(it -> HRStringUtils.isNotEmpty((String)it.getString("entitytype.number"))).map(it -> it.getString("entitytype.number")).collect(Collectors.toSet());
            view.getPageCache().put("hasPermEntityNums", SerializationUtils.toJsonString(entityNums));
        } else {
            entityNums = (Set)SerializationUtils.fromJsonString((String)entityNumsStr, Set.class);
        }
        return new QFilter("number", "in", (Object)entityNums);
    }

    public static StringBuilder collectionToString(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i = 0; i < list.size(); ++i) {
            String id = list.get(i);
            stringBuilder.append('\'').append(id).append('\'');
            if (i == list.size() - 1) continue;
            stringBuilder.append(',');
        }
        return stringBuilder.append(')');
    }

    public static String getBuCaFuncFromDB(String entityNumber, String appId, Map<String, Long> allEntitySpecFunc) {
        Long buCaFunc = allEntitySpecFunc.get(entityNumber);
        if (buCaFunc != null) {
            return String.valueOf(buCaFunc);
        }
        return String.valueOf(HRBuCaServiceHelper.getAppFuncId(appId));
    }

    public static List<DimRoleInfoModel> getDimRelRoles(DynamicObject entity, DynamicObjectCollection collection, int[] selectRows, Map<Long, List<String>> dimRoles, String buId) {
        HRBaseServiceHelper roleDimHelper = new HRBaseServiceHelper("hrcs_roledimension");
        ArrayList dimRoleInfoList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList existRoleIds = Lists.newArrayListWithExpectedSize((int)10);
        for (int selectRow : selectRows) {
            DynamicObject dimension = ((DynamicObject)collection.get(selectRow)).getDynamicObject("dimension");
            if (null == dimension) continue;
            long dimensionId = dimension.getLong("id");
            List<String> roleIds = dimRoles.get(dimensionId);
            Set<String> roles = EntityCtrlServiceHelper.queryDimRoleIds(entity, dimensionId, roleDimHelper);
            if (roleIds == null) {
                dimRoles.put(dimensionId, new ArrayList<String>(roles));
            } else {
                roles.addAll(roleIds);
                dimRoles.put(dimensionId, new ArrayList<String>(roles));
            }
            if (org.apache.commons.collections.CollectionUtils.isEmpty(roles)) continue;
            for (String roleId : roles) {
                if (existRoleIds.contains(roleId)) continue;
                DimRoleInfoModel dimRoleInfoModel = new DimRoleInfoModel(roleId, Long.parseLong(buId), dimensionId, "delete");
                dimRoleInfoList.add(dimRoleInfoModel);
                existRoleIds.add(roleId);
            }
        }
        return dimRoleInfoList;
    }

    private static Set<String> queryDimRoleIds(DynamicObject entity, long dimensionId, HRBaseServiceHelper roleDimHelper) {
        QFilter filter = new QFilter("dimension.id", "=", (Object)dimensionId).and("entry.entitytype.id", "=", (Object)entity.getString("id")).and("entry.enable", "=", (Object)Boolean.TRUE);
        DynamicObject[] roleDims = roleDimHelper.query("id,role.id", new QFilter[]{filter});
        return Arrays.stream(roleDims).map(it -> it.getString("role.id")).collect(Collectors.toSet());
    }

    public static void showDelTip(Map<Long, List<String>> dimRoles, IFormView view, IFormPlugin formPlugin) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hrcs_entitycrl_del_tip");
        parameter.setCustomParam("dimRoles", dimRoles);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack(formPlugin, "delete_confirm"));
        view.showForm(parameter);
    }

    public static Set<String> queryPermRoleIds() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_role");
        DynamicObject[] ids = serviceHelper.query("id", new QFilter[0]);
        return Arrays.stream(ids).map(it -> it.getString("id")).collect(Collectors.toSet());
    }

    public static boolean deleteRoleRange(HRBaseServiceHelper roleDimHelper, long dimensionId, String entityNum, String propKey, Long buId, IFormView view, BeforeDoOperationEventArgs args) {
        return EntityCtrlServiceHelper.deleteRoleRange(roleDimHelper, dimensionId, entityNum, propKey, buId, view, args, Lists.newArrayListWithExpectedSize((int)0));
    }

    public static boolean deleteRoleRange(HRBaseServiceHelper roleDimHelper, long dimensionId, String entityNum, String propKey, Long buId, IFormView view, BeforeDoOperationEventArgs args, List<DimRoleInfoModel> effectDimRoleInfoModelList) {
        Throwable throwable = null;
        try (TXHandle txHandle = TX.requiresNew();){
            QFilter filter = new QFilter("dimension.id", "=", (Object)dimensionId).and("bucafunc.id", "=", (Object)buId).and("entry.entitytype", "=", (Object)entityNum).and("entry.propkey", "=", (Object)propKey);
            DynamicObject[] roleDims = roleDimHelper.query("id,role.id,entry.entitytype,entry.propkey", new QFilter[]{filter});
            ArrayList<String> toDeleteDimGrps = new ArrayList<String>(16);
            ArrayList<Object> toDeleteRoleDims = new ArrayList<Object>(16);
            ArrayList<DynamicObject> toUpdateRoleDims = new ArrayList<DynamicObject>(16);
            ArrayList<DimRoleInfoModel> curEffectDimRoleInfoModelList = new ArrayList<DimRoleInfoModel>(16);
            for (DynamicObject roleDim : roleDims) {
                DynamicObjectCollection entry = roleDim.getDynamicObjectCollection("entry");
                entry.removeIf(it -> null == it.getDynamicObject("entitytype") || it.getString("entitytype.number").equals(entityNum) && it.get("propkey").equals(propKey));
                String roleId = roleDim.getString("role.id");
                DimRoleInfoModel dimRoleInfoModel = new DimRoleInfoModel();
                dimRoleInfoModel.setBuId(buId.longValue());
                dimRoleInfoModel.setDimensionId(dimensionId);
                dimRoleInfoModel.setRoleId(roleId);
                dimRoleInfoModel.setOpType("delete");
                if (entry.size() > 0) {
                    toUpdateRoleDims.add(roleDim);
                } else {
                    toDeleteDimGrps.add(roleId);
                    toDeleteRoleDims.add(roleDim.get("id"));
                }
                curEffectDimRoleInfoModelList.add(dimRoleInfoModel);
            }
            roleDimHelper.update(toUpdateRoleDims.toArray(new DynamicObject[0]));
            roleDimHelper.delete(toDeleteRoleDims.toArray());
            effectDimRoleInfoModelList.addAll(curEffectDimRoleInfoModelList);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (args != null) {
                args.setCancel(true);
            }
            LOG.error("\u5220\u9664\u7ef4\u5ea6\u6620\u5c04\u5931\u8d25," + e.getMessage(), (Throwable)e);
            txHandle.markRollback();
            view.showErrorNotification(ResManager.loadKDString((String)"\u5220\u9664\u7ef4\u5ea6\u6620\u5c04\u5931\u8d25\u3002", (String)"EntityCtrlServiceHelper_01", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public static Map<String, Integer> getPermTreeSeq(String appId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_entitytreecfg");
        QFilter filter = new QFilter("appid", "=", (Object)appId);
        DynamicObject[] dys = serviceHelper.queryOriginalArray("number,index", new QFilter[]{filter}, "index asc");
        if (dys.length <= 0) {
            return null;
        }
        HashMap<String, Integer> ret = new HashMap<String, Integer>(dys.length);
        for (DynamicObject dy : dys) {
            ret.put(dy.getString("number"), dy.getInt("index"));
        }
        return ret;
    }

    public static List<Map<String, Object>> getCtrlDimensionByEntity(String entityNumber, String propKey) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        HRBaseServiceHelper entityCtrlHelper = new HRBaseServiceHelper("hrcs_entityctrl");
        DynamicObject entityCtrlDyna = entityCtrlHelper.queryOne("entryentity.dimension,entryentity.propkey", new QFilter[]{new QFilter("entitytype.number", "=", (Object)entityNumber)});
        if (Objects.isNull(entityCtrlDyna)) {
            return result;
        }
        DynamicObjectCollection entryDynaColl = entityCtrlDyna.getDynamicObjectCollection("entryentity");
        ArrayList ctrlDimIds = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject entryDyna : entryDynaColl) {
            if (HRStringUtils.isNotEmpty((String)propKey)) {
                String entryPropKey = entryDyna.getString("propkey");
                if (!HRStringUtils.equals((String)propKey, (String)entryPropKey)) continue;
                ctrlDimIds.add(entryDyna.getLong("dimension.id"));
                continue;
            }
            ctrlDimIds.add(entryDyna.getLong("dimension.id"));
        }
        if (CollectionUtils.isEmpty((Collection)ctrlDimIds)) {
            return result;
        }
        HRBaseServiceHelper dimHelper = new HRBaseServiceHelper("hrcs_dimension");
        DynamicObjectCollection dimDynaColl = dimHelper.queryOriginalCollection("id,number,name,enable,datasource,showtype,hrbu.id,entitytype.number,teamtype.id", new QFilter[]{new QFilter("id", "in", (Object)ctrlDimIds)});
        for (DynamicObject dimDyna : dimDynaColl) {
            HashMap dimInfoMap = Maps.newHashMapWithExpectedSize((int)16);
            dimInfoMap.put("id", dimDyna.getLong("id"));
            dimInfoMap.put("number", dimDyna.getString("number"));
            dimInfoMap.put("name", dimDyna.getString("name"));
            dimInfoMap.put("enable", dimDyna.getString("enable"));
            dimInfoMap.put("datasource", dimDyna.getString("datasource"));
            dimInfoMap.put("showtype", dimDyna.getString("showtype"));
            dimInfoMap.put("bucafuncid", dimDyna.getLong("hrbu.id"));
            dimInfoMap.put("teamtypeid", dimDyna.getLong("teamtype.id"));
            dimInfoMap.put("entitytype", dimDyna.getString("entitytype.number"));
            result.add(dimInfoMap);
        }
        return result;
    }

    public static Map<String, Map<String, Object>> getPropDimensionMappingByEntity(String entityNumber) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        HRBaseServiceHelper entityCtrlHelper = new HRBaseServiceHelper("hrcs_entityctrl");
        DynamicObject entityCtrlDyna = entityCtrlHelper.queryOne("entryentity.propkey,entryentity.dimension,entryentity.ismust,entryentity.authrange", new QFilter[]{new QFilter("entitytype.number", "=", (Object)entityNumber)});
        if (Objects.isNull(entityCtrlDyna)) {
            return result;
        }
        DynamicObjectCollection entryDynaColl = entityCtrlDyna.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryDyna : entryDynaColl) {
            HashMap dimMappingMap = Maps.newHashMapWithExpectedSize((int)16);
            String propKey = entryDyna.getString("propkey");
            dimMappingMap.put("propkey", propKey);
            dimMappingMap.put("dimensionid", entryDyna.getLong("dimension.id"));
            dimMappingMap.put("dimensionnumber", entryDyna.getString("dimension.number"));
            dimMappingMap.put("ismust", entryDyna.getBoolean("ismust"));
            dimMappingMap.put("authrange", entryDyna.getString("authrange"));
            result.put(propKey, dimMappingMap);
        }
        return result;
    }

    public static Set<String> getAllNoExistEntityCtrlNumbers() {
        HRBaseServiceHelper entityCtrlHelper = new HRBaseServiceHelper("hrcs_entityctrl");
        DynamicObjectCollection entityCtrlColl = entityCtrlHelper.queryOriginalCollection("entitytype", null);
        Set<String> allEntityCtrlNumbers = entityCtrlColl.stream().map(dyna -> dyna.getString("entitytype")).collect(Collectors.toSet());
        HRBaseServiceHelper entityObjectHelper = new HRBaseServiceHelper("bos_entityobject");
        DynamicObjectCollection existedEntityColl = entityObjectHelper.queryOriginalCollection("number", new QFilter[]{new QFilter("number", "in", allEntityCtrlNumbers)});
        Set existedEntityNumbers = existedEntityColl.stream().map(dyna -> dyna.getString("number")).collect(Collectors.toSet());
        allEntityCtrlNumbers.removeAll(existedEntityNumbers);
        return allEntityCtrlNumbers;
    }
}

