/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.dimension;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.EntityCtrlServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class PermRelateServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(PermRelateServiceHelper.class);

    public static Set<String> queryPermRelates(QFilter filter) {
        HRBaseServiceHelper permRelateHelper = new HRBaseServiceHelper("hrcs_permrelat");
        DynamicObject[] permRelates = permRelateHelper.query("entryentity.app,entryentity.entitytypeid,entryentity.permitemid", new QFilter[]{filter});
        HashSet<String> permRelateCfgs = new HashSet<String>(16);
        Map<String, String> permIdNumberMap = PermRelateServiceHelper.queryPermItems();
        for (DynamicObject permRelate : permRelates) {
            DynamicObjectCollection collection = permRelate.getDynamicObjectCollection("entryentity");
            permRelateCfgs.addAll(PermRelateServiceHelper.getEntryInfo(collection, permIdNumberMap));
        }
        return permRelateCfgs;
    }

    public static Set<String> queryPermRelatesFormDB() {
        String algoKeyPrefix = "kd.hr.hrcs.bussiness.servicehelper.perm.dimension.PermRelateServiceHelper.queryPermRelatesFormDB.";
        String sql = "select fappid,fentitytypeid,fpermitemid from t_hrcs_permrelatentry where fissyspreset = '0'";
        DataSet dataSet = DB.queryDataSet((String)algoKeyPrefix, (DBRoute)new DBRoute("hmp"), (String)sql);
        Map<String, String> permIdNumberMap = PermRelateServiceHelper.queryPermItemsDB();
        HashSet<String> permRelateCfgs = new HashSet<String>(16);
        while (dataSet.hasNext()) {
            String[] permItemIds;
            Row next = dataSet.next();
            String appId = next.getString("fappid");
            String entityId = next.getString("fentitytypeid");
            String permItemIdStr = next.getString("fpermitemid");
            for (String permItemId : permItemIds = permItemIdStr.split(",")) {
                String perNumber = permIdNumberMap.get(permItemId);
                if (!HRStringUtils.isNotEmpty((String)perNumber)) continue;
                permRelateCfgs.add(appId + "|" + entityId + "|" + perNumber);
            }
        }
        return permRelateCfgs;
    }

    public static Set<String> getEntryInfo(DynamicObjectCollection collection, Map<String, String> permIdNumberMap) {
        HashSet<String> result = new HashSet<String>(16);
        for (DynamicObject entry : collection) {
            String[] permItemIds;
            String appId = entry.getString("app.id");
            String entityId = entry.getString("entitytypeid.id");
            for (String permItemId : permItemIds = entry.getString("permitemid").split(",")) {
                result.add(appId + "|" + entityId + "|" + permIdNumberMap.get(permItemId));
            }
        }
        return result;
    }

    public static Map<String, String> queryPermItems() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_permitem");
        DynamicObject[] permItems = serviceHelper.queryOriginalArray("id,number", new QFilter[0]);
        HashMap<String, String> permIdNumberMap = new HashMap<String, String>(permItems.length);
        for (DynamicObject dy : permItems) {
            permIdNumberMap.put(dy.getString("number"), dy.getString("id"));
        }
        return permIdNumberMap;
    }

    public static Map<String, String> queryPermItemsDB() {
        String algoKeyPrefix = "kd.hr.hrcs.bussiness.servicehelper.perm.dimension.PermRelateServiceHelper.queryPermItemsDB.";
        String sql = "select fid,fnumber from t_perm_permitem ";
        DataSet dataSet = DB.queryDataSet((String)algoKeyPrefix, (DBRoute)DBRoute.of((String)"sys"), (String)sql);
        HashMap<String, String> permIdNumberMap = new HashMap<String, String>(16);
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            permIdNumberMap.put(next.getString("fnumber"), next.getString("fid"));
        }
        return permIdNumberMap;
    }

    public static Map<String, String> buildPermIdNumber() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_permitem");
        DynamicObject[] permItems = serviceHelper.queryOriginalArray("id,number", new QFilter[0]);
        HashMap<String, String> permIdNumberMap = new HashMap<String, String>(permItems.length);
        for (DynamicObject dy : permItems) {
            permIdNumberMap.put(dy.getString("id"), dy.getString("number"));
        }
        return permIdNumberMap;
    }

    public static void deletePermRelateConfigs(Set<String> deleteRows) {
        if (CollectionUtils.isEmpty(deleteRows)) {
            return;
        }
        Set entityIds = deleteRows.stream().map(it -> it.split("\\|")[1]).collect(Collectors.toSet());
        QFilter entityFilter = new QFilter("entryentity.entitytypeid", "in", entityIds);
        Set<String> existData = PermRelateServiceHelper.queryPermRelates(entityFilter);
        Sets.SetView toDeleteRows = Sets.difference(deleteRows, existData);
        if (toDeleteRows.size() <= 0) {
            return;
        }
        HRBaseServiceHelper configHelper = new HRBaseServiceHelper("hrcs_permrelatcfg");
        QFilter filter = null;
        for (String row : toDeleteRows) {
            String[] split = row.split("\\|");
            QFilter tmp = new QFilter("app", "=", (Object)split[0]).and("entitytype", "=", (Object)split[1]).and("permitem.id", "=", (Object)split[2]);
            if (filter != null) {
                filter = filter.or(tmp);
                continue;
            }
            filter = tmp;
        }
        configHelper.deleteByFilter(new QFilter[]{filter});
    }

    public static void addPermRelateConfigs(Set<String> addRows) {
        if (CollectionUtils.isEmpty(addRows)) {
            return;
        }
        Set entityIds = addRows.stream().map(it -> it.split("\\|")[1]).collect(Collectors.toSet());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_permrelatcfg");
        QFilter filter = new QFilter("entitytype.id", "in", entityIds);
        DynamicObject[] dynamicObjects = serviceHelper.query("app,entitytype,permitem", new QFilter[]{filter});
        HashSet<String> existData = new HashSet<String>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            String appId = dynamicObject.getString("app.id");
            String entityId = dynamicObject.getString("entitytype.id");
            String permItemId = dynamicObject.getString("permitem.id");
            existData.add(appId + "|" + entityId + "|" + permItemId);
        }
        Sets.SetView toAddRows = Sets.difference(addRows, existData);
        PermRelateServiceHelper.savePermRelateConfigs((Set<String>)toAddRows);
    }

    public static void addPermRelateConfigsDB(Set<String> addRows) {
        if (CollectionUtils.isEmpty(addRows)) {
            LOGGER.info("addRows is null,permRelateConfig do not need data upgrade");
            return;
        }
        Set entityIds = addRows.stream().map(it -> it.split("\\|")[1]).collect(Collectors.toSet());
        String entityIdStr = entityIds.stream().map(it -> "'" + it + "'").collect(Collectors.joining(","));
        String algoKeyPrefix = "kd.hr.hrcs.bussiness.servicehelper.perm.dimension.PermRelateServiceHelper.addPermRelateConfigsDB";
        String sql = "select fappid, fentitytypeid, fpermitemid from t_hrcs_permrelatcfg where fentitytypeid in (" + entityIdStr + ')';
        DataSet dataSet = DB.queryDataSet((String)algoKeyPrefix, (DBRoute)DBRoute.of((String)"hmp"), (String)sql);
        HashSet<String> existData = new HashSet<String>(16);
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            String appId = next.getString("fappid");
            String entityId = next.getString("fentitytypeid");
            String permItemId = next.getString("fpermitemid");
            existData.add(appId + "|" + entityId + "|" + permItemId);
        }
        Sets.SetView toAddRows = Sets.difference(addRows, existData);
        PermRelateServiceHelper.savePermRelateConfigsDB((Set<String>)toAddRows);
    }

    public static void savePermRelateConfigs(Set<String> toAddRows) {
        HRBaseServiceHelper configHelper = new HRBaseServiceHelper("hrcs_permrelatcfg");
        ArrayList<DynamicObject> toSaveConfigs = new ArrayList<DynamicObject>(toAddRows.size());
        for (String permRelateCfg : toAddRows) {
            DynamicObject tmp = configHelper.generateEmptyDynamicObject();
            String[] split = permRelateCfg.split("\\|");
            tmp.set("app", (Object)split[0]);
            tmp.set("entitytype", (Object)split[1]);
            tmp.set("permitem", (Object)split[2]);
            tmp.set("isassign", (Object)"0");
            tmp.set("issyspreset", (Object)"0");
            toSaveConfigs.add(tmp);
        }
        configHelper.save(toSaveConfigs.toArray(new DynamicObject[0]));
    }

    public static void savePermRelateConfigsDB(Set<String> toAddRows) {
        ArrayList<Object[]> toSaveConfigs = new ArrayList<Object[]>(16);
        long[] ids = DBServiceHelper.genLongIds((String)"t_hrcs_permrelatcfg", (int)toAddRows.size());
        int index = 0;
        for (String permRelateCfg : toAddRows) {
            String[] split = permRelateCfg.split("\\|");
            Object[] configDataArray = new Object[]{ids[index++], split[0], split[1], split[2], "0", "0"};
            toSaveConfigs.add(configDataArray);
        }
        if (toSaveConfigs.size() > 0) {
            String insertSql = "insert into t_hrcs_permrelatcfg(fid, fappid, fentitytypeid, fpermitemid, fisassign, fissyspreset) values (?,?,?,?,?,?)";
            HRDBUtil.executeBatch((DBRoute)new DBRoute("hmp"), (String)insertSql, toSaveConfigs);
        }
    }

    public static Map<String, Set<String>> queryAllPermRelateConfig() {
        HRBaseServiceHelper configHelper = new HRBaseServiceHelper("hrcs_permrelatcfg");
        QFilter filter = new QFilter("isassign", "=", (Object)"1");
        DynamicObject[] configs = configHelper.query("app,entitytype", new QFilter[]{filter});
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (DynamicObject config : configs) {
            String app = config.getString("app.id");
            String entityType = config.getString("entitytype.id");
            Set entityNums = (Set)result.get(app);
            if (null == app || null == entityType) continue;
            if (null == entityNums) {
                entityNums = Sets.newHashSet((Object[])new String[]{entityType});
                result.put(app, entityNums);
                continue;
            }
            entityNums.add(entityType);
        }
        return result;
    }

    public static Map<String, Map<String, List<String>>> queryAllIndependentPerm() {
        HRBaseServiceHelper configHelper = new HRBaseServiceHelper("hrcs_permrelatcfg");
        QFilter filter = new QFilter("isassign", "=", (Object)"1");
        DynamicObject[] configs = configHelper.query("app,entitytype,permitem", new QFilter[]{filter});
        HashMap<String, Map<String, List<String>>> result = new HashMap<String, Map<String, List<String>>>(configs.length);
        for (DynamicObject config : configs) {
            String app = config.getString("app.id");
            String entityType = config.getString("entitytype.id");
            if (app == null || null == entityType) continue;
            Map map = result.computeIfAbsent(app, k -> Maps.newHashMap());
            String permItemNum = config.getString("permitem.number");
            List perms = (List)map.get(entityType);
            if (null == perms) {
                perms = Lists.newArrayList((Object[])new String[]{permItemNum});
                map.put(entityType, perms);
                continue;
            }
            perms.add(permItemNum);
        }
        return result;
    }

    public static Set<String> queryAllIndependentPermInfo() {
        HRBaseServiceHelper configHelper = new HRBaseServiceHelper("hrcs_permrelatcfg");
        QFilter filter = new QFilter("isassign", "=", (Object)"1");
        DynamicObject[] configs = configHelper.query("app,entitytype,permitem", new QFilter[]{filter});
        HashSet<String> result = new HashSet<String>(configs.length);
        for (DynamicObject config : configs) {
            String app = config.getString("app.id");
            String entityType = config.getString("entitytype.id");
            String permItemId = config.getString("permitem.id");
            if (HRStringUtils.isEmpty((String)app) || HRStringUtils.isEmpty((String)entityType) || HRStringUtils.isEmpty((String)permItemId)) continue;
            result.add(app + "|" + entityType + "|" + permItemId);
        }
        return result;
    }

    public static boolean hasAssignablePerm(String entity, String appId, Set<String> configs, Set<String> forbidPerms) {
        DynamicObject[] dys;
        if (CollectionUtils.isNotEmpty(configs) && configs.contains(entity)) {
            return true;
        }
        Map<String, String> permItemMap = EntityCtrlServiceHelper.queryEntityPermItems(entity);
        Set<String> permItems = permItemMap.keySet();
        HashSet<Object> usedPermItems = new HashSet<Object>(16);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_permrelat");
        QFilter filter = new QFilter("entryentity.entitytypeid", "=", (Object)entity).and("entryentity.app", "=", (Object)appId);
        for (DynamicObject dy : dys = serviceHelper.query("entryentity.entitytypeid,entryentity.permitemid", new QFilter[]{filter})) {
            DynamicObjectCollection entryEntity = dy.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                if (entry.getString("entitytypeid.id") == null || !entry.getString("entitytypeid.id").equals(entity)) continue;
                Set permItemId = Arrays.stream(entry.getString("permitemid").split(",")).collect(Collectors.toSet());
                usedPermItems.addAll(permItemId);
            }
        }
        usedPermItems.addAll(forbidPerms);
        return Sets.difference(permItems, usedPermItems).size() > 0;
    }

    public static Map<String, Map<String, Set<String>>> buildAllRelatedPerm() {
        Map<String, Map<String, List<String>>> allIndependentPerm = PermRelateServiceHelper.queryAllIndependentPerm();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_permrelat");
        DynamicObject[] permRelates = serviceHelper.query("entryentity.entitytypeid,entryentity.app,entryentity.permitemid", new QFilter[0]);
        HashMap<String, Map<String, Set<String>>> entityPermMap = new HashMap<String, Map<String, Set<String>>>(16);
        if (permRelates.length > 0) {
            for (DynamicObject permRelate : permRelates) {
                DynamicObjectCollection entry = permRelate.getDynamicObjectCollection("entryentity");
                for (DynamicObject dy : entry) {
                    String entityTypeId = dy.getString("entitytypeid.id");
                    String appId = dy.getString("app.id");
                    if (HRStringUtils.isEmpty((String)entityTypeId) || HRStringUtils.isEmpty((String)appId)) continue;
                    Map appMap = entityPermMap.computeIfAbsent(appId, k -> new HashMap(16));
                    Set permItems = appMap.computeIfAbsent(entityTypeId, k -> new HashSet(16));
                    Set idSet = Arrays.stream(dy.getString("permitemid").split(",")).collect(Collectors.toSet());
                    if (allIndependentPerm.get(appId) != null && allIndependentPerm.get(appId).get(entityTypeId) != null) {
                        idSet.removeAll((Collection)allIndependentPerm.get(appId).get(entityTypeId));
                    }
                    permItems.addAll(idSet);
                }
            }
        }
        return entityPermMap;
    }

    public static Map<String, String> getPermInfo() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("perm_permitem");
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("id,number", null);
        HashMap itemMap = Maps.newHashMapWithExpectedSize((int)dynamicObjects.size());
        dynamicObjects.forEach(it -> itemMap.put(it.getString("number"), it.getString("id")));
        return itemMap;
    }

    public static Map<String, String> getPermInfoNum() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("perm_permitem");
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("id,number", null);
        HashMap itemMap = Maps.newHashMapWithExpectedSize((int)dynamicObjects.size());
        dynamicObjects.forEach(it -> itemMap.put(it.getString("id"), it.getString("number")));
        return itemMap;
    }

    public static Map<String, String> getRoleInfo(List<String> roleIdList) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("perm_role");
        DynamicObjectCollection dynamicObjects = helper.queryOriginalCollection("id,name", new QFilter[]{new QFilter("id", "in", roleIdList)});
        HashMap itemMap = Maps.newHashMapWithExpectedSize((int)dynamicObjects.size());
        dynamicObjects.forEach(it -> itemMap.put(it.getString("id"), it.getString("name")));
        return itemMap;
    }
}

