/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.dyna;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.openservicehelper.hrpi.HRPIDepempServiceHelper;
import kd.hr.hbp.business.openservicehelper.hrpi.HRPIPersonServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.PermFileSyncServiceHelper;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import kd.hr.hrcs.common.model.perm.DepInfo;
import kd.hr.hrcs.common.model.perm.PersonInfo;

@ExcludeFromJacocoGeneratedReport
public class PersonService {
    private static final Log LOGGER = LogFactory.getLog(PersonService.class);
    private static final Map<String, String> PERSON_PROP_TYPE = ImmutableMap.of((Object)"hrpi_employee", (Object)"3", (Object)"hrpi_depemp", (Object)"4", (Object)"hrpi_person", (Object)"2", (Object)"bos_user", (Object)"1", (Object)"hspm_ermanfile", (Object)"2");
    private static final Map<String, String> PERSON_CUSTOM_TYPE = ImmutableMap.of((Object)"TYPE_EMPLOYEE", (Object)"3", (Object)"TYPE_DEPEMP", (Object)"4", (Object)"TYPE_PERSON", (Object)"2", (Object)"TYPE_BOS_USER", (Object)"1", (Object)"TYPE_ERMANFILE", (Object)"2");

    public static String getPersonPropType(String bdType) {
        LOGGER.info("EventPermService getPersonPropType bdType:{}", (Object)bdType);
        return PERSON_PROP_TYPE.get(bdType);
    }

    public static String getPersonCusType(String bdType) {
        LOGGER.info("EventPermService getPersonCusType bdType:{}", (Object)bdType);
        return PERSON_CUSTOM_TYPE.get(bdType);
    }

    public static PersonInfo getPersonInfo(Long pId, String type) {
        LOGGER.info("EventPermService getPersonInfo param pid={} type={}, ", (Object)pId, (Object)type);
        PersonInfo personInfo = new PersonInfo();
        personInfo.setOriginal(pId);
        personInfo.setType(type);
        if (HRStringUtils.equals((String)type, (String)"4")) {
            Map depIdMap = HRPIDepempServiceHelper.getDepempIds((Long)pId);
            personInfo.setPersonId((Long)depIdMap.get("person_id"));
            personInfo.setDepempId(pId);
            PersonService.setPersonInfo(personInfo.getPersonId(), "2", personInfo);
            Set<DepInfo> depInfoList = PersonService.getDepBu(Sets.newHashSet((Object[])new Long[]{pId}), personInfo.getUserId());
            personInfo.setDepSet(depInfoList);
        } else if (HRStringUtils.equals((String)type, (String)"1")) {
            Map resultMap = HRPIPersonServiceHelper.getPersonModelIdByUserId((Long)pId);
            Map data = (Map)resultMap.get("data");
            if (Objects.isNull(data)) {
                personInfo.setUserId(pId);
                return personInfo;
            }
            Long personId = (Long)data.get("person");
            PersonService.setPersonInfo(personId, "2", personInfo);
        } else if (HRStringUtils.equals((String)type, (String)"2")) {
            personInfo.setPersonId(pId);
            PersonService.setPersonInfo(pId, "2", personInfo);
        } else if (HRStringUtils.equals((String)type, (String)"3")) {
            personInfo.setEmployeeId(pId);
            PersonService.setPersonInfo(pId, "3", personInfo);
        }
        LOGGER.info("EventPermService getPersonInfo result={} ", (Object)personInfo);
        return personInfo;
    }

    private static void setPersonInfo(Long pId, String type, PersonInfo personInfo) {
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)4);
        qFilterList.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        if (HRStringUtils.equals((String)type, (String)"2")) {
            qFilterList.add(new QFilter("person", "=", (Object)pId));
        } else if (HRStringUtils.equals((String)type, (String)"3")) {
            qFilterList.add(new QFilter("employee", "=", (Object)pId));
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrpi_depemp");
        DynamicObject[] dys = helper.query("id,person,employee", HRPermCommonUtil.listToQFilters((List)qFilterList));
        HashSet depSet = Sets.newHashSetWithExpectedSize((int)16);
        Long personId = null;
        Long employeeId = null;
        for (DynamicObject dynamicObject : dys) {
            depSet.add(dynamicObject.getLong("id"));
            personId = dynamicObject.getLong("person.id");
            employeeId = dynamicObject.getLong("employee.id");
        }
        personInfo.setPersonId(personId);
        personInfo.setEmployeeId(employeeId);
        Long sysUserId = (Long)PermFileSyncServiceHelper.getSysUserId(personId);
        personInfo.setUserId(sysUserId);
        LOGGER.info("EventPermService setPersonInfo sysUserId={} ", (Object)sysUserId);
        Set<DepInfo> depInfoList = PersonService.getDepBu(depSet, sysUserId);
        personInfo.setDepSet(depInfoList);
        personInfo.setAllDepSet(depInfoList);
    }

    private static Set<DepInfo> getDepBu(Set<Long> depSet, Long sysUserId) {
        DynamicObject[] erManFiles = PersonService.getErManFile(depSet);
        HashSet orgSet = Sets.newHashSetWithExpectedSize((int)erManFiles.length);
        HashSet depInfoList = Sets.newHashSetWithExpectedSize((int)depSet.size());
        for (DynamicObject dy : erManFiles) {
            Long org = dy.getLong("org.id");
            if (!orgSet.add(org)) continue;
            DepInfo depInfo = new DepInfo();
            depInfo.setBuId(org);
            depInfo.setDepId(Long.valueOf(dy.getLong("depemp.id")));
            depInfoList.add(depInfo);
            LOGGER.info("EventPermService getDepBu depInfo={} ", (Object)depInfo);
        }
        LOGGER.info("EventPermService getDepBu {} ", (Object)depInfoList);
        return depInfoList;
    }

    public static DynamicObject[] getErManFile(Set<Long> depempIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hspm_ermanfile");
        return helper.queryOriginalArray("org.id,depemp.id", new QFilter[]{new QFilter("depemp.id", "in", depempIds), new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("datastatus", "=", (Object)"1")});
    }

    public static PersonInfo getMemberInfo(DynamicObject assignDataSource, String prop, DynamicObject billDyn, Map<String, Long> personData) {
        String dataSourceName = assignDataSource.getString("entitytype.name");
        LOGGER.info("EventPermService getMemberInfo prop={},dataSourceName:{} ", (Object)prop, (Object)dataSourceName);
        DynamicObjectCollection personEntry = assignDataSource.getDynamicObjectCollection("personentry");
        PersonInfo personInfo = new PersonInfo();
        for (DynamicObject dy : personEntry) {
            String personProp = dy.getString("person_propkey");
            String personType = dy.getString("persontype");
            String personClass = dy.getString("personclass");
            LOGGER.info("EventPermService getMemberInfo prop:{} to equals personProp:{} result:{}", new Object[]{prop, personProp, HRStringUtils.equals((String)prop, (String)personProp)});
            if (!HRStringUtils.equals((String)prop, (String)personProp)) continue;
            if (HRStringUtils.equals((String)personClass, (String)"1")) {
                LOGGER.info("EventPermService getMemberInfo match prop={} ", (Object)prop);
                try {
                    Long pId = (Long)billDyn.get(prop + ".id");
                    personInfo = PersonService.getPersonInfo(pId, personType);
                }
                catch (Exception ex) {
                    LOGGER.error("EventPermService getMemberInfo error", (Throwable)ex);
                }
                continue;
            }
            if (HRStringUtils.equals((String)personClass, (String)"2")) {
                if (HRStringUtils.equals((String)"3", (String)personType) || HRStringUtils.equals((String)"2", (String)personType)) {
                    LOGGER.info("EventPermService getMemberInfo not support type ={} continue ", (Object)personType);
                    continue;
                }
                Long personId = personData.get(prop);
                personInfo = PersonService.getPersonInfo(personId, personType);
                continue;
            }
            LOGGER.info("EventPermService getMemberInfo no set personClass ");
        }
        LOGGER.info("EventPermService getMemberInfo PersonInfo={} ", (Object)personInfo);
        return personInfo;
    }
}

