/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.hradmin;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Html;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRCloudServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRRoleFunctionPermHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.HrbuCaControlHelper;

public class HRAdminGroupPermHelper {
    private static final Log LOGGER = LogFactory.getLog(HRAdminGroupPermHelper.class);
    private IPageCache pageCache;
    private Map<String, Map<String, List<String>>> cloudAppBuCaFunc;
    private Map<String, String> allCloudName;
    private Map<String, Long> allEntitySpecFunc;
    private Map<String, String> allAppFunc;
    private Map<String, Set<String>> allDeployEntity = new HashMap<String, Set<String>>(16);
    private Map<String, Set<String>> allSpecAppInfo;

    public HRAdminGroupPermHelper(IPageCache pPageCache) {
        this.pageCache = pPageCache;
        this.init();
    }

    private void init() {
        String cloudAppBuCaFuncStr = this.pageCache.get("cloudAppBuCaFunc");
        if (StringUtils.isNotEmpty((String)cloudAppBuCaFuncStr)) {
            this.cloudAppBuCaFunc = (Map)SerializationUtils.fromJsonString((String)cloudAppBuCaFuncStr, Map.class);
        } else {
            this.cloudAppBuCaFunc = new HashMap<String, Map<String, List<String>>>(16);
            this.pageCache.put("cloudAppBuCaFunc", SerializationUtils.toJsonString(this.cloudAppBuCaFunc));
        }
        this.getAllCloudInfo();
        if (this.allEntitySpecFunc == null) {
            this.allEntitySpecFunc = HRRoleFunctionPermHelper.getAllEntitySpecFunc();
        }
        if (this.allSpecAppInfo == null && this.allEntitySpecFunc.size() > 0) {
            this.buildSpecAppInfo();
        }
        String allAppFuncStr = this.pageCache.get("allAppFunc");
        if (StringUtils.isNotEmpty((String)cloudAppBuCaFuncStr)) {
            this.allAppFunc = (Map)SerializationUtils.fromJsonString((String)allAppFuncStr, Map.class);
        } else {
            this.allAppFunc = new HashMap<String, String>(16);
            this.pageCache.put("allAppFunc", SerializationUtils.toJsonString(this.allAppFunc));
        }
    }

    private void buildSpecAppInfo() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_entityobject");
        QFilter filter = new QFilter("id", "in", this.allEntitySpecFunc.keySet());
        DynamicObject[] query = serviceHelper.query("id,bizappid", new QFilter[]{filter});
        Arrays.stream(query).collect(Collectors.toMap(it -> it.getString("id"), it -> it.getString("bizappid.id")));
        this.allSpecAppInfo = new HashMap<String, Set<String>>(16);
        for (DynamicObject dynamicObject : query) {
            String appId = dynamicObject.getString("bizappid.id");
            Set entity = this.allSpecAppInfo.computeIfAbsent(appId, k -> new HashSet(16));
            entity.add(dynamicObject.getString("id"));
        }
    }

    private void queryAllDeployEntity() {
        DynamicObject[] objects;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("perm_bizobjapp");
        for (DynamicObject object : objects = serviceHelper.query("bizobj,bizapp", null)) {
            String bizApp = object.getString("bizapp.id");
            String entityId = object.getString("bizobj.id");
            if (!HRStringUtils.isNotEmpty((String)bizApp) || !HRStringUtils.isNotEmpty((String)entityId)) continue;
            Set entities = this.allDeployEntity.computeIfAbsent(bizApp, k -> new HashSet(16));
            entities.add(entityId);
        }
    }

    public void setAllAppFunc(Set<String> appIds) {
        if (!this.allAppFunc.isEmpty()) {
            return;
        }
        Map<String, Map<String, Object>> hrBuCaFuncMapByAppId = HrbuCaControlHelper.getHRBuCaFuncMapByAppId(appIds);
        for (Map<String, Object> value : hrBuCaFuncMapByAppId.values()) {
            String buCaFuncId = (String)value.get("buCaFuncId");
            HashSet apps = (HashSet)value.get("appId");
            if (apps.size() <= 0) continue;
            for (String app : apps) {
                this.allAppFunc.put(app, buCaFuncId);
            }
        }
        this.pageCache.put("allAppFunc", SerializationUtils.toJsonString(this.allAppFunc));
    }

    public Set<String> getBuCaFunctionsInApp(String cloudId, String appId) {
        String appDefaultFunc;
        Set<String> entities;
        List<String> res;
        Map<String, List<String>> appBuCaFunc;
        if (this.allDeployEntity.size() <= 0) {
            this.queryAllDeployEntity();
        }
        if (null == (appBuCaFunc = this.cloudAppBuCaFunc.get(cloudId))) {
            appBuCaFunc = new HashMap<String, List<String>>(16);
        }
        if (null != (res = appBuCaFunc.get(appId))) {
            HashSet buCaFuncs = Sets.newHashSet(res);
            return buCaFuncs;
        }
        HashSet<String> buCaFuncs = new HashSet<String>(16);
        if (this.allSpecAppInfo != null && this.allSpecAppInfo.get(appId) != null) {
            entities = this.allSpecAppInfo.get(appId);
            entities.forEach(it -> buCaFuncs.add(String.valueOf(this.allEntitySpecFunc.get(it))));
        }
        if ((entities = this.allDeployEntity.get(appId)) != null && entities.size() > 0) {
            for (String entity : entities) {
                Long bucaId = this.allEntitySpecFunc.get(entity);
                if (bucaId == null) continue;
                buCaFuncs.add(String.valueOf(bucaId));
            }
        }
        if (StringUtils.isEmpty((String)(appDefaultFunc = this.allAppFunc.get(appId)))) {
            buCaFuncs.add("11");
        } else {
            buCaFuncs.add(appDefaultFunc);
        }
        appBuCaFunc.put(appId, new ArrayList(buCaFuncs));
        this.cloudAppBuCaFunc.put(cloudId, appBuCaFunc);
        this.pageCache.put("cloudAppBuCaFunc", SerializationUtils.toJsonString(this.cloudAppBuCaFunc));
        LOGGER.info("getBuCaFunctionsInApp allDeployEntity = {}", this.allDeployEntity);
        LOGGER.info("getBuCaFunctionsInApp allSpecAppInfo = {}", this.allSpecAppInfo);
        LOGGER.info("getBuCaFunctionsInApp allEntitySpecFunc = {}", this.allEntitySpecFunc);
        LOGGER.info("getBuCaFunctionsInApp allAppFunc = {}", this.allAppFunc);
        LOGGER.info("getBuCaFunctionsInApp cloudAppBuCaFunc = {}", this.cloudAppBuCaFunc);
        LOGGER.info("getBuCaFunctionsInApp buCaFuncs = {}", buCaFuncs);
        return buCaFuncs;
    }

    public void fillCloudEntryCard(IFormView formView, Map<String, Set<String>> cloudBuCaFunc) {
        Map<String, Map<String, Object>> allHrBuCaMap = this.getAllHrBuCaMap();
        List cloudSeq = HRCloudServiceHelper.getAllHRPermCloudOrderByAsc();
        StringBuilder htmlBuilder = new StringBuilder();
        htmlBuilder.append("<div class=\"maincontainer\">");
        LOGGER.info("fillCloudEntryCard cloudBuCaFunc = {}", cloudBuCaFunc);
        LOGGER.info("allCloudName = {}", this.allCloudName);
        for (String cloudId : cloudSeq) {
            Set<String> infos = cloudBuCaFunc.get(cloudId);
            if (infos == null) continue;
            LOGGER.info("fillCloudEntryCard infos =  {}", infos);
            ArrayList buCaFuncNames = new ArrayList(16);
            infos.forEach(buCaFuncId -> {
                Map buCaFuncInfo = (Map)allHrBuCaMap.get(buCaFuncId);
                if (null != buCaFuncInfo) {
                    buCaFuncNames.add(String.valueOf(buCaFuncInfo.get("name")));
                }
            });
            String cloudName = this.allCloudName.get(cloudId);
            htmlBuilder.append("<h2 class=\"cloudname\">").append(HRStringUtils.isEmpty((String)cloudName) ? cloudId : cloudName).append("</h2>");
            htmlBuilder.append("<p class=\"hrbucatips\" style=\"padding-bottom:16px\">").append(ResManager.loadKDString((String)"\u5f53\u524d\u5f00\u901a\u7684\u4e1a\u52a1\u8303\u56f4\u4e2d\u5305\u542b\uff0c\u9700\u5728\u201c\u6570\u636e\u6388\u6743\u8303\u56f4\u201d\u914d\u7f6e\u4ee5\u4e0b\u804c\u80fd\u7c7b\u578b\u7684\u7ec4\u7ec7\u6570\u636e\u8303\u56f4\uff0c\u5305\u62ec\uff1a%s\u3002", (String)"RoleServiceHelper_19", (String)"hrmp-hrcs-business", (Object[])new Object[]{String.join((CharSequence)",", buCaFuncNames)})).append("</p>");
        }
        htmlBuilder.append("</div>");
        Html cloudContainer = (Html)formView.getControl("cloudcontainer");
        cloudContainer.setConent(htmlBuilder.toString());
    }

    public Map<String, Map<String, Object>> getAllHrBuCaMap() {
        String allHrBuCaFuncJson = this.pageCache.get("businessList");
        Map allHrBuCaFuncMap = HRStringUtils.isEmpty((String)allHrBuCaFuncJson) ? HrbuCaControlHelper.getAllHRBuCaFuncMapForPerm() : (Map)SerializationUtils.fromJsonString((String)allHrBuCaFuncJson, List.class);
        this.pageCache.put("allHrBuCaFuncMap", SerializationUtils.toJsonString((Object)allHrBuCaFuncMap));
        return allHrBuCaFuncMap;
    }

    public static DynamicObject[] queryDataRange(long adminGroupId) {
        HRBaseServiceHelper orgHelper = new HRBaseServiceHelper("hrcs_admingrouporg");
        QFilter filter = new QFilter("admingroup.id", "=", (Object)adminGroupId);
        return orgHelper.loadDynamicObjectArray(new QFilter[]{filter});
    }

    private void getAllCloudInfo() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_devportal_bizcloud");
        DynamicObject[] clouds = serviceHelper.query("id,name", new QFilter[0]);
        this.allCloudName = new HashMap<String, String>(clouds.length);
        for (DynamicObject cloud : clouds) {
            this.allCloudName.put(cloud.getString("id"), cloud.getString("name"));
        }
    }
}

