/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.imp;

import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.SyncAssignLicenseHelper;
import kd.hr.hrcs.bussiness.util.PermRoleUtil;
import kd.hr.hrcs.common.model.PermImportModel;
import kd.hr.hrcs.common.model.SyncAssignLicenseModel;

public class UserDataRuleImportHelper {
    private static HRBaseServiceHelper USER_ROLE_RELATE_HELPER = new HRBaseServiceHelper("hrcs_userrolerelat");
    private static final Log LOGGER = LogFactory.getLog(UserDataRuleImportHelper.class);

    public DynamicObjectCollection queryDataRuleColByNumber(Set<String> dataRuleNumSet) {
        HRBaseServiceHelper dataRuleHelper = new HRBaseServiceHelper("hrcs_datarule");
        return dataRuleHelper.queryOriginalCollection("id, number, entitynum, enable", new QFilter[]{new QFilter("number", "in", dataRuleNumSet), new QFilter("status", "!=", (Object)"LD")});
    }

    public DynamicObjectCollection queryRoleColByNumber(Set<String> roleNumSet) {
        HRBaseServiceHelper roleHelper = new HRBaseServiceHelper("hrcs_role");
        return roleHelper.queryOriginalCollection("id, property", new QFilter[]{new QFilter("id", "in", roleNumSet)});
    }

    public DynamicObject[] queryFuncPerm(QFilter funcPermQFilter) {
        HRBaseServiceHelper funcPermHelper = new HRBaseServiceHelper("perm_roleperm");
        return funcPermHelper.query("roleid, roleperm.bizapp, roleperm.entity, roleperm.entity.number, roleperm.permitem, roleperm.permitem.id, roleperm.permitem.name", new QFilter[]{funcPermQFilter});
    }

    public DynamicObjectCollection findRoleDuty(Set<String> roleIdSet) {
        HRBaseServiceHelper roleBuHelper = new HRBaseServiceHelper("hrcs_rolebu");
        return roleBuHelper.queryOriginalCollection("id, role, hrbucafunc", new QFilter[]{new QFilter("role", "in", roleIdSet)});
    }

    public DynamicObjectCollection queryUserRoleCol(Set<Long> userRoleRelateIdSet) {
        HRBaseServiceHelper userRoleHelper = new HRBaseServiceHelper("hrcs_userrole");
        return userRoleHelper.queryOriginalCollection("id, org, bucafunc, userrolepf", new QFilter[]{new QFilter("userrolerealt", "in", userRoleRelateIdSet)});
    }

    public DynamicObject[] loadUserRoleRelateCol(QFilter userRoleRelateQFilter) {
        return USER_ROLE_RELATE_HELPER.loadDynamicObjectArray(new QFilter[]{userRoleRelateQFilter});
    }

    public DynamicObjectCollection queryUserRoleRelateCol(QFilter userRoleRelateQFilter) {
        return USER_ROLE_RELATE_HELPER.queryOriginalCollection("id, role.id, user.id, validstart, validend, customenable", new QFilter[]{userRoleRelateQFilter});
    }

    public boolean saveBosUserRole(Set<String> userRolePfIdSet, DynamicObjectCollection bosUserRoleCol, List<PermImportModel> dataList) {
        HRBaseServiceHelper bosUserRoleHelper = new HRBaseServiceHelper("perm_userrole");
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                bosUserRoleHelper.deleteByFilter(new QFilter[]{new QFilter("id", "in", userRolePfIdSet)});
                bosUserRoleHelper.save(bosUserRoleCol);
                this.syncAssignLicense(dataList);
            }
            catch (Exception ex) {
                txHandle.markRollback();
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("save bosUserRole failed", (Throwable)ex);
                }
                boolean bl = false;
                if (txHandle != null) {
                    if (var6_6 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return bl;
            }
        }
        return true;
    }

    private void syncAssignLicense(List<PermImportModel> dataList) throws KDBizException {
        List<SyncAssignLicenseModel> syncAssignLicenseModels = SyncAssignLicenseHelper.getSyncModel(dataList);
        if (syncAssignLicenseModels == null) {
            return;
        }
        for (SyncAssignLicenseModel data : syncAssignLicenseModels) {
            if (PermRoleUtil.handleUserRoleLicense(data.getUserIds(), data.getAppEntity())) continue;
            throw new KDBizException("Sync license failed");
        }
    }

    public boolean saveHrData(DynamicObjectCollection originUserRelateCol, DynamicObjectCollection newUserRoleRelateCol, Set<Long> originUserRoleIdSet, DynamicObjectCollection userRoleCol, DynamicObjectCollection updateDataRuleDyList, DynamicObjectCollection newDataRuleDyList) {
        HRBaseServiceHelper userRoleHelper = new HRBaseServiceHelper("hrcs_userrole");
        HRBaseServiceHelper userDataRuleHelper = new HRBaseServiceHelper("hrcs_userdatarule");
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                USER_ROLE_RELATE_HELPER.save(originUserRelateCol);
                USER_ROLE_RELATE_HELPER.save(newUserRoleRelateCol);
                userRoleHelper.deleteByFilter(new QFilter[]{new QFilter("id", "in", originUserRoleIdSet)});
                userRoleHelper.save(userRoleCol);
                userDataRuleHelper.save(updateDataRuleDyList);
                userDataRuleHelper.save(newDataRuleDyList);
            }
            catch (Exception ex) {
                txHandle.markRollback();
                boolean bl = false;
                if (txHandle != null) {
                    if (var10_10 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var10_10.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return bl;
            }
        }
        return true;
    }
}

