/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.log;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.perm.AssignSource;
import kd.hr.hbp.common.model.perm.EntityFieldPermParam;
import kd.hr.hbp.common.model.perm.UserBucaPermDataParam;
import kd.hr.hbp.common.model.perm.UserRoleAssignParam;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.perm.common.RoleAssignParamBuilder;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.PermLogServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.log.RoleAssignLogServiceHelper;
import kd.hr.hrcs.common.constants.perm.log.RoleAssignFieldEnum;
import kd.hr.hrcs.common.constants.perm.log.RoleAssignSourceTypeEnum;
import kd.hr.hrcs.common.model.perm.dyna.DynaScheme;
import kd.hr.hrcs.common.model.perminit.OrgRangeBean;

public class RoleAssignLogBussinessHelper {
    private static final Log LOGGER = LogFactory.getLog(RoleAssignLogBussinessHelper.class);

    public static DynamicObject getPermFile(Long permFileId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_userpermfile");
        DynamicObject dyno = helper.queryOne((Object)permFileId);
        if (dyno != null) {
            return dyno;
        }
        return null;
    }

    public static DynamicObject getUserByPermFile(Long permFileId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_userpermfile");
        QFilter qFilter = new QFilter("id", "=", (Object)permFileId);
        DynamicObject dyno = helper.queryOriginalOne("user.id", qFilter);
        if (dyno != null) {
            return dyno.getDynamicObject("user");
        }
        return null;
    }

    public static DynamicObject getRoleById(String roleId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("perm_role");
        DynamicObject dyno = helper.queryOne((Object)roleId);
        if (dyno != null) {
            return dyno;
        }
        return null;
    }

    public static DynamicObject getHrcsRoleById(String roleId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_role");
        DynamicObject dyno = helper.queryOne((Object)roleId);
        if (dyno != null) {
            return dyno;
        }
        return null;
    }

    public static DynamicObject getRoleAssignRelate(Long relateId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_userrolerelat");
        DynamicObject dyno = helper.queryOne((Object)relateId);
        if (dyno != null) {
            return dyno;
        }
        return null;
    }

    public static HashMap<Object, Object> getFieldMap(UserRoleAssignParam afterRoleAssignInfo, DynamicObject roleAssignRelate, DynamicObject dyn) {
        DynamicObject dynamicObject;
        DynamicObject permFile = roleAssignRelate.getDynamicObject("permfile");
        dyn.set("permfile", (Object)permFile);
        dyn.set("role", (Object)afterRoleAssignInfo.getRoleId());
        DynamicObject user = roleAssignRelate.getDynamicObject("user");
        DynamicObject role = roleAssignRelate.getDynamicObject("role");
        dyn.set("rolename", (Object)role.getLocaleString("name").getLocaleValue());
        dyn.set("rolenumber", (Object)role.getString("number"));
        String dataProperty = roleAssignRelate.getString("customenable");
        HashMap objectObjectHashMap = Maps.newHashMapWithExpectedSize((int)16);
        objectObjectHashMap.put(RoleAssignFieldEnum.name, user.getLocaleString("name").getLocaleValue());
        objectObjectHashMap.put(RoleAssignFieldEnum.number, user.getString("number"));
        objectObjectHashMap.put(RoleAssignFieldEnum.hrbu, permFile.getLocaleString("org.name") == null ? "" : permFile.getLocaleString("org.name").toString());
        objectObjectHashMap.put(RoleAssignFieldEnum.rolename, role.getLocaleString("name").getLocaleValue());
        objectObjectHashMap.put(RoleAssignFieldEnum.rolenumber, role.getString("number"));
        String sourceType = roleAssignRelate.getString("sourcetype");
        objectObjectHashMap.put(RoleAssignFieldEnum.sourcetype, RoleAssignSourceTypeEnum.getDescription((String)sourceType));
        if (HRStringUtils.equals((String)sourceType, (String)"3")) {
            dynamicObject = roleAssignRelate.getDynamicObject("initrecord");
            if (null != dynamicObject) {
                objectObjectHashMap.put(RoleAssignFieldEnum.sourcebd, dynamicObject.getLocaleString("name").toString());
            }
        } else if (HRStringUtils.equals((String)sourceType, (String)"4") && null != (dynamicObject = roleAssignRelate.getDynamicObject("scheme"))) {
            objectObjectHashMap.put(RoleAssignFieldEnum.sourcebd, dynamicObject.getLocaleString("name").toString());
        }
        if (HRStringUtils.equals((String)"1", (String)dataProperty)) {
            objectObjectHashMap.put(RoleAssignFieldEnum.dataproperty, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6570\u636e\u8303\u56f4", (String)"RoleAssignAddLogHandler_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        } else {
            objectObjectHashMap.put(RoleAssignFieldEnum.dataproperty, ResManager.loadKDString((String)"\u4e0e\u89d2\u8272\u6570\u636e\u8303\u56f4\u4e00\u81f4", (String)"RoleAssignAddLogHandler_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        String startDate = DateUtils.dateToString((Date)afterRoleAssignInfo.getValidStart(), (DatePattern)DatePattern.YYYY_MM_DD);
        String endDate = DateUtils.dateToString((Date)afterRoleAssignInfo.getValidEnd(), (DatePattern)DatePattern.YYYY_MM_DD);
        if (startDate == null || endDate == null) {
            objectObjectHashMap.put(RoleAssignFieldEnum.effectivedaterange, "");
        } else {
            objectObjectHashMap.put(RoleAssignFieldEnum.effectivedaterange, startDate + "~" + endDate);
        }
        return objectObjectHashMap;
    }

    public static Map<Long, List<OrgRangeBean>> calUserOrgs(UserRoleAssignParam afterRoleAssignInfo) {
        ArrayList userOrgRanges = Lists.newArrayListWithExpectedSize((int)16);
        if (afterRoleAssignInfo.isCustomData()) {
            Map bucaPermData = afterRoleAssignInfo.getDataRangeParam().getBucaPermData();
            for (UserBucaPermDataParam bucaPermDataParam : bucaPermData.values()) {
                Long bucaId = bucaPermDataParam.getBucaId();
                for (Map.Entry orgEntry : bucaPermDataParam.getOrgInfos().entrySet()) {
                    OrgRangeBean orgRangeBean = new OrgRangeBean(bucaId, (Long)orgEntry.getKey(), (Boolean)orgEntry.getValue());
                    userOrgRanges.add(orgRangeBean);
                }
            }
        } else {
            HRBaseServiceHelper roleBuHelper = new HRBaseServiceHelper("hrcs_rolebu");
            DynamicObjectCollection orgColl = roleBuHelper.queryOriginalCollection("org.id,containssub,hrbucafunc", new QFilter[]{new QFilter("role", "=", (Object)afterRoleAssignInfo.getRoleId())});
            for (DynamicObject orgDyna : orgColl) {
                OrgRangeBean orgRangeBean = new OrgRangeBean(Long.valueOf(orgDyna.getLong("hrbucafunc")), Long.valueOf(orgDyna.getLong("org.id")), Boolean.valueOf(orgDyna.getBoolean("containssub")));
                userOrgRanges.add(orgRangeBean);
            }
        }
        Map<Long, List<OrgRangeBean>> collect = userOrgRanges.stream().collect(Collectors.groupingBy(userOrgRange -> userOrgRange.getBucaFuncId()));
        return collect;
    }

    public static String getDataRuleDisplayText(String filterCondition, String entityNumber) {
        FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)filterCondition, FilterCondition.class);
        if (CollectionUtils.isEmpty((Collection)fc.getFilterRow())) {
            return "";
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, fc);
        filterBuilder.buildFilter();
        String orgFilterDesc = filterBuilder.getFilterStringDesc().replaceAll("\\s+", " ");
        int useMsgIndex = orgFilterDesc.lastIndexOf(")") - 4;
        String useLocaleStr = orgFilterDesc.substring(0, useMsgIndex).replaceFirst("\\(", "");
        return useLocaleStr;
    }

    public static String getUserRoleFieldString(EntityFieldPermParam fieldPermParam) {
        String viewStr = String.format(ResManager.loadKDString((String)"\u67e5\u770b\uff1a%s\u3002", (String)"RoleLogBaseHandler_6", (String)"hrmp-hrcs-business", (Object[])new Object[0]), RoleAssignLogBussinessHelper.getStringVal(fieldPermParam.isCanRead()));
        String editStr = String.format(ResManager.loadKDString((String)"\u7f16\u8f91\uff1a%s\u3002", (String)"RoleLogBaseHandler_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]), RoleAssignLogBussinessHelper.getStringVal(fieldPermParam.isCanWrite()));
        return viewStr + "\n" + editStr;
    }

    private static String getStringVal(boolean view) {
        return view ? ResManager.loadKDString((String)"\u5141\u8bb8", (String)"RoleLogBaseHandler_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8", (String)"RoleLogBaseHandler_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
    }

    public static ArrayList<UserRoleAssignParam> getUserRoleAssignParams(Set<Long> relatIdSet) {
        ArrayList permLogParams = Lists.newArrayListWithCapacity((int)16);
        try {
            DynamicObject[] userrolerealts;
            HRBaseServiceHelper userRoleRelHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
            for (DynamicObject userrolerealt : userrolerealts = userRoleRelHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", relatIdSet)})) {
                String customenable = userrolerealt.getString("customenable");
                if (HRStringUtils.equals((String)"1", (String)customenable)) {
                    permLogParams.add(RoleAssignParamBuilder.buildBeforeUserRoleAssignParams(userrolerealt.getString("role.id"), userrolerealt.getLong("id")));
                    continue;
                }
                long permFileId = userrolerealt.getLong("permfile.id");
                Date validStart = userrolerealt.getDate("validstart");
                Date validEnd = userrolerealt.getDate("validend");
                UserRoleAssignParam beforeParam = new UserRoleAssignParam(Long.valueOf(permFileId), userrolerealt.getString("role.id"), validStart, validEnd, Long.valueOf(RequestContext.get().getCurrUserId()));
                beforeParam.setCustomData(false);
                permLogParams.add(beforeParam);
                RoleAssignLogBussinessHelper.setSourceTypeAndSchemeName(beforeParam.getAssignSource(), userrolerealt.getLong("id"));
            }
        }
        catch (Exception exception) {
            LOGGER.error("kd.hr.hrcs.formplugin.web.perm.permfile.HRUserAssignRolePlugin.delRoleData error", (Throwable)exception);
        }
        return permLogParams;
    }

    public static void savePermLogs(ArrayList<UserRoleAssignParam> permLogParams, String pageSource) {
        try {
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
            for (int i = 0; i < permLogParams.size(); ++i) {
                UserRoleAssignParam deleteParam = permLogParams.get(i);
                AssignSource assignSource = deleteParam.getAssignSource();
                assignSource.setObType("userRoleDelete");
                assignSource.setPageSource(pageSource);
                RoleAssignLogServiceHelper.roleAssignPermLog("userRoleDelete", deleteParam, null, i, dynamicObjectCollection);
            }
            PermLogServiceHelper.savePermLogs(dynamicObjectCollection);
        }
        catch (Exception exception) {
            LOGGER.error("delRoleData error", (Throwable)exception);
        }
    }

    public static void setSourceTypeAndSchemeName(AssignSource assignSource, Long relateId) {
        DynamicObject dynamicObject;
        DynamicObject roleAssignRelate = RoleAssignLogBussinessHelper.getRoleAssignRelate(relateId);
        if (roleAssignRelate == null) {
            return;
        }
        String sourceType = roleAssignRelate.getString("sourcetype");
        assignSource.setSourceType(sourceType);
        if (HRStringUtils.equals((String)sourceType, (String)"3")) {
            DynamicObject dynamicObject2 = roleAssignRelate.getDynamicObject("initrecord");
            if (null != dynamicObject2) {
                assignSource.setSchemeName(dynamicObject2.getLocaleString("name").toString());
                assignSource.setInitRecordId((Long)dynamicObject2.getPkValue());
            }
        } else if (HRStringUtils.equals((String)sourceType, (String)"4") && null != (dynamicObject = roleAssignRelate.getDynamicObject("scheme"))) {
            assignSource.setSchemeName(dynamicObject.getLocaleString("name").toString());
            assignSource.setSchemeId((Long)dynamicObject.getPkValue());
        }
    }

    public static ArrayList<UserRoleAssignParam> getUserRoleAssignParamsBySchem(Set<Long> relatIdSet, HashMap<Long, DynaScheme> relateIdSchemeMap) {
        ArrayList permLogParams = Lists.newArrayListWithCapacity((int)16);
        try {
            DynamicObject[] userrolerealts;
            HRBaseServiceHelper userRoleRelHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
            for (DynamicObject userrolerealt : userrolerealts = userRoleRelHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", relatIdSet)})) {
                LOGGER.info("getUserRoleAssignParamsBySchem relateid={}", (Object)userrolerealt.getLong("id"));
                String customenable = userrolerealt.getString("customenable");
                if (HRStringUtils.equals((String)"1", (String)customenable)) {
                    UserRoleAssignParam userRoleAssignParam = RoleAssignParamBuilder.buildBeforeUserRoleAssignParams(userrolerealt.getString("role.id"), userrolerealt.getLong("id"));
                    DynaScheme dynaScheme = relateIdSchemeMap.get(userrolerealt.getLong("id"));
                    if (dynaScheme != null && userRoleAssignParam != null) {
                        AssignSource assignSource = userRoleAssignParam.getAssignSource();
                        assignSource.setSchemeName(dynaScheme.getName());
                        assignSource.setSchemeId(dynaScheme.getId());
                    }
                    permLogParams.add(userRoleAssignParam);
                    continue;
                }
                long permFileId = userrolerealt.getLong("permfile.id");
                Date validStart = userrolerealt.getDate("validstart");
                Date validEnd = userrolerealt.getDate("validend");
                UserRoleAssignParam beforeParam = new UserRoleAssignParam(Long.valueOf(permFileId), userrolerealt.getString("role.id"), validStart, validEnd, Long.valueOf(RequestContext.get().getCurrUserId()));
                beforeParam.setCustomData(false);
                permLogParams.add(beforeParam);
                RoleAssignLogBussinessHelper.setSourceTypeAndSchemeName(beforeParam.getAssignSource(), userrolerealt.getLong("id"), relateIdSchemeMap);
            }
        }
        catch (Exception exception) {
            LOGGER.error("kd.hr.hrcs.formplugin.web.perm.permfile.HRUserAssignRolePlugin.delRoleData error", (Throwable)exception);
        }
        return permLogParams;
    }

    public static void setSourceTypeAndSchemeName(AssignSource assignSource, Long relateId, HashMap<Long, DynaScheme> relateIdSchemeMap) {
        DynamicObject roleAssignRelate = RoleAssignLogBussinessHelper.getRoleAssignRelate(relateId);
        if (roleAssignRelate == null) {
            return;
        }
        String sourceType = roleAssignRelate.getString("sourcetype");
        assignSource.setSourceType(sourceType);
        if (HRStringUtils.equals((String)sourceType, (String)"3")) {
            DynamicObject dynamicObject = roleAssignRelate.getDynamicObject("initrecord");
            if (null != dynamicObject) {
                assignSource.setSchemeName(dynamicObject.getLocaleString("name").toString());
                assignSource.setInitRecordId((Long)dynamicObject.getPkValue());
            }
        } else if (HRStringUtils.equals((String)sourceType, (String)"4")) {
            DynamicObject dynamicObject = roleAssignRelate.getDynamicObject("scheme");
            if (null != dynamicObject) {
                assignSource.setSchemeName(dynamicObject.getLocaleString("name").toString());
                assignSource.setSchemeId((Long)dynamicObject.getPkValue());
            }
        } else {
            DynaScheme dynaScheme = relateIdSchemeMap.get(relateId);
            if (dynaScheme != null) {
                assignSource.setSchemeName(dynaScheme.getName());
                assignSource.setSchemeId(dynaScheme.getId());
            }
        }
    }
}

