/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.ot;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.OrgSubInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.ot.PermLazyOTTreeHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.ot.PermOTLazyTreeCommonHelper;
import kd.hr.hrcs.common.constants.HRCSBaseConstants;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import kd.hr.hrcs.common.model.OrgTeamTreeBean;

@ExcludeFromJacocoGeneratedReport
public class PermLazyOTSearchTreeHelper {
    private static final Log LOGGER = LogFactory.getLog(PermLazyOTSearchTreeHelper.class);
    private static final String OT_SELECT_FIELDS = "orgteam.id id, orgteam.name name,orgteam.enable enable,orgteam.number number, orgteam.otclassify classify, enable structenable, structproject, structproject.relyonstructproject, parentorgteam.id parentId,structlongnumber,orgteam.structnumber structnumber";
    private static final String ORG_ORDER_FIELDS = "index, orgteam.number";
    private static final String PROP_LONG_NUMBER = "structlongnumber";

    public static TreeNode buildSearchedOrgTreeNode(String searchText, List<Long> structProjects, Map<String, String> structRelyOnMap, boolean isCustomProjectStruct, boolean showCompanyName) {
        QFilter searchFilter = new QFilter("orgteam.name", "ftlike", (Object)searchText);
        List<QFilter> baseQFilterList = PermOTLazyTreeCommonHelper.getBaseQFilterList();
        baseQFilterList.add(searchFilter);
        baseQFilterList.add(new QFilter("structproject", "in", structProjects));
        HRBaseServiceHelper serviceHelper = isCustomProjectStruct ? PermOTLazyTreeCommonHelper.CUSTOM_OT_STRUCT_HELPER : PermOTLazyTreeCommonHelper.OT_STRUCT_HELPER;
        DynamicObjectCollection searchedCollection = serviceHelper.queryOriginalCollection(OT_SELECT_FIELDS, HRPermCommonUtil.listToQFilters(baseQFilterList), ORG_ORDER_FIELDS);
        Set orgTeamIdSet = searchedCollection.stream().map(it -> it.getLong("id")).collect(Collectors.toSet());
        LOGGER.info("Got hr admin org id set: {}.", orgTeamIdSet);
        Map<Long, String> companyMap = Arrays.stream(serviceHelper.query("id,company.name", new QFilter[]{new QFilter("id", "in", orgTeamIdSet), new QFilter("orgtype.adminorgtypestd.id", "in", Arrays.asList(1030L, 1040L))})).filter(Objects::nonNull).filter(it -> HRStringUtils.isNotEmpty((String)it.getString("company.name"))).collect(Collectors.toMap(it -> it.getLong("id"), it -> it.getString("company.name"), (oldValue, newValue) -> oldValue));
        LOGGER.info("Got hr admin org company name set: {}.", companyMap);
        List<OrgTeamTreeBean> searchedOrgBeanList = searchedCollection.stream().map(dyno -> {
            String name = PermOTLazyTreeCommonHelper.getDisabledName(dyno.getString("name"), (String)companyMap.get(dyno.getLong("id")), dyno.getString("enable"), dyno.getString("structenable"), showCompanyName);
            return new OrgTeamTreeBean(Long.valueOf(dyno.getLong("id")), Long.valueOf(dyno.getLong("parentId")), dyno.getString("number"), name, dyno.getString("structnumber"), dyno.getString(PROP_LONG_NUMBER), Long.valueOf(dyno.getLong("classify")), Long.valueOf(dyno.getLong("structproject")), Long.valueOf(dyno.getLong("structproject.relyonstructproject")));
        }).collect(Collectors.toList());
        Long relyOnStruct = structRelyOnMap.values().stream().filter(HRStringUtils::isNotEmpty).map(Long::parseLong).findAny().orElse(HRCSBaseConstants.LONG_MINUS_ONE);
        AuthorizedOrgResultWithSub authorizedOrgResult = PermLazyOTTreeHelper.getHasPermAdminOrgWithSub(structProjects, relyOnStruct, isCustomProjectStruct);
        List<OrgTeamTreeBean> authorizedOrgs = PermLazyOTSearchTreeHelper.filterAuthorizedOrg(searchedOrgBeanList, authorizedOrgResult);
        List<OrgTeamTreeBean> toShowOrgs = PermLazyOTSearchTreeHelper.getPatrilineOrgs(authorizedOrgs, authorizedOrgResult, structProjects, isCustomProjectStruct, showCompanyName);
        return PermLazyOTSearchTreeHelper.buildRootNodeWithChildren(toShowOrgs, structRelyOnMap, structProjects, isCustomProjectStruct);
    }

    private static TreeNode buildRootNodeWithChildren(List<OrgTeamTreeBean> toShowOrgs, Map<String, String> structRelyOnMap, List<Long> structProjects, boolean isCustomProjectStruct) {
        ArrayList toShowNodeList = Lists.newArrayListWithExpectedSize((int)16);
        TreeNode rootNode = null;
        Set parentIds = toShowOrgs.stream().map(OrgTeamTreeBean::getParentId).collect(Collectors.toSet());
        for (OrgTeamTreeBean orgBean : toShowOrgs) {
            if (0L == orgBean.getParentId()) {
                rootNode = PermOTLazyTreeCommonHelper.buildRootNode(structProjects, true, isCustomProjectStruct, null);
                toShowNodeList.add(rootNode);
                continue;
            }
            boolean isParent = parentIds.contains(orgBean.getId());
            TreeNode node2 = new TreeNode(orgBean.getParentId().toString(), orgBean.getId().toString(), orgBean.getName(), isParent);
            node2.setIcon(HRStringUtils.isNotEmpty((String)structRelyOnMap.get(String.valueOf(orgBean.getStructProject()))) ? "kdfont kdfont-xiangmuxingtuandui" : "kdfont kdfont-shitizuzhi");
            node2.setDisabled(!orgBean.isHasPerm());
            if (isParent) {
                node2.setIsOpened(true);
            }
            toShowNodeList.add(node2);
        }
        Map<String, TreeNode> nodeMap = toShowNodeList.stream().collect(Collectors.toMap(TreeNode::getId, node -> node, (oldValue, newValue) -> oldValue));
        for (TreeNode node3 : toShowNodeList) {
            String parentId = node3.getParentid();
            TreeNode parentNode = nodeMap.get(parentId);
            if (!HRStringUtils.isNotEmpty((String)parentId) || parentNode == null) continue;
            parentNode.addChild(node3);
        }
        return rootNode;
    }

    private static List<OrgTeamTreeBean> getPatrilineOrgs(List<OrgTeamTreeBean> authorizedOrgs, AuthorizedOrgResultWithSub authorizedOrgResult, List<Long> structProjects, boolean isCustomProjectStruct, boolean showCompanyName) {
        HashSet structNumberSet = Sets.newHashSetWithExpectedSize((int)16);
        for (OrgTeamTreeBean orgBean : authorizedOrgs) {
            String structLongNumber = orgBean.getStructLongNumber();
            String[] structNumberArr = structLongNumber.split("!");
            structNumberSet.addAll(Arrays.stream(structNumberArr).collect(Collectors.toSet()));
        }
        List<QFilter> baseQFilterList = PermOTLazyTreeCommonHelper.getBaseQFilterList();
        QFilter toShowOrgFilter = new QFilter("orgteam.structnumber", "in", (Object)structNumberSet);
        baseQFilterList.add(toShowOrgFilter);
        baseQFilterList.add(new QFilter("structproject", "in", structProjects));
        HRBaseServiceHelper serviceHelper = isCustomProjectStruct ? PermOTLazyTreeCommonHelper.CUSTOM_OT_STRUCT_HELPER : PermOTLazyTreeCommonHelper.OT_STRUCT_HELPER;
        DynamicObjectCollection patrilineCollection = serviceHelper.queryOriginalCollection(OT_SELECT_FIELDS, HRPermCommonUtil.listToQFilters(baseQFilterList), ORG_ORDER_FIELDS);
        Set orgTeamIdSet = patrilineCollection.stream().map(it -> it.getLong("id")).collect(Collectors.toSet());
        LOGGER.info("Got hr admin org id set: {}.", orgTeamIdSet);
        Map<Long, String> companyMap = Arrays.stream(serviceHelper.query("id,company.name", new QFilter[]{new QFilter("id", "in", orgTeamIdSet), new QFilter("orgtype.adminorgtypestd.id", "in", Arrays.asList(1030L, 1040L))})).filter(Objects::nonNull).filter(it -> HRStringUtils.isNotEmpty((String)it.getString("company.name"))).collect(Collectors.toMap(it -> it.getLong("id"), it -> it.getString("company.name"), (oldValue, newValue) -> oldValue));
        LOGGER.info("Got hr admin org company name set: {}.", companyMap);
        return patrilineCollection.stream().map(dyno -> {
            String name = PermOTLazyTreeCommonHelper.getDisabledName(dyno.getString("name"), (String)companyMap.get(dyno.getLong("id")), dyno.getString("enable"), dyno.getString("structenable"), showCompanyName);
            OrgTeamTreeBean orgBean = new OrgTeamTreeBean(Long.valueOf(dyno.getLong("id")), Long.valueOf(dyno.getLong("parentId")), dyno.getString("number"), name, dyno.getString("structnumber"), dyno.getString(PROP_LONG_NUMBER), Long.valueOf(dyno.getLong("classify")), Long.valueOf(dyno.getLong("structproject")), Long.valueOf(dyno.getLong("structproject.relyonstructproject")));
            orgBean.setParentId(Long.valueOf(dyno.getLong("parentId")));
            if (authorizedOrgResult.isHasAllOrgPerm()) {
                orgBean.setHasPerm(true);
            } else {
                orgBean.setHasPerm(PermLazyOTSearchTreeHelper.judgeHasOrgPerm(orgBean, authorizedOrgResult.getHasPermOrgsWithSub()));
            }
            return orgBean;
        }).collect(Collectors.toList());
    }

    private static List<OrgTeamTreeBean> filterAuthorizedOrg(List<OrgTeamTreeBean> searchedOrgBeanList, AuthorizedOrgResultWithSub authorizedOrgResult) {
        if (authorizedOrgResult.isHasAllOrgPerm()) {
            return searchedOrgBeanList;
        }
        ArrayList authorizedOrgs = Lists.newArrayListWithExpectedSize((int)16);
        List hasPermOrgList = authorizedOrgResult.getHasPermOrgsWithSub();
        for (OrgTeamTreeBean orgBean : searchedOrgBeanList) {
            if (!PermLazyOTSearchTreeHelper.judgeHasOrgPerm(orgBean, hasPermOrgList)) continue;
            authorizedOrgs.add(orgBean);
        }
        return authorizedOrgs;
    }

    private static boolean judgeHasOrgPerm(OrgTeamTreeBean orgBean, List<OrgSubInfo> hasPermOrgList) {
        if (CollectionUtils.isEmpty(hasPermOrgList)) {
            return false;
        }
        String orgLongNumber = orgBean.getStructLongNumber();
        for (OrgSubInfo orgInfo : hasPermOrgList) {
            if ((orgInfo.isContainsSub() || !HRStringUtils.equals((String)orgLongNumber, (String)orgInfo.getLongStructNumber())) && (!orgInfo.isContainsSub() || !HRStringUtils.startsWithIgnoreCase((String)orgLongNumber, (String)orgInfo.getLongStructNumber()))) continue;
            return true;
        }
        return false;
    }
}

