/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.ot;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.OrgSubInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRPermServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.ot.PermOTLazyTreeCommonHelper;
import kd.hr.hrcs.common.constants.HRCSBaseConstants;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import kd.hr.hrcs.common.model.OrgTeamTreeBean;

@ExcludeFromJacocoGeneratedReport
public class PermLazyOTTreeHelper {
    private static final Log LOGGER = LogFactory.getLog(PermLazyOTTreeHelper.class);

    public static List<OrgTeamTreeBean> getHasAdminPermOrgList(Long parentId, List<Long> struct, Long relyOnStruct, boolean isCustomProjectStruct, boolean showCompanyName) {
        return PermLazyOTTreeHelper.getHasAdminPermOrgList(parentId, struct, relyOnStruct, Collections.emptySet(), isCustomProjectStruct, null, showCompanyName);
    }

    public static List<OrgTeamTreeBean> getHasAdminPermOrgList(Long parentId, List<Long> struct, Long relyOnStruct, Set<String> structLongNumbers, boolean isCustomProjectStruct, QFilter extentQFilter, boolean showCompanyName) {
        List<OrgTeamTreeBean> firstLevelList = PermLazyOTTreeHelper.getFirstLevelData(parentId, struct, structLongNumbers, isCustomProjectStruct, extentQFilter, showCompanyName);
        List<Long> firstLevelIdList = firstLevelList.stream().map(OrgTeamTreeBean::getId).collect(Collectors.toList());
        AuthorizedOrgResultWithSub permOrgResult = PermLazyOTTreeHelper.getHasPermAdminOrgWithSub(struct, relyOnStruct, isCustomProjectStruct);
        List orgsWithSub = permOrgResult.getHasPermOrgsWithSub();
        List<OrgTeamTreeBean> secondLevelList = PermLazyOTTreeHelper.getSecondLevelData(firstLevelIdList, struct, isCustomProjectStruct, null);
        boolean hasAll = permOrgResult.isHasAllOrgPerm() ? true : PermLazyOTTreeHelper.hasAllCurrentNodePerm(isCustomProjectStruct, parentId, orgsWithSub, struct, relyOnStruct);
        if (hasAll) {
            return PermLazyOTTreeHelper.getFirstLevelWithAllPerm(firstLevelList, secondLevelList);
        }
        return PermLazyOTTreeHelper.getFirstLevelWithoutAllPerm(firstLevelList, secondLevelList, orgsWithSub);
    }

    public static List<OrgTeamTreeBean> getHasAdminPermOrgList(Long parentId, List<Long> struct, Long relyOnStruct, Set<String> structLongNumbers, boolean isCustomProjectStruct, boolean cascade, boolean showCompanyName) {
        List<OrgTeamTreeBean> firstLevelList = PermLazyOTTreeHelper.getFirstLevelData(parentId, struct, structLongNumbers, isCustomProjectStruct, null, showCompanyName);
        HashSet<Long> structProjectIds = new HashSet<Long>(struct);
        structProjectIds.add(relyOnStruct);
        HashSet<String> structLongNumberSet = new HashSet<String>();
        for (Long structProjectId : structProjectIds) {
            if (0L == structProjectId || HRCSBaseConstants.LONG_MINUS_ONE.equals(structProjectId)) continue;
            if (cascade) {
                String structLongNumber = PermLazyOTTreeHelper.getStructLongNumber(isCustomProjectStruct, parentId, structProjectId);
                if (HRStringUtils.isEmpty((String)structLongNumber)) continue;
                List<OrgTeamTreeBean> children = PermLazyOTTreeHelper.getDataWithStructLongNumber(structLongNumber, structProjectIds);
                structLongNumberSet.addAll(children.stream().map(OrgTeamTreeBean::getStructLongNumber).collect(Collectors.toSet()));
                continue;
            }
            List<Long> firstLevelIdList = firstLevelList.stream().map(OrgTeamTreeBean::getId).collect(Collectors.toList());
            Set<Long> tempStructProjectIds = new HashSet<Long>(struct);
            tempStructProjectIds.remove(relyOnStruct);
            tempStructProjectIds = tempStructProjectIds.stream().filter(it -> 0L != it && !HRCSBaseConstants.LONG_MINUS_ONE.equals(it)).collect(Collectors.toSet());
            List<OrgTeamTreeBean> secondLevelList = PermLazyOTTreeHelper.getSecondLevelData(firstLevelIdList, new ArrayList<Long>(tempStructProjectIds), isCustomProjectStruct, null);
            structLongNumberSet.addAll(secondLevelList.stream().map(OrgTeamTreeBean::getStructLongNumber).collect(Collectors.toSet()));
        }
        AuthorizedOrgResultWithSub permOrgResult = PermLazyOTTreeHelper.getHasPermAdminOrgWithSub(struct, relyOnStruct, isCustomProjectStruct);
        List orgsWithSub = permOrgResult.getHasPermOrgsWithSub();
        boolean hasAll = permOrgResult.isHasAllOrgPerm() ? true : PermLazyOTTreeHelper.hasAllCurrentNodePerm(isCustomProjectStruct, parentId, orgsWithSub, struct, relyOnStruct);
        if (hasAll) {
            return PermLazyOTTreeHelper.getFirstLevelWithAllPermAndFilter(firstLevelList, structLongNumberSet, cascade);
        }
        return PermLazyOTTreeHelper.getFirstLevelWithoutAllPermAndFilter(firstLevelList, structLongNumberSet, orgsWithSub, cascade);
    }

    private static List<OrgTeamTreeBean> getFirstLevelWithoutAllPerm(List<OrgTeamTreeBean> firstLevelList, List<OrgTeamTreeBean> secondLevelList, List<OrgSubInfo> orgsWithSub) {
        Set<String> hasPermAllParentStructNumber = PermLazyOTTreeHelper.getAllParentStructNumber(orgsWithSub);
        Set parentIdSet = secondLevelList.stream().map(OrgTeamTreeBean::getParentId).collect(Collectors.toSet());
        Set hasPermOrgIds = orgsWithSub.stream().map(OrgSubInfo::getOrgId).collect(Collectors.toSet());
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        for (OrgTeamTreeBean orgBean : firstLevelList) {
            if (!hasPermAllParentStructNumber.contains(orgBean.getStructNumber())) continue;
            result.add(orgBean);
            orgBean.setHasPerm(hasPermOrgIds.contains(orgBean.getId()));
            orgBean.setLeaf(!parentIdSet.contains(orgBean.getId()));
        }
        return result;
    }

    private static Set<String> getAllParentStructNumber(List<OrgSubInfo> orgsWithSub) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)16);
        for (OrgSubInfo orgSubInfo : orgsWithSub) {
            result.addAll(PermLazyOTTreeHelper.splitLongNumber(orgSubInfo.getLongStructNumber()));
        }
        return result;
    }

    private static List<OrgTeamTreeBean> getFirstLevelWithAllPerm(List<OrgTeamTreeBean> firstLevelList, List<OrgTeamTreeBean> secondLevelList) {
        Set parentIdSet = secondLevelList.stream().map(OrgTeamTreeBean::getParentId).collect(Collectors.toSet());
        for (OrgTeamTreeBean orgBean : firstLevelList) {
            orgBean.setLeaf(!parentIdSet.contains(orgBean.getId()));
            orgBean.setHasPerm(true);
        }
        return firstLevelList;
    }

    private static List<OrgTeamTreeBean> getFirstLevelWithoutAllPermAndFilter(List<OrgTeamTreeBean> firstLevelList, Set<String> structLongNumberSet, List<OrgSubInfo> orgsWithSub, boolean cascade) {
        Set<String> hasPermAllParentStructNumber = PermLazyOTTreeHelper.getAllParentStructNumber(orgsWithSub);
        Set hasPermOrgIds = orgsWithSub.stream().map(OrgSubInfo::getOrgId).collect(Collectors.toSet());
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        for (OrgTeamTreeBean orgBean : firstLevelList) {
            boolean show;
            if (!hasPermAllParentStructNumber.contains(orgBean.getStructNumber())) continue;
            if (cascade) {
                show = structLongNumberSet.stream().anyMatch(structLongNumber -> structLongNumber.startsWith(orgBean.getStructLongNumber()));
                boolean hasChildren = structLongNumberSet.stream().anyMatch(structLongNumber -> !HRStringUtils.equals((String)structLongNumber, (String)orgBean.getStructLongNumber()) && structLongNumber.startsWith(orgBean.getStructLongNumber()));
                orgBean.setLeaf(!hasChildren);
                if (!show) {
                    continue;
                }
            } else if (HRStringUtils.equals((String)"1010", (String)String.valueOf(orgBean.getCurrentClassify()))) {
                show = structLongNumberSet.stream().anyMatch(structLongNumber -> structLongNumber.startsWith(orgBean.getStructLongNumber()));
                orgBean.setLeaf(!show);
                if (!show) {
                    continue;
                }
            } else {
                orgBean.setLeaf(true);
            }
            orgBean.setHasPerm(hasPermOrgIds.contains(orgBean.getId()));
            result.add(orgBean);
        }
        return result;
    }

    private static List<OrgTeamTreeBean> getFirstLevelWithAllPermAndFilter(List<OrgTeamTreeBean> firstLevelList, Set<String> structLongNumberSet, boolean cascade) {
        return firstLevelList.stream().filter(it -> {
            it.setHasPerm(true);
            if (cascade) {
                boolean show = structLongNumberSet.stream().anyMatch(structLongNumber -> structLongNumber.startsWith(it.getStructLongNumber()));
                boolean hasChildren = structLongNumberSet.stream().anyMatch(structLongNumber -> !HRStringUtils.equals((String)structLongNumber, (String)it.getStructLongNumber()) && structLongNumber.startsWith(it.getStructLongNumber()));
                it.setLeaf(!hasChildren);
                return show;
            }
            if (HRStringUtils.equals((String)"1010", (String)String.valueOf(it.getCurrentClassify()))) {
                boolean show = structLongNumberSet.stream().anyMatch(structLongNumber -> structLongNumber.startsWith(it.getStructLongNumber()));
                it.setLeaf(!show);
                return show;
            }
            it.setLeaf(true);
            return true;
        }).collect(Collectors.toList());
    }

    private static boolean hasAllCurrentNodePerm(boolean isCustomProjectStruct, Long parentId, List<OrgSubInfo> orgsWithSub, List<Long> struct, Long relyOnStruct) {
        ArrayList<Long> structProjectIds = new ArrayList<Long>(struct);
        structProjectIds.add(relyOnStruct);
        for (Long structProjectParamId : structProjectIds) {
            String structLongNumber;
            if (0L == structProjectParamId || HRCSBaseConstants.LONG_MINUS_ONE.equals(structProjectParamId) || null == (structLongNumber = PermLazyOTTreeHelper.getStructLongNumber(isCustomProjectStruct, parentId, structProjectParamId)) || "".equals(structLongNumber.trim())) continue;
            for (OrgSubInfo orgSubInfo : orgsWithSub) {
                if (HRStringUtils.isEmpty((String)orgSubInfo.getLongStructNumber())) {
                    LOGGER.error("hasAllCurrentNodePerm org has not longstructnumber:" + orgSubInfo);
                    continue;
                }
                if (!orgSubInfo.isContainsSub() || !structLongNumber.startsWith(orgSubInfo.getLongStructNumber())) continue;
                return true;
            }
        }
        return false;
    }

    private static String getStructLongNumber(boolean isCustomProjectStruct, Long id, Long structProjectId) {
        DynamicObject item = PermLazyOTTreeHelper.getDynamicObject(isCustomProjectStruct, id, structProjectId);
        if (null == item) {
            return null;
        }
        return item.getString("structlongnumber");
    }

    private static DynamicObject getDynamicObject(boolean isCustomProjectStruct, Long id, Long structProjectId) {
        QFilter idFilter = new QFilter("orgteam", "=", (Object)id);
        QFilter structProjectFilter = new QFilter("structproject.id", "=", (Object)structProjectId);
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        HRBaseServiceHelper serviceHelper = isCustomProjectStruct ? PermOTLazyTreeCommonHelper.CUSTOM_OT_STRUCT_HELPER : PermOTLazyTreeCommonHelper.OT_STRUCT_HELPER;
        DynamicObject item = serviceHelper.queryOriginalOne("structlongnumber,orgteam.id,orgteam.otclassify", new QFilter[]{idFilter, structProjectFilter, currentVersionFilter});
        return item;
    }

    private static List<OrgTeamTreeBean> getDataWithStructLongNumber(String structLongNumber, Set<Long> struct) {
        List<QFilter> baseQFilterList = PermOTLazyTreeCommonHelper.getBaseQFilterList();
        baseQFilterList.add(new QFilter("structlongnumber", "like", (Object)(structLongNumber + "%")));
        baseQFilterList.add(new QFilter("structproject.id", "in", struct));
        String selectFields = "orgteam.id id,parentorgteam.id parentid,structlongnumber longnumber, orgteam.otclassify otclassify,structproject.id";
        DynamicObjectCollection secondLevelColl = PermOTLazyTreeCommonHelper.OT_STRUCT_HELPER.queryOriginalCollection(selectFields, HRPermCommonUtil.listToQFilters(baseQFilterList));
        ArrayList orgBeans = Lists.newArrayListWithCapacity((int)secondLevelColl.size());
        for (DynamicObject dyno : secondLevelColl) {
            OrgTeamTreeBean orgBean = new OrgTeamTreeBean(Long.valueOf(dyno.getLong("id")), Long.valueOf(dyno.getLong("parentid")));
            orgBean.setStructLongNumber(dyno.getString("longnumber"));
            orgBean.setCurrentClassify(Long.valueOf(dyno.getLong("otclassify")));
            orgBean.setStructProject(Long.valueOf(dyno.getLong("structproject.id")));
            orgBeans.add(orgBean);
        }
        return orgBeans;
    }

    private static List<OrgTeamTreeBean> getSecondLevelData(List<Long> firstLevelIdList, List<Long> struct, boolean isCustomProjectStruct, QFilter extendQFilter) {
        List<QFilter> baseQFilterList = PermOTLazyTreeCommonHelper.getBaseQFilterList();
        baseQFilterList.add(new QFilter("parentorgteam", "in", firstLevelIdList));
        baseQFilterList.add(new QFilter("structproject", "in", struct));
        baseQFilterList.add(extendQFilter);
        String selectFields = "orgteam.id id,parentorgteam.id parentid,structlongnumber longnumber, orgteam.otclassify otclassify";
        HRBaseServiceHelper serviceHelper = isCustomProjectStruct ? PermOTLazyTreeCommonHelper.CUSTOM_OT_STRUCT_HELPER : PermOTLazyTreeCommonHelper.OT_STRUCT_HELPER;
        DynamicObjectCollection secondLevelColl = serviceHelper.queryOriginalCollection(selectFields, HRPermCommonUtil.listToQFilters(baseQFilterList));
        ArrayList orgBeans = Lists.newArrayListWithCapacity((int)secondLevelColl.size());
        for (DynamicObject dyno : secondLevelColl) {
            OrgTeamTreeBean orgBean = new OrgTeamTreeBean(Long.valueOf(dyno.getLong("id")), Long.valueOf(dyno.getLong("parentid")));
            orgBean.setStructLongNumber(dyno.getString("longnumber"));
            orgBean.setCurrentClassify(Long.valueOf(dyno.getLong("otclassify")));
            orgBeans.add(orgBean);
        }
        return orgBeans;
    }

    private static List<OrgTeamTreeBean> getFirstLevelData(Long parentId, List<Long> struct, Set<String> structLongNumbers, boolean isCustomProjectStruct, QFilter extendQFilter, boolean showCompanyName) {
        String selectFields = "orgteam.id id,orgteam.number number, parentorgteam.id parentId, orgteam.name name,orgteam.enable enable, orgteam.otclassify otclassify, enable structenable, parentorgteam.id,structlongnumber longnumber,orgteam.structnumber structnumber,structproject.id, structproject.relyonstructproject.id";
        List<QFilter> baseQFilterList = PermOTLazyTreeCommonHelper.getBaseQFilterList();
        baseQFilterList.add(new QFilter("parentorgteam", "=", (Object)parentId));
        baseQFilterList.add(new QFilter("structproject", "in", struct));
        if (null != structLongNumbers && !structLongNumbers.isEmpty()) {
            baseQFilterList.add(new QFilter("structlongnumber", "in", structLongNumbers));
        }
        if (null != extendQFilter) {
            baseQFilterList.add(extendQFilter);
        }
        HRBaseServiceHelper serviceHelper = isCustomProjectStruct ? PermOTLazyTreeCommonHelper.CUSTOM_OT_STRUCT_HELPER : PermOTLazyTreeCommonHelper.OT_STRUCT_HELPER;
        DynamicObjectCollection firstLevelCollection = serviceHelper.queryOriginalCollection(selectFields, HRPermCommonUtil.listToQFilters(baseQFilterList), "structlongnumber");
        Set orgTeamIdSet = firstLevelCollection.stream().map(it -> it.getLong("id")).collect(Collectors.toSet());
        LOGGER.info("Got hr admin org id set: {}.", orgTeamIdSet);
        Map<Long, String> companyMap = Arrays.stream(PermOTLazyTreeCommonHelper.HR_OT_HELPER.query("id,company.name", new QFilter[]{new QFilter("id", "in", orgTeamIdSet), new QFilter("orgtype.adminorgtypestd.id", "in", Arrays.asList(1030L, 1040L))})).filter(Objects::nonNull).filter(it -> HRStringUtils.isNotEmpty((String)it.getString("company.name"))).collect(Collectors.toMap(it -> it.getLong("id"), it -> it.getString("company.name"), (oldValue, newValue) -> oldValue));
        LOGGER.info("Got hr admin org company name set: {}.", companyMap);
        return firstLevelCollection.stream().map(dyno -> {
            String name = PermOTLazyTreeCommonHelper.getDisabledName(dyno.getString("name"), (String)companyMap.get(dyno.getLong("id")), dyno.getString("enable"), dyno.getString("structenable"), showCompanyName);
            return new OrgTeamTreeBean(Long.valueOf(dyno.getLong("id")), Long.valueOf(dyno.getLong("parentId")), dyno.getString("number"), name, dyno.getString("structnumber"), dyno.getString("longnumber"), Long.valueOf(dyno.getLong("otclassify")), Long.valueOf(dyno.getLong("structproject.id")), Long.valueOf(dyno.getLong("structproject.relyonstructproject.id")));
        }).collect(Collectors.toList());
    }

    public static AuthorizedOrgResultWithSub getHasPermAdminOrgWithSub(List<Long> struct, Long relyOnStruct, boolean isCustomProjectStruct) {
        long level = HRPermServiceHelper.getUserGroupMinLevel();
        if (level >= 0L && level <= 2L) {
            return AuthorizedOrgResultWithSub.allOrg();
        }
        ArrayList<Long> tempStructParam = new ArrayList<Long>(struct);
        if (!relyOnStruct.equals(HRCSBaseConstants.LONG_MINUS_ONE) && !relyOnStruct.equals(0L)) {
            tempStructParam.remove(relyOnStruct);
        }
        List<Long> adminGroupOrgIds = HRPermServiceHelper.getAdminGroupOrgTeams(tempStructParam);
        List<OrgTeamTreeBean> orgBeans = PermLazyOTTreeHelper.getOTStructBeansByIds(adminGroupOrgIds, struct, relyOnStruct, isCustomProjectStruct);
        LOGGER.info("GotHasPermAdminOrgWithSub struct: {}, relyOnStruct: {}, tempStructParam: {}, adminGroupOrgIds: {}, orgBeans: {}.", new Object[]{struct, relyOnStruct, tempStructParam, adminGroupOrgIds, orgBeans});
        Map<Long, OrgTeamTreeBean> orgBeanMap = orgBeans.stream().collect(Collectors.toMap(OrgTeamTreeBean::getId, bean -> bean, (oldValue, newValue) -> oldValue));
        ArrayList orgSubInfos = Lists.newArrayListWithCapacity((int)adminGroupOrgIds.size());
        for (Long orgId : adminGroupOrgIds) {
            OrgTeamTreeBean orgBean = orgBeanMap.get(orgId);
            if (orgBean == null) continue;
            orgSubInfos.add(new OrgSubInfo(orgId, true, orgBean.getStructNumber(), orgBean.getStructLongNumber()));
        }
        return new AuthorizedOrgResultWithSub(false, (List)orgSubInfos);
    }

    private static List<OrgTeamTreeBean> getOTStructBeansByIds(List<Long> orgIds, List<Long> structProjectIds, Long relyOnStruct, boolean isCustomProjectStruct) {
        List<Long> structProjectParams = new ArrayList<Long>(structProjectIds);
        structProjectParams.add(relyOnStruct);
        structProjectParams = structProjectParams.stream().filter(it -> 0L != it && !HRCSBaseConstants.LONG_MINUS_ONE.equals(it)).collect(Collectors.toList());
        String selectFields = "orgteam.id id,structlongnumber longnumber,orgteam.structnumber structnumber,orgteam.otclassify otclassify";
        List<QFilter> baseQFilterList = PermOTLazyTreeCommonHelper.getBaseQFilterList();
        QFilter idsQFilter = new QFilter("orgteam.id", "in", orgIds);
        baseQFilterList.add(new QFilter("structproject.id", "in", structProjectParams));
        baseQFilterList.add(idsQFilter);
        HRBaseServiceHelper serviceHelper = isCustomProjectStruct ? PermOTLazyTreeCommonHelper.CUSTOM_OT_STRUCT_HELPER : PermOTLazyTreeCommonHelper.OT_STRUCT_HELPER;
        DynamicObjectCollection orgColl = serviceHelper.queryOriginalCollection(selectFields, HRPermCommonUtil.listToQFilters(baseQFilterList));
        return orgColl.stream().map(dyno -> new OrgTeamTreeBean(Long.valueOf(dyno.getLong("id")), dyno.getString("structnumber"), dyno.getString("longnumber"), Long.valueOf(dyno.getLong("otclassify")))).distinct().collect(Collectors.toList());
    }

    private static Set<String> splitLongNumber(String longNumber) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)16);
        if (HRStringUtils.isEmpty((String)longNumber)) {
            return result;
        }
        String[] structNumberArr = longNumber.split("!");
        Collections.addAll(result, structNumberArr);
        return result;
    }
}

