/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.ot;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRPermServiceHelper;
import kd.hr.hrcs.common.constants.perm.DimGrpModel;
import kd.hr.hrcs.common.constants.perm.DimModel;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import kd.hr.hrcs.common.constants.perm.RoleDataPermModel;
import kd.hr.hrcs.common.model.OrgTeamTreeBean;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.tuple.Pair;

@ExcludeFromJacocoGeneratedReport
public class PermOTLazyTreeCommonHelper {
    private static final Log LOGGER = LogFactory.getLog(PermOTLazyTreeCommonHelper.class);
    public static HRBaseServiceHelper HR_OT_HELPER = new HRBaseServiceHelper("haos_adminorghr");
    public static HRBaseServiceHelper OT_STRUCT_HELPER = new HRBaseServiceHelper("haos_adminorgstructure");
    public static HRBaseServiceHelper OT_HELPER = new HRBaseServiceHelper("haos_adminorgteam");
    public static HRBaseServiceHelper CUSTOM_OT_STRUCT_HELPER = new HRBaseServiceHelper("haos_customotstruct");
    public static final String MAIN_STRUCT_PROJECT = "kdfont kdfont-shitizuzhi";
    public static final String RELY_ON_STRUCT_PROJECT = "kdfont kdfont-xiangmuxingtuandui";

    public static List<QFilter> getBaseQFilterList() {
        return Lists.newArrayList((Object[])new QFilter[]{new QFilter("status", "=", (Object)"C"), new QFilter("datastatus", "=", (Object)"1"), new QFilter("initstatus", "=", (Object)"2"), new QFilter("iscurrentversion", "=", (Object)"1")});
    }

    public static Map<String, Map<String, Object>> getSelectedAdminOrgValueMap(IFormView formView) {
        JSONObject jsonValue = (JSONObject)formView.getFormShowParameter().getCustomParam("checkValue");
        return PermOTLazyTreeCommonHelper.getSelectedAdminOrgValueMap(formView, jsonValue);
    }

    public static Map<String, Map<String, Object>> getSelectedAdminOrgValueMap(IFormView formView, JSONObject jsonValue) {
        String controlId;
        String[] split;
        HashMap nullValueMap = Maps.newHashMapWithExpectedSize((int)16);
        RoleDataPermModel permModel = (RoleDataPermModel)JSONObject.toJavaObject((JSON)jsonValue, RoleDataPermModel.class);
        if (Objects.isNull(permModel)) {
            return nullValueMap;
        }
        Map dimGroupMap = permModel.getDimGroupMap();
        DimGrpModel dimGrpModel = (DimGrpModel)dimGroupMap.get((split = (controlId = (String)formView.getFormShowParameter().getCustomParam("controlId")).split("#"))[2]);
        if (Objects.isNull(dimGrpModel)) {
            return nullValueMap;
        }
        String dimNumber = (String)formView.getFormShowParameter().getCustomParam("dimensionNumber");
        TreeMap dimMap = dimGrpModel.getDimMap();
        DimModel dimModel = (DimModel)dimMap.get(dimNumber);
        if (Objects.isNull(dimModel)) {
            return nullValueMap;
        }
        String struct = controlId.substring(controlId.lastIndexOf("#") + 1);
        Map dimValues = dimModel.getDimValues();
        dimValues.entrySet().removeIf(dimValue -> !((String)dimValue.getKey()).endsWith(struct) || HRStringUtils.equals((String)"2", (String)((String)((Map)dimValue.getValue()).get("valueType"))));
        return dimValues;
    }

    public static List<Long> getSelectedOrgIds(IFormView formView, JSONObject jsonValue) {
        Map<String, Map<String, Object>> selectedValueMap = PermOTLazyTreeCommonHelper.getSelectedAdminOrgValueMap(formView, jsonValue);
        if (CollectionUtils.isEmpty(selectedValueMap)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        return PermOTLazyTreeCommonHelper.getSelectedOrgIds(selectedValueMap);
    }

    public static List<Long> getSelectedOrgIds(IFormView formView) {
        Map<String, Map<String, Object>> selectedValueMap = PermOTLazyTreeCommonHelper.getSelectedAdminOrgValueMap(formView);
        if (CollectionUtils.isEmpty(selectedValueMap)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        return PermOTLazyTreeCommonHelper.getSelectedOrgIds(selectedValueMap);
    }

    public static List<Long> getSelectedOrgIds(Map<String, Map<String, Object>> selectedValueMap) {
        return selectedValueMap.keySet().stream().filter(HRStringUtils::isNotEmpty).map(it -> {
            int index = it.indexOf("#");
            if (index != -1) {
                String tempId = it.substring(0, it.indexOf("#"));
                if (HRStringUtils.isEmpty((String)tempId)) {
                    return 0L;
                }
                return Long.parseLong(tempId);
            }
            if (HRStringUtils.isEmpty((String)it)) {
                return 0L;
            }
            return Long.parseLong(it);
        }).filter(it -> 0L != it).collect(Collectors.toList());
    }

    public static List<OrgTeamTreeBean> buildEntryData(IFormView formView, String struct, boolean isCustomProjectStruct, boolean showCompanyName) {
        Map<String, Map<String, Object>> selectedValueMap = PermOTLazyTreeCommonHelper.getSelectedAdminOrgValueMap(formView);
        HashMap<String, Map<String, Object>> newSelectedValueMap = new HashMap<String, Map<String, Object>>();
        selectedValueMap.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            int index = key.indexOf("#");
            if (index != -1) {
                key = key.substring(0, key.indexOf("#"));
            }
            newSelectedValueMap.put(key, (Map<String, Object>)entry.getValue());
        });
        if (CollectionUtils.isEmpty(newSelectedValueMap)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        List<Long> selectedIds = PermOTLazyTreeCommonHelper.getSelectedOrgIds(newSelectedValueMap);
        List<OrgTeamTreeBean> selectedOrgInfos = PermOTLazyTreeCommonHelper.getAdminOrgInfoByIds(selectedIds, struct, isCustomProjectStruct, showCompanyName);
        for (OrgTeamTreeBean orgBean : selectedOrgInfos) {
            Map orgEntryInfo = (Map)newSelectedValueMap.get(orgBean.getId().toString());
            if (orgEntryInfo == null) continue;
            orgBean.setIncludesub(((Boolean)orgEntryInfo.get("includeSub")).booleanValue());
            if (null != orgBean.getStructProjectRelyOn() && 0L != orgBean.getStructProjectRelyOn()) {
                orgBean.setIncludeSubAdminOrg(false);
                continue;
            }
            orgBean.setIncludeSubAdminOrg(((Boolean)orgEntryInfo.get("includeSubAdminOrg")).booleanValue());
        }
        return selectedOrgInfos;
    }

    public static TreeNode buildRootNode(List<Long> structProjects, boolean showTips, boolean isCustomProjectStruct, IFormView formView) {
        DynamicObject rootOT;
        HRBaseServiceHelper dependencyServiceHelper;
        DynamicObject item;
        long relyOnStructProject;
        List<QFilter> baseQFilterList = PermOTLazyTreeCommonHelper.getBaseQFilterList();
        long level = HRPermServiceHelper.getUserGroupMinLevel();
        if (level < 0L || level > 2L) {
            List<Long> otIds = HRPermServiceHelper.getAdminGroupOrgTeams(structProjects);
            baseQFilterList.add(new QFilter("orgteam.id", "in", otIds));
        }
        if (0L != (relyOnStructProject = (item = (dependencyServiceHelper = new HRBaseServiceHelper("haos_structproject")).queryOriginalOne("relyonstructproject.id", new QFilter[]{new QFilter("id", "in", structProjects)})).getLong("relyonstructproject.id"))) {
            ArrayList allStructProjects = Lists.newArrayList(structProjects);
            allStructProjects.add(item.getLong("relyonstructproject.id"));
            baseQFilterList.add(new QFilter("structproject.id", "in", (Object)allStructProjects));
        } else {
            baseQFilterList.add(new QFilter("structproject.id", "in", structProjects));
        }
        HRBaseServiceHelper serviceHelper = isCustomProjectStruct ? CUSTOM_OT_STRUCT_HELPER : OT_STRUCT_HELPER;
        DynamicObjectCollection ots = serviceHelper.queryOriginalCollection("id,structlongnumber,orgteam.id,orgteam.name", HRPermCommonUtil.listToQFilters(baseQFilterList));
        List items = ots.stream().map(it -> Pair.of((Object)it, (Object)it.getString("structlongnumber").split("!").length)).sorted(Comparator.comparingInt(Pair::getValue)).limit(2L).collect(Collectors.toList());
        if (items.isEmpty()) {
            if (showTips && null != formView) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u4e0a\u7ea7\u7ba1\u7406\u5458\uff0c\u5206\u914d\u7ec4\u7ec7\u67b6\u6784\u8303\u56f4\u3002", (String)"PermOTLazyTreeCommonHelper_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            LOGGER.error("buildRootNode() is null.");
            return new TreeNode();
        }
        if (items.size() == 1) {
            rootOT = (DynamicObject)((Pair)items.get(0)).getKey();
        } else {
            List<QFilter> rootBaseQFilterList = PermOTLazyTreeCommonHelper.getBaseQFilterList();
            String structLongNumber = PermOTLazyTreeCommonHelper.getLongestCommonStructLongNumber("!", (DynamicObject[])items.stream().map(Pair::getKey).toArray(DynamicObject[]::new));
            rootBaseQFilterList.add(new QFilter("structlongnumber", "=", (Object)structLongNumber));
            rootOT = serviceHelper.queryOne("orgteam.id,orgteam.name", HRPermCommonUtil.listToQFilters(rootBaseQFilterList));
        }
        TreeNode rootNode = new TreeNode("", rootOT.getString("orgteam.id"), rootOT.getString("orgteam.name"), true);
        rootNode.setChildren(new ArrayList());
        rootNode.setIsOpened(true);
        rootNode.setDisabled(!PermOTLazyTreeCommonHelper.hasRootNodePerm(structProjects, Long.parseLong(rootNode.getId())));
        if (showTips) {
            rootNode.setIcon(MAIN_STRUCT_PROJECT);
        } else {
            rootNode.setIcon(RELY_ON_STRUCT_PROJECT);
        }
        LOGGER.info("buildRootNode() rooNode:{}", (Object)rootNode);
        return rootNode;
    }

    public static List<OrgTeamTreeBean> getAdminOrgInfoByIds(List<Long> orgIds, String struct, boolean isCustomProjectStruct, boolean showCompanyName) {
        long relyOnId;
        long relyOnStruct = Long.parseLong(struct);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_structproject");
        DynamicObject relyOnStructItem = serviceHelper.queryOne("relyonstructproject.id", new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(struct))});
        if (null != relyOnStructItem && (relyOnId = relyOnStructItem.getLong("relyonstructproject.id")) != 0L) {
            relyOnStruct = relyOnStructItem.getLong("relyonstructproject.id");
        }
        HRBaseServiceHelper structServiceHelper = isCustomProjectStruct ? CUSTOM_OT_STRUCT_HELPER : OT_STRUCT_HELPER;
        List<QFilter> baseQFilterList = PermOTLazyTreeCommonHelper.getBaseQFilterList();
        baseQFilterList.add(new QFilter("orgteam.id", "in", orgIds));
        baseQFilterList.add(new QFilter("structproject", "in", Arrays.asList(Long.parseLong(struct), relyOnStruct)));
        DynamicObjectCollection items = structServiceHelper.queryOriginalCollection("structproject, orgteam.id, orgteam.number, orgteam.name, orgteam.enable enable, orgteam.otclassify otclassify, enable structenable", HRPermCommonUtil.listToQFilters(baseQFilterList));
        Set orgTeamIdSet = items.stream().map(it -> it.getLong("orgteam.id")).collect(Collectors.toSet());
        LOGGER.info("Got hr admin org id set: {}.", orgTeamIdSet);
        Map<Long, String> companyMap = Arrays.stream(HR_OT_HELPER.query("id,company.name", new QFilter[]{new QFilter("id", "in", orgTeamIdSet), new QFilter("orgtype.adminorgtypestd.id", "in", Arrays.asList(1030L, 1040L))})).filter(Objects::nonNull).filter(it -> HRStringUtils.isNotEmpty((String)it.getString("company.name"))).collect(Collectors.toMap(it -> it.getLong("id"), it -> it.getString("company.name"), (oldValue, newValue) -> oldValue));
        LOGGER.info("Got hr admin org company name set: {}.", companyMap);
        long finalRelyOnStruct = relyOnStruct;
        return items.stream().map(item -> {
            OrgTeamTreeBean orgBean = new OrgTeamTreeBean(Long.valueOf(item.getLong("orgteam.id")));
            orgBean.setNumber(item.getString("orgteam.number"));
            orgBean.setCurrentClassify(Long.valueOf(item.getLong("otclassify")));
            orgBean.setStructProject(Long.valueOf(item.getLong("structproject")));
            orgBean.setStructProjectRelyOn(Long.parseLong(struct) == item.getLong("structproject") ? Long.valueOf(finalRelyOnStruct) : null);
            String name = PermOTLazyTreeCommonHelper.getDisabledName(item.getString("orgteam.name"), (String)companyMap.get(item.getLong("orgteam.id")), item.getString("enable"), item.getString("structenable"), showCompanyName);
            orgBean.setName(name);
            return orgBean;
        }).collect(Collectors.toList());
    }

    public static OrgTeamTreeBean getAdminOrgInfoById(Long orgId, String struct, boolean isCustomProjectStruct, boolean showCompanyName) {
        List<OrgTeamTreeBean> list = PermOTLazyTreeCommonHelper.getAdminOrgInfoByIds(Collections.singletonList(orgId), struct, isCustomProjectStruct, showCompanyName);
        return list.get(0);
    }

    public static String getDisabledName(String oriName, String enable) {
        String disabledPrefix = ResManager.loadKDString((String)"\uff08\u7981\u7528\uff09", (String)"PermOTLazyTreeCommonHelper_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        String name = oriName;
        if ("0".equals(enable)) {
            name = name + disabledPrefix;
        }
        return name;
    }

    public static String getDisabledName(String oriName, String companyName, String enable, String structEnable, boolean showCompanyName) {
        String disabledPrefix = ResManager.loadKDString((String)"\uff08\u7981\u7528\uff09", (String)"PermOTLazyTreeCommonHelper_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        String name = oriName;
        if (showCompanyName) {
            if (HRStringUtils.isNotEmpty((String)companyName)) {
                name = name + ResManager.loadKDString((String)"\uff08%s\uff09", (String)"PermOTLazyTreeCommonHelper_3", (String)"hrmp-hrcs-business", (Object[])new Object[]{companyName});
            }
            if ("0".equals(structEnable)) {
                name = name + disabledPrefix;
            }
        } else if ("0".equals(enable)) {
            name = name + disabledPrefix;
        }
        return name;
    }

    public static List<Long> getOrgIdsByEntry(IFormView formView) {
        IDataModel model = formView.getModel();
        DynamicObjectCollection collection = model.getEntryEntity("entryentity");
        return collection.stream().map(dyno -> dyno.getLong("id")).collect(Collectors.toList());
    }

    public static boolean hasRootNodePerm(List<Long> structProjectIds, Long orgId) {
        long level = HRPermServiceHelper.getUserGroupMinLevel();
        if (level >= 0L && level <= 2L) {
            return true;
        }
        List<Long> adminGroupOrgIds = HRPermServiceHelper.getAdminGroupOrgTeams(structProjectIds);
        return adminGroupOrgIds.contains(orgId);
    }

    public static List<OrgTeamTreeBean> getAllChildrenByParentId(Long parentId, List<Long> struct, boolean isCustomProjectStruct, boolean showCompanyName) {
        HRBaseServiceHelper structServiceHelper = isCustomProjectStruct ? CUSTOM_OT_STRUCT_HELPER : OT_STRUCT_HELPER;
        List<QFilter> baseQFilterList = PermOTLazyTreeCommonHelper.getBaseQFilterList();
        baseQFilterList.add(new QFilter("orgteam.id", "=", (Object)parentId));
        baseQFilterList.add(new QFilter("structproject", "in", struct));
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObject dynamicObject = structServiceHelper.queryOriginalOne("structlongnumber", HRPermCommonUtil.listToQFilters(baseQFilterList));
        if (dynamicObject == null) {
            return result;
        }
        String longNumber = dynamicObject.getString("structlongnumber");
        baseQFilterList = PermOTLazyTreeCommonHelper.getBaseQFilterList();
        baseQFilterList.add(new QFilter("structlongnumber", "like", (Object)(longNumber + "!" + "%")));
        baseQFilterList.add(new QFilter("structproject", "in", struct));
        String selectFields = "orgteam.id id,orgteam.number number, orgteam.name name,orgteam.enable enable, enable structenable, orgteam.otclassify otclassify,structproject.id";
        DynamicObjectCollection items = structServiceHelper.queryOriginalCollection(selectFields, HRPermCommonUtil.listToQFilters(baseQFilterList));
        Set orgTeamIdSet = items.stream().map(it -> it.getLong("id")).collect(Collectors.toSet());
        LOGGER.info("Got hr admin org id set: {}.", orgTeamIdSet);
        Map<Long, String> companyMap = Arrays.stream(HR_OT_HELPER.query("id,company.name", new QFilter[]{new QFilter("id", "in", orgTeamIdSet), new QFilter("orgtype.adminorgtypestd.id", "in", Arrays.asList(1030L, 1040L))})).filter(Objects::nonNull).filter(it -> HRStringUtils.isNotEmpty((String)it.getString("company.name"))).collect(Collectors.toMap(it -> it.getLong("id"), it -> it.getString("company.name"), (oldValue, newValue) -> oldValue));
        LOGGER.info("Got hr admin org company name set: {}.", companyMap);
        for (DynamicObject item : items) {
            OrgTeamTreeBean orgBean = new OrgTeamTreeBean(Long.valueOf(item.getLong("id")));
            orgBean.setNumber(item.getString("number"));
            orgBean.setCurrentClassify(Long.valueOf(item.getLong("otclassify")));
            orgBean.setStructProject(Long.valueOf(item.getLong("structproject.id")));
            String name = PermOTLazyTreeCommonHelper.getDisabledName(item.getString("name"), companyMap.get(item.getLong("id")), item.getString("enable"), item.getString("structenable"), showCompanyName);
            orgBean.setName(name);
            result.add(orgBean);
        }
        return result;
    }

    public static int getAllChildrenCountByParentId(Long parentId, List<Long> struct, boolean isCustomProjectStruct) {
        int count = 0;
        HRBaseServiceHelper serviceHelper = isCustomProjectStruct ? CUSTOM_OT_STRUCT_HELPER : OT_STRUCT_HELPER;
        List<QFilter> baseQFilterList = PermOTLazyTreeCommonHelper.getBaseQFilterList();
        baseQFilterList.add(new QFilter("orgteam.id", "=", (Object)parentId));
        baseQFilterList.add(new QFilter("structproject", "in", struct));
        DynamicObject dynamicObject = serviceHelper.queryOriginalOne("structlongnumber", HRPermCommonUtil.listToQFilters(baseQFilterList));
        if (dynamicObject == null) {
            return count;
        }
        String longNumber = dynamicObject.getString("structlongnumber");
        baseQFilterList = PermOTLazyTreeCommonHelper.getBaseQFilterList();
        baseQFilterList.add(new QFilter("structproject", "in", struct));
        baseQFilterList.add(new QFilter("structlongnumber", "like", (Object)(longNumber + "!" + "%")));
        return serviceHelper.count(serviceHelper.getEntityName(), HRPermCommonUtil.listToQFilters(baseQFilterList));
    }

    public static String getLongestCommonStructLongNumber(String splitString, DynamicObject[] items) {
        String structLongNumber = items[0].getString("structlongnumber");
        for (int index = 1; index < items.length; ++index) {
            structLongNumber = PermOTLazyTreeCommonHelper.commonPrefix(splitString, structLongNumber, items[index].getString("structlongnumber"));
        }
        if (structLongNumber.endsWith(StringEscapeUtils.unescapeJava((String)splitString))) {
            structLongNumber = structLongNumber.substring(0, structLongNumber.length() - 1);
        }
        return structLongNumber;
    }

    public static String commonPrefix(String splitString, String str1, String str2) {
        String shortStr;
        String longStr;
        if (str1.length() > str2.length()) {
            longStr = str1;
            shortStr = str2;
        } else {
            longStr = str2;
            shortStr = str1;
        }
        StringBuilder result = new StringBuilder();
        String[] longItems = longStr.split(splitString);
        String[] shortItems = shortStr.split(splitString);
        for (int index = 0; index < shortItems.length && shortItems[index].equals(longItems[index]); ++index) {
            result.append(shortItems[index]).append(StringEscapeUtils.unescapeJava((String)splitString));
        }
        return result.toString();
    }
}

