/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.preview;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.OrgSubInfo;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRPermServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.preview.AbstractTreeNodeService;
import kd.hr.hrcs.bussiness.servicehelper.perm.preview.TreeNodeBean;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;

@ExcludeFromJacocoGeneratedReport
public class BizOrgServiceImpl
extends AbstractTreeNodeService {
    private final Log LOGGER = LogFactory.getLog(BizOrgServiceImpl.class);

    @Override
    protected AuthorizedOrgResultWithSub getHasPermAdminOrgWithSub(IFormView formView) {
        long level = HRPermServiceHelper.getUserGroupMinLevel();
        this.LOGGER.info("Got level:[{}].", (Object)level);
        if (level >= 0L && level <= 2L) {
            return AuthorizedOrgResultWithSub.allOrg();
        }
        String currentHRbuCaFunc = (String)formView.getFormShowParameter().getCustomParam("currentHRbuCaFunc");
        List<Long> adminGroupFuncIds = HRPermServiceHelper.getAdminGroupFunc(Long.parseLong(currentHRbuCaFunc));
        List<TreeNodeBean> orgBeans = this.getStructBeansByIds(formView, adminGroupFuncIds);
        Map<Long, TreeNodeBean> orgBeanMap = orgBeans.stream().collect(Collectors.toMap(TreeNodeBean::getId, bean -> bean));
        this.LOGGER.info("Got all admin group func ids: [{}], orgBeans:[{}], orgBeanMap:[{}]", new Object[]{adminGroupFuncIds, orgBeans, orgBeanMap});
        ArrayList orgSubInfos = Lists.newArrayListWithCapacity((int)adminGroupFuncIds.size());
        for (Long orgId : adminGroupFuncIds) {
            TreeNodeBean orgBean = orgBeanMap.get(orgId);
            if (orgBean == null) continue;
            orgSubInfos.add(new OrgSubInfo(orgId, true, orgBean.getStructNumber(), orgBean.getStructLongNumber()));
        }
        return new AuthorizedOrgResultWithSub(false, (List)orgSubInfos);
    }

    @Override
    protected String getStructEntityNumber(String entityNumber) {
        return "bos_org_structure";
    }

    @Override
    protected String getStructLongNumber(String entityNumber, Long id) {
        String structEntityNumber = this.getStructEntityNumber(entityNumber);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(structEntityNumber);
        DynamicObject item = serviceHelper.queryOriginalOne("longnumber", new QFilter[]{new QFilter("org.id", "=", (Object)id)});
        return item.getString("longnumber");
    }

    @Override
    protected List<QFilter> getBaseFilter(IFormView formView) {
        ArrayList baseFilter = Lists.newArrayListWithExpectedSize((int)16);
        String hrBuCaFuncId = (String)formView.getFormShowParameter().getCustomParam("currentHRbuCaFunc");
        QFilter paramFilter = (QFilter)formView.getFormShowParameter().getCustomParam("filter");
        if (Objects.nonNull(paramFilter)) {
            baseFilter.add(paramFilter);
        }
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter viewFilter = new QFilter("view.id", "=", (Object)Long.valueOf(hrBuCaFuncId));
        QFilter viewDefaultFilter = new QFilter("view.isdefault", "=", (Object)"1");
        baseFilter.addAll(Arrays.asList(statusFilter, viewFilter, viewDefaultFilter));
        return baseFilter;
    }

    @Override
    protected String getPrimaryKey() {
        return "org.id";
    }

    @Override
    protected String getSelectFields() {
        return "org.id id,parent.id parentid,org.number number,org.name name,org.enable enable, longnumber longnumber,org.number structnumber";
    }

    @Override
    protected String getOrderBy() {
        return "org.number";
    }

    @Override
    protected String getSeparator() {
        return "!";
    }

    private List<TreeNodeBean> getStructBeansByIds(IFormView formView, List<Long> orgIds) {
        String selectFields = "org.id id,org.number structnumber,longnumber";
        List<QFilter> baseQFilterList = this.getBaseFilter(formView);
        QFilter idsQFilter = new QFilter("org.id", "in", orgIds);
        baseQFilterList.add(idsQFilter);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_org_structure");
        DynamicObjectCollection orgColl = serviceHelper.queryOriginalCollection(selectFields, HRPermCommonUtil.listToQFilters(baseQFilterList));
        return orgColl.stream().map(dyno -> {
            TreeNodeBean treeNodeBean = new TreeNodeBean();
            treeNodeBean.setId(dyno.getLong("id"));
            treeNodeBean.setStructNumber(dyno.getString("structnumber"));
            treeNodeBean.setStructLongNumber(dyno.getString("longnumber"));
            treeNodeBean.setCurrentClassify(1010L);
            return treeNodeBean;
        }).collect(Collectors.toList());
    }
}

