/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.preview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.ot.PermLazyOTTreeHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.ot.PermOTLazyTreeCommonHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.preview.TreeNodeBean;
import kd.hr.hrcs.bussiness.servicehelper.perm.preview.TreeNodeService;
import kd.hr.hrcs.common.constants.HRCSBaseConstants;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;
import kd.hr.hrcs.common.model.OrgTeamTreeBean;
import org.apache.commons.lang3.tuple.Pair;

@ExcludeFromJacocoGeneratedReport
public class OrgTeamServiceImpl
implements TreeNodeService {
    private final Function<OrgTeamTreeBean, TreeNodeBean> transfer = orgTeamTreeBean -> {
        TreeNodeBean treeNodeBean = new TreeNodeBean();
        treeNodeBean.setId(orgTeamTreeBean.getId());
        treeNodeBean.setNumber(orgTeamTreeBean.getNumber());
        treeNodeBean.setName(orgTeamTreeBean.getName());
        treeNodeBean.setParentId(orgTeamTreeBean.getParentId());
        treeNodeBean.setStructNumber(orgTeamTreeBean.getStructNumber());
        treeNodeBean.setStructLongNumber(orgTeamTreeBean.getStructLongNumber());
        treeNodeBean.setLeaf(orgTeamTreeBean.isLeaf());
        treeNodeBean.setHasPerm(orgTeamTreeBean.isHasPerm());
        treeNodeBean.setIncludeSub(orgTeamTreeBean.isIncludesub());
        treeNodeBean.setIncludeSubAdminOrg(orgTeamTreeBean.isIncludeSubAdminOrg());
        treeNodeBean.setChecked(orgTeamTreeBean.isChecked());
        treeNodeBean.setCurrentClassify(orgTeamTreeBean.getCurrentClassify());
        treeNodeBean.setCurrentStructProject(orgTeamTreeBean.getStructProject());
        treeNodeBean.setCurrentStructProjectRelyOn(orgTeamTreeBean.getStructProjectRelyOn());
        return treeNodeBean;
    };

    @Override
    public List<TreeNodeBean> getHasAdminPermTreeNodeList(IFormView formView, Long parentId, List<Long> struct, Long relyOnStruct, Set<String> structLongNumbers, boolean isCustomProjectStruct, QFilter extendQFilter, boolean showCompanyName) {
        return PermLazyOTTreeHelper.getHasAdminPermOrgList(parentId, struct, relyOnStruct, structLongNumbers, isCustomProjectStruct, extendQFilter, showCompanyName).stream().map(this.transfer).collect(Collectors.toList());
    }

    @Override
    public List<TreeNodeBean> getHasAdminPermTreeNodeList(IFormView formView, Long parentId, List<Long> struct, Long relyOnStruct, Set<String> structLongNumbers, boolean isCustomProjectStruct, boolean cascade, boolean showCompanyName) {
        return PermLazyOTTreeHelper.getHasAdminPermOrgList(parentId, struct, relyOnStruct, Collections.emptySet(), isCustomProjectStruct, cascade, showCompanyName).stream().map(this.transfer).collect(Collectors.toList());
    }

    @Override
    public Map<Long, List<Pair<Long, String>>> getNodeAllParents(IFormView formView, List<Long> nodeIds, List<Long> struct, Long relyOnStruct, boolean isCustomProjectStruct) {
        Set<Long> structProjectIds = new HashSet<Long>(struct);
        structProjectIds.add(relyOnStruct);
        structProjectIds = structProjectIds.stream().filter(it -> 0L != it && !HRCSBaseConstants.LONG_MINUS_ONE.equals(it)).collect(Collectors.toSet());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(isCustomProjectStruct ? "haos_customotstruct" : "haos_adminorgstructure");
        List<QFilter> qFilters = PermOTLazyTreeCommonHelper.getBaseQFilterList();
        qFilters.add(new QFilter("orgteam.id", "in", nodeIds));
        qFilters.add(new QFilter("structproject.id", "in", structProjectIds));
        HashSet structLongNumberList = new HashSet(16);
        HashSet leafStructLongNumberList = new HashSet(16);
        Arrays.stream(serviceHelper.query("structlongnumber", HRPermCommonUtil.listToQFilters(qFilters))).forEach(item -> {
            String structLongNumber = item.getString("structlongnumber");
            leafStructLongNumberList.add(structLongNumber);
            while (HRStringUtils.isNotEmpty((String)structLongNumber)) {
                structLongNumberList.add(structLongNumber);
                int tempIndex = structLongNumber.lastIndexOf("!");
                if (-1 == tempIndex) break;
                structLongNumber = structLongNumber.substring(0, tempIndex);
            }
        });
        structLongNumberList.removeAll(leafStructLongNumberList);
        List<QFilter> commonParentFilters = PermOTLazyTreeCommonHelper.getBaseQFilterList();
        commonParentFilters.add(new QFilter("structlongnumber", "in", structLongNumberList));
        commonParentFilters.add(new QFilter("structproject.id", "in", structProjectIds));
        List commonParent = Arrays.stream(serviceHelper.query("orgteam.id,structlongnumber", HRPermCommonUtil.listToQFilters(commonParentFilters))).map(it -> Pair.of((Object)it.getLong("orgteam.id"), (Object)it.getString("structlongnumber"))).sorted(Comparator.comparingInt(it -> ((String)it.getRight()).length())).collect(Collectors.toList());
        List<QFilter> parentFilters = PermOTLazyTreeCommonHelper.getBaseQFilterList();
        parentFilters.add(new QFilter("structlongnumber", "in", leafStructLongNumberList));
        parentFilters.add(new QFilter("structproject.id", "in", structProjectIds));
        return Arrays.stream(serviceHelper.query("orgteam.id,structlongnumber", HRPermCommonUtil.listToQFilters(parentFilters))).collect(Collectors.toMap(item -> item.getLong("orgteam.id"), item -> {
            ArrayList<Pair> list = new ArrayList<Pair>(commonParent);
            list.add(list.size(), Pair.of((Object)item.getLong("orgteam.id"), (Object)item.getString("structlongnumber")));
            return list;
        }, (oldValue, newValue) -> oldValue));
    }
}

