/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.perm.role;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections.CollectionUtils;

@ExcludeFromJacocoGeneratedReport
public class HRRolePermHelper {
    public static void showRoleF7(CloseCallBack closeCallBack, IFormView formView) {
        String entityName = "hrcs_rolelist";
        ListShowParameter fsp = ShowFormHelper.createShowListForm((String)entityName, (boolean)true, (int)0, (boolean)true);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setMultiSelect(false);
        Set<String> roleIds = HRRolePermHelper.queryViewableRoles(RequestContext.get().getCurrUserId());
        fsp.getListFilterParameter().setFilter(new QFilter("perm_role.enable", "=", (Object)"1").and("id", "in", roleIds));
        fsp.setFormId("hrcs_roletreelistf7");
        fsp.setShowTitle(false);
        fsp.setHasRight(true);
        fsp.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u89d2\u8272", (String)"HRUserAssignRolePlugin_7", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        if (null != closeCallBack) {
            fsp.setCloseCallBack(closeCallBack);
        }
        formView.showForm((FormShowParameter)fsp);
    }

    public static boolean isTopAdminGroupModify(String longNumber, Set<String> longNumbers) {
        if (HRStringUtils.isEmpty((String)longNumber)) {
            return true;
        }
        String[] numbers = longNumber.split("\\.");
        if (numbers.length < 2) {
            return true;
        }
        String topNumber = numbers[0] + "." + numbers[1];
        return longNumbers.contains(topNumber);
    }

    public static Set<Long> queryUserAdminGroups() {
        return HRRolePermHelper.queryUserAdminGroups(RequestContext.get().getCurrUserId());
    }

    public static Set<Long> queryUserAdminGroups(long userId) {
        HRBaseServiceHelper userAdminGroupServiceHelper = new HRBaseServiceHelper("perm_useradmingroup");
        DynamicObject[] userGroupItems = userAdminGroupServiceHelper.queryOriginalArray("usergroup.id", new QFilter[]{new QFilter("user.id", "=", (Object)userId)});
        Set groupIds = Arrays.stream(userGroupItems).map(it -> it.getLong("usergroup.id")).collect(Collectors.toSet());
        HRBaseServiceHelper adminGroupServiceHelper = new HRBaseServiceHelper("perm_admingroup");
        DynamicObjectCollection collection = adminGroupServiceHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("id", "in", groupIds).and(HRRolePermHelper.buildHRAdminGroupFilter())}, "createtime desc");
        LinkedHashSet<Long> adminGroupIds = new LinkedHashSet<Long>(collection.size());
        collection.forEach(it -> adminGroupIds.add(it.getLong("id")));
        return adminGroupIds;
    }

    public static QFilter buildHRAdminGroupFilter() {
        return new QFilter("isdomain", "=", (Object)"1").and("domain.number", "=", (Object)"hr");
    }

    public static QFilter buildAdminGroupFilter(DynamicObject dataEntity) {
        QFilter filter = HRRolePermHelper.buildHRAdminGroupFilter();
        DynamicObject createAdminGrp = dataEntity.getDynamicObject("createadmingrp");
        if (null != createAdminGrp) {
            filter.and(new QFilter("id", "!=", (Object)createAdminGrp.getLong("id")));
        }
        return filter;
    }

    public static Map<Long, String> queryUserAdminGroupInfos(long userId) {
        HRBaseServiceHelper userAdminGroupServiceHelper = new HRBaseServiceHelper("perm_useradmingroup");
        DynamicObjectCollection collection = userAdminGroupServiceHelper.queryOriginalCollection("usergroup.id,usergroup.longnumber", new QFilter[]{new QFilter("user.id", "=", (Object)userId)});
        return collection.stream().collect(Collectors.toMap(it -> it.getLong("usergroup.id"), it -> it.getString("usergroup.longnumber"), (oldValue, newValue) -> oldValue));
    }

    public static Set<String> queryUserRoles(Set<Long> groupIds) {
        HRBaseServiceHelper adminGroupHelper = new HRBaseServiceHelper("perm_admingroup");
        DynamicObjectCollection userAdminCollection = adminGroupHelper.queryOriginalCollection("longnumber", new QFilter[]{new QFilter("id", "in", groupIds).and("level", "=", (Object)2)});
        List topAdminLongNumbers = userAdminCollection.stream().map(it -> it.getString("longnumber")).collect(Collectors.toList());
        HashSet<String> roleIds = new HashSet<String>(16);
        HRBaseServiceHelper roleServiceHelper = new HRBaseServiceHelper("hrcs_role");
        if (CollectionUtils.isNotEmpty(topAdminLongNumbers)) {
            HashSet adminGroups = new HashSet(16);
            QFilter filter = new QFilter("longnumber", "ftlike", topAdminLongNumbers.get(0));
            for (int index = 1; index < topAdminLongNumbers.size(); ++index) {
                filter.or(new QFilter("longnumber", "ftlike", topAdminLongNumbers.get(index)));
            }
            DynamicObjectCollection collection = adminGroupHelper.queryOriginalCollection("id", new QFilter[]{filter});
            Set adminGroupIds = collection.stream().map(it -> it.getLong("id")).collect(Collectors.toSet());
            adminGroups.addAll(adminGroupIds);
            DynamicObjectCollection roles = roleServiceHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("createadmingrp.id", "in", adminGroups)});
            Set subRoleIds = roles.stream().map(it -> it.getString("id")).collect(Collectors.toSet());
            roleIds.addAll(subRoleIds);
        }
        Set noCreateAdminGrpRoles = roleServiceHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("createadmingrp.id", "=", (Object)0).or("createadmingrp.id", "in", groupIds)}).stream().map(it -> it.getString("id")).collect(Collectors.toSet());
        roleIds.addAll(noCreateAdminGrpRoles);
        return roleIds;
    }

    public static Set<String> queryViewableRoles(long userId) {
        Set<Long> groupIds = HRRolePermHelper.queryUserAdminGroups(userId);
        HashSet<String> roleIds = new HashSet<String>(16);
        roleIds.addAll(HRRolePermHelper.queryOpenRoles());
        roleIds.addAll(HRRolePermHelper.queryAssignRoles(groupIds));
        roleIds.addAll(HRRolePermHelper.queryPrivateRoles(groupIds));
        roleIds.addAll(HRRolePermHelper.queryUserRoles(groupIds));
        return roleIds;
    }

    private static Set<String> queryOpenRoles() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_role");
        DynamicObjectCollection collection = serviceHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("usescope", "=", (Object)"2")});
        return collection.stream().map(it -> it.getString("id")).collect(Collectors.toSet());
    }

    private static Set<String> queryAssignRoles(Set<Long> groupIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_roleassignscope");
        DynamicObjectCollection collection = serviceHelper.queryOriginalCollection("roleid", new QFilter[]{new QFilter("admingroup", "in", groupIds)});
        return collection.stream().map(it -> it.getString("roleid")).collect(Collectors.toSet());
    }

    private static Set<String> queryPrivateRoles(Set<Long> groupIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_role");
        DynamicObjectCollection collection = serviceHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("usescope", "=", (Object)"0").and(new QFilter("createadmingrp.id", "in", groupIds))});
        return collection.stream().map(it -> it.getString("id")).collect(Collectors.toSet());
    }

    public static Long[] queryAdminGrpUsers(long groupId) {
        HRBaseServiceHelper userAdminHelper = new HRBaseServiceHelper("perm_useradmingroup");
        DynamicObjectCollection userGroups = userAdminHelper.queryOriginalCollection("user", new QFilter[]{new QFilter("usergroup", "=", (Object)groupId)});
        return (Long[])userGroups.stream().map(it -> it.getLong("user")).distinct().toArray(Long[]::new);
    }
}

