/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.prompt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.user.UserService;
import kd.bos.url.UrlService;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.util.CompareUtils;
import org.apache.commons.collections.CollectionUtils;

public class PromptServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(PromptServiceHelper.class);

    public static List<String> controlGetPromptContent(String entityId, String controlId) {
        ArrayList contentList = Lists.newArrayListWithExpectedSize((int)16);
        HRBaseServiceHelper ruleHelper = new HRBaseServiceHelper("hrcs_promptrule");
        DynamicObject rule = ruleHelper.queryOne("entryentity,entryentity.entryprompt", new QFilter[]{new QFilter("businessobject.number", "=", (Object)entityId).and("controlnumber", "=", (Object)controlId).and("enable", "=", (Object)"1")}, "modifytime desc");
        HRBaseServiceHelper contentHelper = new HRBaseServiceHelper("hrcs_promptcontent");
        if (Objects.nonNull(rule)) {
            DynamicObjectCollection entry = rule.getDynamicObjectCollection("entryentity");
            HashSet promptIdSet = Sets.newHashSetWithExpectedSize((int)entry.size());
            HashMap selectContentMap = Maps.newHashMapWithExpectedSize((int)entry.size());
            PromptServiceHelper.addPrompt(promptIdSet, selectContentMap, entry);
            DynamicObject[] results = contentHelper.query("promptcontent,syscontent,prompt", new QFilter[]{new QFilter("prompt", "in", (Object)promptIdSet).and("locale.number", "=", (Object)Lang.get().name())});
            Map<Long, List<DynamicObject>> promptMap = Arrays.stream(results).collect(Collectors.groupingBy(et -> et.getLong("prompt")));
            for (DynamicObject ruleEntry : entry) {
                DynamicObject prompt = ruleEntry.getDynamicObject("entryprompt");
                long promptId = ruleEntry.getLong("entryprompt.id");
                String selContent = prompt.getString("selectcontent");
                String langType = prompt.getString("langtype");
                ILocaleString promptLangContent = prompt.getLocaleString("promptlangcontent");
                ILocaleString sysLangContent = prompt.getLocaleString("syslangcontent");
                List<DynamicObject> contents = promptMap.get(promptId);
                String content = null;
                if ("1".equals(selContent)) {
                    if (PromptServiceHelper.isMulLangEmpty(sysLangContent)) {
                        if (!CollectionUtils.isEmpty(contents)) {
                            content = contents.get(0).getString("syscontent");
                        }
                    } else {
                        content = sysLangContent.getLocaleValue();
                    }
                } else {
                    content = "1".equals(langType) ? contents.get(0).getString("promptcontent") : promptLangContent.getLocaleValue();
                }
                contentList.add(content);
            }
        }
        return contentList;
    }

    public static List<String> queryPromptContent(String entityId, String controlKey, DynamicObject dataModel) {
        Map<Long, String> promptIdAndContent = PromptServiceHelper.queryPromptIdAndContent(entityId, controlKey, dataModel);
        ArrayList contentString = Lists.newArrayList(promptIdAndContent.values());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Result contentString : " + contentString);
        }
        return contentString;
    }

    public static Map<String, Map<String, Set<String>>> queryPromptContent(Map<String, Set<String>> controlMap, Map<String, DynamicObject> dataModelMap) {
        return PromptServiceHelper.queryContent(controlMap, dataModelMap, false);
    }

    public static DynamicObject queryPromptRules(String entityNum, String controlKey) {
        HRBaseServiceHelper ruleHelper = new HRBaseServiceHelper("hrcs_promptrule");
        return ruleHelper.queryOne("entryentity.entryrule,entryentity.entryprompt,businessobject.number,modifytime", new QFilter[]{new QFilter("businessobject.number", "=", (Object)entityNum).and("controlnumber", "=", (Object)controlKey).and("enable", "=", (Object)"1")});
    }

    public static Map<String, Map<String, DynamicObject>> queryPromptRules(Map<String, Set<String>> controlMap) {
        HashMap resultsMap = Maps.newHashMapWithExpectedSize((int)controlMap.size());
        HRBaseServiceHelper ruleHelper = new HRBaseServiceHelper("hrcs_promptrule");
        DynamicObject[] results = ruleHelper.query("entryentity.entryrule,entryentity.entryprompt,businessobject.number,modifytime,controlnumber", new QFilter[]{new QFilter("businessobject.number", "in", controlMap.keySet()).and("enable", "=", (Object)"1")});
        Arrays.stream(results).filter(result -> {
            Set controlSet = (Set)controlMap.get(result.getString("businessobject.number"));
            return CollectionUtils.isEmpty((Collection)controlSet) || controlSet.contains(result.getString("controlnumber"));
        }).forEach(result -> {
            String entityNum = result.getString("businessobject.number");
            String controlNum = result.getString("controlnumber");
            Map ruleMap = resultsMap.getOrDefault(entityNum, Maps.newHashMapWithExpectedSize((int)16));
            ruleMap.put(controlNum, result);
            resultsMap.put(entityNum, ruleMap);
        });
        return resultsMap;
    }

    public static Map<Long, String> queryPromptIdAndContent(String entityId, String controlKey, DynamicObject dataModel) {
        LOGGER.info("PromptServiceHelper.queryPromptIdAndContent -- entityId : {},controlKey : {}", (Object)entityId, (Object)controlKey);
        DynamicObjectCollection ruleEntry = PromptServiceHelper.queryRuleEntry(entityId, controlKey, dataModel);
        HashSet promptIdSet = Sets.newHashSetWithExpectedSize((int)ruleEntry.size());
        HashMap selectContentMap = Maps.newHashMapWithExpectedSize((int)ruleEntry.size());
        PromptServiceHelper.addPrompt(promptIdSet, selectContentMap, ruleEntry);
        DynamicObject[] contentDys = PromptServiceHelper.queryContentByPrompt(promptIdSet);
        Map<Long, DynamicObject> promptIdAndContent = Arrays.stream(contentDys).collect(Collectors.toMap(dy -> dy.getLong("prompt"), dy -> dy));
        LinkedHashMap resultMap = Maps.newLinkedHashMapWithExpectedSize((int)promptIdAndContent.size());
        for (DynamicObject entry : ruleEntry) {
            DynamicObject entryPrompt = entry.getDynamicObject("entryprompt");
            long promptId = entry.getLong("entryprompt.id");
            DynamicObject contentDyn = promptIdAndContent.get(promptId);
            String content = PromptServiceHelper.getContent(entryPrompt, contentDyn, entityId, dataModel, false);
            resultMap.put(promptId, content);
        }
        return resultMap;
    }

    public static List<String> queryPromptForString(String entityId, String controlKey, DynamicObject dataModel) {
        if (StringUtils.isEmpty((String)entityId) || StringUtils.isEmpty((String)controlKey) || Objects.isNull(dataModel)) {
            return Lists.newArrayListWithExpectedSize((int)16);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("entityId : " + entityId + ",controlKey : " + controlKey);
        }
        DynamicObjectCollection ruleEntry = PromptServiceHelper.queryRuleEntry(entityId, controlKey, dataModel);
        HashSet promptIdSet = Sets.newHashSetWithExpectedSize((int)ruleEntry.size());
        HashMap selectContentMap = Maps.newHashMapWithExpectedSize((int)ruleEntry.size());
        PromptServiceHelper.addPrompt(promptIdSet, selectContentMap, ruleEntry);
        DynamicObject[] contentDys = PromptServiceHelper.queryStringContentByLanguageAndPrompt(promptIdSet);
        Map<Long, DynamicObject> promptIdAndContent = Arrays.stream(contentDys).collect(Collectors.toMap(dy -> dy.getLong("prompt"), dy -> dy));
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)promptIdAndContent.size());
        for (DynamicObject entry : ruleEntry) {
            DynamicObject entryPrompt = entry.getDynamicObject("entryprompt");
            long promptId = entry.getLong("entryprompt.id");
            DynamicObject contentDy = promptIdAndContent.get(promptId);
            String content = PromptServiceHelper.getContent(entryPrompt, contentDy, entityId, dataModel, true);
            resultList.add(content);
        }
        return resultList;
    }

    public static Map<String, Map<String, Set<String>>> queryPromptForString(Map<String, Set<String>> controlMap, Map<String, DynamicObject> dataModelMap) {
        return PromptServiceHelper.queryContent(controlMap, dataModelMap, true);
    }

    private static Map<String, Map<String, Set<String>>> queryContent(Map<String, Set<String>> controlMap, Map<String, DynamicObject> dataModelMap, boolean isContentText) {
        LOGGER.info("PromptServiceHelper.queryPromptIdAndContent--controlMap:{}", controlMap);
        Map<String, Map<String, DynamicObjectCollection>> ruleEntryMap = PromptServiceHelper.queryRuleEntry(controlMap, dataModelMap);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)ruleEntryMap.size());
        HashSet promptIdSet = Sets.newHashSetWithExpectedSize((int)16);
        HashMap selectContentMap = Maps.newHashMapWithExpectedSize((int)16);
        ruleEntryMap.forEach((key, value) -> value.values().forEach(ruleEntry -> PromptServiceHelper.addPrompt(promptIdSet, selectContentMap, ruleEntry)));
        DynamicObject[] contentDys = PromptServiceHelper.queryContentByPrompt(promptIdSet);
        Map<String, DynamicObject> promptIdAndContent = Arrays.stream(contentDys).collect(Collectors.toMap(dy -> dy.getString("prompt"), dy -> dy));
        ruleEntryMap.forEach((key, value) -> {
            HashMap contentMap = Maps.newHashMapWithExpectedSize((int)value.size());
            value.forEach((control, ruleEntry) -> {
                HashSet contentSet = Sets.newHashSetWithExpectedSize((int)ruleEntry.size());
                ruleEntry.forEach(row -> {
                    DynamicObject entryPrompt = row.getDynamicObject("entryprompt");
                    long promptId = row.getLong("entryprompt.id");
                    DynamicObject contentDy = (DynamicObject)promptIdAndContent.get(String.valueOf(promptId));
                    String content = PromptServiceHelper.getContent(entryPrompt, contentDy, key, (DynamicObject)dataModelMap.get(key), isContentText);
                    contentSet.add(content);
                });
                contentMap.put(control, contentSet);
            });
            resultMap.put(key, contentMap);
        });
        return resultMap;
    }

    private static DynamicObjectCollection queryRuleEntry(String entityId, String controlKey, DynamicObject dataModel) {
        DynamicObject ruleDys = PromptServiceHelper.queryPromptRules(entityId, controlKey);
        LOGGER.info("PromptServiceHelper.queryPromptIds -- ruleDys : {}", (Object)ruleDys);
        if (Objects.isNull(ruleDys)) {
            return new DynamicObjectCollection();
        }
        DynamicObjectCollection ruleEntryDys = PromptServiceHelper.judgeFilterRule(dataModel, ruleDys);
        LOGGER.info("PromptServiceHelper.queryPromptIds -- ruleEntryDys : {}", (Object)ruleEntryDys);
        return ruleEntryDys;
    }

    private static Map<String, Map<String, DynamicObjectCollection>> queryRuleEntry(Map<String, Set<String>> controlMap, Map<String, DynamicObject> dataModelMap) {
        HashMap ruleEntryDysMap = Maps.newHashMapWithExpectedSize((int)controlMap.size());
        Map<String, Map<String, DynamicObject>> rulesMap = PromptServiceHelper.queryPromptRules(controlMap);
        LOGGER.info("PromptServiceHelper.queryPromptIds--ruleResults:{}", rulesMap);
        rulesMap.forEach((key, value) -> {
            DynamicObject dataModel = (DynamicObject)dataModelMap.get(key);
            HashMap ruleEntryMap = Maps.newHashMapWithExpectedSize((int)value.size());
            value.forEach((control, ruleDy) -> {
                DynamicObjectCollection ruleEntryDys = PromptServiceHelper.judgeFilterRule(dataModel, ruleDy);
                ruleEntryMap.put(control, ruleEntryDys);
            });
            ruleEntryDysMap.put(key, ruleEntryMap);
        });
        LOGGER.info("PromptServiceHelper.queryPromptIds--ruleEntryDys:{}", (Object)ruleEntryDysMap);
        return ruleEntryDysMap;
    }

    public static boolean isExists(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_prompt");
        return serviceHelper.isExists((Object)id);
    }

    public static DynamicObject[] getPrompts(List<Long> pks) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_prompt");
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", pks)};
        return helper.query("id,number,name,selectcontent,syslangcontent,promptlangcontent,langtype", filters);
    }

    public static DynamicObject[] getPrompts(Set<String> numberSet) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_prompt");
        QFilter[] filters = new QFilter[]{new QFilter("number", "in", numberSet)};
        return helper.query("id,number,name,selectcontent,syslangcontent,promptlangcontent,langtype", filters);
    }

    public static String getContent(Long id) {
        DynamicObject[] prompts = PromptServiceHelper.getPrompts(Lists.newArrayList((Object[])new Long[]{id}));
        String content = null;
        if (prompts.length > 0) {
            DynamicObject promptContent = PromptServiceHelper.getPromptContent(id);
            DynamicObject prompt = prompts[0];
            String selectContent = prompt.getString("selectcontent");
            ILocaleString promptLangContent = prompt.getLocaleString("promptlangcontent");
            ILocaleString sysLangContent = prompt.getLocaleString("syslangcontent");
            if ("1".equals(selectContent)) {
                if (PromptServiceHelper.isMulLangEmpty(sysLangContent) && promptContent != null) {
                    content = promptContent.getString("syscontent");
                } else if (!PromptServiceHelper.isMulLangEmpty(sysLangContent)) {
                    content = sysLangContent.getLocaleValue();
                }
            } else {
                String langType = prompt.getString("langtype");
                content = "1".equals(langType) && promptContent != null ? promptContent.getString("promptcontent") : promptLangContent.getLocaleValue();
            }
        }
        return content;
    }

    public static Map<String, String> getContentAndHtml(Long id) {
        DynamicObject[] prompts = PromptServiceHelper.getPrompts(Lists.newArrayList((Object[])new Long[]{id}));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        if (prompts.length > 0) {
            DynamicObject promptContent = PromptServiceHelper.getPromptContent(id);
            DynamicObject prompt = prompts[0];
            String selectContent = prompt.getString("selectcontent");
            ILocaleString promptLangContent = prompt.getLocaleString("promptlangcontent");
            ILocaleString sysLangContent = prompt.getLocaleString("syslangcontent");
            String content = null;
            String html = null;
            if ("1".equals(selectContent)) {
                if (PromptServiceHelper.isMulLangEmpty(sysLangContent) && promptContent != null) {
                    content = promptContent.getString("syscontenttext");
                } else if (!PromptServiceHelper.isMulLangEmpty(sysLangContent)) {
                    content = sysLangContent.getLocaleValue();
                }
                if (promptContent != null) {
                    html = promptContent.getString("syscontent");
                }
            } else {
                String langType;
                if (promptContent != null) {
                    html = promptContent.getString("promptcontent");
                }
                content = "1".equals(langType = prompt.getString("langtype")) && promptContent != null ? promptContent.getString("contenttext") : promptLangContent.getLocaleValue();
            }
            resultMap.put("content", content);
            resultMap.put("html", html);
        }
        return resultMap;
    }

    private static DynamicObject[] queryContentByPrompt(Set<Long> promptIds) {
        HRBaseServiceHelper contentHelper = new HRBaseServiceHelper("hrcs_promptcontent");
        return contentHelper.query("promptcontent,prompt,syscontent,contenttext,syscontenttext", new QFilter[]{new QFilter("prompt", "in", promptIds).and("locale.number", "=", (Object)Lang.get().name())});
    }

    private static DynamicObject[] queryStringContentByLanguageAndPrompt(Set<Long> promptIds) {
        HRBaseServiceHelper contentHelper = new HRBaseServiceHelper("hrcs_promptcontent");
        return contentHelper.query("contenttext,prompt,syscontenttext", new QFilter[]{new QFilter("prompt", "in", promptIds).and("locale.number", "=", (Object)Lang.get().name())});
    }

    private static DynamicObjectCollection judgeFilterRule(DynamicObject dataModel, DynamicObject ruleDy) {
        DynamicObjectCollection ruleEntryColl = ruleDy.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection removeRuleDy = new DynamicObjectCollection();
        if (CollectionUtils.isEmpty((Collection)ruleEntryColl)) {
            return ruleEntryColl;
        }
        ruleEntryColl.forEach(ruleEntryDy -> {
            FilterCondition filterCondition;
            String filterConditionStr = ruleEntryDy.getString("entryrule");
            if (HRStringUtils.isNotEmpty((String)filterConditionStr) && Objects.nonNull(filterCondition = (FilterCondition)kd.bos.login.actions.SerializationUtils.fromJsonString((String)filterConditionStr, FilterCondition.class)) && !CollectionUtils.isEmpty((Collection)filterCondition.getFilterRow())) {
                PromptServiceHelper.compareFilter(dataModel, removeRuleDy, ruleEntryDy, filterCondition, ruleDy.getString("businessobject.number"));
            }
        });
        ruleEntryColl.removeAll((Collection)removeRuleDy);
        return ruleEntryColl;
    }

    private static void compareFilter(DynamicObject dataModel, DynamicObjectCollection removeRuleDy, DynamicObject rule, FilterCondition filterCondition, String entityNum) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        FilterBuilder filterBuilder = new FilterBuilder(entityType, filterCondition);
        filterBuilder.setUserService((IUserService)new UserService());
        try {
            filterBuilder.buildFilter();
        }
        catch (Exception e) {
            LOGGER.error("filterBuilder build fail, this filterBuilder is :{}", (Object)filterCondition);
            removeRuleDy.add((Object)rule);
            return;
        }
        QFilter filter = filterBuilder.getQFilter();
        if (!PromptServiceHelper.judgeFilter(dataModel, filter).booleanValue()) {
            removeRuleDy.add((Object)rule);
        }
    }

    public static Boolean judgeFilter(DynamicObject dataModel, QFilter filter) {
        boolean flag = PromptServiceHelper.compareFilter(dataModel, filter);
        List nests = filter.getNests(false);
        if (CollectionUtils.isNotEmpty((Collection)nests)) {
            for (QFilter.QFilterNest nest : nests) {
                flag = nest.isAnd() ? flag && PromptServiceHelper.judgeFilter(dataModel, nest.getFilter()).booleanValue() : flag || PromptServiceHelper.judgeFilter(dataModel, nest.getFilter()) != false;
            }
        }
        return flag;
    }

    private static boolean compareFilter(DynamicObject dataModel, QFilter filter) {
        boolean ruleFlag = false;
        Object rightValue = filter.isExpressValue() ? dataModel.get((String)filter.getValue()) : filter.getValue();
        Object leftValue = dataModel.get(filter.getProperty());
        if (Objects.isNull(leftValue) || Objects.isNull(rightValue)) {
            return false;
        }
        switch (filter.getCP().toLowerCase(Locale.ROOT)) {
            case "=": {
                ruleFlag = CompareUtils.compareEquals(leftValue, rightValue);
                break;
            }
            case ">": {
                ruleFlag = CompareUtils.compareLargeThan(leftValue, rightValue);
                break;
            }
            case ">=": {
                ruleFlag = !CompareUtils.compareLessThan(leftValue, rightValue);
                break;
            }
            case "<": {
                ruleFlag = CompareUtils.compareLessThan(leftValue, rightValue);
                break;
            }
            case "<=": {
                ruleFlag = !CompareUtils.compareLargeThan(leftValue, rightValue);
                break;
            }
            case "!=": 
            case "<>": {
                ruleFlag = !CompareUtils.compareEquals(leftValue, rightValue);
                break;
            }
            case "like": 
            case "ftlike": {
                ruleFlag = CompareUtils.compareLike(leftValue, rightValue);
                break;
            }
            case "not like": {
                ruleFlag = !CompareUtils.compareLike(leftValue, rightValue);
                break;
            }
            case "in": {
                ruleFlag = CompareUtils.compareIn(leftValue, rightValue);
                break;
            }
            case "not in": {
                ruleFlag = !CompareUtils.compareIn(leftValue, rightValue);
                break;
            }
            case "is null": {
                ruleFlag = Objects.isNull(dataModel.get(filter.getProperty()));
                break;
            }
            case "is not null": {
                ruleFlag = Objects.nonNull(dataModel.get(filter.getProperty()));
                break;
            }
        }
        return ruleFlag;
    }

    public static String parsePromptContent(String entityName, String content, DynamicObject dyn) {
        if (Objects.isNull(content)) {
            return null;
        }
        String regex = "\u2460#\\{([^}]*)\\}#";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        HashMap<String, String> map = new HashMap<String, String>();
        while (matcher.find()) {
            map.put(matcher.group(0), matcher.group(1));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("before content::::::" + content);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("hintmap::::::" + map);
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityName);
        content = PromptServiceHelper.propBaseDadta(content, dyn, map, mainType);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("after content::::::" + content);
        }
        return content;
    }

    public static String parseDiyVariable(String content) {
        if (Objects.isNull(content)) {
            return null;
        }
        Pattern pattern = Pattern.compile("\u2461#\\{([\\s\\S]*?)}#");
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String result;
            Map map;
            String group = matcher.group(1);
            int firstIndex = group.indexOf(124);
            int lastIndex = group.lastIndexOf(124);
            if (firstIndex == -1 || firstIndex == lastIndex) {
                content = content.replace(matcher.group(), "");
                continue;
            }
            String diyVar = group.substring(firstIndex + 1, lastIndex);
            if (StringUtils.isEmpty((String)diyVar)) {
                content = content.replace(matcher.group(), "");
                continue;
            }
            try {
                map = (Map)SerializationUtils.fromJsonString((String)diyVar, Map.class);
            }
            catch (RuntimeException ex) {
                LOGGER.error(ex.getMessage());
                content = content.replace(matcher.group(), "");
                continue;
            }
            if (StringUtils.isEmpty((String)((String)map.get("cloudId"))) || StringUtils.isEmpty((String)((String)map.get("appId"))) || StringUtils.isEmpty((String)((String)map.get("serviceName"))) || StringUtils.isEmpty((String)((String)map.get("methodName")))) {
                content = content.replace(matcher.group(), "");
                continue;
            }
            try {
                result = (String)HRMServiceHelper.invokeBizService((String)((String)map.get("cloudId")), (String)((String)map.get("appId")), (String)((String)map.get("serviceName")), (String)((String)map.get("methodName")), (Object[])new Object[]{map.get("param")});
            }
            catch (KDException ex) {
                content = content.replace(matcher.group(), "");
                continue;
            }
            if (StringUtils.isEmpty((String)result)) {
                content = content.replace(matcher.group(), "");
                continue;
            }
            String behindText = lastIndex == group.length() - 1 ? "" : group.substring(lastIndex + 1);
            String parsedVir = group.substring(0, firstIndex) + result + behindText;
            content = content.replace(matcher.group(), parsedVir);
        }
        return content;
    }

    public static DynamicObject getPromptContent(Long promptId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_promptcontent");
        return serviceHelper.queryOne("prompt,promptcontent,contenttext,syscontent,syscontenttext", new QFilter[]{new QFilter("prompt", "=", (Object)promptId), new QFilter("locale.number", "=", (Object)Lang.get().name())});
    }

    public static DynamicObject getPrompt(String number) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_prompt");
        return serviceHelper.queryOriginalOne("id,number,name,selectcontent", new QFilter("number", "=", (Object)number));
    }

    public static DynamicObject[] getExtForms(String originId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_formmeta");
        return serviceHelper.query("id,masterid,inheritpath", new QFilter[]{new QFilter("masterid", "=", (Object)originId)});
    }

    public static String getExtEntityId(String originId) {
        DynamicObject[] extForms = PromptServiceHelper.getExtForms(originId);
        Optional<DynamicObject> lastExtForm = Arrays.stream(extForms).max(Comparator.comparingInt(x -> x.getString("inheritpath").length()));
        String entityId = lastExtForm.isPresent() ? lastExtForm.get().getString("id") : originId;
        return entityId;
    }

    public static DynamicObject[] getExtApps(String originId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        return serviceHelper.query("id,masterid,inheritpath", new QFilter[]{new QFilter("masterid", "=", (Object)originId)});
    }

    public static void setFieldVisible(IFormView view, DynamicObject busObj) {
        if (busObj != null) {
            String number = busObj.getString("number");
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)number);
            String alias = dataEntityType.getAlias();
            view.setVisible(Boolean.valueOf(HRStringUtils.isNotEmpty((String)alias)), new String[]{"selectfield"});
        } else {
            view.setVisible(Boolean.valueOf(false), new String[]{"selectfield"});
        }
    }

    public static boolean isMulLangEmpty(ILocaleString localeString) {
        boolean isEmpty = true;
        if (localeString != null) {
            for (Map.Entry entry : localeString.entrySet()) {
                if (HRStringUtils.isEmpty((String)((String)entry.getValue()))) continue;
                isEmpty = false;
            }
        }
        return isEmpty;
    }

    private static String propBaseDadta(String content, DynamicObject dyn, HashMap<String, String> map, MainEntityType mainType) {
        for (Map.Entry<String, String> resultEntry : map.entrySet()) {
            Object prop = null;
            prop = mainType.getProperties().get((Object)resultEntry.getValue());
            if (!Objects.isNull(prop)) {
                content = PromptServiceHelper.replaceProp(content, resultEntry, prop, dyn);
                continue;
            }
            if (!resultEntry.getValue().contains(".")) {
                content = content.replace(resultEntry.getKey(), "");
                continue;
            }
            try {
                IDataEntityProperty property;
                String fieldStr = resultEntry.getValue();
                String[] fieldStrs = fieldStr.split("\\.");
                String value = "";
                if (fieldStrs.length == 2 && (property = (IDataEntityProperty)dyn.getDynamicObject(fieldStrs[0]).getDataEntityType().getProperties().get((Object)fieldStrs[1])) instanceof ComboProp) {
                    value = ((ComboProp)property).getItemByName(dyn.getString(resultEntry.getValue()));
                    content = content.replace(resultEntry.getKey(), value);
                    continue;
                }
                value = dyn.getString(resultEntry.getValue()) == null ? "" : dyn.getString(resultEntry.getValue());
                content = content.replace(resultEntry.getKey(), value);
            }
            catch (RuntimeException exception) {
                LOGGER.error("getContent:", (Throwable)exception);
                content = content.replace(resultEntry.getKey(), "");
            }
        }
        return content;
    }

    private static String replaceProp(String content, Map.Entry<String, String> resultEntry, Object prop, DynamicObject dyn) {
        Object value = dyn.get(resultEntry.getValue());
        if (Objects.isNull(value)) {
            content = content.replace(resultEntry.getKey(), "");
            return content;
        }
        if (prop instanceof BillStatusProp) {
            String statusVar = PromptServiceHelper.getStatusCaption((BillStatusProp)prop, value.toString());
            content = content.replace(resultEntry.getKey(), statusVar);
        } else if (prop instanceof DateTimeProp) {
            content = PromptServiceHelper.setContentByDateTime(content, resultEntry, (DateTimeProp)prop, value);
        } else if (prop instanceof MulComboProp) {
            if (StringUtils.isEmpty((String)value.toString())) {
                return content;
            }
            String valueStr = value.toString();
            String newValue = valueStr.substring(1, valueStr.length() - 1);
            HashSet valueSet = Sets.newHashSet((Object[])newValue.split(","));
            List comboItemList = ((MulComboProp)prop).getComboItems();
            StringBuilder stringBuilder = new StringBuilder();
            comboItemList.stream().filter(comboItem -> valueSet.contains(comboItem.getValue())).forEach(comboItem -> stringBuilder.append(comboItem.getName()).append(';'));
            if (stringBuilder.length() != 0) {
                content = content.replace(resultEntry.getKey(), stringBuilder.substring(0, stringBuilder.length() - 1));
            }
        } else if (prop instanceof MulBasedataProp) {
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)value;
            List nameList = dynamicObjectCollection.stream().map(dy -> ((DynamicObject)dy.get("fbasedataid")).getString("name")).collect(Collectors.toList());
            String name = String.join((CharSequence)",", nameList);
            content = content.replace(resultEntry.getKey(), name);
        } else if (prop instanceof TimeProp) {
            content = PromptServiceHelper.setContentByTime(content, resultEntry, (Integer)value);
        } else if (prop instanceof BasedataProp) {
            DynamicObject dy2 = (DynamicObject)value;
            content = content.replace(resultEntry.getKey(), dy2.getString("name"));
        } else if (prop instanceof PictureProp) {
            content = content.replace(resultEntry.getKey(), "<img>" + UrlService.getImageFullUrl((String)((String)value)) + "</img>");
        } else if (prop instanceof ComboProp) {
            List comboItemList = ((ComboProp)prop).getComboItems();
            ValueMapItem valueMapItem = comboItemList.stream().filter(comboItem -> Objects.equals(value, comboItem.getValue())).findFirst().orElse(null);
            content = content.replace(resultEntry.getKey(), valueMapItem == null ? "" : valueMapItem.getName().toString());
        } else {
            content = prop instanceof BigIntProp ? content.replace(resultEntry.getKey(), Objects.equals(String.valueOf(0L), value.toString()) ? "0" : value.toString()) : (prop instanceof IntegerProp ? content.replace(resultEntry.getKey(), value.toString()) : (prop instanceof DecimalProp ? content.replace(resultEntry.getKey(), BigDecimal.ZERO.compareTo(new BigDecimal(value.toString())) == 0 ? "0" : value.toString()) : content.replace(resultEntry.getKey(), value.toString() == null ? "" : value.toString())));
        }
        return content;
    }

    private static String setContentByTime(String content, Map.Entry<String, String> resultEntry, Integer value) {
        StringBuilder timeStr = new StringBuilder();
        if (value != -1) {
            int hour = value / 3600;
            int min = value % 3600 / 60;
            int sec = value % 60;
            timeStr.append(PromptServiceHelper.unitFormat(hour)).append(':').append(PromptServiceHelper.unitFormat(min)).append(':').append(PromptServiceHelper.unitFormat(sec));
        }
        content = content.replace(resultEntry.getKey(), timeStr.toString());
        return content;
    }

    private static String setContentByDateTime(String content, Map.Entry<String, String> resultEntry, DateTimeProp prop, Object value) {
        DateFormat dateFormat = prop.getDateFormat();
        try {
            Date date = null;
            date = value instanceof Date ? (Date)value : dateFormat.parse(value.toString());
            String dateStr = dateFormat.format(date);
            content = content.replace(resultEntry.getKey(), dateStr);
        }
        catch (ParseException e) {
            LOGGER.error((Throwable)e);
        }
        return content;
    }

    private static String getStatusCaption(BillStatusProp statusProp, String status) {
        for (ValueMapItem item : statusProp.getComboItems()) {
            if (!status.equals(item.getValue())) continue;
            return item.getName().getLocaleValue();
        }
        return "";
    }

    private static String unitFormat(int var) {
        String retStr = null;
        retStr = var >= 0 && var < 10 ? "0" + Integer.toString(var) : "" + var;
        return retStr;
    }

    private static String replaceByPattern(Pattern pattern, String content) {
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String group = matcher.group(0);
            content = content.replace(group, "");
        }
        return content;
    }

    private static void addPrompt(Set<Long> promptIdSet, Map<Long, String> selectContentMap, DynamicObjectCollection entry) {
        entry.forEach(row -> {
            long promptId = row.getLong("entryprompt.id");
            promptIdSet.add(promptId);
            selectContentMap.put(promptId, row.getString("entryprompt.selectcontent"));
        });
    }

    private static String getContent(DynamicObject prompt, DynamicObject contentDyn, String entityId, DynamicObject dataModel, boolean isContentText) {
        String selContent = prompt.getString("selectcontent");
        String langType = prompt.getString("langtype");
        ILocaleString promptLangContent = prompt.getLocaleString("promptlangcontent");
        ILocaleString sysLangContent = prompt.getLocaleString("syslangcontent");
        String content = "1".equals(selContent) ? (PromptServiceHelper.isMulLangEmpty(sysLangContent) ? PromptServiceHelper.getContent(contentDyn, entityId, dataModel, isContentText, true) : sysLangContent.getLocaleValue()) : ("1".equals(langType) ? PromptServiceHelper.getContent(contentDyn, entityId, dataModel, isContentText, false) : promptLangContent.getLocaleValue());
        return content;
    }

    private static String getContent(DynamicObject contentDyn, String entityId, DynamicObject dataModel, boolean isContentText, boolean isSys) {
        String content = null;
        if (contentDyn != null) {
            if (isContentText) {
                content = isSys ? contentDyn.getString("syscontenttext") : contentDyn.getString("contenttext");
                content = PromptServiceHelper.replaceByPattern(Pattern.compile("\u2462#\\{([\\s\\S]*?)}#"), content);
                content = PromptServiceHelper.replaceByPattern(Pattern.compile("\u2463#\\{([\\s\\S]*?)}#"), content);
            } else {
                content = isSys ? contentDyn.getString("syscontent") : contentDyn.getString("promptcontent");
            }
            content = PromptServiceHelper.parseDiyVariable(content);
            content = PromptServiceHelper.parsePromptContent(entityId, content, dataModel);
        }
        return content;
    }
}

