/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.servicehelper.strategytype;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.StrategyServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.HRBUExtServiceHelper;
import kd.hr.hrcs.common.constants.ManageStrategyConstants;

public class StrategyTypeInvokeServiceHelper {
    private static final Log LOG = LogFactory.getLog(StrategyTypeInvokeServiceHelper.class);
    private static final String FIELD_BUSSINESS_FIELD_ID = "bussinessfield.id";
    private static final String FIELD_ADMINORG_ID = "adminorg.id";

    public Map<Long, Map<String, Object>> setResultMap(DynamicObject strategyTypeDy, List<Long> orgIdList, String objectType, Boolean isAllField) {
        HashMap<Long, Map<String, Object>> resultMap = new HashMap<Long, Map<String, Object>>();
        this.setResultMapById(strategyTypeDy, resultMap, orgIdList, objectType, isAllField);
        return resultMap;
    }

    private void setResultMapById(DynamicObject strategyTypeDy, Map<Long, Map<String, Object>> resultMap, List<Long> orgIdList, String objectType, Boolean isAllField) {
        String strategyTypeFlag;
        if (null == strategyTypeDy || orgIdList.size() == 0) {
            return;
        }
        Long bussinessFieldId = strategyTypeDy.getLong(FIELD_BUSSINESS_FIELD_ID);
        switch (strategyTypeFlag = strategyTypeDy.getString("strategytype")) {
            case "0": {
                this.stayWithParentOrg(resultMap, orgIdList, bussinessFieldId, objectType, isAllField);
                break;
            }
            case "1": {
                this.stayWithAdminOrgType(resultMap, orgIdList, bussinessFieldId, objectType, ManageStrategyConstants.ID_ORGTYPE_GROUP, isAllField);
                break;
            }
            case "2": {
                this.stayWithAdminOrgType(resultMap, orgIdList, bussinessFieldId, objectType, ManageStrategyConstants.ID_ORGTYPE_COMPANY, isAllField);
                break;
            }
            case "4": {
                this.stayWithSelfOrg(resultMap, orgIdList, bussinessFieldId, objectType, isAllField);
                break;
            }
            case "6": {
                this.stayWithOrg(resultMap, orgIdList, bussinessFieldId, isAllField);
                break;
            }
            case "5": {
                this.stayWithCustomOrg(resultMap, orgIdList, objectType, bussinessFieldId, isAllField);
                break;
            }
        }
    }

    private void stayWithCustomOrg(Map<Long, Map<String, Object>> resultMap, List<Long> orgIdList, String objectType, Long bussinessFieldId, Boolean isAllField) {
        DynamicObject[] strategyEntryDys = null;
        if (HRStringUtils.equals((String)objectType, (String)"2")) {
            if (isAllField.booleanValue()) {
                DynamicObject[] strategyDys = StrategyServiceHelper.getOrgStrategyByOrgList(orgIdList);
                this.bulidDefResultMap(strategyDys, resultMap, isAllField);
            } else {
                strategyEntryDys = StrategyServiceHelper.getOrgStrategyEntryByOrgListAndBussinessField(orgIdList, bussinessFieldId);
                this.buildEntryResultMap(strategyEntryDys, resultMap, isAllField, null);
            }
        } else if (HRStringUtils.equals((String)objectType, (String)"1")) {
            if (isAllField.booleanValue()) {
                DynamicObject[] strategyDys = StrategyServiceHelper.getEmpStrategyByOrgList(orgIdList);
                this.bulidDefResultMap(strategyDys, resultMap, isAllField);
            } else {
                strategyEntryDys = StrategyServiceHelper.getEmpStrategyEntryByOrgListAndBussinessField(orgIdList, bussinessFieldId);
                this.buildEntryResultMap(strategyEntryDys, resultMap, isAllField, null);
            }
        }
    }

    private void stayWithSelfOrg(Map<Long, Map<String, Object>> resultMap, List<Long> orgIdList, Long bussinessFieldId, String bussinessObjectType, Boolean isAllField) {
        DynamicObject[] manageStrategyDys = null;
        if (HRStringUtils.equals((String)bussinessObjectType, (String)"1")) {
            if (isAllField.booleanValue()) {
                DynamicObject[] strategyDys = StrategyServiceHelper.getEmpStrategyByOrgList(orgIdList);
                this.bulidSelfDefResultMap(strategyDys, resultMap);
            } else {
                manageStrategyDys = StrategyServiceHelper.getEmpStrategyEntryByOrgListAndBussinessField(orgIdList, bussinessFieldId);
                this.bulidSelfResultMap(manageStrategyDys, resultMap);
            }
        } else if (HRStringUtils.equals((String)bussinessObjectType, (String)"2")) {
            if (isAllField.booleanValue()) {
                DynamicObject[] strategyDys = StrategyServiceHelper.getOrgStrategyByOrgList(orgIdList);
                this.bulidSelfDefResultMap(strategyDys, resultMap);
            } else {
                manageStrategyDys = StrategyServiceHelper.getOrgStrategyEntryByOrgListAndBussinessField(orgIdList, bussinessFieldId);
                this.bulidSelfResultMap(manageStrategyDys, resultMap);
            }
        }
    }

    private void bulidSelfResultMap(DynamicObject[] manageStrategyDys, Map<Long, Map<String, Object>> strategyMapList) {
        DynamicObject[] hrbuDys;
        ArrayList adminOrgIdList = Lists.newArrayListWithExpectedSize((int)manageStrategyDys.length);
        HashMap entryMap = Maps.newHashMapWithExpectedSize((int)manageStrategyDys.length);
        for (DynamicObject dyObj : manageStrategyDys) {
            Long adminOrgId = dyObj.getLong(FIELD_ADMINORG_ID);
            entryMap.put("inheritedorg", dyObj.getDynamicObject("orgteam"));
            adminOrgIdList.add(adminOrgId);
            strategyMapList.put(adminOrgId, entryMap);
        }
        for (DynamicObject hrbuDy : hrbuDys = HRBUExtServiceHelper.getHROrgByIdList(adminOrgIdList)) {
            entryMap.put("hrbu", hrbuDy);
            strategyMapList.put(hrbuDy.getLong("id"), entryMap);
        }
    }

    private void bulidSelfDefResultMap(DynamicObject[] strategyDys, Map<Long, Map<String, Object>> strategyMap) {
        HashMap defMap = Maps.newHashMapWithExpectedSize((int)strategyDys.length);
        ArrayList adminOrgIdList = Lists.newArrayListWithExpectedSize((int)strategyDys.length);
        DynamicObject[] hrbuDys = HRBUExtServiceHelper.getHROrgByIdList(adminOrgIdList);
        HashMap hrbuMap = Maps.newHashMapWithExpectedSize((int)hrbuDys.length);
        for (DynamicObject hrbuDy : hrbuDys) {
            Long hrbuId = hrbuDy.getLong("id");
            hrbuMap.put(hrbuId, hrbuDy);
        }
        for (DynamicObject dy : strategyDys) {
            Long adminOrgId = dy.getLong(FIELD_ADMINORG_ID);
            DynamicObject inheritedOrgDy = dy.getDynamicObject("orgteam");
            defMap.put("inheritedorg", inheritedOrgDy);
            adminOrgIdList.add(adminOrgId);
            strategyMap.put(adminOrgId, defMap);
            DynamicObjectCollection dyColl = dy.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryDy : dyColl) {
                Long bussinessFieldId = entryDy.getLong("entryentity.bussinessfield.id");
                defMap.put(bussinessFieldId + "inheritedorg", inheritedOrgDy);
                defMap.put(bussinessFieldId + "hrbu", hrbuMap.get(adminOrgId));
                strategyMap.put(adminOrgId, defMap);
            }
        }
    }

    private void stayWithParentOrg(Map<Long, Map<String, Object>> resultMap, List<Long> orgIdList, Long bussinessFieldId, String bussinessObjectType, Boolean isAllField) {
        DynamicObject[] adminOrgDys = StrategyServiceHelper.getStructOrgByOrgIdList(orgIdList);
        ArrayList parentIdList = Lists.newArrayListWithExpectedSize((int)adminOrgDys.length);
        HashMap parentidOrgIdMap = Maps.newHashMapWithExpectedSize((int)adminOrgDys.length);
        for (DynamicObject dys : adminOrgDys) {
            Long parentId = dys.getLong("parentorg.id");
            parentIdList.add(parentId);
            parentidOrgIdMap.put(parentId, dys.getLong(FIELD_ADMINORG_ID));
        }
        this.buildResultMapByOrgIdList(resultMap, parentIdList, bussinessFieldId, bussinessObjectType, isAllField);
        this.transferMapKey(resultMap, parentidOrgIdMap);
    }

    private void buildResultMapByOrgIdList(Map<Long, Map<String, Object>> resultMap, List<Long> orgIdList, Long bussinessFieldId, String bussinessObjectType, Boolean isAllField) {
        DynamicObject[] manageStrategyDys = null;
        if (HRStringUtils.equals((String)bussinessObjectType, (String)"2")) {
            if (isAllField.booleanValue()) {
                Object[] strategyDys = StrategyServiceHelper.getOrgStrategyByOrgList(orgIdList);
                if (ObjectUtils.isEmpty((Object[])strategyDys)) {
                    LOG.error("buildResultMapByOrgIdList() org:{} orgStrategyDys is empty.", orgIdList);
                }
                this.bulidDefResultMap((DynamicObject[])strategyDys, resultMap, isAllField);
            } else {
                manageStrategyDys = StrategyServiceHelper.getOrgStrategyEntryByOrgListAndBussinessField(orgIdList, bussinessFieldId);
                this.buildEntryResultMap(manageStrategyDys, resultMap, isAllField, null);
            }
        } else if (isAllField.booleanValue()) {
            Object[] strategyDys = StrategyServiceHelper.getEmpStrategyByOrgList(orgIdList);
            if (ObjectUtils.isEmpty((Object[])strategyDys)) {
                LOG.error("buildResultMapByOrgIdList() org:{} empStrategyDys is empty.", orgIdList);
            }
            this.bulidDefResultMap((DynamicObject[])strategyDys, resultMap, isAllField);
        } else {
            manageStrategyDys = StrategyServiceHelper.getEmpStrategyEntryByOrgListAndBussinessField(orgIdList, bussinessFieldId);
            this.buildEntryResultMap(manageStrategyDys, resultMap, isAllField, null);
        }
    }

    private void bulidDefResultMap(DynamicObject[] strategyDys, Map<Long, Map<String, Object>> strategyMap, Boolean isAllField) {
        HashMap defMap = Maps.newHashMapWithExpectedSize((int)strategyDys.length);
        for (DynamicObject dy : strategyDys) {
            Long adminOrgId = dy.getLong("orgteam.id");
            DynamicObject inheritedOrgDy = dy.getDynamicObject("orgteam");
            DynamicObject sourceOrgDy = dy.getDynamicObject("sourceorg");
            defMap.put("inheritedorg", inheritedOrgDy);
            defMap.put("sourceorg", sourceOrgDy);
            strategyMap.put(adminOrgId, defMap);
            DynamicObjectCollection strategyEntryDyColl = dy.getDynamicObjectCollection("entryentity");
            Object[] strategyEntryDys = new DynamicObject[strategyEntryDyColl.size()];
            strategyEntryDys = (DynamicObject[])strategyEntryDyColl.toArray(strategyEntryDys);
            this.buildEntryResultMap((DynamicObject[])strategyEntryDys, strategyMap, isAllField, defMap);
        }
    }

    private void stayWithAdminOrgType(Map<Long, Map<String, Object>> resultMap, List<Long> orgIdList, Long bussinessFieldId, String bussinessObjectType, Long adminOrgTypeId, Boolean isAllField) {
        DynamicObject[] adminOrgStructDys = StrategyServiceHelper.getStructOrgByOrgIdList(orgIdList);
        DynamicObject[] groupAdminOrgDys = adminOrgStructDys.length == 1 ? StrategyServiceHelper.getAdminOrgByAdminorgType(adminOrgTypeId, adminOrgStructDys[0].getInt("level")) : StrategyServiceHelper.getAdminOrgByAdminorgType(adminOrgTypeId, null);
        ArrayList<Long> groupIdList = new ArrayList<Long>();
        HashMap<Long, Long> grpoupidOrgIdMap = new HashMap<Long, Long>();
        for (DynamicObject dy : adminOrgStructDys) {
            DynamicObject groupDy = this.getGroupOrCampanyParentByLongnumber(groupAdminOrgDys, dy);
            if (null == groupDy) {
                LOG.error("getGroupOrCampanyParentByLongnumber() groupDy:{} is null", (Object)dy.getLong(FIELD_ADMINORG_ID));
                continue;
            }
            groupIdList.add(groupDy.getLong("id"));
            grpoupidOrgIdMap.put(groupDy.getLong("id"), dy.getLong(FIELD_ADMINORG_ID));
        }
        LOG.info("getGroupOrCampanyParentByLongnumber() grpoupidOrgIdMap:{}", grpoupidOrgIdMap);
        this.buildResultMapByOrgIdList(resultMap, groupIdList, bussinessFieldId, bussinessObjectType, isAllField);
        this.transferMapKey(resultMap, grpoupidOrgIdMap);
    }

    private DynamicObject getGroupOrCampanyParentByLongnumber(DynamicObject[] allAdminOrgDys, DynamicObject adminOrgStructDy) {
        DynamicObject parentDy = null;
        String longNumber = adminOrgStructDy.getString("structlongnumber");
        String[] adminNumbers = longNumber.split("!");
        if (1 == adminNumbers.length) {
            return null;
        }
        HashMap orgNumberMap = Maps.newHashMapWithExpectedSize((int)allAdminOrgDys.length);
        for (DynamicObject adminOrgDy : allAdminOrgDys) {
            String adminOrgNumber = adminOrgDy.getString("structnumber");
            orgNumberMap.put(adminOrgNumber, adminOrgDy);
        }
        for (int i = adminNumbers.length - 1; i >= 0; --i) {
            if (!orgNumberMap.containsKey(adminNumbers[i])) continue;
            parentDy = (DynamicObject)orgNumberMap.get(adminNumbers[i]);
            break;
        }
        return parentDy;
    }

    private void stayWithOrg(Map<Long, Map<String, Object>> resultMap, List<Long> orgIdList, Long bussinessFieldId, Boolean isAllField) {
        DynamicObject[] strategyEntryDys = null;
        if (isAllField.booleanValue()) {
            DynamicObject[] strategyDys = StrategyServiceHelper.getOrgStrategyByOrgList(orgIdList);
            this.bulidDefResultMap(strategyDys, resultMap, isAllField);
        } else {
            strategyEntryDys = StrategyServiceHelper.getOrgStrategyEntryByOrgListAndBussinessField(orgIdList, bussinessFieldId);
            this.buildEntryResultMap(strategyEntryDys, resultMap, isAllField, null);
        }
    }

    private void buildEntryResultMap(DynamicObject[] manageStrategyDys, Map<Long, Map<String, Object>> strategyMap, Boolean isAllField, Map<String, Object> defMap) {
        if (null == manageStrategyDys || manageStrategyDys.length < 1) {
            return;
        }
        String strategyEntryType = "";
        Long adminOrgId = 0L;
        if (isAllField.booleanValue()) {
            HashMap<String, DynamicObject> resultStrategyMap = new HashMap<String, DynamicObject>();
            HashMap<String, DynamicObject> resultStrategyDefMap = new HashMap<String, DynamicObject>();
            for (DynamicObject dyObj : manageStrategyDys) {
                adminOrgId = dyObj.getLong("entryorgteam.id");
                strategyEntryType = dyObj.getString("strategyentrytype");
                Long bussinessFieldId = dyObj.getLong(FIELD_BUSSINESS_FIELD_ID);
                if (HRStringUtils.equals((String)"0", (String)strategyEntryType)) {
                    resultStrategyDefMap.put(String.valueOf(bussinessFieldId) + String.valueOf(adminOrgId), dyObj);
                    continue;
                }
                if (!HRStringUtils.equals((String)"1", (String)strategyEntryType)) continue;
                resultStrategyMap.put(String.valueOf(bussinessFieldId) + String.valueOf(adminOrgId), dyObj);
            }
            this.compareEntryAndDefEntryMap(resultStrategyMap, resultStrategyDefMap);
            this.setMoreEntryMap(strategyMap, resultStrategyMap, defMap, adminOrgId);
        } else {
            this.addStrategyMapByField(manageStrategyDys, strategyMap);
        }
    }

    private void addStrategyMapByField(DynamicObject[] manageStrategyDys, Map<Long, Map<String, Object>> strategyMap) {
        HashMap<Long, DynamicObject> resultStrategyMap = new HashMap<Long, DynamicObject>();
        HashMap<Long, DynamicObject> resultStrategyDefMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject dyObj : manageStrategyDys) {
            Long adminOrgId = dyObj.getLong("orgteam.id");
            String strategyEntryType = dyObj.getString("strategyentrytype");
            if (HRStringUtils.equals((String)"0", (String)strategyEntryType)) {
                resultStrategyDefMap.put(adminOrgId, dyObj);
                continue;
            }
            if (!HRStringUtils.equals((String)"1", (String)strategyEntryType)) continue;
            resultStrategyMap.put(adminOrgId, dyObj);
        }
        this.compareEntryAndDefEntryMap(resultStrategyMap, resultStrategyDefMap);
        this.setSingleEntryMap(strategyMap, resultStrategyMap);
    }

    private void setMoreEntryMap(Map<Long, Map<String, Object>> strategyMap, Map<String, DynamicObject> resultStrategyMap, Map<String, Object> defMap, Long adminOrgId) {
        for (Map.Entry<String, DynamicObject> entry : resultStrategyMap.entrySet()) {
            DynamicObject mapValue = entry.getValue();
            Long bussinessFieldId = mapValue.getLong(FIELD_BUSSINESS_FIELD_ID);
            DynamicObject hrbuDy = mapValue.getDynamicObject("entryhrbu");
            DynamicObject inheritedOrgDy = mapValue.getDynamicObject("entryorgteam");
            DynamicObject sourceOrgDy = mapValue.getDynamicObject("entrysourceorg");
            defMap.put(bussinessFieldId + "hrbu", hrbuDy);
            defMap.put(bussinessFieldId + "inheritedorg", inheritedOrgDy);
            defMap.put(bussinessFieldId + "sourceorg", sourceOrgDy);
        }
        strategyMap.put(adminOrgId, defMap);
    }

    private void setSingleEntryMap(Map<Long, Map<String, Object>> strategyMap, Map<Long, DynamicObject> resultStrategyMap) {
        HashMap entryMap = Maps.newHashMapWithExpectedSize((int)resultStrategyMap.size());
        for (Map.Entry<Long, DynamicObject> entry : resultStrategyMap.entrySet()) {
            Long mapKey = entry.getKey();
            DynamicObject mapValue = entry.getValue();
            DynamicObject hrbuDy = mapValue.getDynamicObject("hrbu");
            DynamicObject inheritedOrgDy = mapValue.getDynamicObject("orgteam");
            DynamicObject sourceOrgDy = mapValue.getDynamicObject("sourceorg");
            entryMap.put("hrbu", hrbuDy);
            entryMap.put("inheritedorg", inheritedOrgDy);
            entryMap.put("sourceorg", sourceOrgDy);
            strategyMap.put(mapKey, entryMap);
        }
    }

    private void transferMapKey(Map<Long, Map<String, Object>> resultMap, Map<Long, Long> xxxOrgIdMap) {
        HashMap<Long, Map<String, Object>> newResultMap = new HashMap<Long, Map<String, Object>>();
        Iterator<Map.Entry<Long, Map<String, Object>>> iterator = resultMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, Map<String, Object>> next = iterator.next();
            Long groupId = next.getKey();
            Long orgId = xxxOrgIdMap.get(groupId);
            Map<String, Object> map = resultMap.get(groupId);
            if (map == null || orgId == null) continue;
            iterator.remove();
            newResultMap.put(orgId, map);
        }
        resultMap.putAll(newResultMap);
    }

    private void compareEntryAndDefEntryMap(Map entryMap, Map defEntryMap) {
        for (Map.Entry entry : defEntryMap.entrySet()) {
            Object key = entry.getKey();
            DynamicObject value = (DynamicObject)entry.getValue();
            if (entryMap.containsKey(key)) continue;
            entryMap.put(key, value);
        }
    }
}

