/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.strategy.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.bussiness.strategy.InitStrategyService;
import kd.hr.hrcs.bussiness.strategy.InitStrategyServiceHelper;
import kd.hr.hrcs.common.constants.ManageStrategyConstants;
import kd.hr.hrcs.common.strategy.InitStrategyOrgModel;
import kd.hr.hrcs.common.strategy.InitStrategySaveModel;
import org.apache.commons.lang3.tuple.Pair;

public abstract class InitStrategyServiceImpl
implements InitStrategyService {
    private static final Log LOGGER = LogFactory.getLog(InitStrategyServiceImpl.class);
    private static final String HR_BU_ORG = "hrBuOrg";
    private static final String NOT_HR_BU_ORG = "notHrBuOrg";
    protected final Map<Long, Set<Long>> businessTypeTies = new ConcurrentHashMap<Long, Set<Long>>(16);
    protected final Map<String, DynamicObject> baseStrategys = new ConcurrentHashMap<String, DynamicObject>(16);
    protected final Map<Long, DynamicObject> alreadyStrategy = Maps.newHashMapWithExpectedSize((int)16);
    protected IPageCache pageCache;

    public IPageCache getPageCache() {
        return this.pageCache;
    }

    @Override
    public void setPageCache(IPageCache pageCache) {
        this.pageCache = pageCache;
    }

    @Override
    public void initStrategy() {
        List<DynamicObject> enableHROrgDys = InitStrategyServiceHelper.getEnableAdminOrg();
        LOGGER.info("initStrategy() enableAdminOrgs.length is {}", (Object)enableHROrgDys.size());
        Map<Long, DynamicObject> existStrategys = this.getExistStrategy();
        LOGGER.info("initStrategy() existStrategys.length is {}", (Object)existStrategys.size());
        this.setBusinessTypeReal();
        this.setStrategyType();
        Pair<Set<Long>, Map<Long, Set<Long>>> completeAndLacks = InitStrategyServiceHelper.compareStrategy(existStrategys, this.businessTypeTies.get(this.getBusinessObjectId()));
        Set left = (Set)completeAndLacks.getLeft();
        LOGGER.info("initStrategy() completed org length:{}", (Object)left.size());
        Map<Long, DynamicObject> hrOrgId2Dy = enableHROrgDys.stream().filter(dy2 -> !left.contains(dy2.getLong("id"))).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
        LOGGER.info("initStrategy() hrOrgId2Dy length:{}", (Object)hrOrgId2Dy.size());
        HashSet hrOrgIds = Sets.newHashSet(hrOrgId2Dy.keySet());
        List<InitStrategyOrgModel> initOrgModels = InitStrategyServiceHelper.getInitModel(hrOrgIds, hrOrgId2Dy);
        hrOrgIds.removeAll(existStrategys.keySet());
        LOGGER.info("initStrategy() length of complete new org:{}", (Object)hrOrgIds.size());
        HashSet adminOrgIds = Sets.newHashSet();
        adminOrgIds.addAll(hrOrgIds);
        adminOrgIds.addAll(((Map)completeAndLacks.getRight()).keySet());
        LOGGER.info("initStrategy()_adminOrgIds length:{}", (Object)adminOrgIds.size());
        Map<Long, List<Long>> hrBuByAdminOrg = InitStrategyServiceHelper.getHrBuByAdminOrg(adminOrgIds, this.getBusinessObjectId());
        if (hrBuByAdminOrg.size() < 100) {
            LOGGER.info("initStrategy()_hrBuByAdminOrg\uff1a{}", hrBuByAdminOrg);
        }
        LOGGER.info("initStrategy()_hrBuByAdminOrg length:{}", (Object)hrBuByAdminOrg.size());
        InitStrategySaveModel model = new InitStrategySaveModel().setOrgTeamIds((Set)hrOrgIds).setLacks((Map)completeAndLacks.getRight()).setBusinessType2HRBu(hrBuByAdminOrg).setInitOrgModels(initOrgModels).setExistStrategys(existStrategys).setAdminOrgDetails(hrOrgId2Dy);
        this.handleStrategy(model);
    }

    protected void processHisInThreshold(DynamicObjectCollection leftCollection) {
        LOGGER.info("start processHisInThreshold, size large than Threshold, leftCollection.size():{}", (Object)leftCollection.size());
        long start = System.currentTimeMillis();
        ArrayList leftList = Lists.newArrayListWithExpectedSize((int)10000);
        for (int i = 0; i < leftCollection.size(); ++i) {
            if (i % 10000 == 0) {
                LOGGER.info("process processHisInThreshold, leftCollection index :{},leftList.size():{},cost timeMillis:{}", new Object[]{i, leftList.size(), System.currentTimeMillis() - start});
                InitStrategyServiceHelper.notEmptyExecute(leftList, this::addStrategyHisByList);
                leftList.clear();
            }
            leftList.add(leftCollection.get(i));
        }
        LOGGER.info("last time process processHisInThreshold, leftList.size():{},cost timeMillis:{}", (Object)leftList.size(), (Object)(System.currentTimeMillis() - start));
        InitStrategyServiceHelper.notEmptyExecute(leftList, this::addStrategyHisByList);
        LOGGER.info("end processHisInThreshold,cost timeMillis:{}", (Object)(System.currentTimeMillis() - start));
    }

    protected Map<Long, DynamicObject> getExistStrategy() {
        return InitStrategyServiceHelper.getExistsStrategy(this.getEntityNumber());
    }

    protected abstract void handleStrategy(InitStrategySaveModel var1);

    protected abstract void addStrategyHisByList(List<DynamicObject> var1);

    protected Pair<DynamicObjectCollection, DynamicObjectCollection> handleStrategy(InitStrategySaveModel saveModel, String entityNumber) {
        List<InitStrategyOrgModel> supplyModels = saveModel.getInitOrgModels().stream().filter(model -> saveModel.getLacks().containsKey(model.getId())).collect(Collectors.toList());
        DynamicObjectCollection supplys = new DynamicObjectCollection();
        if (!CollectionUtils.isEmpty(supplyModels)) {
            LOGGER.info("supplyModels is not empty, assembleSupplyStrategy,supplyModels.size():{}", (Object)supplyModels.size());
            supplys = this.assembleSupplyStrategy(supplyModels, saveModel, entityNumber, "supply");
        }
        List<InitStrategyOrgModel> orgModels = saveModel.getInitOrgModels().stream().filter(model -> saveModel.getOrgTeamIds().contains(model.getId())).collect(Collectors.toList());
        DynamicObjectCollection news = new DynamicObjectCollection();
        if (!CollectionUtils.isEmpty(orgModels)) {
            LOGGER.info("orgModels is not empty, assembleSupplyStrategy,orgModels.size():{}", (Object)orgModels.size());
            news = this.assembleSupplyStrategy(orgModels, saveModel, entityNumber, "news");
        }
        return Pair.of((Object)news, (Object)supplys);
    }

    protected DynamicObjectCollection assembleSupplyStrategy(List<InitStrategyOrgModel> orgModels, InitStrategySaveModel saveModel, String entityNumber, String flag) {
        Set<Long> businessTypeTiesIds = this.businessTypeTies.get(this.getBusinessObjectId());
        Map businessType2HRBu = saveModel.getBusinessType2HRBu();
        Map<String, List<InitStrategyOrgModel>> orgGroups = orgModels.stream().collect(Collectors.groupingBy(model -> {
            if (businessTypeTiesIds.stream().allMatch(id -> businessType2HRBu.get(id) != null && ((List)businessType2HRBu.get(id)).contains(model.getId()))) {
                return HR_BU_ORG;
            }
            return NOT_HR_BU_ORG;
        }));
        DynamicObjectCollection saveColl = new DynamicObjectCollection();
        List<InitStrategyOrgModel> hrBuOrgs = orgGroups.get(HR_BU_ORG);
        List<InitStrategyOrgModel> notHrBuOrgs = orgGroups.get(NOT_HR_BU_ORG);
        long[] ids = null;
        if ("news".equals(flag)) {
            ids = ORM.create().genLongIds(entityNumber, orgModels.size());
        }
        int index = 0;
        Date date = new Date();
        if (!CollectionUtils.isEmpty(hrBuOrgs)) {
            LOGGER.info("start assembleSupplyStrategy() hrBuOrgs.size():[{}]", (Object)hrBuOrgs.size());
            long timeStart = System.currentTimeMillis();
            for (InitStrategyOrgModel orgModel : hrBuOrgs) {
                DynamicObject strategyObject = this.genHrBuStrategyObject(orgModel, saveModel, date, ids != null ? ids[index++] : 0L, flag);
                if (strategyObject == null) continue;
                this.alreadyStrategy.put(orgModel.getId(), strategyObject);
                saveColl.add((Object)strategyObject);
            }
            LOGGER.info("end assembleSupplyStrategy() hrBuOrgs.size():[{}],cost:{}", (Object)hrBuOrgs.size(), (Object)(System.currentTimeMillis() - timeStart));
        }
        if (!CollectionUtils.isEmpty(notHrBuOrgs)) {
            List sorted = notHrBuOrgs.stream().sorted(Comparator.comparing(InitStrategyOrgModel::getLevel)).collect(Collectors.toList());
            LOGGER.info("start assembleSupplyStrategy() notHrBuOrgs.size() sorted:[{}]", (Object)notHrBuOrgs.size());
            long timeStart = System.currentTimeMillis();
            for (InitStrategyOrgModel orgModel : sorted) {
                DynamicObject strategyObject = this.genNotHrBuStrategyObject(orgModel, saveModel, date, ids != null ? ids[index++] : 0L, flag);
                if (strategyObject == null) continue;
                this.alreadyStrategy.put(orgModel.getId(), strategyObject);
                saveColl.add((Object)strategyObject);
            }
            LOGGER.info("end assembleSupplyStrategy() notHrBuOrgs.size() sorted:[{}],cost:{}", (Object)notHrBuOrgs.size(), (Object)(System.currentTimeMillis() - timeStart));
        }
        return saveColl;
    }

    protected abstract DynamicObject genHrBuStrategyObject(InitStrategyOrgModel var1, InitStrategySaveModel var2, Date var3, long var4, String var6);

    protected abstract DynamicObject genNotHrBuStrategyObject(InitStrategyOrgModel var1, InitStrategySaveModel var2, Date var3, long var4, String var6);

    protected void createEntryDynamicObject(DynamicObject orgStrategy, Set<Long> typeReals, HRBaseServiceHelper strategyHelper, DynamicObject parentStrategy, String flag, Map<Long, List<Long>> businessType2HRBu) {
        int seq = 1;
        DynamicObjectCollection entryColl = "supply".equals(flag) ? orgStrategy.getDynamicObjectCollection("entryentity") : strategyHelper.generateEmptyEntryCollection(orgStrategy, "entryentity");
        Map parentEntryMap = null;
        if (parentStrategy != null) {
            DynamicObjectCollection parentEntry = parentStrategy.getDynamicObjectCollection("entryentity");
            parentEntryMap = parentEntry.stream().collect(Collectors.toMap(entry -> HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)entry, (String)"bussinessfield"), Function.identity()));
        }
        HashSet<String> isAllMatch = new HashSet<String>(2);
        List storedTypeReals = typeReals.stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        for (Long type : storedTypeReals) {
            DynamicObject entry2 = strategyHelper.generateEmptyEntryDynamicObject("entryentity");
            entry2.set("bussinessfield", (Object)type);
            entry2.set("seq", (Object)seq++);
            if (parentEntryMap != null && !parentEntryMap.isEmpty()) {
                DynamicObject parentTypeEntry = (DynamicObject)parentEntryMap.get(type);
                if (parentTypeEntry == null) {
                    LOGGER.error("createEntryDynamicObject() parentTypeEntry is null. orgTeamId:{},parentOrgTeamId:{}", orgStrategy.get("orgteam"), parentStrategy.get("orgteam"));
                } else if (businessType2HRBu.get(type) == null || !businessType2HRBu.get(type).contains(orgStrategy.getLong("orgteam"))) {
                    entry2.set("entryhrbu", parentTypeEntry.get("entryhrbu"));
                    entry2.set("entrysourceorg", parentTypeEntry.get("entrysourceorg"));
                    entry2.set("entryinheritedorg", orgStrategy.get("inheritedorg"));
                    entry2.set("seq", parentTypeEntry.get("seq"));
                    entry2.set("entrydefstrategy", (Object)this.baseStrategys.get(this.fetchSpEntryStrategyKey(type)));
                    isAllMatch.add("1");
                } else {
                    Object hrBuDy = orgStrategy.get("orgteam");
                    entry2.set("entryhrbu", hrBuDy);
                    entry2.set("entrydefstrategy", (Object)this.baseStrategys.get(this.fetchDefEntryStrategyKey(type)));
                    entry2.set("entrysourceorg", hrBuDy);
                    entry2.set("entryinheritedorg", (Object)orgStrategy.getLong("orgteam"));
                    isAllMatch.add("2");
                }
            } else {
                Object hrBuDy = orgStrategy.get("hrbu");
                entry2.set("entryhrbu", hrBuDy);
                entry2.set("entrydefstrategy", (Object)this.baseStrategys.get(this.fetchDefEntryStrategyKey(type)));
                entry2.set("entrysourceorg", hrBuDy);
                entry2.set("entryinheritedorg", (Object)orgStrategy.getLong("orgteam"));
                isAllMatch.add("2");
            }
            entry2.set("entryeffdt", orgStrategy.get("effdt"));
            entry2.set("entryenable", orgStrategy.get("enable"));
            entry2.set("strategyentrytype", (Object)"0");
            entry2.set("entryorgteam", orgStrategy.get("orgteam"));
            entry2.set("sourceentry", orgStrategy.get("id"));
            entryColl.add((Object)entry2);
        }
        if (isAllMatch.size() > 1) {
            orgStrategy.set("defstrategytype", null);
            orgStrategy.set("inheritedorg", null);
        }
    }

    private Set<Long> filterAdminOrgIdParam(List<InitStrategyOrgModel> initOrgModels, Set<Long> complete) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)16);
        initOrgModels.forEach(model -> {
            if (!complete.contains(model.getId())) {
                result.add(model.getId());
                Optional.ofNullable(model.getParent()).ifPresent(parent -> result.add(parent.getLong("id")));
            }
        });
        LOGGER.info("filterAdminOrgIdParam() result.size():{}", (Object)result.size());
        return result;
    }

    private void setBusinessTypeReal() {
        if (CollectionUtils.isEmpty(this.businessTypeTies)) {
            DynamicObject[] allBusinessTypeReals = InitStrategyServiceHelper.getAllBusinessTypeReal(ManageStrategyConstants.LONG_ORGTYPE_ADMINORG, new Long[0]);
            this.businessTypeTies.putAll(Arrays.stream(allBusinessTypeReals).collect(Collectors.groupingBy(dy -> dy.getLong("bussinessobject.id"), Collectors.mapping(dy -> dy.getLong("id"), Collectors.toSet()))));
            LOGGER.info("InitStrategyServiceImpl.setBusinessTypeReal(),businessTypeTies\uff1a{}", this.businessTypeTies);
        }
    }

    private void setStrategyType() {
        if (CollectionUtils.isEmpty(this.baseStrategys)) {
            DynamicObject[] allStrategyTypes = InitStrategyServiceHelper.getAllStrategyType();
            this.baseStrategys.putAll(Arrays.stream(allStrategyTypes).collect(Collectors.groupingBy(this::fetchKey, Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0)))));
        }
    }

    private String fetchKey(DynamicObject dy) {
        return dy.getString("strategytype") + "#" + HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dy, (String)"bussinessfield.id") + "#" + HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)dy, (String)"bussinessfield.bussinessobject");
    }

    protected abstract String fetchDefEntryStrategyKey(Long var1);

    protected abstract String fetchSpEntryStrategyKey(Long var1);

    protected DynamicObject getStrategyObject(String flag, InitStrategySaveModel saveModel, long orgId, Date date, long objId, HRBaseServiceHelper serviceHelper) {
        DynamicObject strategy;
        if ("supply".equals(flag)) {
            strategy = (DynamicObject)saveModel.getExistStrategys().get(orgId);
            this.setSupplyCommonField(strategy, date);
        } else {
            strategy = serviceHelper.generateEmptyDynamicObject();
            strategy.set("id", (Object)objId);
            InitStrategyServiceHelper.setCommonField(strategy, date, ((DynamicObject)saveModel.getAdminOrgDetails().get(orgId)).get("enable"));
        }
        return strategy;
    }

    protected void setSupplyCommonField(DynamicObject dynamicObject, Date date) {
        dynamicObject.set("modifytime", (Object)date);
        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
    }
}

