/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class CheckUserRoleSynTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(CheckUserRoleSynTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long start = System.currentTimeMillis();
        LOGGER.info("CheckUserRoleSynTask_execute start..");
        if (requestContext.getOrgId() != 0L) {
            LOGGER.info("CheckUserRoleSynTask_execute requestContext.getOrgId() != 0,execute updateSysUserRoleSource.");
            this.updateSysUserRoleSource();
            return;
        }
        HRBaseServiceHelper sysUserRoleHelper = new HRBaseServiceHelper("perm_userrole");
        DataSet sysUserRoleDs = sysUserRoleHelper.queryDataSet("CheckUserRoleSynTask_executeQuerySysUserRole", "id", new QFilter[]{new QFilter("source", "=", (Object)"hr")});
        ArrayList sysIds = Lists.newArrayListWithExpectedSize((int)16);
        while (sysUserRoleDs.hasNext()) {
            Row row = sysUserRoleDs.next();
            sysIds.add(row.getString("id"));
        }
        HRBaseServiceHelper hmpUserRoleHelper = new HRBaseServiceHelper("hrcs_userrole");
        DataSet hmpUserRoleDs = hmpUserRoleHelper.queryDataSet("CheckUserRoleSynTask_executeQueryHmpUserRole", "userrolepf.id", new QFilter[0]);
        ArrayList hmpIds = Lists.newArrayListWithExpectedSize((int)16);
        while (hmpUserRoleDs.hasNext()) {
            Row row = hmpUserRoleDs.next();
            hmpIds.add(row.getString("userrolepf.id"));
        }
        List onlyInSysIds = (List)CollectionUtils.subtract((Iterable)sysIds, (Iterable)hmpIds);
        List onlyInHmpIds = (List)CollectionUtils.subtract((Iterable)hmpIds, (Iterable)sysIds);
        int onlyInSysIdSize = onlyInSysIds.size();
        int onlyInHmpIdSize = onlyInHmpIds.size();
        if (onlyInSysIdSize == 0 && onlyInHmpIdSize == 0) {
            LOGGER.info("CheckUserRoleSynTask_execute success. the data in sys and hmp is complete same.", (Object)(System.currentTimeMillis() - start));
            return;
        }
        LOGGER.info("CheckUserRoleSynTask_execute resulst,onlyInSysIds:{}", (Object)onlyInSysIds);
        String onlyInHmpIdStr = onlyInHmpIds.stream().map(it -> "'" + it + "'").collect(Collectors.joining(","));
        LOGGER.info("CheckUserRoleSynTask_execute resulst,onlyInHmpIds:{}", (Object)onlyInHmpIdStr);
        if (onlyInSysIdSize > 100) {
            onlyInSysIds = onlyInSysIds.subList(0, 100);
        }
        if (onlyInHmpIdSize > 100) {
            onlyInHmpIds = onlyInHmpIds.subList(0, 100);
        }
        HRBaseServiceHelper userRoleSynHelper = new HRBaseServiceHelper("hrcs_checkuserrolesyn");
        DynamicObject userRoleSynDyna = userRoleSynHelper.generateEmptyDynamicObject();
        userRoleSynDyna.set("onlyinsyssize", (Object)onlyInSysIdSize);
        userRoleSynDyna.set("onlyinhmpsize", (Object)onlyInHmpIdSize);
        if (onlyInSysIdSize > 0) {
            DynamicObjectCollection onlyInSysEntryCollection = userRoleSynDyna.getDynamicObjectCollection("onlyinsysentry");
            DynamicObjectCollection sysUserRoleDynaColl = sysUserRoleHelper.queryOriginalCollection("id,user.id,role.id,org.id,includesuborg", new QFilter[]{new QFilter("id", "in", onlyInSysIds)});
            for (DynamicObject onlyInSysDyna : sysUserRoleDynaColl) {
                DynamicObject row = onlyInSysEntryCollection.addNew();
                row.set("sysid", (Object)onlyInSysDyna.getString("id"));
                row.set("sys_role", (Object)onlyInSysDyna.getString("role.id"));
                row.set("sys_user", (Object)onlyInSysDyna.getLong("user.id"));
                row.set("sys_org", (Object)onlyInSysDyna.getLong("org.id"));
                row.set("sys_isincludesuborg", (Object)onlyInSysDyna.getBoolean("includesuborg"));
            }
        }
        if (onlyInHmpIdSize > 0) {
            DynamicObjectCollection onlyInHmpEntryColl = userRoleSynDyna.getDynamicObjectCollection("onlyinhmpentry");
            DynamicObjectCollection hmpUserRoleDynaColl = hmpUserRoleHelper.queryOriginalCollection("id,org.id,includesuborg,userrolerealt.id,userrolepf.id,bucafunc", new QFilter[]{new QFilter("userrolepf.id", "in", onlyInHmpIds)});
            Set relatIds = hmpUserRoleDynaColl.stream().map(dyna -> dyna.getLong("userrolerealt.id")).collect(Collectors.toSet());
            HRBaseServiceHelper relatHelper = new HRBaseServiceHelper("hrcs_userrolerelat");
            DynamicObjectCollection relatDynaColl = relatHelper.queryOriginalCollection("id,user.id,role.id,customenable,creator.id,createtime", new QFilter[]{new QFilter("id", "in", relatIds)});
            HashMap relatDynaMap = Maps.newHashMapWithExpectedSize((int)16);
            for (DynamicObject relatDyna : relatDynaColl) {
                relatDynaMap.put(relatDyna.getLong("id"), relatDyna);
            }
            for (DynamicObject onlyInHmpDyna : hmpUserRoleDynaColl) {
                DynamicObject row = onlyInHmpEntryColl.addNew();
                row.set("hmpid", (Object)onlyInHmpDyna.getLong("id"));
                row.set("hmp_sysid", (Object)onlyInHmpDyna.getString("userrolepf.id"));
                row.set("hmp_bucafunc", (Object)onlyInHmpDyna.getLong("bucafunc"));
                row.set("hmp_org", (Object)onlyInHmpDyna.getLong("org.id"));
                row.set("hmp_isincludesuborg", (Object)onlyInHmpDyna.getBoolean("includesuborg"));
                Long relatId = onlyInHmpDyna.getLong("userrolerealt.id");
                row.set("hmp_relatid", (Object)relatId);
                DynamicObject relatDyna = (DynamicObject)relatDynaMap.get(relatId);
                if (Objects.isNull(relatDyna)) continue;
                row.set("hmp_role", (Object)relatDyna.getString("role.id"));
                row.set("hmp_user", (Object)relatDyna.getLong("user.id"));
                row.set("hmp_customenable", (Object)relatDyna.getString("customenable"));
                row.set("hmp_creator", (Object)relatDyna.getLong("creator.id"));
                row.set("hmp_createdate", (Object)relatDyna.getDate("createtime"));
            }
        }
        userRoleSynHelper.saveOne(userRoleSynDyna);
        LOGGER.info("CheckUserRoleSynTask_execute end...cost_mills:{}", (Object)(System.currentTimeMillis() - start));
        this.stop();
    }

    private void updateSysUserRoleSource() {
        try (TXHandle txHandle = TX.required();){
            String algoKey = ((Object)((Object)this)).getClass().getName() + ".updateSysUserRoleSource";
            String querySql = "select fuserrolepfid from t_hbss_userrole";
            DataSet userRolePfIdDs = DB.queryDataSet((String)algoKey, (DBRoute)new DBRoute("hmp"), (String)querySql);
            HashSet pfIds = Sets.newHashSetWithExpectedSize((int)16);
            int batchIndex = 0;
            long totalSize = 0L;
            while (userRolePfIdDs.hasNext()) {
                Row row = userRolePfIdDs.next();
                pfIds.add(row.getString("fuserrolepfid"));
                ++totalSize;
                if (++batchIndex < 2000) continue;
                String pfIdStr = pfIds.stream().map(it -> "'" + it + "'").collect(Collectors.joining(","));
                String sql = "update t_perm_userrole set fsource='hr'  where fid in (" + pfIdStr + ") ";
                DB.execute((DBRoute)new DBRoute("sys"), (String)sql);
                batchIndex = 0;
                pfIds.clear();
            }
            if (pfIds.size() > 0) {
                String pfIdStr = pfIds.stream().map(it -> "'" + it + "'").collect(Collectors.joining(","));
                String sql = "update t_perm_userrole set fsource='hr'  where fid in (" + pfIdStr + ") ";
                DB.execute((DBRoute)new DBRoute("sys"), (String)sql);
            }
            userRolePfIdDs.close();
            LOGGER.info("CheckUserRoleSynTask.updateSysUserRoleSource success. total rows:{}", (Object)totalSize);
        }
    }
}

