/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.task;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.BroadcastTask;
import kd.bos.schedule.api.ShardingUtil;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hrcs.bussiness.service.label.LabelTaskService;
import kd.hr.hrcs.bussiness.servicehelper.label.LabelPolicyServiceHelper;

public class LabelGeneData
extends AbstractTask
implements BroadcastTask {
    private static final Log LOGGER = LogFactory.getLog(LabelGeneData.class);
    private final LabelPolicyServiceHelper labelPolicyServiceHelper = new LabelPolicyServiceHelper();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] policyTaskList = this.labelPolicyServiceHelper.listPolicyTask();
        if (policyTaskList == null || policyTaskList.length == 0) {
            return;
        }
        for (DynamicObject policyTask : policyTaskList) {
            long policyId = policyTask.getLong("labelpolicy.id");
            String taskNumber = policyTask.getString("number");
            try {
                LabelTaskService iLabelTaskService = new LabelTaskService(policyId, taskNumber);
                LOGGER.info("start generate label --> policy:{},taskNumber:{}", (Object)policyId, (Object)taskNumber);
                iLabelTaskService.execute();
            }
            catch (Exception e) {
                LOGGER.error("start generate label error  --> policy:{},taskNumber:{},error:{}", new Object[]{policyId, taskNumber, e.getMessage()});
            }
        }
    }

    public void execute(RequestContext requestContext, Map<String, Object> map, ShardingUtil.BroadcastVO broadcastVO) throws KDException {
        if (broadcastVO == null) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"labelGeneData_broadcast task parameter broadcastVO is null."});
        }
        String broadcastVOStr = String.format("total:%d,index:%d", broadcastVO.getTotal(), broadcastVO.getIndex());
        LOGGER.info("labelGeneData_broadcast task start.broadcastVO:{}", (Object)broadcastVOStr);
        DynamicObject[] policyTaskList = this.labelPolicyServiceHelper.listPolicyTask();
        LOGGER.info("labelGeneData_broadcast task number is {}. broadcastVO:{}", (Object)policyTaskList.length, (Object)broadcastVOStr);
        if (policyTaskList == null || policyTaskList.length == 0) {
            return;
        }
        for (DynamicObject policyTask : policyTaskList) {
            long policyId = policyTask.getLong("labelpolicy.id");
            String taskNumber = policyTask.getString("number");
            try {
                LabelTaskService iLabelTaskService = new LabelTaskService(policyId, taskNumber);
                LOGGER.info("labelGeneData_broadcast task start --> broadcastVO:{},policy:{},taskNumber:{},", new Object[]{broadcastVOStr, policyId, taskNumber});
                iLabelTaskService.execute();
            }
            catch (Exception ex) {
                LOGGER.error(String.format("labelGeneData_broadcast task error --> broadcastVO:%s,policy:%d,taskNumber:%s.", broadcastVOStr, policyId, taskNumber), (Throwable)ex);
            }
        }
        LOGGER.info("labelGeneData_broadcast task end.broadcastVO:{}", (Object)broadcastVOStr);
    }
}

