/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.task;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.label.LabelPolicyServiceHelper;

public class LabelGeneMarkTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(LabelGeneMarkTask.class);
    private final long currUserId = RequestContext.get().getCurrUserId();
    private final LabelPolicyServiceHelper labelPolicyServiceHelper = new LabelPolicyServiceHelper();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] allPolicy = this.getAllPolicy();
        if (allPolicy == null || allPolicy.length == 0) {
            return;
        }
        this.geneTaskAndUpdateNextTime(allPolicy);
    }

    private void geneTaskAndUpdateNextTime(DynamicObject[] allPolicy) {
        DynamicObjectCollection taskCollection = new DynamicObjectCollection();
        for (DynamicObject policy : allPolicy) {
            if (this.checkNextTaskTime(policy) && !this.checkHaveUndoTask(policy.getLong("id"))) {
                taskCollection.add((Object)this.geneTask(policy));
            }
            this.updateNextTime(policy);
        }
        this.labelPolicyServiceHelper.updatePolicy(allPolicy);
        if (!taskCollection.isEmpty()) {
            this.labelPolicyServiceHelper.savePolicyTask(taskCollection);
        }
    }

    private boolean checkNextTaskTime(DynamicObject policy) {
        if (policy.getDate("nexttasktime") == null) {
            return true;
        }
        return HRDateTimeUtils.dayAfter((Date)new Date(), (Date)policy.getDate("nexttasktime"));
    }

    private boolean checkHaveUndoTask(long policyId) {
        DynamicObject[] dynamicObjects = this.labelPolicyServiceHelper.listUndoPolicyTaskByPolicyId(policyId);
        return dynamicObjects != null && dynamicObjects.length != 0;
    }

    private DynamicObject geneTask(DynamicObject policy) {
        DynamicObject dynamicObject = this.labelPolicyServiceHelper.geneEmptyPolicyTaskDy();
        dynamicObject.set("number", (Object)LabelPolicyServiceHelper.geneTaskNumber());
        dynamicObject.set("labelpolicy", (Object)policy.getLong("id"));
        dynamicObject.set("creator", (Object)this.currUserId);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("modifier", (Object)this.currUserId);
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("taskstatus", (Object)"0");
        return dynamicObject;
    }

    private void updateNextTime(DynamicObject policy) {
        Date nextTime = this.transFrequencyToNextTaskTime(policy);
        if (nextTime != null) {
            policy.set("nexttasktime", (Object)nextTime);
        }
    }

    private Date transFrequencyToNextTaskTime(DynamicObject policy) {
        String frequency = policy.getString("frequency");
        if (HRStringUtils.isEmpty((String)frequency)) {
            return null;
        }
        if ("0".equals(frequency)) {
            Date nextTaskTime = policy.getDate("nexttasktime");
            Calendar calendar = Calendar.getInstance();
            if (nextTaskTime != null) {
                calendar.setTime(nextTaskTime);
            }
            calendar.set(1, 2999);
            return calendar.getTime();
        }
        if ("1".equals(frequency)) {
            Date nowDate = new Date();
            Date date = HRDateTimeUtils.addDay((Date)nowDate, (long)1L);
            return DateUtils.stringToDate((String)(DateUtils.dateToString((Date)date, (DatePattern)DatePattern.YYYY_MM_DD) + " 00:00:00"), (DatePattern)DatePattern.YYYY_MM_DD_HH_MM_SS);
        }
        if (frequency.length() == 3 && "2_".equals(frequency.substring(0, 2))) {
            int week = Integer.parseInt(frequency.substring(2, 3));
            Calendar calendar = Calendar.getInstance();
            calendar.add(7, 1);
            calendar.set(7, week == 6 ? 1 : week + 2);
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 1);
            Date nextTime = calendar.getTime();
            if (HRDateTimeUtils.dayAfter((Date)new Date(), (Date)nextTime)) {
                Calendar calendarMonth = Calendar.getInstance();
                calendarMonth.add(4, 1);
                calendarMonth.set(7, week == 6 ? 1 : week + 2);
                calendarMonth.set(11, 0);
                calendarMonth.set(12, 0);
                calendarMonth.set(13, 1);
                return calendarMonth.getTime();
            }
            return nextTime;
        }
        if (frequency.length() >= 3 && "3_".equals(frequency.substring(0, 2))) {
            int day = Integer.parseInt(frequency.substring(2));
            Calendar calendar = Calendar.getInstance();
            Date nowDate = new Date();
            calendar.setTime(nowDate);
            int monthDay = calendar.get(5);
            if (day > monthDay) {
                calendar.set(5, Math.min(LabelGeneMarkTask.getMoneyDay(), day));
            } else {
                calendar.add(2, 1);
                calendar.set(5, day);
            }
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 1);
            return calendar.getTime();
        }
        return null;
    }

    public static int getMoneyDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.roll(5, -1);
        return calendar.get(5);
    }

    private DynamicObject[] getAllPolicy() {
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter startTimeFilter = new QFilter("startdate", "<=", (Object)new Date());
        QFilter endTimeFilter = new QFilter("enddate", ">=", (Object)new Date());
        QFilter[] qFilters = new QFilter[]{statusFilter, enableFilter, endTimeFilter, startTimeFilter};
        return this.labelPolicyServiceHelper.listPolicy(qFilters);
    }
}

