/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.common.enums.DataSubjectIdTypeEnum;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hrcs.bussiness.service.PrivacyServiceHelper;
import kd.hr.hrcs.common.constants.PrivacyConstants;
import kd.hr.hrcs.common.constants.perm.HRPermCommonUtil;

public class RetainedDuePersonTask
extends AbstractTask
implements PrivacyConstants {
    private static final Log LOGGER = LogFactory.getLog(RetainedDuePersonTask.class);
    private static final String FIELD_BUSINESS_OBJECT = "businessobject";
    private static final String FIELD_RETENTION_START_DATE = "startdatefield";
    private static final String FIELD_TYPE_CONDITION = "condition";
    private static final String FIELD_RETENTION_PERIOD = "retentionperiod";
    private static final String ENTITY_RETAINED_DUE_PERSON = "hrcs_retaineddueperson";
    private static HashMap<String, String> dataSubjectIdTypeMap = Maps.newHashMapWithExpectedSize((int)8);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Boolean isOpenPrivacySwitch;
        Map paramsMap;
        long orgId = OrgUnitServiceHelper.getRootOrgId();
        if (requestContext != null && requestContext.getOrgId() != 0L) {
            orgId = requestContext.getOrgId();
        }
        if (!((paramsMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)new AppParam("15NPDX/GJFOO", Long.valueOf(orgId)))) == null || (isOpenPrivacySwitch = (Boolean)paramsMap.get("privacydataswitch")) != null && isOpenPrivacySwitch.booleanValue())) {
            LOGGER.warn("privacy_data_switch_is_not_opened");
            return;
        }
        if (null == map || null == map.get("dataRoleNumber")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u8c03\u5ea6\u53c2\u6570\u201cdataRoleNumber\u201d\uff0c\u5bf9\u5e94\u7684\u503c\u4e3a\u9690\u79c1\u5bf9\u8c61\u89d2\u8272\u7f16\u7801\u3002", (String)"RetainedDuePersonTask_0", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
        }
        LOGGER.info("RetainedDuePersonTask_is_started");
        String dataRoleNumber = map.get("dataRoleNumber").toString();
        LOGGER.info("\u5f00\u59cb\u6267\u884c{}\u7684\u9690\u79c1\u7559\u5b58\u8c03\u5ea6\u4efb\u52a1\uff01", (Object)dataRoleNumber);
        DynamicObject privacyObjectDy = PrivacyServiceHelper.getPrivacyObjectRole(dataRoleNumber);
        if (null == privacyObjectDy) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230%s\u5bf9\u5e94\u7684\u9690\u79c1\u5bf9\u8c61\u89d2\u8272\u3002", (String)"RetainedDuePersonTask_1", (String)"hrmp-hrcs-business", (Object[])new Object[]{dataRoleNumber}));
        }
        DynamicObject[] retentionPeriodColls = PrivacyServiceHelper.getRetentionPeriod(dataRoleNumber);
        DynamicObjectCollection retainedColls = this.getRetainedDuePoolData(privacyObjectDy, retentionPeriodColls);
        PrivacyServiceHelper.saveRetainedDuePerson(retainedColls);
        LOGGER.info("{}\u7684\u9690\u79c1\u7559\u5b58\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u7ed3\u675f\uff01\u5171\u65b0\u589e{}\u6761\u6570\u636e\uff01", (Object)dataRoleNumber, (Object)retainedColls.size());
    }

    private DynamicObjectCollection getRetainedDuePoolData(DynamicObject privacyObjectDy, DynamicObject[] retentionPeriodColls) {
        DynamicObject businessObjectDy = privacyObjectDy.getDynamicObject(FIELD_BUSINESS_OBJECT);
        String entityNumber = businessObjectDy.getString("number");
        String startDateField = privacyObjectDy.getString(FIELD_RETENTION_START_DATE);
        long roleId = privacyObjectDy.getLong("id");
        String dataSubjectType = dataSubjectIdTypeMap.get(entityNumber);
        int beforeDays = privacyObjectDy.getInt("beforedays");
        LinkedHashMap roleSort2ConditionMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        DynamicObjectCollection entryEntity = privacyObjectDy.getDynamicObjectCollection("entryentity");
        if (null != entryEntity && !entryEntity.isEmpty()) {
            for (DynamicObject dy : entryEntity) {
                roleSort2ConditionMap.put(dy.getLong("id"), dy.getString(FIELD_TYPE_CONDITION));
            }
        }
        Map<Long, Date> beforeDateMap = this.getRoleSort2PoolDateMap(beforeDays, retentionPeriodColls);
        LinkedHashMap roleSort2DataSubjectMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        QFilter filter = new QFilter(startDateField, "is not null", null);
        int dataSubjectCount = 0;
        for (Map.Entry entry : roleSort2ConditionMap.entrySet()) {
            QFilter[] qFilters;
            DynamicObjectCollection dynamicObjectCollection;
            QFilter[] qFilterArray;
            QFilter beforeDateFilter = new QFilter(startDateField, "<=", (Object)beforeDateMap.get(entry.getKey()));
            QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            if (StringUtils.isEmpty((CharSequence)((CharSequence)entry.getValue()))) {
                QFilter[] qFilterArray2 = new QFilter[3];
                qFilterArray2[0] = filter;
                qFilterArray2[1] = beforeDateFilter;
                qFilterArray = qFilterArray2;
                qFilterArray2[2] = isCurrentVersionFilter;
            } else {
                QFilter[] qFilterArray3 = new QFilter[4];
                qFilterArray3[0] = HRPermCommonUtil.getQFilterFromFilterCondition((String)entityNumber, (String)((String)entry.getValue()));
                qFilterArray3[1] = filter;
                qFilterArray3[2] = beforeDateFilter;
                qFilterArray = qFilterArray3;
                qFilterArray3[3] = isCurrentVersionFilter;
            }
            if (null == (dynamicObjectCollection = PrivacyServiceHelper.queryDataSubject(entityNumber, startDateField, qFilters = qFilterArray)) || dynamicObjectCollection.isEmpty()) continue;
            ArrayList dataSubjectList = Lists.newArrayListWithExpectedSize((int)dynamicObjectCollection.size());
            for (DynamicObject dy : dynamicObjectCollection) {
                HashMap map = Maps.newHashMapWithExpectedSize((int)4);
                if (entityNumber.equals("hrpi_employee")) {
                    map.put("dataSubjectId", dy.getString("person"));
                } else {
                    map.put("dataSubjectId", dy.getString("id"));
                }
                map.put(FIELD_RETENTION_START_DATE, dy.getDate(startDateField));
                dataSubjectList.add(map);
            }
            roleSort2DataSubjectMap.put(entry.getKey(), dataSubjectList);
            dataSubjectCount += dataSubjectList.size();
        }
        LinkedHashMap roleSort2RetentionPeriodMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        for (DynamicObject retentionPeriodDy : retentionPeriodColls) {
            DynamicObjectCollection dynamicObjectCollection = retentionPeriodDy.getDynamicObjectCollection("entryentity");
            if (null == dynamicObjectCollection || dynamicObjectCollection.isEmpty()) continue;
            for (DynamicObject dy : dynamicObjectCollection) {
                DynamicObjectCollection bizAppColls = retentionPeriodDy.getDynamicObjectCollection("bizappid");
                if (null == bizAppColls || bizAppColls.isEmpty()) continue;
                int retentionPeriod = dy.getInt(FIELD_RETENTION_PERIOD);
                long roleSortId = dy.getLong("rolesort.id");
                List retentionPeriodList = roleSort2RetentionPeriodMap.getOrDefault(roleSortId, Lists.newArrayListWithExpectedSize((int)16));
                for (DynamicObject bizAppDy : bizAppColls) {
                    HashMap map = Maps.newHashMapWithExpectedSize((int)4);
                    map.put("bizAppId", bizAppDy.getString("fbasedataid_id"));
                    map.put(FIELD_RETENTION_PERIOD, retentionPeriod);
                    retentionPeriodList.add(map);
                }
                roleSort2RetentionPeriodMap.put(roleSortId, retentionPeriodList);
            }
        }
        LOGGER.info("\u89d2\u8272\u5206\u7c7b\u4e0b\u7684\u5e94\u7528\u7559\u5b58\u671f\uff1a", (Object)((Object)roleSort2RetentionPeriodMap).toString());
        List<String> list = PrivacyServiceHelper.getRetainedDuePersonKeys();
        Date today = new Date();
        HashMap retainedInfoMap = Maps.newHashMapWithExpectedSize((int)dataSubjectCount);
        for (Map.Entry entry : roleSort2RetentionPeriodMap.entrySet()) {
            Long roleSortId = (Long)entry.getKey();
            List dataSubjectList = (List)roleSort2DataSubjectMap.get(roleSortId);
            if (null == dataSubjectList) continue;
            for (Map retentionPeriodMap : (List)entry.getValue()) {
                String bizAppId = (String)retentionPeriodMap.get("bizAppId");
                int retentionPeriod = (Integer)retentionPeriodMap.get(FIELD_RETENTION_PERIOD);
                for (Map dataSubjectMap : dataSubjectList) {
                    Date startDate;
                    String dataSubjectId = (String)dataSubjectMap.get("dataSubjectId");
                    String key = this.getKey(bizAppId, dataSubjectId);
                    if (list.contains(key) || !this.addDuration(startDate = (Date)dataSubjectMap.get(FIELD_RETENTION_START_DATE), retentionPeriod, -beforeDays).before(today) || retainedInfoMap.containsKey(key) && (!retainedInfoMap.containsKey(key) || ((RetainedInfo)retainedInfoMap.get(key)).getRetentionPeriod() <= retentionPeriod)) continue;
                    RetainedInfo retainedInfo = new RetainedInfo();
                    retainedInfo.setDataSubjectId(dataSubjectId);
                    retainedInfo.setDataSubjectType(dataSubjectType);
                    retainedInfo.setRoleId(roleId);
                    retainedInfo.setRoleSortId(roleSortId);
                    retainedInfo.setBizAppId(bizAppId);
                    retainedInfo.setStartDate(startDate);
                    retainedInfo.setRetentionPeriod(retentionPeriod);
                    retainedInfo.setBeforedays(beforeDays);
                    retainedInfo.setPlanExecDate(HRDateTimeUtils.addMonth((Date)startDate, (int)retentionPeriod));
                    retainedInfo.setExecStatus("A");
                    retainedInfoMap.put(key, retainedInfo);
                }
            }
        }
        Collection valueCollection = retainedInfoMap.values();
        return this.formatData(new ArrayList<RetainedInfo>(valueCollection));
    }

    private String getKey(String bizAppId, String dataSubjectId) {
        return String.format(Locale.ROOT, "%s_%s", bizAppId, dataSubjectId);
    }

    private DynamicObjectCollection formatData(List<RetainedInfo> retainedInfoList) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        for (RetainedInfo retainedInfo : retainedInfoList) {
            DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_RETAINED_DUE_PERSON);
            dy.set("datasubjectid", (Object)retainedInfo.getDataSubjectId());
            dy.set("datasubjecttype", (Object)retainedInfo.getDataSubjectType());
            dy.set("roleid", (Object)retainedInfo.getRoleId());
            dy.set("rolesortid", (Object)retainedInfo.getRoleSortId());
            dy.set("bizappid", (Object)retainedInfo.getBizAppId());
            dy.set("planexecdate", (Object)retainedInfo.getPlanExecDate());
            dy.set("actualexecdate", (Object)retainedInfo.getActualExecDate());
            dy.set("execstatus", (Object)retainedInfo.getExecStatus());
            dynamicObjectCollection.add((Object)dy);
        }
        return dynamicObjectCollection;
    }

    private Map<Long, Date> getRoleSort2PoolDateMap(Integer beforeDays, DynamicObject[] retentionPeriodColls) {
        Date today = new Date();
        HashMap retainedDataMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject retentionPeriodDy : retentionPeriodColls) {
            DynamicObjectCollection retainedDueEntry = retentionPeriodDy.getDynamicObjectCollection("entryentity");
            if (null == retainedDueEntry || retainedDueEntry.isEmpty()) continue;
            for (DynamicObject dy : retainedDueEntry) {
                Date retainedDue = this.addDuration(today, -dy.getInt(FIELD_RETENTION_PERIOD), beforeDays);
                Date poolDate = (Date)retainedDataMap.get(dy.getLong("rolesort.id"));
                if (null != poolDate && !retainedDue.after(poolDate)) continue;
                retainedDataMap.put(dy.getLong("rolesort.id"), retainedDue);
            }
        }
        return retainedDataMap;
    }

    private Date addDuration(Date dDate, int iNbMonth, int iNbDay) {
        Date result = dDate;
        result = HRDateTimeUtils.addMonth((Date)result, (int)iNbMonth);
        result = HRDateTimeUtils.addDay((Date)result, (long)iNbDay);
        return result;
    }

    static {
        dataSubjectIdTypeMap.put("hrpi_employee", DataSubjectIdTypeEnum.PERSONID.getName());
        dataSubjectIdTypeMap.put("hcf_candidate", DataSubjectIdTypeEnum.CANDIDATEID.getName());
        dataSubjectIdTypeMap.put("tstpm_rsm", DataSubjectIdTypeEnum.RESUMEID.getName());
    }

    static class RetainedInfo {
        private String dataSubjectId;
        private String dataSubjectType;
        private long roleId;
        private long roleSortId;
        private String bizAppId;
        private Date planExecDate;
        private Date actualExecDate;
        private String execStatus;
        private Date startDate;
        private int retentionPeriod;
        private int beforedays;

        RetainedInfo() {
        }

        public String getDataSubjectId() {
            return this.dataSubjectId;
        }

        public void setDataSubjectId(String dataSubjectId) {
            this.dataSubjectId = dataSubjectId;
        }

        public String getDataSubjectType() {
            return this.dataSubjectType;
        }

        public void setDataSubjectType(String dataSubjectType) {
            this.dataSubjectType = dataSubjectType;
        }

        public long getRoleId() {
            return this.roleId;
        }

        public void setRoleId(long roleId) {
            this.roleId = roleId;
        }

        public long getRoleSortId() {
            return this.roleSortId;
        }

        public void setRoleSortId(long roleSortId) {
            this.roleSortId = roleSortId;
        }

        public String getBizAppId() {
            return this.bizAppId;
        }

        public void setBizAppId(String bizAppId) {
            this.bizAppId = bizAppId;
        }

        public Date getPlanExecDate() {
            return this.planExecDate;
        }

        public void setPlanExecDate(Date planExecDate) {
            this.planExecDate = planExecDate;
        }

        public Date getActualExecDate() {
            return this.actualExecDate;
        }

        public void setActualExecDate(Date actualExecDate) {
            this.actualExecDate = actualExecDate;
        }

        public String getExecStatus() {
            return this.execStatus;
        }

        public void setExecStatus(String execStatus) {
            this.execStatus = execStatus;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public void setStartDate(Date startDate) {
            this.startDate = startDate;
        }

        public int getRetentionPeriod() {
            return this.retentionPeriod;
        }

        public void setRetentionPeriod(int retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        public int getBeforedays() {
            return this.beforedays;
        }

        public void setBeforedays(int beforedays) {
            this.beforedays = beforedays;
        }
    }
}

