/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class SyncPermFileUserInfoTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(SyncPermFileUserInfoTask.class);
    private final int BATCH_SIZE = 10000;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long start = System.currentTimeMillis();
        LOGGER.info("SyncPermFileUserInfoTask_execute start..");
        int permfileSize = ORM.create().count("algoKey_SyncPermFileUserInfoTask_countPermFile", "hrcs_userpermfile", null);
        LOGGER.info("SyncPermFileUserInfoTask_execute permfile size:{}", (Object)permfileSize);
        for (int idx = 0; idx < permfileSize; idx += 10000) {
            try (DataSet dataSet = ORM.create().queryDataSet("algoKey_SyncPermFileUserInfoTask_queryPermFile_" + idx, "hrcs_userpermfile", "id,user.id,username", null, "id desc", idx, 10000);){
                DynamicObject[] needUpdateDynas;
                HashSet userIds = Sets.newHashSetWithExpectedSize((int)10000);
                ArrayList permfileMaps = Lists.newArrayListWithExpectedSize((int)10000);
                while (dataSet.hasNext()) {
                    HashMap permfileMap = Maps.newHashMapWithExpectedSize((int)3);
                    Row row = dataSet.next();
                    permfileMap.put("id", row.getLong("id"));
                    long userId = row.getLong("user.id");
                    userIds.add(userId);
                    permfileMap.put("userId", userId);
                    permfileMap.put("username", row.getString("username"));
                    permfileMaps.add(permfileMap);
                }
                DynamicObjectCollection userDynaColl = QueryServiceHelper.query((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)userIds)});
                Map<Long, String> userNameMap = userDynaColl.stream().collect(Collectors.toMap(userDyna -> userDyna.getLong("id"), userDyna -> userDyna.getString("name")));
                HRBaseServiceHelper permfileHelper = new HRBaseServiceHelper("hrcs_userpermfile");
                HashMap needUpdateMap = Maps.newHashMapWithExpectedSize((int)16);
                for (Map permfileMap : permfileMaps) {
                    Long userId = (Long)permfileMap.get("userId");
                    String permfileName = (String)permfileMap.get("username");
                    String bosUserName = userNameMap.get(userId);
                    if (!HRStringUtils.isNotEmpty((String)bosUserName) || HRStringUtils.equals((String)permfileName, (String)bosUserName)) continue;
                    needUpdateMap.put((Long)permfileMap.get("id"), bosUserName);
                }
                if (needUpdateMap.size() <= 0) continue;
                LOGGER.info("SyncPermFileUserInfoTask_execute batch:{} need to update,size:{},detail info:{}", new Object[]{idx, needUpdateMap.size(), needUpdateMap});
                for (DynamicObject needUpdateDyna : needUpdateDynas = permfileHelper.query("id,username", new QFilter[]{new QFilter("id", "in", needUpdateMap.keySet())})) {
                    OrmLocaleValue ormLocaleValue = (OrmLocaleValue)needUpdateDyna.get("username");
                    ormLocaleValue.setLocaleValue((String)needUpdateMap.get(needUpdateDyna.get("id")));
                    needUpdateDyna.set("username", (Object)ormLocaleValue);
                }
                SaveServiceHelper.update((DynamicObject[])needUpdateDynas);
                continue;
            }
            catch (Exception ex) {
                LOGGER.error("SyncPermFileUserInfoTask_execute deal error.", (Throwable)ex);
            }
        }
        LOGGER.info("SyncPermFileUserInfoTask_execute end...cost_mills:{}", (Object)(System.currentTimeMillis() - start));
    }
}

