/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.util;

import com.google.common.collect.Maps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.hr.ruleengine.enums.ParamTypeEnum;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;

public class ExpressionUtil {
    private static final Set<Character> SPECIAL_CHARS = Stream.of(Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('%'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('\"'), Character.valueOf(','), Character.valueOf(' '), Character.valueOf('='), Character.valueOf('>'), Character.valueOf('<'), Character.valueOf('!')).collect(Collectors.toSet());
    private static final Set<String> SPECIAL_STRINGS = Stream.of("true", "false", "null").collect(Collectors.toSet());
    private static final Set<Character> DIGIT_CHARS = Stream.of(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('.')).collect(Collectors.toSet());
    private static final char PARAM_SPLIT = '$';

    private ExpressionUtil() {
    }

    public static Map<String, Object> preCompileExpression(String expression, Map<String, String> paramTypeMap) {
        HashMap defaultParams = Maps.newHashMapWithExpectedSize((int)16);
        paramTypeMap.forEach((number, type) -> defaultParams.put(number, ExpressionUtil.getDefaultValue(type)));
        return (Map)HRMServiceHelper.invokeHRMPService((String)"bree", (String)"IBREEFunctionExecuteService", (String)"executeExpression", (Object[])new Object[]{expression, defaultParams});
    }

    public static String validateExpression(String expression) {
        expression = expression.replaceAll("\\s+", "");
        boolean bucketRight = true;
        if (expression.indexOf(36) >= 0) {
            return ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u9519\u8bef\uff0c\u7981\u6b62\u4f7f\u7528\u7cfb\u7edf\u9884\u7f6e\u7b26\u53f7\u201c$\u201d\u3002", (String)"TargetExpressionUtil_0", (String)"hrmp-brm-business", (Object[])new Object[0]);
        }
        ArrayDeque<Character> bucketStack = new ArrayDeque<Character>();
        int n = expression.length();
        for (int i = 0; i < n; ++i) {
            char item = expression.charAt(i);
            if ('(' == item) {
                bucketStack.push(Character.valueOf('('));
                continue;
            }
            if (')' != item) continue;
            if (bucketStack.size() > 0) {
                bucketStack.pop();
                continue;
            }
            bucketRight = false;
            break;
        }
        if (0 != bucketStack.size()) {
            bucketRight = false;
        }
        if (!bucketRight) {
            return ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u9519\u8bef\uff0c\u62ec\u53f7\u6570\u91cf\u6216\u987a\u5e8f\u4e0d\u5339\u914d\u3002", (String)"TargetExpressionUtil_1", (String)"hrmp-brm-business", (Object[])new Object[0]);
        }
        if (Pattern.matches(".*[+\\-*/%.]{2,}.*", expression)) {
            return ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u9519\u8bef\uff0c\u8fde\u7eed\u7684\u8fd0\u7b97\u7b26\u3002", (String)"TargetExpressionUtil_2", (String)"hrmp-brm-business", (Object[])new Object[0]);
        }
        if (Pattern.matches("[+*/%].+", expression)) {
            return ExpressionUtil.getSymbolErrorMsg();
        }
        if (Pattern.matches(".+[+*/%\\-]", expression)) {
            return ExpressionUtil.getSymbolErrorMsg();
        }
        return "";
    }

    public static boolean transferExpression(String expression, Map<String, String> paramMap, Map<String, String> resultMap) {
        expression = expression.trim();
        expression = expression.replaceAll("\\s+", " ");
        expression = expression.replaceAll("\\s+(\\()", "$1");
        char[] exprArr = expression.toCharArray();
        StringBuilder variableSb = new StringBuilder();
        ArrayList<String> variableList = new ArrayList<String>();
        StringBuilder finalExpr = new StringBuilder();
        boolean isString = false;
        boolean isVariable = false;
        boolean variableStart = true;
        boolean isFunction = false;
        int funcBucketCount = 0;
        for (char chr : exprArr) {
            finalExpr.append(chr);
            if (SPECIAL_CHARS.contains(Character.valueOf(chr))) {
                if (!isString && chr == '(') {
                    if (isFunction) {
                        ++funcBucketCount;
                    }
                    if (variableSb.length() > 0) {
                        if (!isFunction) {
                            isFunction = true;
                            ++funcBucketCount;
                        }
                        finalExpr.deleteCharAt(finalExpr.length() - variableSb.length() - 2);
                        isVariable = false;
                        variableSb = new StringBuilder();
                        variableStart = true;
                    }
                } else if (chr == '\"') {
                    isString = !isString;
                } else if (!isString && chr == ')' || variableSb.length() > 0) {
                    if (!isString && chr == ')' && isFunction && --funcBucketCount == 0) {
                        isFunction = false;
                    }
                    if (variableSb.length() > 0) {
                        variableList.add(variableSb.toString());
                        variableSb = new StringBuilder();
                        isVariable = false;
                        finalExpr.deleteCharAt(finalExpr.length() - 1);
                        finalExpr.append('$').append(chr);
                        variableStart = true;
                    }
                }
            } else if (isVariable || !isString && !DIGIT_CHARS.contains(Character.valueOf(chr))) {
                isVariable = true;
                variableSb.append(chr);
            }
            if (!isVariable || !variableStart || variableSb.length() <= 0) continue;
            finalExpr.deleteCharAt(finalExpr.length() - 1);
            finalExpr.append('$').append(chr);
            variableStart = false;
        }
        return ExpressionUtil.handleVariableTail(paramMap, resultMap, variableSb, variableList, finalExpr);
    }

    private static boolean handleVariableTail(Map<String, String> paramMap, Map<String, String> resultMap, StringBuilder variableSb, ArrayList<String> variableList, StringBuilder finalExpr) {
        if (variableSb.length() > 0) {
            variableList.add(variableSb.toString());
            finalExpr.append('$');
        }
        String finalExprStr = finalExpr.toString();
        StringBuilder undefinedVariable = new StringBuilder();
        for (String variable : variableList) {
            if (SPECIAL_STRINGS.contains(variable)) {
                finalExprStr = finalExprStr.replaceAll("\\$(" + variable + ")\\$", variable);
                continue;
            }
            if (!paramMap.containsKey(variable)) {
                undefinedVariable.append(variable).append(", ");
                continue;
            }
            finalExprStr = finalExprStr.replaceAll("\\$(" + variable + ")\\$", "\\$" + paramMap.get(variable) + "\\$");
        }
        if (undefinedVariable.length() > 0) {
            resultMap.put("undefinedVal", undefinedVariable.deleteCharAt(undefinedVariable.length() - 2).toString());
            return false;
        }
        resultMap.put("successExpr", finalExprStr);
        return true;
    }

    private static String getSymbolErrorMsg() {
        return ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u9519\u8bef\uff0c\u8fd0\u7b97\u7b26\u5de6\u53f3\u9700\u8981\u6709\u53d8\u91cf\u3001\u5e38\u91cf\u6216\u51fd\u6570\u7b49\u3002", (String)"TargetExpressionUtil_3", (String)"hrmp-brm-business", (Object[])new Object[0]);
    }

    private static Object getDefaultValue(String type) {
        Object result;
        ParamTypeEnum typeEnum = ParamTypeEnum.getEnum((String)type);
        switch (typeEnum) {
            case NUMBER: {
                result = 1;
                break;
            }
            case STRING: {
                result = "\"testString\"";
                break;
            }
            case BOOLEAN: {
                result = Boolean.TRUE;
                break;
            }
            case DATE: {
                result = "NOW()";
                break;
            }
            case DYNAMICOBJECT: 
            case BASEDATA: {
                result = 0L;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }
}

