/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.util;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class MsgUtils {
    public static void validateIsNull(Map<String, Object> map, String ... keys) {
        if (Objects.isNull(map)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u5b9e\u4f8bmap\u4e3a\u7a7a", (String)"MsgUtils_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (Objects.isNull(keys)) {
            return;
        }
        for (String key : keys) {
            Object value = map.get(key);
            if (!Objects.isNull(value)) continue;
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"MsgUtils_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]), key));
        }
    }

    public static String generateNumber(String metaNumber) {
        if (HRStringUtils.isEmpty((String)metaNumber)) {
            return null;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(metaNumber);
        DynamicObject permRoleDy = serviceHelper.generateEmptyDynamicObject();
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)metaNumber, (DynamicObject)permRoleDy, null);
        return CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)permRoleDy);
    }

    public static void validateValueType(Map<String, Class> valueKeyClassMap, Map<String, Object> valueMap) {
        if (Objects.isNull(valueKeyClassMap) || Objects.isNull(valueMap)) {
            return;
        }
        for (Map.Entry<String, Class> entry : valueKeyClassMap.entrySet()) {
            String key = entry.getKey();
            Class clazz = entry.getValue();
            Object value = valueMap.get(key);
            if (Objects.isNull(value) || Objects.isNull(clazz) || clazz.isInstance(value)) continue;
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u5b57\u6bb5\u5bf9\u5e94\u7684\u503c\u7c7b\u578b\u9519\u8bef,\u9700\u8981\u7684\u503c\u7c7b\u578b\u4e3a%2$s\u3002", (String)"MsgUtils_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]), key, clazz.getSimpleName()));
        }
    }

    public static void validateValueDuplicate(List<Map<String, Object>> list, String ... duplicateKeys) {
        if (Objects.isNull(list) || Objects.isNull(duplicateKeys)) {
            return;
        }
        for (String key : duplicateKeys) {
            List duplicateList = list.stream().map(listValue -> listValue.get(key)).collect(Collectors.toMap(value -> value, value -> 1, Integer::sum)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
            if (duplicateList.isEmpty()) continue;
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u96c6\u5408\u5bf9\u8c61\u4e2d\u201c%1$s\u201d\u5b57\u6bb5\u5b58\u5728\u91cd\u590d\u7684\u503c:%2$s\u3002", (String)"MsgUtils_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]), key, duplicateList.toString()));
        }
    }
}

