/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.util;

import java.util.regex.Pattern;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.econtract.SignReqParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.ShaUtils;

public class ParamsUtil {
    private static final Log LOGGER = LogFactory.getLog(ParamsUtil.class);
    private static final Pattern ID_PATTERN = Pattern.compile("^(?i)\\d{17}+(?:\\d|X)$");
    private static final Pattern MOBILE_PATTERN = Pattern.compile("^\\d{11}$");
    private static final Pattern MOBILE_PATTERN_CHINA = Pattern.compile("^(((1[0-9]{2}))\\\\d{8})$");

    public static void setSignReqParam(SignReqParam signReqParam) {
        if (signReqParam == null) {
            LOGGER.info("signReqParam is null.");
            return;
        }
        if (HRStringUtils.isNotEmpty((String)signReqParam.getName())) {
            signReqParam.setNameMd5Val(ShaUtils.hashingBySha256((String)signReqParam.getName(), (String)""));
        }
        if (HRStringUtils.isNotEmpty((String)signReqParam.getMobile())) {
            signReqParam.setMobileMd5Val(ShaUtils.hashingBySha256((String)signReqParam.getMobile(), (String)""));
        }
        if (HRStringUtils.isNotEmpty((String)signReqParam.getIdentity())) {
            signReqParam.setIdentityMd5Val(ShaUtils.hashingBySha256((String)signReqParam.getIdentity(), (String)""));
        }
    }

    public static boolean isIdentityMatch(String identity) {
        return ID_PATTERN.matcher(identity).matches();
    }

    public static boolean isMobileMatch(String mobile) {
        return MOBILE_PATTERN.matcher(mobile).matches();
    }

    public static boolean isChinaMobileMatch(String mobile) {
        return MOBILE_PATTERN_CHINA.matcher(mobile).matches();
    }
}

