/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.imp.UserDataRuleImportHelper;
import kd.hr.hrcs.bussiness.util.PermRoleUtil;
import kd.hr.hrcs.common.model.PermImportModel;

public class PermImportValidator {
    public static String validMustFillForFunc(PermImportModel data) {
        StringBuilder fields = PermImportValidator.validMustFillForBaseMsg(data);
        if (HRStringUtils.isEmpty((String)data.getRoleName())) {
            fields.append(ResManager.loadKDString((String)"\u89d2\u8272\u540d\u79f0", (String)"PermImportValidator_9", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(",");
        }
        if (HRStringUtils.isEmpty((String)data.getPermItem())) {
            fields.append(ResManager.loadKDString((String)"\u6743\u9650\u9879\u540d\u79f0", (String)"PermImportValidator_10", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(",");
        }
        if (fields.length() > 0) {
            data.setValid(Boolean.valueOf(false));
            return PermImportValidator.getMustFillValidMsg(fields.toString().substring(0, fields.length() - 1));
        }
        return "";
    }

    public static String validMustFillForUserDataRule(PermImportModel data) {
        StringBuilder fields = PermImportValidator.validMustFillForBaseMsg(data);
        if (HRStringUtils.isEmpty((String)data.getUserNumber())) {
            fields.append(ResManager.loadKDString((String)"\u5458\u5de5\u5de5\u53f7", (String)"PermImportValidator_11", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(",");
        }
        if (data.getValid().booleanValue() && Objects.isNull(data.getStartEffectDate())) {
            fields.append(ResManager.loadKDString((String)"\u6709\u6548\u671f\u5f00\u59cb\u65e5\u671f", (String)"PermImportValidator_12", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(",");
        }
        if (data.getValid().booleanValue() && Objects.isNull(data.getEndEffectDate())) {
            fields.append(ResManager.loadKDString((String)"\u6709\u6548\u671f\u7ed3\u675f\u65e5\u671f", (String)"PermImportValidator_13", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(",");
        }
        if (HRStringUtils.isEmpty((String)data.getDataRuleNumber())) {
            fields.append(ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u65b9\u6848\u7f16\u7801", (String)"PermImportValidator_14", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(",");
        }
        if (fields.length() > 0) {
            data.setValid(Boolean.valueOf(false));
            return PermImportValidator.getMustFillValidMsg(fields.toString().substring(0, fields.length() - 1));
        }
        return "";
    }

    public static String validMustFillForUserFieldPerm(PermImportModel data) {
        StringBuilder fields = PermImportValidator.validMustFillForBaseMsg(data);
        if (HRStringUtils.isEmpty((String)data.getUserNumber())) {
            fields.append(ResManager.loadKDString((String)"\u5458\u5de5\u5de5\u53f7", (String)"PermImportValidator_11", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(",");
        }
        if (HRStringUtils.isEmpty((String)data.getFieldNumber())) {
            fields.append(ResManager.loadKDString((String)"\u5b57\u6bb5\u7f16\u7801", (String)"PermImportValidator_16", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(",");
        }
        if (Objects.isNull(data.getBanRead())) {
            fields.append(ResManager.loadKDString((String)"\u7981\u6b62\u67e5\u770b", (String)"PermImportValidator_17", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(",");
        }
        if (Objects.isNull(data.getBanWrite())) {
            fields.append(ResManager.loadKDString((String)"\u7981\u6b62\u7f16\u8f91", (String)"PermImportValidator_18", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(",");
        }
        if (Objects.isNull(data.getStartEffectDate())) {
            fields.append(ResManager.loadKDString((String)"\u6709\u6548\u671f\u5f00\u59cb\u65e5\u671f", (String)"PermImportValidator_12", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(",");
        }
        if (Objects.isNull(data.getEndEffectDate())) {
            fields.append(ResManager.loadKDString((String)"\u6709\u6548\u671f\u7ed3\u675f\u65e5\u671f", (String)"PermImportValidator_13", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(",");
        }
        if (fields.length() > 0) {
            data.setValid(Boolean.valueOf(false));
            return PermImportValidator.getMustFillValidMsg(fields.toString().substring(0, fields.length() - 1));
        }
        return "";
    }

    public static void validAppIdAndEntityNum(List<PermImportModel> dataList, ImportLogger importLogger) {
        HashSet appNumSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet entityNumSet = Sets.newHashSetWithExpectedSize((int)16);
        dataList.forEach(data -> {
            appNumSet.add(data.getAppNumber());
            entityNumSet.add(data.getEntityNumber());
        });
        HRBaseServiceHelper appHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        QFilter appNumQFilter = new QFilter("number", "in", (Object)appNumSet);
        DynamicObjectCollection appCol = appHelper.queryOriginalCollection("id, number, masterid", new QFilter[]{appNumQFilter});
        HRBaseServiceHelper entityHelper = new HRBaseServiceHelper("bos_formmeta");
        QFilter entityNumQFilter = new QFilter("number", "in", (Object)entityNumSet);
        DynamicObjectCollection entityCol = entityHelper.queryOriginalCollection("id, number, bizappid", new QFilter[]{entityNumQFilter});
        HRBaseServiceHelper entityAppHelper = new HRBaseServiceHelper("perm_bizobjapp");
        QFilter entityAppQFilter = new QFilter("bizobj", "in", (Object)entityNumSet);
        DynamicObjectCollection entityAppCol = entityAppHelper.queryOriginalCollection("bizobj, bizapp", new QFilter[]{entityAppQFilter});
        HashMap appEntityMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap entityAppMap = Maps.newHashMapWithExpectedSize((int)16);
        HashSet entitySetForDesign = Sets.newHashSetWithExpectedSize((int)16);
        ArrayList notExistAppEntityList = Lists.newArrayListWithCapacity((int)16);
        PermImportValidator.buildEntitySetForDesign(entityCol, appEntityMap, entitySetForDesign);
        PermImportValidator.buildEntityAppMap(entityAppCol, entityAppMap);
        for (PermImportModel row : dataList) {
            PermImportValidator.validAppsExist(appCol, row, importLogger);
            PermImportValidator.validEntityAndRelateExist(entityAppMap, appEntityMap, notExistAppEntityList, entitySetForDesign, row, importLogger);
        }
        if (notExistAppEntityList.size() == 0) {
            return;
        }
        Set entityExtNumSet = notExistAppEntityList.stream().map(PermImportModel::getEntityNumber).collect(Collectors.toSet());
        DynamicObjectCollection entityExtCol = entityHelper.queryOriginalCollection("id, number, bizappid", new QFilter[]{new QFilter("number", "in", entityExtNumSet)});
        Set appExtIdSet = entityExtCol.stream().map(dy -> dy.getString("bizappid")).collect(Collectors.toSet());
        HashMap entityExtMap = Maps.newHashMapWithExpectedSize((int)16);
        entityExtCol.forEach(dy -> entityExtMap.put(dy.getString("number"), dy.getString("bizappid")));
        DynamicObjectCollection appExtCol = appHelper.queryOriginalCollection("id, number, masterid", new QFilter[]{new QFilter("id", "in", appExtIdSet)});
        HashMap appExtMap = Maps.newHashMapWithExpectedSize((int)16);
        appExtCol.forEach(dy -> appExtMap.put(dy.getString("id"), dy.getString("masterid")));
        PermImportValidator.validateExtApp(importLogger, notExistAppEntityList, entityExtMap, appExtMap);
    }

    private static void validateExtApp(ImportLogger importLogger, List<PermImportModel> notExistAppEntityList, Map<String, String> entityExtMap, Map<String, String> appExtMap) {
        for (PermImportModel row : notExistAppEntityList) {
            String appId = entityExtMap.get(row.getEntityNumber());
            String originAppId = appExtMap.get(appId);
            if (!HRStringUtils.equals((String)originAppId, (String)row.getAppId())) continue;
            row.setValid(Boolean.valueOf(true));
            importLogger.getLogCache().remove(row.getRowNum());
        }
    }

    private static void buildEntityAppMap(DynamicObjectCollection entityAppCol, Map<String, Set<String>> entityAppMap) {
        entityAppCol.forEach(dy -> {
            String entityNum = dy.getString("bizobj");
            Set appList = entityAppMap.getOrDefault(entityNum, new HashSet(16));
            appList.add(dy.getString("bizapp"));
            entityAppMap.put(entityNum, appList);
        });
    }

    private static void buildEntitySetForDesign(DynamicObjectCollection entityCol, Map<String, Set<String>> appEntityMap, Set<String> entitySetForDesign) {
        entityCol.forEach(dy -> {
            String appId = dy.getString("bizappid");
            String entityNum = dy.getString("number");
            Set entityList = appEntityMap.getOrDefault(appId, new HashSet(16));
            entityList.add(entityNum);
            appEntityMap.put(appId, entityList);
            entitySetForDesign.add(entityNum);
        });
    }

    public static void validRoleAndUserPermFile(List<PermImportModel> dataList, ImportLogger importLogger) {
        HRBaseServiceHelper roleHelper = new HRBaseServiceHelper("perm_role");
        Set roleNumSet = dataList.stream().map(PermImportModel::getRoleNumber).collect(Collectors.toSet());
        QFilter roleNumQFilter = new QFilter("number", "in", roleNumSet);
        DynamicObjectCollection roleCol = roleHelper.queryOriginalCollection("id, number, enable", new QFilter[]{roleNumQFilter});
        HRBaseServiceHelper permFileHelper = new HRBaseServiceHelper("hrcs_userpermfile");
        Set userNumSet = dataList.stream().map(PermImportModel::getUserNumber).collect(Collectors.toSet());
        DynamicObject[] permFileCol = permFileHelper.query("id, user, user.number, permfileenable", new QFilter[]{new QFilter("user.number", "in", userNumSet)});
        for (PermImportModel row : dataList) {
            PermImportValidator.validRoleExistAndEnable(row, roleCol, importLogger);
            PermImportValidator.validUserPermFileExistAndEnable(row, permFileCol, importLogger);
        }
    }

    public static void validHasMultiPerm(List<PermImportModel> dataList, ImportLogger importLogger) {
        UserDataRuleImportHelper helper = new UserDataRuleImportHelper();
        QFilter userRoleRelateQFilter = PermImportValidator.buildUserRoleRelateQFilter(dataList);
        DynamicObjectCollection userRoleRelateCol = helper.queryUserRoleRelateCol(userRoleRelateQFilter);
        List<DynamicObject> filteredUserRoleRelateCol = PermImportValidator.filterUserRoleRelateCol(userRoleRelateCol, dataList);
        if (filteredUserRoleRelateCol.size() == 0) {
            return;
        }
        dataList.forEach(data -> {
            List filteredList = filteredUserRoleRelateCol.stream().filter(dy -> Objects.equals(data.getUserId(), dy.getLong("user.id")) && HRStringUtils.equals((String)data.getRoleId(), (String)dy.getString("role.id")) && HRDateTimeUtils.dayEquals((Date)data.getStartEffectDate(), (Date)dy.getDate("validstart")) && HRDateTimeUtils.dayEquals((Date)data.getEndEffectDate(), (Date)dy.getDate("validend"))).collect(Collectors.toList());
            if (filteredList.size() > 1) {
                data.setValid(Boolean.valueOf(false));
                importLogger.log(Integer.valueOf(data.getRowNum()), PermImportValidator.getHasMultiPermMsg(data.getUserNumber(), data.getRoleNumber())).fail();
            } else if (filteredList.size() == 1) {
                if (!((DynamicObject)filteredList.get(0)).getBoolean("customenable")) {
                    data.setValid(Boolean.valueOf(false));
                    importLogger.log(Integer.valueOf(data.getRowNum()), PermImportValidator.getUserCustomizeMsg(data.getUserNumber(), data.getRoleNumber())).fail();
                }
                data.setUserRoleRealtId(Long.valueOf(((DynamicObject)filteredList.get(0)).getLong("id")));
            }
        });
    }

    private static QFilter buildUserRoleRelateQFilter(List<PermImportModel> dataList) {
        HashSet userIdSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet roleIdSet = Sets.newHashSetWithExpectedSize((int)16);
        dataList.forEach(data -> {
            userIdSet.add(data.getUserId());
            roleIdSet.add(data.getRoleId());
        });
        QFilter userQFilter = new QFilter("user", "in", (Object)userIdSet);
        QFilter roleQFilter = new QFilter("role", "in", (Object)roleIdSet);
        return userQFilter.and(roleQFilter);
    }

    private static List<DynamicObject> filterUserRoleRelateCol(DynamicObjectCollection userRoleRelateCol, List<PermImportModel> dataList) {
        return userRoleRelateCol.stream().filter(dy -> {
            boolean findFlag = false;
            for (PermImportModel data : dataList) {
                data.setEndEffectDate(PermRoleUtil.formatEndDate(data.getEndEffectDate()));
                if (!Objects.equals(data.getUserId(), dy.getLong("user.id")) || !Objects.equals(data.getRoleId(), dy.getString("role.id")) || !HRDateTimeUtils.dayEquals((Date)data.getStartEffectDate(), (Date)dy.getDate("validstart")) || !HRDateTimeUtils.dayEquals((Date)data.getEndEffectDate(), (Date)dy.getDate("validend"))) continue;
                findFlag = true;
            }
            return findFlag;
        }).collect(Collectors.toList());
    }

    private static void validRoleExistAndEnable(PermImportModel row, DynamicObjectCollection roleCol, ImportLogger importLogger) {
        boolean findFlag = false;
        for (DynamicObject roleDy : roleCol) {
            if (!HRStringUtils.equals((String)row.getRoleNumber(), (String)roleDy.getString("number"))) continue;
            findFlag = true;
            row.setRoleId(roleDy.getString("id"));
            if (!HRStringUtils.equals((String)roleDy.getString("enable"), (String)"0")) break;
            row.setValid(Boolean.valueOf(false));
            importLogger.log(Integer.valueOf(row.getRowNum()), PermImportValidator.getRoleDisableMsg(row.getRoleNumber())).fail();
            break;
        }
        if (!findFlag) {
            row.setValid(Boolean.valueOf(false));
            row.setRoleExist(Boolean.valueOf(false));
            importLogger.log(Integer.valueOf(row.getRowNum()), PermImportValidator.getRoleExistMsg(row.getRoleNumber())).fail();
        }
    }

    private static void validUserPermFileExistAndEnable(PermImportModel row, DynamicObject[] permFileCol, ImportLogger importLogger) {
        boolean findFlag = false;
        for (DynamicObject permFileDy : permFileCol) {
            if (!HRStringUtils.equalsIgnoreCase((String)row.getUserNumber(), (String)permFileDy.getString("user.number"))) continue;
            findFlag = true;
            row.setUserId(Long.valueOf(permFileDy.getLong("user.id")));
            row.setUserPermFileId(Long.valueOf(permFileDy.getLong("id")));
            if (!HRStringUtils.equals((String)permFileDy.getString("permfileenable"), (String)"0")) break;
            row.setValid(Boolean.valueOf(false));
            importLogger.log(Integer.valueOf(row.getRowNum()), PermImportValidator.getUserPermFileDisableMsg(row.getUserNumber())).fail();
            break;
        }
        if (!findFlag) {
            row.setValid(Boolean.valueOf(false));
            importLogger.log(Integer.valueOf(row.getRowNum()), PermImportValidator.getUserPermFileExistMsg(row.getUserNumber())).fail();
        }
    }

    private static void validAppsExist(DynamicObjectCollection appCol, PermImportModel row, ImportLogger importLogger) {
        String appNum = row.getAppNumber();
        if (HRStringUtils.isEmpty((String)appNum)) {
            return;
        }
        boolean findFlag = false;
        for (DynamicObject appDy : appCol) {
            if (!HRStringUtils.equals((String)appDy.getString("number"), (String)appNum)) continue;
            findFlag = true;
            row.setAppId(appDy.getString("id"));
            break;
        }
        if (!findFlag) {
            row.setValid(Boolean.valueOf(false));
            row.setAppExist(Boolean.valueOf(false));
            importLogger.log(Integer.valueOf(row.getRowNum()), PermImportValidator.getAppIsNullMsg(row.getAppNumber())).fail();
        }
    }

    private static void validEntityAndRelateExist(Map<String, Set<String>> entityAppMap, Map<String, Set<String>> appEntityMap, List<PermImportModel> notExistAppEntityList, Set<String> entitySetForDesign, PermImportModel row, ImportLogger importLogger) {
        Set appSet;
        String entityNum = row.getEntityNumber();
        String appId = row.getAppId();
        if (HRStringUtils.isEmpty((String)entityNum)) {
            return;
        }
        if (!entityAppMap.containsKey(entityNum) && !entitySetForDesign.contains(entityNum)) {
            row.setValid(Boolean.valueOf(false));
            row.setEntityExist(Boolean.valueOf(false));
            importLogger.log(Integer.valueOf(row.getRowNum()), PermImportValidator.getEntityIsNullMsg(entityNum)).fail();
            return;
        }
        if (HRStringUtils.isEmpty((String)appId) || !row.getAppExist().booleanValue()) {
            return;
        }
        boolean designRelate = false;
        boolean publishRelate = false;
        Set entitySet = appEntityMap.getOrDefault(appId, new HashSet(1));
        if (entitySet.contains(entityNum)) {
            designRelate = true;
        }
        if ((appSet = (Set)entityAppMap.getOrDefault(entityNum, new HashSet(1))).contains(appId)) {
            publishRelate = true;
        }
        if (!designRelate && !publishRelate) {
            row.setValid(Boolean.valueOf(false));
            importLogger.log(Integer.valueOf(row.getRowNum()), PermImportValidator.getAppAndEntityRelateMsg(row.getAppNumber(), entityNum)).fail();
            notExistAppEntityList.add(row);
        }
    }

    private static StringBuilder validMustFillForBaseMsg(PermImportModel data) {
        StringBuilder fields = new StringBuilder();
        if (HRStringUtils.isEmpty((String)data.getRoleNumber())) {
            fields.append(ResManager.loadKDString((String)"\u89d2\u8272\u7f16\u7801", (String)"PermImportValidator_19", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(",");
        }
        if (HRStringUtils.isEmpty((String)data.getAppNumber())) {
            fields.append(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801", (String)"PermImportValidator_20", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(",");
        }
        if (HRStringUtils.isEmpty((String)data.getEntityNumber())) {
            fields.append(ResManager.loadKDString((String)"\u5b9e\u4f53\u7f16\u7801", (String)"PermImportValidator_21", (String)"hrmp-hrcs-business", (Object[])new Object[0])).append(",");
        }
        return fields;
    }

    private static String getMustFillValidMsg(String fieldName) {
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c%s\u201d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PermImportValidator_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]), fieldName);
    }

    private static String getAppIsNullMsg(String appNumber) {
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u6ca1\u6709\u627e\u5230\u201c%s\u201d\u5e94\u7528\u7f16\u7801\u3002", (String)"PermImportValidator_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]), appNumber);
    }

    private static String getEntityIsNullMsg(String entityNumber) {
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u201c%s\u201d\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u3002", (String)"PermImportValidator_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]), entityNumber);
    }

    private static String getAppAndEntityRelateMsg(String appNum, String entityNum) {
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7cfb\u7edf\u201c%1$s\u201d\u5e94\u7528\u6ca1\u6709\u201c%2$s\u201d\u5b9e\u4f53\u5bf9\u8c61\u3002", (String)"PermImportValidator_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]), appNum, entityNum);
    }

    private static String getRoleExistMsg(String roleNumber) {
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u6ca1\u6709\u627e\u5230\u201c%s\u201d\u89d2\u8272\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PermImportValidator_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]), roleNumber);
    }

    private static String getRoleDisableMsg(String roleNumber) {
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u201c%s\u201d\u89d2\u8272\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PermImportValidator_6", (String)"hrmp-hrcs-business", (Object[])new Object[0]), roleNumber);
    }

    private static String getUserPermFileDisableMsg(String userNumber) {
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u201c%s\u201d\u5458\u5de5\u7684\u6743\u9650\u6863\u6848\u5df2\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PermImportValidator_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]), userNumber);
    }

    private static String getUserPermFileExistMsg(String userNumber) {
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u7cfb\u7edf\u4e2d\u662f\u5426\u5b58\u5728\u5458\u5de5\u201c%s\u201d\u7684\u6743\u9650\u6863\u6848\u3002", (String)"PermImportValidator_8", (String)"hrmp-hrcs-business", (Object[])new Object[0]), userNumber);
    }

    private static String getHasMultiPermMsg(String userNumber, String roleNumber) {
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u6709\u6548\u671f\u5185\u201c%1$s\u201d\u5458\u5de5\u5728\u201c%2$s\u201d\u89d2\u8272\u4e0b\u6709\u591a\u6761\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"PermImportValidator_26", (String)"hrmp-hrcs-business", (Object[])new Object[0]), userNumber, roleNumber);
    }

    private static String getUserCustomizeMsg(String userNumber, String roleNumber) {
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u5458\u5de5\u5728\u201c%2$s\u201d\u89d2\u8272\u4e0b\u6570\u636e\u8303\u56f4\u975e\u81ea\u5b9a\u4e49\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PermImportValidator_25", (String)"hrmp-hrcs-business", (Object[])new Object[0]), userNumber, roleNumber);
    }

    public static String getDateFormatMsg() {
        return ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u201cyyyy-MM-dd\u201d\u683c\u5f0f\u3002", (String)"PermImportValidator_27", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
    }
}

