/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.util;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import kd.bos.service.KDDateUtils;

public class PermLogUtil {
    private PermLogUtil() {
    }

    public static int computeArchivePeriod(String archiveType) {
        switch (archiveType) {
            case "3d": {
                return 3;
            }
            case "7d": {
                return 7;
            }
            case "15d": {
                return 15;
            }
            case "1m": {
                return 30;
            }
            case "3m": {
                return 90;
            }
            case "6m": {
                return 180;
            }
            case "1y": {
                return 365;
            }
            case "2y": {
                return 730;
            }
        }
        return 0;
    }

    public static int computeArchivePeriodDay(int day) {
        LocalDate now = LocalDate.now(KDDateUtils.getSysTimeZone().toZoneId());
        LocalDate plus = now.plusDays(day);
        return (int)now.until(plus, ChronoUnit.DAYS);
    }

    public static int computeArchivePeriodMonth(int month) {
        LocalDate now = LocalDate.now(KDDateUtils.getSysTimeZone().toZoneId());
        LocalDate plus = now.plusMonths(month);
        return (int)now.until(plus, ChronoUnit.DAYS);
    }

    public static int computeArchivePeriodYear(int year) {
        LocalDate now = LocalDate.now(KDDateUtils.getSysTimeZone().toZoneId());
        LocalDate plus = now.plusYears(year);
        return (int)now.until(plus, ChronoUnit.DAYS);
    }
}

