/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.md.UserRoleFieldPermInfo;
import kd.hr.hrcs.bussiness.servicehelper.perm.HrbuCaControlHelper;
import kd.hr.hrcs.bussiness.servicehelper.perm.RoleServiceHelper;
import kd.hr.hrcs.bussiness.util.FieldPermInfoJsonUtil;
import kd.hr.hrcs.common.constants.perm.RoleDataPermModel;

public class PermPageCacheUtil {
    private static final Log LOGGER = LogFactory.getLog(PermPageCacheUtil.class);
    public static final String ASSIGNED_DIM_INFO = "assignedDimInfo";
    public static final String REAL_TIME_BUCAFUNC_DIM_INFO = "bucaFuncDimInfo";
    public static final String FUNC_PERM_DATA_LIST = "funcPermDataList";
    public static final String ORIGINAL_FUNC_PERM_DATA_LIST = "originalFuncPermDataList";
    public static final String DO_NOT_SAVE_DIM_GRP = "doNotSaveDimGrp";
    private IPageCache pageCache;
    public static final String KEYLIST = "PermPageCache_KeyList";
    public static final String DATA_PERM_LIST = "dataPermList";
    private static final String FIELD_PERM_CACHE = "fieldPermCache";
    public static final String CONTROL_MAP = "controlMap";

    public PermPageCacheUtil(IPageCache pPageCache) {
        this.pageCache = pPageCache;
        this.addExtraKey();
    }

    public PermPageCacheUtil(IFormView formView, boolean batchSave) {
        this.pageCache = new PageCache(formView.getPageId(), batchSave);
        this.addExtraKey();
    }

    public void setPageCache(IPageCache pageCache) {
        this.pageCache.put(pageCache.getAll());
    }

    public Map<String, Map<String, Object>> getAllHrBuCaMap() {
        Map allHrBuCaFuncMap;
        String allHrBuCaFuncJson = this.pageCache.get("businessList");
        if (HRStringUtils.isEmpty((String)allHrBuCaFuncJson)) {
            allHrBuCaFuncMap = HrbuCaControlHelper.getAllHRBuCaFuncMapForPerm();
            this.pageCache.put("businessList", SerializationUtils.toJsonString((Object)allHrBuCaFuncMap));
        } else {
            allHrBuCaFuncMap = (Map)SerializationUtils.fromJsonString((String)allHrBuCaFuncJson, Map.class);
        }
        return allHrBuCaFuncMap;
    }

    public Map<String, Map<String, String>> getAllAppHrBuCaMap() {
        Map allHrBuCaFuncMap;
        String allHrBuCaFuncJson = this.pageCache.get("allAppBucaMap");
        if (HRStringUtils.isEmpty((String)allHrBuCaFuncJson)) {
            allHrBuCaFuncMap = RoleServiceHelper.getAppBuCaFuncMap(null);
            this.pageCache.put("allAppBucaMap", SerializationUtils.toJsonString((Object)allHrBuCaFuncMap));
        } else {
            allHrBuCaFuncMap = (Map)SerializationUtils.fromJsonString((String)allHrBuCaFuncJson, Map.class);
        }
        return allHrBuCaFuncMap;
    }

    public Set<String> getAssignedHrBuCaSet() {
        String currentBuCaFuncJson = this.pageCache.get("assignedBuCaIds");
        Set hrBuCaFuncSet = Sets.newHashSet();
        if (HRStringUtils.isNotEmpty((String)currentBuCaFuncJson)) {
            hrBuCaFuncSet = (Set)SerializationUtils.fromJsonString((String)currentBuCaFuncJson, Set.class);
        }
        return hrBuCaFuncSet;
    }

    public void setAssignedHrBuCaSet(Set<String> hrBuCaFuncIds) {
        this.getPageCache().put("assignedBuCaIds", SerializationUtils.toJsonString(hrBuCaFuncIds));
    }

    public Set<String> getAssignedAppSet() {
        String assignedAppJson = this.pageCache.get("assignedAppIds");
        Set assignedAppIdSet = Sets.newHashSet();
        if (HRStringUtils.isNotEmpty((String)assignedAppJson)) {
            assignedAppIdSet = (Set)SerializationUtils.fromJsonString((String)assignedAppJson, Set.class);
        }
        return assignedAppIdSet;
    }

    public void setAssignedAppSet(Set<String> appSet) {
        this.pageCache.put("assignedAppIds", SerializationUtils.toJsonString(appSet));
    }

    public void setAssignedCloudSet(Set<String> cloudSet) {
        this.pageCache.put("assignedCloudIds", SerializationUtils.toJsonString(cloudSet));
    }

    public void addAssignedCloud(Set<String> cloudSet) {
        if (CollectionUtils.isEmpty(cloudSet)) {
            return;
        }
        Set<String> assignedCloudSet = this.getAssignedCloudSet();
        assignedCloudSet.addAll(cloudSet);
        this.setAssignedCloudSet(assignedCloudSet);
    }

    public void removeAssignedCloud(Set<String> cloudSet) {
        Set<String> assignedCloudSet = this.getAssignedCloudSet();
        assignedCloudSet.removeAll(cloudSet);
        this.setAssignedCloudSet(assignedCloudSet);
    }

    public Set<String> getAssignedCloudSet() {
        String assignedCloudJson = this.pageCache.get("assignedCloudIds");
        Set assignedCloudIdSet = Sets.newHashSet();
        if (HRStringUtils.isNotEmpty((String)assignedCloudJson)) {
            assignedCloudIdSet = (Set)SerializationUtils.fromJsonString((String)assignedCloudJson, Set.class);
        }
        return assignedCloudIdSet;
    }

    public Map<String, Map<String, String>> getAssignedAppHrBuCaMap() {
        Set<String> assignedAppSet = this.getAssignedAppSet();
        Map<String, Map<String, String>> allAppBuCaMap = this.getAllAppHrBuCaMap();
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)assignedAppSet.size());
        for (String appId : assignedAppSet) {
            resultMap.put(appId, allAppBuCaMap.get(appId));
        }
        return resultMap;
    }

    public Map<String, Map<String, Object>> getAssignedHrBuCaMap() {
        Set<String> assignedHrBuCaSet = this.getAssignedHrBuCaSet();
        Map<String, Map<String, Object>> allHrBuCaMap = this.getAllHrBuCaMap();
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)assignedHrBuCaSet.size());
        for (String buCaId : assignedHrBuCaSet) {
            resultMap.put(buCaId, allHrBuCaMap.get(buCaId));
        }
        return resultMap;
    }

    public IPageCache getPageCache() {
        return this.pageCache;
    }

    public final void addExtraKey() {
        List<String> keyList = this.getKeyList();
        if (keyList != null && keyList.size() == 0) {
            keyList.add("CustomFilter_OrgIds");
            keyList.add("CustomFilter_DimObjIds");
            keyList.add("CustomFilter_UserIds");
            keyList.add("CustomFilter_RoleIds");
            keyList.add("CustomQFilter_DimObjIds");
            keyList.add("CustomQFilter_UserIds");
            keyList.add("CustomQFilter_RoleIds");
            this.pageCache.put(KEYLIST, SerializationUtils.toJsonString(keyList));
        }
    }

    public String get(String key) {
        return this.pageCache.get(key);
    }

    public List<String> getKeyList() {
        String keyListValue = this.pageCache.get(KEYLIST);
        List keyList = StringUtils.isNotEmpty((String)keyListValue) ? (List)SerializationUtils.fromJsonString((String)keyListValue, List.class) : new ArrayList();
        return keyList;
    }

    public void put(String key, String value) {
        this.pageCache.put(key, value);
    }

    public void remove(String key) {
        this.pageCache.remove(key);
    }

    public Map<String, RoleDataPermModel> getDataPermMap() {
        ObjectMapper mapper = new ObjectMapper();
        Map result = Maps.newHashMapWithExpectedSize((int)16);
        String json = this.get("roleDimensionGroup");
        if (HRStringUtils.isEmpty((String)json)) {
            return result;
        }
        try {
            result = (Map)mapper.readValue(json, (TypeReference)new TypeReference<Map<String, RoleDataPermModel>>(){});
        }
        catch (JsonProcessingException e) {
            LOGGER.error("parse roleDimensionGroup error :" + json);
        }
        return result;
    }

    public <T> T getMapData(String key) {
        String json = this.pageCache.get(key);
        if (HRStringUtils.isEmpty((String)json)) {
            return (T)new HashMap(16);
        }
        Map resultMap = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
        if (CollectionUtils.isEmpty((Map)resultMap)) {
            return (T)new HashMap(16);
        }
        return (T)resultMap;
    }

    public <T> T getListData(String key) {
        String json = this.pageCache.get(key);
        if (HRStringUtils.isEmpty((String)json)) {
            return (T)Lists.newArrayList();
        }
        return (T)SerializationUtils.fromJsonString((String)json, List.class);
    }

    public void setDataPerm(Map<String, RoleDataPermModel> roleDimGrpMap) {
        ArrayList<RoleDataPermModel> list = new ArrayList<RoleDataPermModel>(roleDimGrpMap.values());
        this.pageCache.put(DATA_PERM_LIST, SerializationUtils.toJsonString(list));
        this.pageCache.put("roleDimensionGroup", SerializationUtils.toJsonString(roleDimGrpMap));
    }

    public void clearDataPerm() {
        this.pageCache.remove(DATA_PERM_LIST);
        this.pageCache.remove("roleDimensionGroup");
    }

    public void setControlMap(Map<String, Map<String, Object>> roleDimGrpMap) {
        this.pageCache.put(CONTROL_MAP, SerializationUtils.toJsonString(roleDimGrpMap));
    }

    public Map<String, UserRoleFieldPermInfo> getFieldPermData() {
        String jsonStr = this.pageCache.get(FIELD_PERM_CACHE);
        return FieldPermInfoJsonUtil.fromJsonStr(jsonStr);
    }

    public Map<String, Map<String, Object>> getControlMap() {
        return (Map)this.getMapData(CONTROL_MAP);
    }

    public Map<String, List<String>> getGrpControlMap() {
        return (Map)this.getMapData("grpControlMap");
    }

    public void setGrpControlMap(Map<String, List<String>> grpControlMap) {
        this.pageCache.put("grpControlMap", SerializationUtils.toJsonString(grpControlMap));
    }

    public void setAssignedDimIntoCache(Map<String, Map<String, Object>> dimInfoMap) {
        this.pageCache.put(ASSIGNED_DIM_INFO, SerializationUtils.toJsonString(dimInfoMap));
    }

    public Map<String, Map<String, Map<String, Object>>> getRealTimeBuCaFuncDim() {
        return (Map)this.getMapData(REAL_TIME_BUCAFUNC_DIM_INFO);
    }

    public void setRealTimeBuCaFuncDim(Map<String, Map<String, Map<String, Object>>> dimInfoMap) {
        this.pageCache.put(REAL_TIME_BUCAFUNC_DIM_INFO, SerializationUtils.toJsonString(dimInfoMap));
    }

    public void setAssignedDimIntoCache(String roleId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_roledimension");
        DynamicObject[] dynamicObjects = helper.query("dimension", new QFilter[]{new QFilter("role", "=", (Object)roleId)});
        Map<String, Map<String, Object>> dimInfoMap = Arrays.stream(dynamicObjects).filter(item -> HRStringUtils.isNotEmpty((String)item.getString("dimension.id"))).collect(Collectors.toMap(item -> item.getString("dimension.id"), item -> {
            HashMap<String, Object> dimMap = new HashMap<String, Object>(16);
            dimMap.put("dimId", item.getString("dimension.id"));
            dimMap.put("dimensionNumber", item.getString("dimension.number"));
            dimMap.put("showType", item.getString("dimension.showtype"));
            dimMap.put("dataSource", item.getString("dimension.datasource"));
            dimMap.put("dimensionName", item.getString("dimension.name"));
            String showType = item.getString("dimension.showtype");
            if (HRStringUtils.equals((String)"checkbox", (String)showType)) {
                DynamicObjectCollection dimEnumColl = item.getDynamicObjectCollection("dimension.entry");
                List valueList = dimEnumColl.stream().map(enumItem -> enumItem.getString("value")).collect(Collectors.toList());
                List idList = dimEnumColl.stream().map(enumItem -> enumItem.getLong("id")).collect(Collectors.toList());
                dimMap.put("enumList", valueList);
                dimMap.put("enumIdList", idList);
            }
            return dimMap;
        }, (entity1, entity2) -> entity1));
        this.setAssignedDimIntoCache(dimInfoMap);
    }

    public Map<String, Map<String, Object>> getAssignedDimInfo() {
        return (Map)this.getMapData(ASSIGNED_DIM_INFO);
    }

    public List<Map<String, String>> getFuncPermDataList() {
        return (List)this.getListData(FUNC_PERM_DATA_LIST);
    }

    public void updateFuncPermDataList(List<Map<String, String>> funcPermDataList) {
        this.pageCache.put(FUNC_PERM_DATA_LIST, SerializationUtils.toJsonString(funcPermDataList));
    }

    public List<Map<String, String>> getRoleFuncPermDataList() {
        return (List)this.getListData("rolePerms");
    }

    public List<Map<String, String>> getOriginalFuncPermDataList() {
        return (List)this.getListData(ORIGINAL_FUNC_PERM_DATA_LIST);
    }

    public void setOriginalFuncPermDataList(List<Map<String, String>> funcPermDataList) {
        this.pageCache.put(ORIGINAL_FUNC_PERM_DATA_LIST, SerializationUtils.toJsonString(funcPermDataList));
    }

    public Map<String, Map<String, Map<String, Object>>> getAssignedHrBuCaDim() {
        return (Map)this.getMapData("hrBuFuncDimMap");
    }

    public Map<String, Map<String, Map<String, Object>>> getOriginalHrBuCaDim() {
        return (Map)this.getMapData("originalHrBuFuncDimMap");
    }

    public Map<String, Set<String>> getRoleDimData() {
        return (Map)this.getMapData("roleDimMapInDb");
    }

    public void setRoleDimData(Map<String, Set<String>> roleDimData) {
        this.pageCache.put("roleDimMapInDb", SerializationUtils.toJsonString(roleDimData));
    }

    public Map<String, Map<String, String>> getAssignedDim() {
        Map<String, Map<String, Map<String, Object>>> assignedHrBuCaDim = this.getAssignedHrBuCaDim();
        HashMap assignedDimMap = Maps.newHashMapWithExpectedSize((int)16);
        assignedHrBuCaDim.forEach((hrBuCaFuncId, dimMap) -> dimMap.forEach((key, dimInfo) -> {
            String dimId = (String)dimInfo.get("dimId");
            HashMap tempMap = Maps.newHashMapWithExpectedSize((int)3);
            tempMap.put("buCaFuncId", hrBuCaFuncId);
            tempMap.put("dimId", dimId);
            tempMap.put("dimensionNumber", (String)dimInfo.get("dimensionNumber"));
            assignedDimMap.put(dimId + "#" + hrBuCaFuncId, tempMap);
        }));
        return assignedDimMap;
    }

    public void setAssignedHrBuCaDim(Map<String, Map<String, Map<String, Object>>> hrBuCaFuncDimMap) {
        this.pageCache.put("hrBuFuncDimMap", SerializationUtils.toJsonString(hrBuCaFuncDimMap));
    }

    public void setOriginalHrBuCaDim(Map<String, Map<String, Map<String, Object>>> hrBuCaFuncDimMap) {
        this.pageCache.put("originalHrBuFuncDimMap", SerializationUtils.toJsonString(hrBuCaFuncDimMap));
    }

    public void clearAssignedHrBuCaDim() {
        this.pageCache.remove("hrBuFuncDimMap");
    }

    public void setAssignedAppEntity(Map<String, List<String>> appEntityMap) {
        this.pageCache.put("assignedAppEntityMap", SerializationUtils.toJsonString(appEntityMap));
    }

    public Map<String, List<String>> getAssignedAppEntity() {
        return (Map)this.getMapData("assignedAppEntityMap");
    }

    public void setDoNotSaveDimGrp() {
        this.pageCache.put(DO_NOT_SAVE_DIM_GRP, "1");
    }

    public boolean getDoNotSaveDimGrp() {
        return HRStringUtils.equals((String)"1", (String)this.pageCache.get(DO_NOT_SAVE_DIM_GRP));
    }

    public void updateAssignedBuCaFunc(Map<String, Set<String>> assignedCloudBuCaFunc) {
        HashSet assignedBuCaFuncSet = Sets.newHashSetWithExpectedSize((int)16);
        assignedCloudBuCaFunc.values().forEach(assignedBuCaFuncSet::addAll);
        if (!CollectionUtils.isEmpty((Collection)assignedBuCaFuncSet)) {
            this.setAssignedHrBuCaSet(assignedBuCaFuncSet);
        }
    }

    public void setEntityBuCaFuncMap(Map<String, Map<String, String>> entityBuCaFuncMap) {
        if (CollectionUtils.isEmpty(entityBuCaFuncMap)) {
            this.pageCache.remove("assignedEntityBuCaFuncMap");
            return;
        }
        this.pageCache.put("assignedEntityBuCaFuncMap", SerializationUtils.toJsonString(entityBuCaFuncMap));
    }

    public Map<String, Map<String, String>> getAssignedEntityBuCaFuncMap() {
        ObjectMapper mapper = new ObjectMapper();
        Map result = Maps.newHashMapWithExpectedSize((int)16);
        String json = this.get("assignedEntityBuCaFuncMap");
        if (HRStringUtils.isEmpty((String)json)) {
            return result;
        }
        try {
            result = (Map)mapper.readValue(json, (TypeReference)new TypeReference<Map<String, Map<String, String>>>(){});
        }
        catch (JsonProcessingException e) {
            LOGGER.error("parse assignedEntityBuCaFuncMap error :" + json);
        }
        return result;
    }

    public void setOriginalDataPerm(Map<String, RoleDataPermModel> roleDataPermModelMap) {
        this.pageCache.put("originalRoleDimensionGroup", SerializationUtils.toJsonString(roleDataPermModelMap));
    }

    public Map<String, RoleDataPermModel> getOriginalDataPermMap() {
        ObjectMapper mapper = new ObjectMapper();
        Map result = Maps.newHashMapWithExpectedSize((int)16);
        String json = this.get("originalRoleDimensionGroup");
        if (HRStringUtils.isEmpty((String)json)) {
            return result;
        }
        try {
            result = (Map)mapper.readValue(json, (TypeReference)new TypeReference<Map<String, RoleDataPermModel>>(){});
        }
        catch (JsonProcessingException e) {
            LOGGER.error("parse originalRoleDimensionGroup error :" + json);
        }
        return result;
    }

    public Map<String, Map<String, String>> getParentNodeMap() {
        String parentNodeMapJson = this.pageCache.get("parentMap$tree_funcperm");
        return HRStringUtils.isEmpty((String)parentNodeMapJson) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)parentNodeMapJson, Map.class);
    }

    public Set<String> getDimResultSet() {
        String idsJson = this.pageCache.get("dimResultIds");
        Set hrBuCaFuncSet = Sets.newHashSet();
        if (HRStringUtils.isNotEmpty((String)idsJson)) {
            hrBuCaFuncSet = (Set)SerializationUtils.fromJsonString((String)idsJson, Set.class);
        }
        return hrBuCaFuncSet;
    }

    public void setDimResultSet(Set<String> dimResultIds) {
        Set<String> dimResultSet = this.getDimResultSet();
        dimResultSet.addAll(dimResultIds);
        this.getPageCache().put("dimResultIds", SerializationUtils.toJsonString(dimResultSet));
    }
}

