/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.util;

import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.util.StringUtils;
import kd.hr.hrcs.bussiness.util.PermPageCacheUtil;
import kd.hr.hrcs.common.constants.perm.PermFormCommonUtil;
import kd.hr.hrcs.common.constants.perm.PermTreeUtil;

public class PermRoleDuplicateCodeUtil {
    private static final String ROLEORG = "roleorg";

    public static int[] getIntArray(int rowCount) {
        int[] intArray = new int[rowCount];
        for (int index = 0; index < intArray.length; ++index) {
            intArray[index] = index;
        }
        return intArray;
    }

    public static void confirmCallBack(MessageBoxClosedEvent event, IFormView view) {
        String callBackId = event.getCallBackId();
        if (callBackId.equals("continue_close") && event.getResult() == MessageBoxResult.Yes) {
            PermFormCommonUtil.closeClientForm((IFormView)view);
        }
    }

    public static List<Map.Entry<String, String>> sortForAddNodes(List<Map.Entry<String, String>> childNodeMapList, PermPageCacheUtil permPageCacheUtil) {
        if (childNodeMapList == null || childNodeMapList.size() == 0) {
            return new ArrayList<Map.Entry<String, String>>();
        }
        Map.Entry<String, String> childNodeMap = childNodeMapList.get(0);
        String childNodeId = childNodeMap.getKey();
        if (childNodeId.contains("#entity")) {
            ArrayList<Map.Entry<String, String>> newChildNodeMapList = new ArrayList<Map.Entry<String, String>>();
            PermRoleDuplicateCodeUtil.handleContainsNodeId(childNodeId, childNodeMapList, newChildNodeMapList);
            return newChildNodeMapList;
        }
        PermRoleDuplicateCodeUtil.sortChildNodeMapList(permPageCacheUtil, childNodeMapList);
        return childNodeMapList;
    }

    private static void sortChildNodeMapList(PermPageCacheUtil permPageCacheUtil, List<Map.Entry<String, String>> childNodeMapList) {
        Map<String, String> permItemInfoMap = PermRoleDuplicateCodeUtil.getPermItemInfoMap(permPageCacheUtil);
        childNodeMapList.sort((o1, o2) -> {
            String key1 = (String)o1.getKey();
            String key2 = (String)o2.getKey();
            if (key1.contains("#permItem")) {
                String permItem1 = key1.substring(key1.indexOf(124) + 1, key1.indexOf(64));
                String permItem2 = key2.substring(key2.indexOf(124) + 1, key2.indexOf(64));
                if (permItemInfoMap == null || permItemInfoMap.get(permItem1) == null || permItemInfoMap.get(permItem2) == null) {
                    return permItem1.compareTo(permItem2);
                }
                return ((String)permItemInfoMap.get(permItem1)).compareTo((String)permItemInfoMap.get(permItem2));
            }
            return key1.compareTo(key2);
        });
    }

    private static void handleContainsNodeId(String childNodeId, List<Map.Entry<String, String>> childNodeMapList, List<Map.Entry<String, String>> newChildNodeMapList) {
        String appId = childNodeId.substring(childNodeId.indexOf(64) + 1, childNodeId.indexOf(35));
        List listMenuNode = PermTreeUtil.getSortedMenuList((String)appId);
        for (AppMenuElement menuNode : listMenuNode) {
            String entityNum;
            String formNum = menuNode.getFormNumber();
            if (StringUtils.isEmpty((String)formNum)) continue;
            try {
                entityNum = FormMetadataCache.getFormConfig((String)formNum).getEntityTypeId();
            }
            catch (Exception e) {
                continue;
            }
            if (StringUtils.isEmpty((String)entityNum)) continue;
            if ("empty".equals(entityNum)) {
                entityNum = menuNode.getFormNumber();
            }
            Iterator<Map.Entry<String, String>> iter = childNodeMapList.iterator();
            while (iter.hasNext()) {
                Map.Entry<String, String> entry = iter.next();
                String key = entry.getKey();
                String entityNumFromChildNodeMap = key.substring(key.indexOf(124) + 1, key.indexOf(64));
                if (!entityNumFromChildNodeMap.equals(entityNum)) continue;
                newChildNodeMapList.add(entry);
                iter.remove();
            }
        }
        if (childNodeMapList.size() > 0) {
            Collator cltr = Collator.getInstance(RequestContext.get().getLang().getLocale());
            childNodeMapList.sort((e1, e2) -> {
                String value1 = (String)e1.getValue();
                String value2 = (String)e2.getValue();
                return cltr.compare(value1, value2);
            });
        }
        newChildNodeMapList.addAll(childNodeMapList);
    }

    public static Map<String, String> getPermItemInfoMap(PermPageCacheUtil permPageCacheUtil) {
        HashMap<String, String> permItemInfoMap = null;
        String cache = permPageCacheUtil.get("pgCache_PermItemIdNumMap");
        if (StringUtils.isEmpty((String)cache)) {
            permItemInfoMap = new HashMap();
            permPageCacheUtil.put("pgCache_PermItemIdNumMap", SerializationUtils.toJsonString(permItemInfoMap));
        } else {
            permItemInfoMap = (Map)SerializationUtils.fromJsonString((String)cache, Map.class);
        }
        return permItemInfoMap;
    }
}

