/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.PermissionControlType;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.EntityCtrlServiceHelper;
import kd.hr.hrcs.common.constants.perm.PermFormCommonUtil;

public class QueryEntitiesUtil {
    private static final String BIZ_UNIT_REL_FORM_DS = "bizUnitRelFormDS";
    private static final String BIZ_OBJ_APP_DS = "bizObjAppDS";
    private static final String ENTITY_DESIGN_DS = "entityDesignDS";
    private static final String ENTAPP_ENTNUM = "entapp_entnum";
    private static final String ENT_NUM = "ent_num";
    private static final String ENTAPP_APPID = "entapp_appid";
    private static final String ENT_ID = "ent_id";
    private static final String ENT_DS = "entDS";
    private static final String ENTD_ID = "entd_id";
    private static final String APP_ID = "app_id";
    private static final String ENTD_NUM = "entd_num";
    private static final String BURF_APPID = "burf_appid";
    private static final String BURF_FORMID = "burf_formid";
    private static final String FUNCPERM_ENTID = "funcperm_entid";
    private static final String FUNC_PERM_DS = "funcPermDS";
    private static final String CLOUD_APP_DS = "cloudAppDS";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicObject[] getAllowedEntities(String appId) {
        DynamicObject[] dynamicObjectArray;
        List forQueryAppIds = PermFormCommonUtil.getAllExtAppId((String)appId);
        forQueryAppIds.add(appId);
        String algoKeyPrefix = this.getClass().getName() + ".addEntityNode.";
        DataSet bizUnitRelFormDS = null;
        DataSet bizObjAppDS = null;
        DataSet entityDesignDS = null;
        DataSet bizObjAppJoinEntityDesignDS = null;
        DataSet appEntDS = null;
        DataSet funcPermDS = null;
        DataSet appEntPermItemDS = null;
        DataSet appEntPermItemDS2 = null;
        DataSet cloudAppDS = null;
        DataSet entDS = null;
        DataSet finalDS = null;
        try {
            bizUnitRelFormDS = this.getBizUniRelFormDs(algoKeyPrefix);
            bizObjAppDS = this.getBizObjAppDs(algoKeyPrefix);
            entityDesignDS = this.getEntityDesignDs(algoKeyPrefix);
            bizObjAppJoinEntityDesignDS = bizObjAppDS.join(entityDesignDS).on(ENTAPP_ENTNUM, ENT_NUM).select(new String[]{ENTAPP_APPID, ENT_ID}).finish();
            appEntDS = bizUnitRelFormDS.union(bizObjAppJoinEntityDesignDS);
            funcPermDS = this.getFuncPermDs(algoKeyPrefix);
            appEntPermItemDS = appEntDS.join(funcPermDS).on(BURF_FORMID, FUNCPERM_ENTID).select(new String[]{BURF_APPID}, new String[]{FUNCPERM_ENTID}).finish();
            StringBuilder sbEntSql = this.buildEntitySql();
            String appNumber = AppMetadataCache.getAppNumberById((String)appId);
            String formBlacklist = RunModeServiceHelper.getEntityNumFromBlacklist((String)appNumber);
            if (StringUtils.isNotEmpty((String)formBlacklist)) {
                sbEntSql.append(" AND entd.fnumber not in (").append(formBlacklist).append(')');
            }
            entDS = DB.queryDataSet((String)(algoKeyPrefix + ENT_DS), (DBRoute)DBRoute.meta, (String)sbEntSql.toString());
            appEntPermItemDS2 = appEntPermItemDS.join(entDS).on(FUNCPERM_ENTID, ENTD_ID).select(new String[]{BURF_APPID}, new String[]{ENTD_NUM, ENTD_ID}).finish();
            cloudAppDS = DB.queryDataSet((String)(algoKeyPrefix + CLOUD_APP_DS), (DBRoute)DBRoute.meta, (String)this.buildCloudAppSql4AddEntityNode(forQueryAppIds).toString());
            finalDS = appEntPermItemDS2.join(cloudAppDS).on(BURF_APPID, APP_ID).select(new String[]{BURF_APPID, ENTD_NUM, ENTD_ID}, new String[0]).finish();
            Iterator iterator = finalDS.iterator();
            HashSet<String> entityNumSet = new HashSet<String>(16);
            ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_entitytreecfg");
            HashSet<String> forBidIds = new HashSet<String>(16);
            HashSet<String> apps = new HashSet<String>(16);
            HashMap<String, List<String>> appEntity = new HashMap<String, List<String>>(16);
            EntityCtrlServiceHelper.queryEntityForBidInfo(forBidIds, apps, appEntity);
            EntityCtrlServiceHelper.getAllForBidEntityInApp(forBidIds, appEntity, appId);
            while (iterator.hasNext()) {
                Row next = (Row)iterator.next();
                String entityNum = next.getString(ENTD_NUM);
                if (entityNumSet.contains(entityNum)) continue;
                entityNumSet.add(entityNum);
                DynamicObject tmp = serviceHelper.generateEmptyDynamicObject();
                if (!this.matchByPermControl(entityNum) || forBidIds.contains(entityNum)) continue;
                tmp.set("number", (Object)entityNum);
                tmp.set("appid", (Object)next.getString(BURF_APPID));
                dynamicObjects.add(tmp);
            }
            DynamicObject[] dys = new DynamicObject[dynamicObjects.size()];
            dynamicObjectArray = dys = dynamicObjects.toArray(dys);
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, funcPermDS, bizObjAppJoinEntityDesignDS, appEntDS, appEntPermItemDS, appEntPermItemDS2, entDS, finalDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, funcPermDS, bizObjAppJoinEntityDesignDS, appEntDS, appEntPermItemDS, appEntPermItemDS2, entDS, finalDS});
        return dynamicObjectArray;
    }

    private boolean matchByPermControl(String entityNum) {
        PermissionControlType permControl = EntityMetadataCache.getPermissionControlType((String)entityNum);
        boolean isCtrlFunction = permControl.isControlFunction();
        String curDim = permControl.getDimension();
        String dimension = "DIM_ORG";
        if (StringUtils.isEmpty((String)curDim) || "DIM_NULL".equals(curDim)) {
            curDim = "DIM_ORG";
        }
        if (dimension.equals("bos_org")) {
            dimension = "DIM_ORG";
        } else if (dimension.equals("bcm_model")) {
            dimension = "DIM_BCM_MODEL";
        }
        return isCtrlFunction && ("DIM_NULL".equals(curDim) || curDim.equals(dimension));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> queryAppInCloud(String parentNodeId, String nodeId) {
        HashSet<String> hashSet;
        Map extAppAndOrgnlAppRel = PermFormCommonUtil.getExtAppAndOrgnlAppRel();
        String algoKeyPrefix = this.getClass().getName() + ".addAppNode.";
        DataSet bizUnitRelFormDS = null;
        DataSet bizObjAppDS = null;
        DataSet entityDesignDS = null;
        DataSet bizObjAppJoinEntityDesignDS = null;
        DataSet appEntDS = null;
        DataSet entDS = null;
        DataSet funcPermDS = null;
        DataSet appEntPermItemDS = null;
        DataSet appEntPermItemDS2 = null;
        DataSet cloudAppDS = null;
        DataSet finalDS = null;
        try {
            bizUnitRelFormDS = this.getBizUniRelFormDs(algoKeyPrefix);
            bizObjAppDS = this.getBizObjAppDs(algoKeyPrefix);
            entityDesignDS = this.getEntityDesignDs(algoKeyPrefix);
            bizObjAppJoinEntityDesignDS = bizObjAppDS.join(entityDesignDS).on(ENTAPP_ENTNUM, ENT_NUM).select(new String[]{ENTAPP_APPID, ENT_ID}).finish();
            String whereCondition = "";
            String appBlacklist = RunModeServiceHelper.getAppIdFromBlacklist();
            if (HRStringUtils.isNotEmpty((String)appBlacklist)) {
                whereCondition = whereCondition + " burf_appid not in (" + appBlacklist + ")";
            }
            appEntDS = bizUnitRelFormDS.union(bizObjAppJoinEntityDesignDS).where(whereCondition);
            funcPermDS = DB.queryDataSet((String)(algoKeyPrefix + FUNC_PERM_DS), (DBRoute)DBRoute.permission, (String)"select distinct  funcperm.FDENTITYTYPEID funcperm_entid from t_perm_functionperm funcperm  INNER JOIN t_perm_permitem  permitem ON permitem.FID = funcperm.FPERMITEMID ");
            appEntPermItemDS = appEntDS.join(funcPermDS).on(BURF_FORMID, FUNCPERM_ENTID).select(new String[]{BURF_APPID}, new String[]{FUNCPERM_ENTID}).finish();
            entDS = DB.queryDataSet((String)(algoKeyPrefix + ENT_DS), (DBRoute)DBRoute.meta, (String)"select entd.FID entd_id,  entd.fnumber entd_num  from t_meta_entitydesign  entd  where  entd.FISTEMPLATE = '0' AND entd.FTYPE = '0' ");
            appEntPermItemDS2 = appEntPermItemDS.join(entDS).on(FUNCPERM_ENTID, ENTD_ID).select(new String[]{BURF_APPID}, new String[]{ENTD_NUM}).finish();
            cloudAppDS = DB.queryDataSet((String)(algoKeyPrefix + CLOUD_APP_DS), (DBRoute)DBRoute.meta, (String)this.buildCloudAppSql4AddAppNode(nodeId).toString(), (Object[])new Object[]{parentNodeId});
            HashSet<String> appIdSet = new HashSet<String>(16);
            finalDS = appEntPermItemDS2.join(cloudAppDS).on(BURF_APPID, APP_ID).select(new String[]{ENTD_NUM}, new String[]{APP_ID, "app_industry"}).finish();
            while (finalDS.hasNext()) {
                Row row = finalDS.next();
                String appId = row.getString(APP_ID);
                if (appIdSet.contains(appId = (String)extAppAndOrgnlAppRel.get(appId))) continue;
                appIdSet.add(appId);
            }
            hashSet = appIdSet;
        }
        catch (Throwable throwable) {
            PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, bizObjAppJoinEntityDesignDS, appEntDS, funcPermDS, appEntPermItemDS, entDS, appEntPermItemDS2, cloudAppDS, finalDS});
            throw throwable;
        }
        PermCommonUtil.closeDataSet((DataSet[])new DataSet[]{bizUnitRelFormDS, bizObjAppDS, entityDesignDS, bizObjAppJoinEntityDesignDS, appEntDS, funcPermDS, appEntPermItemDS, entDS, appEntPermItemDS2, cloudAppDS, finalDS});
        return hashSet;
    }

    private StringBuilder buildCloudAppSql4AddAppNode(String nodeId) {
        String appIdBlackList;
        StringBuilder sb = new StringBuilder().append(" select app.fid app_id, app.fnumber app_num, app.findustry app_industry ").append(" from t_meta_bizapp  app ").append(" INNER JOIN t_meta_bizcloud  cloud ON (cloud.FID = app.FBIZCLOUDID) ").append(" WHERE NOT EXISTS (SELECT  1 FROM t_meta_appruntime appr ").append(" WHERE (app.fid = appr.fid OR app.fmasterid = appr.fid) ").append(" AND appr.falluserapp = '1') ").append(" AND app.fdeploystatus =  '2' ").append(" AND cloud.FID = ? ");
        if (StringUtils.isNotEmpty((String)nodeId)) {
            sb.append(" and app.fid = '").append(nodeId).append("' ");
        }
        if (StringUtils.isNotEmpty((String)(appIdBlackList = RunModeServiceHelper.getAppIdFromBlacklist()))) {
            sb.append(" and app.fid not in (").append(appIdBlackList).append(')');
        }
        return sb;
    }

    private DataSet getFuncPermDs(String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + FUNC_PERM_DS), (DBRoute)DBRoute.permission, (String)"select distinct funcperm.FDENTITYTYPEID  funcperm_entid from t_perm_functionperm funcperm  INNER JOIN t_perm_permitem permitem  ON permitem.FID = funcperm.FPERMITEMID ");
    }

    private DataSet getEntityDesignDs(String algoKeyPrefix) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_entitymeta");
        return helper.queryDataSet(algoKeyPrefix + ENTITY_DESIGN_DS, "id ent_id, number ent_num, name");
    }

    private DataSet getBizObjAppDs(String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + BIZ_OBJ_APP_DS), (DBRoute)DBRoute.permission, (String)"SELECT fbizappid entapp_appid, fbizobjid  entapp_entnum FROM t_perm_bizobjapp");
    }

    private DataSet getBizUniRelFormDs(String algoKeyPrefix) {
        return DB.queryDataSet((String)(algoKeyPrefix + BIZ_UNIT_REL_FORM_DS), (DBRoute)DBRoute.meta, (String)"SELECT fbizappid burf_appid,  fformid burf_formid FROM t_meta_bizunitrelform");
    }

    private StringBuilder buildCloudAppSql4AddEntityNode(List<String> forQueryAppIds) {
        StringBuilder sbCloudAppSql = new StringBuilder().append("select  app.fid app_id, app.fnumber app_num, app.findustry app_industry ").append(" from t_meta_bizapp app   ").append(" INNER JOIN t_meta_bizcloud cloud ON cloud.FID = app.FBIZCLOUDID   ");
        if (forQueryAppIds.size() > 0) {
            sbCloudAppSql.append(" AND app.FID in ").append((CharSequence)EntityCtrlServiceHelper.collectionToString(forQueryAppIds));
        }
        return sbCloudAppSql;
    }

    private StringBuilder buildEntitySql() {
        StringBuilder stringBuilder = new StringBuilder().append(" select entd.FID entd_id, entd.fnumber entd_num ").append(" from t_meta_entitydesign entd ").append(" where entd.FISTEMPLATE =  '0' ").append(" AND entd.FTYPE = '0' ");
        return stringBuilder;
    }
}

