/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.util;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.hr.ruleengine.enums.RuleOperatorEnum;
import kd.bos.ext.hr.ruleengine.infos.ConditionExpressInfo;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.util.RuleUtil;

public class RulePreviewUtil {
    private static final Log LOGGER = LogFactory.getLog(RulePreviewUtil.class);
    static List<String> replaceOptList = new ArrayList<String>(10);

    public static Map<String, String> getConditionPreviewMulLang(String conditions) {
        HashMap multiLangMap = Maps.newHashMapWithExpectedSize((int)16);
        if (StringUtils.isEmpty((CharSequence)conditions)) {
            return multiLangMap;
        }
        if (StringUtils.isEmpty((CharSequence)(conditions = RuleUtil.getNewestConditionValueForSave(conditions)))) {
            return multiLangMap;
        }
        RuleConditionInfo conditionInfo = (RuleConditionInfo)SerializationUtils.fromJsonString((String)conditions, RuleConditionInfo.class);
        List conditionList = conditionInfo.getConditionList();
        List conditionExpressList = conditionInfo.getConditionExpressList();
        Map<String, ConditionInfo> conditionInfoMap = conditionList.stream().collect(Collectors.toMap(ConditionInfo::getName, condition -> condition));
        if (!conditionExpressList.isEmpty()) {
            ConditionExpressInfo lastInfo = (ConditionExpressInfo)conditionExpressList.get(conditionExpressList.size() - 1);
            lastInfo.setLogical("");
        }
        Map<String, ILocaleString> opNameMap = RulePreviewUtil.getOpName();
        Map<String, ILocaleString> ruleParamName = RulePreviewUtil.getRuleParamName();
        InteServiceImpl intService = new InteServiceImpl();
        List enabledLangList = intService.getEnabledLang();
        for (EnabledLang enabledLang : enabledLangList) {
            String langNumber = enabledLang.getNumber();
            String ruleDescription = RulePreviewUtil.getRuleDescription(conditionExpressList, conditionInfoMap, opNameMap, ruleParamName, langNumber);
            multiLangMap.put(langNumber, ruleDescription);
        }
        return multiLangMap;
    }

    private static String getRuleDescription(List<ConditionExpressInfo> conditionExpressList, Map<String, ConditionInfo> conditionInfoMap, Map<String, ILocaleString> opNameMap, Map<String, ILocaleString> ruleParamNameMap, String langNumber) {
        LOGGER.info("Got rule description params conditionExpressList: {}, conditionInfoMap: {}, opNameMap: {}, ruleParamNameMap: {}, langNumber: {}.", new Object[]{conditionExpressList, conditionInfoMap, opNameMap, ruleParamNameMap, langNumber});
        StringBuilder previewSb = new StringBuilder();
        conditionExpressList.forEach(conditionExpressInfo -> {
            String logical;
            String displayValueStr;
            String leftBracket = conditionExpressInfo.getLeftBracket();
            if (HRStringUtils.isNotEmpty((String)leftBracket)) {
                previewSb.append(leftBracket).append(' ');
            }
            ConditionInfo info = (ConditionInfo)conditionInfoMap.get(conditionExpressInfo.getName());
            String ruleParamName = info.getDisplayParam();
            if (ruleParamNameMap.containsKey(info.getParam())) {
                ruleParamName = (String)((ILocaleString)ruleParamNameMap.get(info.getParam())).get((Object)langNumber);
            }
            previewSb.append(ruleParamName).append(' ');
            String displayValue = displayValueStr = info.getDisplayValue();
            if (HRStringUtils.isNotEmpty((String)displayValueStr)) {
                try {
                    displayValue = ((Map)SerializationUtils.fromJsonString((String)displayValueStr, Map.class)).getOrDefault(langNumber, "");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            displayValue = RulePreviewUtil.trimMaxLength(displayValue, 150);
            String operators = info.getOperators();
            if (RulePreviewUtil.isReplaceOpt(operators, langNumber)) {
                String content = RuleOperatorEnum.IS_OR_IS_SUB.getValue().equals(operators) ? String.format(Locale.ROOT, (String)ResManager.getLocaleString((String)"\u7b49\u4e8e\u6216\u8005\u662f%s\u7684\u4e0b\u7ea7", (String)"RulePreviewUtil_3", (String)"hrmp-hrcs-business").get((Object)langNumber), displayValue) : (HRStringUtils.equals((String)"containsub", (String)operators) ? ((String)((ILocaleString)opNameMap.get(operators)).getOrDefault((Object)langNumber, ((ILocaleString)opNameMap.get(operators)).getOrDefault((Object)"GLang", (Object)""))).replace("\u2026", displayValue) : Optional.ofNullable(RuleOperatorEnum.getEnum((String)operators)).map(RuleOperatorEnum::getName).orElse("").replace("...", displayValue));
                previewSb.append(content).append(' ');
            } else {
                previewSb.append((String)((ILocaleString)opNameMap.get(operators)).get((Object)langNumber)).append(' ');
                String value = displayValue;
                if (HRStringUtils.isNotEmpty((String)value)) {
                    previewSb.append(value).append(' ');
                }
            }
            String rightBracket = conditionExpressInfo.getRightBracket();
            if (HRStringUtils.isNotEmpty((String)rightBracket)) {
                previewSb.append(rightBracket).append(' ');
            }
            if (HRStringUtils.isNotEmpty((String)(logical = conditionExpressInfo.getLogical()))) {
                previewSb.append((String)RulePreviewUtil.getLogicLocaleStr(logical).get((Object)langNumber)).append(' ');
            }
        });
        return previewSb.toString();
    }

    public static String trimMaxLength(String str, int maxLength) {
        if (HRStringUtils.isEmpty((String)str)) {
            return str;
        }
        if (str.length() > maxLength) {
            return str.substring(0, maxLength - 3) + "...";
        }
        return str;
    }

    private static boolean isReplaceOpt(String opt, String langNumber) {
        return (Lang.zh_CN.name().equals(langNumber) || Lang.zh_TW.name().equals(langNumber)) && replaceOptList.contains(opt);
    }

    private static ILocaleString getLogicLocaleStr(String logic) {
        return HRStringUtils.equals((String)logic.trim(), (String)"and") ? ResManager.getLocaleString((String)"\u5e76\u4e14", (String)"RulePreviewUtil_1", (String)"hrmp-hrcs-business") : ResManager.getLocaleString((String)"\u6216\u8005", (String)"RulePreviewUtil_2", (String)"hrmp-hrcs-business");
    }

    private static Map<String, ILocaleString> getOpName() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dynaruleoperator");
        DynamicObject[] operatorDys = serviceHelper.query("number,name", null);
        return Arrays.stream(operatorDys).collect(Collectors.toMap(it -> it.getString("number"), it -> it.getLocaleString("name"), (newVal, oldVal) -> newVal));
    }

    private static Map<String, ILocaleString> getRuleParamName() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dynaruleparam");
        DynamicObject[] operatorDys = serviceHelper.query("id,name", null);
        return Arrays.stream(operatorDys).collect(Collectors.toMap(it -> it.getString("id"), it -> it.getLocaleString("name"), (newVal, oldVal) -> newVal));
    }

    static {
        replaceOptList.add(RuleOperatorEnum.IN.getValue());
        replaceOptList.add(RuleOperatorEnum.NOT_IN.getValue());
        replaceOptList.add(RuleOperatorEnum.IS_OR_IS_SUB.getValue());
        replaceOptList.add(RuleOperatorEnum.STARTS_WITH.getValue());
        replaceOptList.add(RuleOperatorEnum.ENDS_WITH.getValue());
        replaceOptList.add("containsub");
    }
}

