/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.util;

import com.alibaba.fastjson.JSONArray;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.org.OrgViewSchemeProp;
import kd.bos.ext.hr.ruleengine.enums.ParamTypeEnum;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections.MapUtils;

public class RuleUtil {
    private static Log LOGGER = LogFactory.getLog(RuleUtil.class);

    private static String getEntityNumber(String entityNumber, String field) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        DynamicProperty prop = (DynamicProperty)mainEntityType.getAllFields().get(field);
        if (prop instanceof OrgProp) {
            OrgProp orgProp = (OrgProp)prop;
            OrgViewSchemeProp orgViewScheme = orgProp.getOrgViewScheme();
            return orgProp.getBaseEntityId();
        }
        if (prop instanceof BasedataProp) {
            return ((BasedataProp)prop).getBaseEntityId();
        }
        if (prop instanceof MulBasedataProp) {
            return ((MulBasedataProp)prop).getBaseEntityId();
        }
        return entityNumber;
    }

    public static String getNewestConditionValue(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        try {
            RuleConditionInfo info = (RuleConditionInfo)SerializationUtils.fromJsonString((String)value, RuleConditionInfo.class);
            List conditionInfoList = info.getConditionList();
            if (null != conditionInfoList && conditionInfoList.size() > 0) {
                for (ConditionInfo conditionInfo : conditionInfoList) {
                    boolean isDynamicObject = ParamTypeEnum.DYNAMICOBJECT.getValue().equals(conditionInfo.getParamType());
                    boolean isBasedata = ParamTypeEnum.BASEDATA.getValue().equals(conditionInfo.getParamType());
                    boolean isValue = "2".equals(conditionInfo.getValueType());
                    boolean isTarget = "3".equals(conditionInfo.getValueType());
                    String conditionValue = conditionInfo.getValue();
                    if ((isDynamicObject || isBasedata) && isValue) {
                        QFilter filter;
                        DynamicProperty prop;
                        BasedataEntityType mainEntityType;
                        String objectId = conditionInfo.getObjectId();
                        String[] ids = null;
                        if (StringUtils.isNotEmpty((CharSequence)objectId)) {
                            ids = objectId.split(",");
                        } else if (StringUtils.isNotEmpty((CharSequence)conditionValue)) {
                            ids = conditionValue.split(",");
                        }
                        if (null == ids || ids.length == 0) continue;
                        String entityNumber = conditionInfo.getParam();
                        String[] entitys = entityNumber.split("\\.");
                        if (StringUtils.isNotEmpty((CharSequence)conditionInfo.getBaseDataNumber())) {
                            entityNumber = conditionInfo.getBaseDataNumber();
                        } else if (entitys.length == 6) {
                            entityNumber = RuleUtil.getEntityNumber(entitys[3], entitys[4]);
                        } else if (entitys.length == 5) {
                            mainEntityType = MetadataServiceHelper.getDataEntityType((String)entitys[1]);
                            prop = (DynamicProperty)mainEntityType.getAllFields().get(entitys[2]);
                            if (prop instanceof BasedataProp) {
                                entityNumber = ((BasedataProp)prop).getBaseEntityId();
                            } else if (prop instanceof MulBasedataProp) {
                                entityNumber = ((MulBasedataProp)prop).getBaseEntityId();
                            }
                            entityNumber = RuleUtil.getEntityNumber(entityNumber, entitys[3]);
                        } else if (entitys.length == 4) {
                            mainEntityType = MetadataServiceHelper.getDataEntityType((String)entitys[1]);
                            prop = (BasedataProp)mainEntityType.getAllFields().get(entitys[2]);
                            entityNumber = prop.getBaseEntityId();
                        } else {
                            entityNumber = entitys.length == 3 ? entitys[1] : entitys[0];
                        }
                        mainEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)entityNumber);
                        if (mainEntityType.getPrimaryKey() instanceof LongProp) {
                            List longIds = Arrays.stream(ids).map(Long::parseLong).collect(Collectors.toList());
                            filter = new QFilter("id", "in", longIds);
                        } else {
                            filter = new QFilter("id", "in", (Object)ids);
                        }
                        String name = mainEntityType.getNameProperty();
                        DynamicObjectCollection colls = QueryServiceHelper.query((String)entityNumber, (String)name, (QFilter[])new QFilter[]{filter});
                        if (null == colls || colls.isEmpty()) {
                            conditionInfo.setDisplayValue("");
                            conditionInfo.setValue("");
                            conditionInfo.setObjectId("");
                            conditionInfo.setObjectNumber("");
                            continue;
                        }
                        String displayValue = Joiner.on((String)",").join((Iterable)colls.stream().map(dy -> dy.getString(name)).collect(Collectors.toList()));
                        if (StringUtils.isEmpty((CharSequence)displayValue)) {
                            LOGGER.warn("displayValue is empty! {}", (Object)conditionInfo.toString());
                        }
                        conditionInfo.setDisplayValue(displayValue);
                        continue;
                    }
                    if (!isTarget) continue;
                    String[] ids = conditionValue.split(",");
                    List targetIds = Arrays.stream(ids).map(id -> Long.parseLong(id.substring(id.lastIndexOf("_") + 1))).collect(Collectors.toList());
                    DynamicObjectCollection colls = QueryServiceHelper.query((String)"brm_target", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", targetIds)});
                    String displayValue = Joiner.on((String)",").join((Iterable)colls.stream().map(dy -> dy.getString("name")).collect(Collectors.toList()));
                    conditionInfo.setDisplayValue(displayValue);
                }
            }
            return SerializationUtils.toJsonString((Object)info);
        }
        catch (Exception exception) {
            LOGGER.error("parse error!", (Throwable)exception);
            return value;
        }
    }

    public static String getNewestConditionValueForSave(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        try {
            RuleConditionInfo info = (RuleConditionInfo)SerializationUtils.fromJsonString((String)value, RuleConditionInfo.class);
            List conditionInfoList = info.getConditionList();
            if (null != conditionInfoList && conditionInfoList.size() > 0) {
                List<String> enumParamNums = conditionInfoList.stream().filter(it -> HRStringUtils.equals((String)ParamTypeEnum.MUL_ENUM.getValue(), (String)it.getValueDataType()) || HRStringUtils.equals((String)ParamTypeEnum.ENUM.getValue(), (String)it.getValueDataType())).map(it -> it.getDisplayParam()).collect(Collectors.toList());
                Map<String, Map<String, Map<String, String>>> allEnumParamInfo = RuleUtil.queryEnumParamInfo(enumParamNums);
                Map<String, Map<String, String>> booleanMul = RuleUtil.getBooleanMul();
                for (ConditionInfo conditionInfo : conditionInfoList) {
                    boolean isDynamicObject = ParamTypeEnum.DYNAMICOBJECT.getValue().equals(conditionInfo.getParamType());
                    boolean isBasedata = ParamTypeEnum.BASEDATA.getValue().equals(conditionInfo.getParamType());
                    boolean isValue = "2".equals(conditionInfo.getValueType());
                    boolean isTarget = "3".equals(conditionInfo.getValueType());
                    String conditionValue = conditionInfo.getValue();
                    String displayParam = conditionInfo.getDisplayParam();
                    String valueDataType = conditionInfo.getValueDataType();
                    if ((isDynamicObject || isBasedata) && isValue) {
                        QFilter filter;
                        DynamicProperty prop;
                        BasedataEntityType mainEntityType;
                        String objectId = conditionInfo.getObjectId();
                        String[] ids = null;
                        if (StringUtils.isNotEmpty((CharSequence)objectId)) {
                            ids = objectId.split(",");
                        } else if (StringUtils.isNotEmpty((CharSequence)conditionValue)) {
                            ids = conditionValue.split(",");
                        }
                        if (null == ids || ids.length == 0) continue;
                        String entityNumber = conditionInfo.getParam();
                        String[] entitys = entityNumber.split("\\.");
                        if (StringUtils.isNotEmpty((CharSequence)conditionInfo.getBaseDataNumber())) {
                            entityNumber = conditionInfo.getBaseDataNumber();
                        } else if (entitys.length == 6) {
                            entityNumber = RuleUtil.getEntityNumber(entitys[3], entitys[4]);
                        } else if (entitys.length == 5) {
                            mainEntityType = MetadataServiceHelper.getDataEntityType((String)entitys[1]);
                            prop = (DynamicProperty)mainEntityType.getAllFields().get(entitys[2]);
                            if (prop instanceof BasedataProp) {
                                entityNumber = ((BasedataProp)prop).getBaseEntityId();
                            } else if (prop instanceof MulBasedataProp) {
                                entityNumber = ((MulBasedataProp)prop).getBaseEntityId();
                            }
                            entityNumber = RuleUtil.getEntityNumber(entityNumber, entitys[3]);
                        } else if (entitys.length == 4) {
                            mainEntityType = MetadataServiceHelper.getDataEntityType((String)entitys[1]);
                            prop = (BasedataProp)mainEntityType.getAllFields().get(entitys[2]);
                            entityNumber = prop.getBaseEntityId();
                        } else {
                            entityNumber = entitys.length == 3 ? entitys[1] : entitys[0];
                        }
                        mainEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)entityNumber);
                        if (mainEntityType.getPrimaryKey() instanceof LongProp) {
                            List longIds = Arrays.stream(ids).map(Long::parseLong).collect(Collectors.toList());
                            filter = new QFilter("id", "in", longIds);
                        } else {
                            filter = new QFilter("id", "in", (Object)ids);
                        }
                        String name = mainEntityType.getNameProperty();
                        DynamicObject[] colls = BusinessDataServiceHelper.load((String)entityNumber, (String)name, (QFilter[])new QFilter[]{filter});
                        if (null == colls || colls.length == 0) {
                            conditionInfo.setDisplayValue("");
                            conditionInfo.setValue("");
                            conditionInfo.setObjectId("");
                            conditionInfo.setObjectNumber("");
                            continue;
                        }
                        Map<String, String> mulDisplayValueMap = RuleUtil.getMulDisplayValueMap(colls, "name");
                        if (MapUtils.isEmpty(mulDisplayValueMap)) {
                            LOGGER.warn("displayValue is empty! {}", (Object)conditionInfo.toString());
                        }
                        conditionInfo.setDisplayValue(JSONArray.toJSONString(mulDisplayValueMap));
                        continue;
                    }
                    if (isTarget) {
                        String[] ids = conditionValue.split(",");
                        List targetIds = Arrays.stream(ids).map(id -> Long.parseLong(id.substring(id.lastIndexOf("_") + 1))).collect(Collectors.toList());
                        DynamicObject[] colls = BusinessDataServiceHelper.load((String)"brm_target", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", targetIds)});
                        Map<String, String> mulDisplayValueMap = RuleUtil.getMulDisplayValueMap(colls, "name");
                        conditionInfo.setDisplayValue(JSONArray.toJSONString(mulDisplayValueMap));
                        continue;
                    }
                    if (enumParamNums.contains(displayParam)) {
                        Map<String, Map<String, String>> enumMap = allEnumParamInfo.get(displayParam);
                        Map<String, String> map = enumMap.get(conditionValue);
                        conditionInfo.setDisplayValue(JSONArray.toJSONString(map));
                        continue;
                    }
                    if (!HRStringUtils.equals((String)ParamTypeEnum.BOOLEAN.getValue(), (String)valueDataType)) continue;
                    Map<String, String> map = booleanMul.get(conditionValue);
                    conditionInfo.setDisplayValue(JSONArray.toJSONString(map));
                }
            }
            return SerializationUtils.toJsonString((Object)info);
        }
        catch (Exception exception) {
            LOGGER.error("parse error!", (Throwable)exception);
            return value;
        }
    }

    private static Map<String, String> getMulDisplayValueMap(DynamicObject[] colls, String name) {
        HashMap mulDisplayValueListMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject coll : colls) {
            ILocaleString localeString = coll.getLocaleString(name);
            for (Map.Entry entry : localeString.entrySet()) {
                String langType = (String)entry.getKey();
                String langValue = (String)entry.getValue();
                List valueList = mulDisplayValueListMap.computeIfAbsent(langType, it -> Lists.newArrayListWithExpectedSize((int)10));
                valueList.add(langValue);
            }
        }
        HashMap mulDisplayValueMap = Maps.newHashMapWithExpectedSize((int)mulDisplayValueListMap.size());
        for (Map.Entry entry : mulDisplayValueListMap.entrySet()) {
            String value = ((List)entry.getValue()).stream().collect(Collectors.joining(","));
            mulDisplayValueMap.put(entry.getKey(), value);
        }
        return mulDisplayValueMap;
    }

    private static Map<String, Map<String, String>> getBooleanMul() {
        LocaleString yesMul = ResManager.getLocaleString((String)"\u662f", (String)"RuleUtil_1", (String)"hrmp-hrcs-business");
        LocaleString noMul = ResManager.getLocaleString((String)"\u5426", (String)"RuleUtil_2", (String)"hrmp-hrcs-business");
        HashMap booleanMulMap = Maps.newHashMapWithExpectedSize((int)2);
        HashMap yesMap = Maps.newHashMapWithExpectedSize((int)yesMul.size());
        for (Map.Entry entry : yesMul.entrySet()) {
            yesMap.put(entry.getKey(), entry.getValue());
        }
        booleanMulMap.put("true", yesMap);
        HashMap noMap = Maps.newHashMapWithExpectedSize((int)noMul.size());
        for (Map.Entry entry : noMul.entrySet()) {
            noMap.put(entry.getKey(), entry.getValue());
        }
        booleanMulMap.put("false", noMap);
        return booleanMulMap;
    }

    private static Map<String, Map<String, Map<String, String>>> queryEnumParamInfo(List<String> enumParamNums) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dynaruleparam");
        DynamicObject[] ruleParamArr = serviceHelper.query("number,entryentity.value,entryentity.displayvalue", new QFilter[]{new QFilter("number", "in", enumParamNums)});
        LinkedHashMap enumInfos = Maps.newLinkedHashMapWithExpectedSize((int)enumParamNums.size());
        for (DynamicObject ruleParam : ruleParamArr) {
            String ruleNumber = ruleParam.getString("number");
            DynamicObjectCollection coll = ruleParam.getDynamicObjectCollection("entryentity");
            HashMap enumMulMap = Maps.newHashMapWithExpectedSize((int)coll.size());
            for (DynamicObject entryRow : coll) {
                String value = entryRow.getString("value");
                ILocaleString displayValue = entryRow.getLocaleString("displayvalue");
                HashMap displayValueMul = Maps.newHashMapWithExpectedSize((int)displayValue.size());
                for (Map.Entry entry : displayValue.entrySet()) {
                    displayValueMul.put(entry.getKey(), entry.getValue());
                }
                enumMulMap.put(value, displayValueMul);
            }
            enumInfos.put(ruleNumber, enumMulMap);
        }
        return enumInfos;
    }
}

