/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.webapi.esign;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.service.context.ServiceApiContext;
import kd.bos.util.CollectionUtils;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddCallBackService;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.enu.CallBackEventType;
import kd.hr.hrcs.bussiness.service.esign.util.CallBackUtil;
import kd.hr.hrcs.webapi.esign.constant.FddConst;
import org.apache.commons.lang3.ObjectUtils;

@ApiController(value="HRESignCallBack", desc="HR\u7535\u5b50\u7b7e\u56de\u8c03\u670d\u52a1")
@ApiMapping(value="/openapi/hresign/fdd")
public class HRESignCallBackController
implements FddConst {
    private static final Log LOGGER = LogFactory.getLog(HRESignCallBackController.class);
    private static final CustomApiResult<@ApiResponseBody String> success = CustomApiResult.success((Object)"{\"msg\":\"success\"}");
    private static final CustomApiResult<@ApiResponseBody String> fail = CustomApiResult.success((Object)"{\"msg\":\"fail\"}");

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @ApiPostMapping(value="/callBackService", desc="hrESign callBackService for fadada")
    public CustomApiResult<@ApiResponseBody String> fddEventCallback(@ApiParam(value="bizContent") @ApiParam(value="bizContent") String bizContent) {
        LOGGER.info("hrESign callBackService start");
        if (StringUtils.isBlank((CharSequence)bizContent)) {
            LOGGER.warn("bizContent is null");
            return success;
        }
        Map requestHeaders = ServiceApiContext.getRequest().getRequestHeaders();
        LOGGER.info("hrESign callBackService requestHeaders:{}", (Object)SerializationUtils.toJsonString((Object)requestHeaders));
        String appId = this.getHeadVal(requestHeaders, "X-FASC-App-Id");
        String signType = this.getHeadVal(requestHeaders, "X-FASC-Sign-Type");
        String sign = this.getHeadVal(requestHeaders, "X-FASC-Sign");
        String timestamp = this.getHeadVal(requestHeaders, "X-FASC-Timestamp");
        String nonce = this.getHeadVal(requestHeaders, "X-FASC-Nonce");
        String event = this.getHeadVal(requestHeaders, "X-FASC-Event");
        HashMap<String, String> paramMap = new HashMap<String, String>(6);
        paramMap.put("X-FASC-App-Id", appId);
        paramMap.put("X-FASC-Sign-Type", StringUtils.isNotBlank((CharSequence)signType) ? signType : "HMAC-SHA256");
        paramMap.put("X-FASC-Timestamp", timestamp);
        paramMap.put("X-FASC-Nonce", nonce);
        paramMap.put("X-FASC-Event", event);
        paramMap.put("bizContent", bizContent);
        LOGGER.info("hr\u7535\u5b50\u7b7e\u6cd5\u5927\u5927\u56de\u8c03\u670d\u52a1 reqParamMap={}", (Object)SerializationUtils.toJsonString(paramMap));
        if (!this.checkRequiredParams(paramMap, sign)) {
            return success;
        }
        if (StringUtils.isBlank((CharSequence)event)) {
            LOGGER.warn("reqParam[event] is null, please check param:{}", (Object)"X-FASC-Event");
            return success;
        }
        if ("notifyUrlVerify".equals(event)) {
            return success;
        }
        CallBackEventType callBackEventType = CallBackEventType.tranEnum((String)event);
        if (ObjectUtils.isEmpty((Object)callBackEventType)) {
            LOGGER.warn("invoke callBackEventType not yet supported, please confirm that it has been implemented:{}", (Object)"X-FASC-Event");
            return success;
        }
        FddCallBackService fddCallBackService = new FddCallBackService(paramMap, sign, timestamp, callBackEventType);
        if (!fddCallBackService.checkService()) {
            return fail;
        }
        @ApiResponseBody CustomApiResult res = CustomApiResult.success((Object)this.invoke(fddCallBackService));
        LOGGER.info("hrESign callBackService res{}", (Object)SerializationUtils.toJsonString((Object)res));
        LOGGER.info("hrESign callBackService end");
        return res;
    }

    private String invoke(FddCallBackService fddCallBackService) {
        CallBackEventType callBackEventType = fddCallBackService.getCallBackEventType();
        LOGGER.info("invoke callBackEventType={}", (Object)callBackEventType.getX_FASC_Event());
        String resultMsg = "";
        switch (callBackEventType) {
            case SIGN_TASK_FINISHED: {
                resultMsg = fddCallBackService.signTaskFinished();
                break;
            }
            case SIGN_TASK_SIGNED: {
                resultMsg = fddCallBackService.signTaskSigned();
                break;
            }
            case SIGN_TASK_SIGN_REJECTED: {
                resultMsg = fddCallBackService.signTaskSignReject();
                break;
            }
            case SIGN_TASK_SIGN_FAILED: {
                resultMsg = fddCallBackService.signTaskSignFailed();
                break;
            }
            case SEAL_VERIFY_SUCCESSED: 
            case SEAL_VERIFY_FAILED: {
                resultMsg = fddCallBackService.sealVerify();
                break;
            }
            case CORP_AUTHORIZE: {
                resultMsg = fddCallBackService.corporateAuth();
                break;
            }
            case SEAL_AUTHORIZE_FREE_SIGN: {
                resultMsg = fddCallBackService.sealAuthorizeFreeSign();
                break;
            }
            case SIGN_TASK_CANCELED: {
                resultMsg = fddCallBackService.cancelTask();
                break;
            }
            case SIGN_TASK_ABOLISH: {
                resultMsg = fddCallBackService.abolishTask();
                break;
            }
            default: {
                LOGGER.info("hrESign callBackService event:{} Not configured on [kd.hr.hrcs.webapi.esign.HRESignCallBackController.EventType], please cofug", (Object)callBackEventType.getX_FASC_Event());
                resultMsg = "{\"msg\":\"success\"}";
            }
        }
        CallBackUtil.updateInvokeSucess((CallBackEventType)callBackEventType, (Map)fddCallBackService.getParamMap());
        return resultMsg;
    }

    private String getHeadVal(Map<String, String> requestHeaders, String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return "";
        }
        String headVal = requestHeaders.get(key);
        if (StringUtils.isBlank((CharSequence)headVal)) {
            headVal = requestHeaders.get(key.toLowerCase(Locale.ROOT));
        }
        return headVal;
    }

    private boolean checkRequiredParams(Map<String, String> paramMap, String sign) {
        ArrayList<String> paramErrList = new ArrayList<String>(6);
        for (Map.Entry<String, String> param : paramMap.entrySet()) {
            String key = param.getKey();
            String value = param.getValue();
            if (!StringUtils.isBlank((CharSequence)value)) continue;
            paramErrList.add("required parameter[" + key + "] is null");
        }
        if (StringUtils.isBlank((CharSequence)sign)) {
            paramErrList.add("required parameter[sign] is null");
        }
        if (CollectionUtils.isNotEmpty(paramErrList)) {
            LOGGER.warn(String.join((CharSequence)",", paramErrList));
            return false;
        }
        return true;
    }
}

