/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.common.constants.perm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.list.JoinProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRPermCommonUtil {
    public static QFilter getQFilterFromFilterCondition(String entityNum, String ruleJsonStr) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)ruleJsonStr, FilterCondition.class);
        return HRPermCommonUtil.getQFilterFromFilterCondition(entityType, fc);
    }

    public static QFilter getQFilterFromFilterCondition(MainEntityType entityType, FilterCondition fc) {
        FilterBuilder builder = new FilterBuilder(entityType, fc);
        builder.setUserService((IUserService)new UserService());
        builder.buildFilter();
        QFilter resultFilter = builder.getQFilter();
        return resultFilter;
    }

    public static void removeExtraColumn(List<Map<String, Object>> filterColumns, MainEntityType entityType) {
        Map allFields = entityType.getAllFields();
        Iterator<Map<String, Object>> iter = filterColumns.iterator();
        while (iter.hasNext()) {
            IDataEntityProperty dataEntityProperty;
            String alias;
            Map<String, Object> map = iter.next();
            String fieldName = (String)map.get("fieldName");
            if (fieldName.indexOf(46) != -1) {
                fieldName = fieldName.split("\\.")[0];
            }
            if (!HRStringUtils.isEmpty((String)(alias = (dataEntityProperty = (IDataEntityProperty)allFields.get(fieldName)).getAlias()))) continue;
            iter.remove();
        }
    }

    @Deprecated
    public static QFilter convertQFilter(String entityNum, QFilter srcQFilter) {
        HashMap<String, QFilter> convertRuleRowMap = new HashMap<String, QFilter>(16);
        return HRPermCommonUtil.convertQFilter(entityNum, srcQFilter, convertRuleRowMap);
    }

    @Deprecated
    public static QFilter convertQFilter(String entityNum, QFilter srcQFilter, Map<String, QFilter> convertRuleRowMap) {
        if (srcQFilter == null) {
            return null;
        }
        String serializedQFilterStr = srcQFilter.toSerializedString();
        QFilter resultFromMap = convertRuleRowMap.get(serializedQFilterStr);
        if (resultFromMap != null) {
            return resultFromMap;
        }
        HashMap entityTypeInfo = new HashMap(16);
        QFilter resultQFilter = srcQFilter.trans(qFilter -> {
            QFilter hasConvertQFilter = (QFilter)convertRuleRowMap.get(qFilter.toSerializedString());
            if (hasConvertQFilter != null) {
                return hasConvertQFilter;
            }
            String propKey = qFilter.getProperty();
            String[] propPartArr = propKey.split("\\.");
            if (propPartArr.length == 1) {
                return qFilter;
            }
            MainEntityType entityType = (MainEntityType)entityTypeInfo.get(entityNum);
            if (entityType == null) {
                entityType = EntityMetadataCache.getDataEntityType((String)entityNum);
                entityTypeInfo.put(entityNum, entityType);
            }
            qFilter = HRPermCommonUtil.handleDyProp(qFilter, entityType, propPartArr, convertRuleRowMap);
            return qFilter;
        });
        convertRuleRowMap.put(serializedQFilterStr, resultQFilter);
        return resultQFilter;
    }

    private static QFilter handleDyProp(QFilter qFilter, MainEntityType entityType, String[] propPartArr, Map<String, QFilter> convertRuleRowMap) {
        DynamicProperty dyProp = entityType.getProperty(propPartArr[0]);
        if (dyProp instanceof JoinProperty) {
            JoinProperty jp = (JoinProperty)dyProp;
            String subEntNum = jp.getName();
            String subEntPropKey = qFilter.getProperty();
            if (subEntPropKey.indexOf(46) == -1) {
                return qFilter;
            }
            String newSubEntPropKey = subEntPropKey.substring(subEntPropKey.indexOf(46) + 1);
            qFilter = new QFilter(newSubEntPropKey, qFilter.getCP(), qFilter.getValue());
            qFilter = HRPermCommonUtil.convertQFilter(subEntNum, qFilter, convertRuleRowMap);
            qFilter = new QFilter(subEntNum + "." + qFilter.getProperty(), qFilter.getCP(), qFilter.getValue());
        } else {
            QFilter returnQFilter;
            if (dyProp instanceof BasedataProp) {
                return HRPermCommonUtil.propCollapse(null, convertRuleRowMap, qFilter, propPartArr, dyProp);
            }
            if (dyProp instanceof EntryProp && (returnQFilter = HRPermCommonUtil.getqFilter(convertRuleRowMap, qFilter, propPartArr, dyProp = ((EntryProp)dyProp).getDynamicCollectionItemPropertyType().getProperty(propPartArr[1]))) != null) {
                return returnQFilter;
            }
        }
        return qFilter;
    }

    private static QFilter getqFilter(Map<String, QFilter> convertRuleRowMap, QFilter qfilter, String[] propPartArr, DynamicProperty dyProp) {
        if (dyProp instanceof BasedataProp && propPartArr.length >= 3) {
            BasedataProp bdProp = (BasedataProp)dyProp;
            String baseEntityId = bdProp.getBaseEntityId();
            QFilter bdPropInEntry = null;
            MainEntityType subEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
            DynamicProperty subEntProp = subEntityType.getProperty(propPartArr[2]);
            bdPropInEntry = subEntProp instanceof BasedataProp ? HRPermCommonUtil.propCollapse(null, convertRuleRowMap, qfilter, new String[]{propPartArr[1], propPartArr[2], propPartArr[3]}, dyProp) : (subEntProp instanceof EntryProp ? HRPermCommonUtil.propCollapse(null, convertRuleRowMap, qfilter, new String[]{propPartArr[1], propPartArr[2], propPartArr[3], propPartArr[4]}, dyProp) : HRPermCommonUtil.propCollapse(null, convertRuleRowMap, qfilter, new String[]{propPartArr[1], propPartArr[2]}, dyProp));
            QFilter returnQFilter = new QFilter(propPartArr[0] + "." + bdPropInEntry.getProperty(), "in", bdPropInEntry.getValue());
            convertRuleRowMap.put(qfilter.toSerializedString(), returnQFilter);
            return returnQFilter;
        }
        return null;
    }

    private static QFilter propCollapse(String baseEntityNum, Map<String, QFilter> convertRuleRowMap, QFilter qFilter, String[] propPartArr, DynamicProperty dyProp) {
        if (propPartArr.length > 2) {
            return HRPermCommonUtil.handleMoreThanTwoLevel(convertRuleRowMap, dyProp, qFilter, propPartArr);
        }
        if (HRStringUtils.isEmpty((String)baseEntityNum)) {
            baseEntityNum = ((BasedataProp)dyProp).getBaseEntityId();
        }
        return HRPermCommonUtil.handleLessLevel(convertRuleRowMap, qFilter, propPartArr, baseEntityNum);
    }

    private static QFilter handleMoreThanTwoLevel(Map<String, QFilter> convertRuleRowMap, DynamicProperty dyProp, QFilter qFilter, String[] propPartArr) {
        QFilter resultFilter = qFilter;
        if (dyProp instanceof BasedataProp) {
            DynamicProperty subProp;
            String baseEntityNum = ((BasedataProp)dyProp).getBaseEntityId();
            String propKey0 = propPartArr[0];
            String propKey1 = propPartArr[1];
            String propKey2 = propPartArr[2];
            String propKey3 = "";
            if (propPartArr.length > 3) {
                propKey3 = propPartArr[3];
            }
            if ((subProp = EntityMetadataCache.getDataEntityType((String)baseEntityNum).getProperty(propKey1)) instanceof BasedataProp) {
                resultFilter = HRPermCommonUtil.handleBaseDataProp(baseEntityNum, convertRuleRowMap, qFilter, propKey0, propKey1, propKey2, subProp);
            } else if (subProp instanceof EntryProp) {
                resultFilter = HRPermCommonUtil.handleEntryProp(baseEntityNum, convertRuleRowMap, qFilter, dyProp, propKey0, propKey1, propKey2, propKey3, (EntryProp)subProp);
            } else {
                return qFilter;
            }
        }
        return resultFilter;
    }

    private static QFilter handleLessLevel(Map<String, QFilter> convertRuleRowMap, QFilter qFilter, String[] propPartArr, String baseEntityNum) {
        QFilter returnQFilter;
        if (qFilter.getCP().equals("<>") || qFilter.getCP().equals("!=")) {
            QFilter newQ = new QFilter(propPartArr[1], "=", qFilter.getValue());
            DynamicObjectCollection doc = QueryServiceHelper.query((String)baseEntityNum, (String)"id", (QFilter[])new QFilter[]{newQ});
            ArrayList<Object> ids = new ArrayList<Object>();
            for (DynamicObject dObj : doc) {
                ids.add(dObj.get("id"));
            }
            returnQFilter = new QFilter(propPartArr[0], "not in", ids);
        } else if (qFilter.getCP().equals("=") && qFilter.getValue() instanceof QEmptyValue) {
            returnQFilter = new QFilter(propPartArr[0], "=", (Object)QEmptyValue.value);
        } else if (qFilter.getCP().equalsIgnoreCase("not in")) {
            List ids = QueryServiceHelper.query((String)baseEntityNum, (String)"id", (QFilter[])new QFilter[]{new QFilter(propPartArr[1], "in", qFilter.getValue())}).stream().map(dyo -> dyo.get("id")).collect(Collectors.toList());
            returnQFilter = new QFilter(propPartArr[0], "not in", ids);
        } else {
            QFilter newQ = new QFilter(propPartArr[1], qFilter.getCP(), qFilter.getValue());
            DynamicObjectCollection doc = QueryServiceHelper.query((String)baseEntityNum, (String)"id", (QFilter[])new QFilter[]{newQ});
            ArrayList<Object> ids = new ArrayList<Object>();
            for (DynamicObject dObj : doc) {
                ids.add(dObj.get("id"));
            }
            returnQFilter = new QFilter(propPartArr[0], "in", ids);
        }
        convertRuleRowMap.put(qFilter.toSerializedString(), returnQFilter);
        return returnQFilter;
    }

    private static QFilter handleEntryProp(String baseEntityNum, Map<String, QFilter> convertRuleRowMap, QFilter qFilter, DynamicProperty dyProp, String propKey0, String propKey1, String propKey2, String propKey3, EntryProp subProp) {
        DynamicProperty thirdProp = subProp.getDynamicCollectionItemPropertyType().getProperty(propKey2);
        String thirdBaseDataEntityNum = ((BasedataProp)thirdProp).getBaseEntityId();
        DynamicProperty lastProp = EntityMetadataCache.getDataEntityType((String)thirdBaseDataEntityNum).getProperty(propKey3);
        QFilter resultFilter = new QFilter(propKey2 + "." + propKey3, qFilter.getCP(), qFilter.getValue());
        resultFilter = HRPermCommonUtil.propCollapse(thirdBaseDataEntityNum, convertRuleRowMap, resultFilter, new String[]{propKey2, propKey3}, lastProp);
        resultFilter = new QFilter(propKey0 + "." + propKey2, resultFilter.getCP(), resultFilter.getValue());
        resultFilter = HRPermCommonUtil.propCollapse(baseEntityNum, convertRuleRowMap, resultFilter, new String[]{propKey0, propKey1 + "." + propKey2}, dyProp);
        return resultFilter;
    }

    private static QFilter handleBaseDataProp(String baseEntityNum, Map<String, QFilter> convertRuleRowMap, QFilter qFilter, String propKey0, String propKey1, String propKey2, DynamicProperty subProp) {
        String subBaseDataEntityNum = ((BasedataProp)subProp).getBaseEntityId();
        DynamicProperty thirdProp = EntityMetadataCache.getDataEntityType((String)subBaseDataEntityNum).getProperty(propKey2);
        QFilter resultFilter = new QFilter(propKey1 + "." + propKey2, qFilter.getCP(), qFilter.getValue());
        resultFilter = HRPermCommonUtil.propCollapse(subBaseDataEntityNum, convertRuleRowMap, resultFilter, new String[]{propKey1, propKey2}, thirdProp);
        resultFilter = new QFilter(propKey0 + "." + propKey1, resultFilter.getCP(), resultFilter.getValue());
        resultFilter = HRPermCommonUtil.propCollapse(baseEntityNum, convertRuleRowMap, resultFilter, new String[]{propKey0, propKey1}, subProp);
        return resultFilter;
    }

    public static QFilter qFilterAnd(QFilter qFilterOne, QFilter qFilterTwo) {
        if (qFilterOne == null) {
            return qFilterTwo;
        }
        if (qFilterTwo == null) {
            return qFilterOne;
        }
        if (HRStringUtils.equals((String)qFilterOne.toString(), (String)qFilterTwo.toString())) {
            return qFilterOne;
        }
        return qFilterOne.and(qFilterTwo);
    }

    public static QFilter qFilterOr(QFilter qFilterOne, QFilter qFilterTwo) {
        if (qFilterOne == null) {
            return qFilterTwo;
        }
        if (qFilterTwo == null) {
            return qFilterOne;
        }
        if (HRStringUtils.equals((String)qFilterOne.toString(), (String)qFilterTwo.toString())) {
            return qFilterOne;
        }
        if (HRStringUtils.equals((String)qFilterOne.getProperty(), (String)qFilterTwo.getProperty()) && HRStringUtils.equals((String)qFilterOne.getCP(), (String)"in") && HRStringUtils.equals((String)qFilterTwo.getCP(), (String)"in") && CollectionUtils.isEmpty((Collection)qFilterOne.getNests(false)) && CollectionUtils.isEmpty((Collection)qFilterTwo.getNests(false))) {
            Collection collOne = (Collection)qFilterOne.getValue();
            Collection collTwo = (Collection)qFilterTwo.getValue();
            if (Objects.nonNull(collOne) && Objects.nonNull(collTwo)) {
                collOne.addAll(collTwo);
                return new QFilter(qFilterOne.getProperty(), "in", (Object)collOne);
            }
        }
        return qFilterOne.or(qFilterTwo);
    }

    public static QFilter[] listToQFilters(List<QFilter> qFilterList) {
        if (CollectionUtils.isEmpty(qFilterList)) {
            return new QFilter[]{null};
        }
        QFilter[] qFilters = new QFilter[qFilterList.size()];
        int size = qFilterList.size();
        for (int i = 0; i < size; ++i) {
            qFilters[i] = qFilterList.get(i);
        }
        return qFilters;
    }
}

