/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.common.util;

import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.hr.hrcs.common.util.MyClassLoader;

public class CodeUtils {
    private static final ClassPool POOL = new ClassPool(true);

    private static void initPoolPackage(ClassPool pool, Set<String> importPackages) {
        HashSet packageNameSet = Sets.newHashSet();
        if (Objects.nonNull(importPackages)) {
            for (String packageName : importPackages) {
                if (!packageNameSet.add(packageName)) continue;
                pool.importPackage(packageName);
            }
        }
        packageNameSet.clear();
    }

    public static Optional<String> getImportCodeByClassType(String classType) {
        if ("Date".equals(classType) || "Date[]".equals(classType)) {
            return Optional.of("java.util.Date");
        }
        if ("BigDecimal".equals(classType) || "BigDecimal[]".equals(classType)) {
            return Optional.of("java.math.BigDecimal");
        }
        return Optional.empty();
    }

    public static void checkJavaFunctionCode(Class<?> classObj, String functionCode, Set<String> importCodes) {
        Method method = CodeUtils.getMethod(classObj, functionCode, importCodes);
        if (Objects.isNull(method)) {
            throw new KDBizException(ResManager.loadKDString((String)"Java\u4ee3\u7801\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u67e5\u662f\u5426\u5b58\u5728\u8bed\u6cd5\u7cd6\u6216\u5176\u4ed6\u8bed\u6cd5\u95ee\u9898\u3002", (String)"CodeUtils_0", (String)"hrmp-hrcs-common", (Object[])new Object[0]));
        }
    }

    public static Method getMethod(Class<?> classObj, String functionCode, Set<String> importCodes) throws KDBizException {
        ClassPool childPool = CodeUtils.getPool(importCodes);
        CtClass ctClass = null;
        try {
            childPool.insertClassPath((ClassPath)new ClassClassPath(classObj));
            ctClass = childPool.makeClass(classObj.getName() + "Impl", childPool.get(classObj.getName()));
            CtMethod ctMethod = CtNewMethod.make((String)functionCode, (CtClass)ctClass);
            ctClass.addMethod(ctMethod);
            Class clazz = ctClass.toClass((ClassLoader)new MyClassLoader(classObj.getClassLoader()), classObj.getProtectionDomain());
            Method method = clazz.getMethod(ctMethod.getName(), CodeUtils.getMethodParameterTypes(ctMethod));
            return method;
        }
        catch (ClassNotFoundException | NoSuchMethodException | CannotCompileException | NotFoundException e) {
            throw new KDBizException(e.getMessage());
        }
        catch (VerifyError e) {
            throw new KDBizException(ResManager.loadKDString((String)"Java\u4ee3\u7801\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u67e5\u662f\u5426\u5b58\u5728\u8bed\u6cd5\u7cd6\u6216\u5176\u4ed6\u8bed\u6cd5\u95ee\u9898\u3002", (String)"CodeUtils_0", (String)"hrmp-hrcs-common", (Object[])new Object[0]));
        }
        finally {
            if (Objects.nonNull(ctClass)) {
                ctClass.detach();
                ctClass.defrost();
            }
        }
    }

    private static Class<?>[] getMethodParameterTypes(CtMethod ctMethod) throws NotFoundException, ClassNotFoundException {
        CtClass[] parameterTypes = ctMethod.getParameterTypes();
        if (Objects.nonNull(parameterTypes)) {
            Class[] parameterClasses = new Class[parameterTypes.length];
            for (int index = 0; index < parameterTypes.length; ++index) {
                CtClass parameterType = parameterTypes[index];
                parameterClasses[index] = parameterType.isArray() ? Array.newInstance(Class.forName(parameterType.getComponentType().getName()), 0).getClass() : Class.forName(parameterType.getName());
            }
            return parameterClasses;
        }
        return null;
    }

    private static ClassPool getPool(Set<String> importCodes) {
        ClassPool childPool = new ClassPool(POOL);
        CodeUtils.initPoolPackage(childPool, importCodes);
        return childPool;
    }
}

