/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.query.QueryEntityTreeBuildParameter;
import kd.bos.designer.query.QueryEntityTreeNode;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.StringUtils;

public class EntityFieldTreeUtil {
    private static final Log LOGGER = LogFactory.getLog(EntityFieldTreeUtil.class);

    public static TreeNode buildBillTreeNodes(QueryEntityTreeBuildParameter parameter, boolean isShowId, String val, String entryNumber) {
        MainEntityType mainType = parameter.getMainType();
        TreeNode billNode = new TreeNode("", mainType.getName() + val, mainType.getDisplayName().toString());
        billNode.setIsOpened(!isShowId);
        List<TreeNode> fldNodes = EntityFieldTreeUtil.buildFldTreeNodes(parameter, isShowId);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        for (TreeNode node : fldNodes) {
            nodeMap.put(node.getId(), node);
        }
        if (HRStringUtils.isNotEmpty((String)entryNumber)) {
            List<TreeNode> entryNodes = EntityFieldTreeUtil.buildEntryFldRefPropNodes(mainType, null, null, billNode, mainType.getName(), parameter.isDynamicText(), isShowId, entryNumber);
            billNode.addChildren(entryNodes);
        } else {
            TreeNode entityNode = new TreeNode(mainType.getName(), mainType.getName() + "billhead", ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"EntityFieldTreeUtil_0", (String)"hrmp-hrcs-common", (Object[])new Object[0]));
            entityNode.setIsOpened(true);
            if (isShowId) {
                TreeNode idNode = new TreeNode(mainType.getName(), mainType.getName() + ".id", "id");
                entityNode.addChild(idNode);
            }
            List<TreeNode> refNodes = EntityFieldTreeUtil.buildBDFldRefPropNodes(mainType, null, null, billNode, mainType.getName(), parameter.isDynamicText(), isShowId);
            entityNode.addChildren(refNodes);
            billNode.addChild(entityNode);
        }
        for (TreeNode node : fldNodes) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(billNode.getId());
                billNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return billNode;
    }

    public static TreeNode buildFieldTreeNodes(QueryEntityTreeBuildParameter parameter, String val, String activityid, String propertyType, List<String> targetFieldList) {
        MainEntityType mainType = parameter.getMainType();
        TreeNode billNode = new TreeNode("", mainType.getName() + val + "$" + activityid, mainType.getDisplayName().toString());
        billNode.setIsOpened(true);
        List<TreeNode> fldNodes = EntityFieldTreeUtil.buildFldTreeNodes(parameter, activityid, propertyType);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        for (TreeNode node : fldNodes) {
            nodeMap.put(node.getId(), node);
        }
        TreeNode entityNode = new TreeNode(mainType.getName(), mainType.getName() + "billhead", ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"EntityFieldTreeUtil_0", (String)"hrmp-hrcs-common", (Object[])new Object[0]));
        entityNode.setIsOpened(true);
        List<TreeNode> entryNodes = EntityFieldTreeUtil.buildEntryFldRefPropNodes(mainType, null, null, billNode, mainType.getName(), parameter.isDynamicText(), false);
        List<TreeNode> refNodes = EntityFieldTreeUtil.buildBDFieldPropNodes(mainType, null, null, billNode, mainType.getName(), parameter.isDynamicText(), activityid, propertyType, targetFieldList);
        entityNode.addChildren(refNodes);
        entityNode.addChildren(entryNodes);
        billNode.addChild(entityNode);
        for (TreeNode node : fldNodes) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(billNode.getId());
                billNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return billNode;
    }

    public static List<TreeNode> buildFldTreeNodes(QueryEntityTreeBuildParameter parameter, boolean isShowId) {
        List queryChildEntityList;
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        MainEntityType mainType = parameter.getMainType();
        ArrayList<TreeNode> entityFldNodes = new ArrayList<TreeNode>();
        if (parameter.getQueryEntityList() != null && (queryChildEntityList = ((QueryEntityTreeNode)parameter.getQueryEntityList().get(0)).getChildList()) != null) {
            for (QueryEntityTreeNode queryEntityTreeNode : queryChildEntityList) {
                MainEntityType queryentityType = EntityMetadataCache.getDataEntityType((String)queryEntityTreeNode.getEntityNumber());
                TreeNode queryentityNode = new TreeNode(((QueryEntityTreeNode)parameter.getQueryEntityList().get(0)).getEntityAlias(), queryEntityTreeNode.getEntityAlias(), queryentityType.getDisplayName().toString());
                entityFldNodes.add(queryentityNode);
                TreeNode entityNode = new TreeNode(queryEntityTreeNode.getEntityAlias(), queryEntityTreeNode.getEntityAlias() + "billhead", ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"EntityFieldTreeUtil_0", (String)"hrmp-hrcs-common", (Object[])new Object[0]));
                entityNode.setIsOpened(false);
                List<TreeNode> entryNodes = EntityFieldTreeUtil.buildEntryFldRefPropNodes(queryentityType, null, null, queryentityNode, queryEntityTreeNode.getEntityAlias(), parameter.isDynamicText(), isShowId);
                List<TreeNode> refNodes = EntityFieldTreeUtil.buildBDFldRefPropNodes(queryentityType, null, null, queryentityNode, queryEntityTreeNode.getEntityAlias(), parameter.isDynamicText(), isShowId);
                if (isShowId) {
                    TreeNode idNode = new TreeNode(queryentityType.getName(), queryentityType.getName() + ".id", "id");
                    entityFldNodes.add(idNode);
                }
                if (refNodes.size() > 0) {
                    entityFldNodes.addAll(refNodes);
                }
                if (entryNodes.size() <= 0) continue;
                entityFldNodes.addAll(entryNodes);
            }
        }
        nodes.addAll(entityFldNodes);
        if (parameter.getQueryEntityList() != null && parameter.getQueryEntityList().size() > 1) {
            parameter.getQueryEntityList().remove(0);
            List<TreeNode> nextNodes = EntityFieldTreeUtil.buildFldTreeNodes(parameter, isShowId);
            nodes.addAll(nextNodes);
        }
        return nodes;
    }

    public static List<TreeNode> buildFldTreeNodes(QueryEntityTreeBuildParameter parameter, String activityid, String propertyType) {
        List queryChildEntityList;
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        MainEntityType mainType = parameter.getMainType();
        ArrayList<TreeNode> entityFldNodes = new ArrayList<TreeNode>();
        if (parameter.getQueryEntityList() != null && (queryChildEntityList = ((QueryEntityTreeNode)parameter.getQueryEntityList().get(0)).getChildList()) != null) {
            for (QueryEntityTreeNode queryEntityTreeNode : queryChildEntityList) {
                MainEntityType queryentityType = EntityMetadataCache.getDataEntityType((String)queryEntityTreeNode.getEntityNumber());
                TreeNode queryentityNode = new TreeNode(((QueryEntityTreeNode)parameter.getQueryEntityList().get(0)).getEntityAlias(), queryEntityTreeNode.getEntityAlias(), queryentityType.getDisplayName().toString());
                entityFldNodes.add(queryentityNode);
                TreeNode entityNode = new TreeNode(queryEntityTreeNode.getEntityAlias(), queryEntityTreeNode.getEntityAlias() + "billhead", ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"EntityFieldTreeUtil_0", (String)"hrmp-hrcs-common", (Object[])new Object[0]));
                entityNode.setIsOpened(false);
                List<TreeNode> entryNodes = EntityFieldTreeUtil.buildEntryFldRefPropNodes(queryentityType, null, null, queryentityNode, queryEntityTreeNode.getEntityAlias(), parameter.isDynamicText(), false);
                List<TreeNode> refNodes = EntityFieldTreeUtil.buildBDFieldPropNodes(queryentityType, null, null, queryentityNode, queryEntityTreeNode.getEntityAlias(), parameter.isDynamicText(), activityid, propertyType, null);
                if (refNodes.size() > 0) {
                    entityFldNodes.addAll(refNodes);
                }
                if (entryNodes.size() <= 0) continue;
                entityFldNodes.addAll(entryNodes);
            }
        }
        nodes.addAll(entityFldNodes);
        if (parameter.getQueryEntityList() != null && parameter.getQueryEntityList().size() > 1) {
            parameter.getQueryEntityList().remove(0);
            List<TreeNode> nextNodes = EntityFieldTreeUtil.buildFldTreeNodes(parameter, activityid, propertyType);
            nodes.addAll(nextNodes);
        }
        return nodes;
    }

    private static List<TreeNode> buildEntryFldRefPropNodes(MainEntityType bdType, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode bdFldNode, String prefix, boolean isDynamicText, boolean isShowId) {
        ArrayList<TreeNode> refNodes = new ArrayList<TreeNode>();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bdType.getName());
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            EntryProp entryProp;
            if (!(property instanceof EntryProp) || (entryProp = (EntryProp)property).getParent().getName() != dataEntityType.getName()) continue;
            IDataEntityType entryEntitytype = entryProp.getItemType();
            DataEntityPropertyCollection entryProperties = entryEntitytype.getProperties();
            TreeNode entityNode = new TreeNode(bdFldNode.getId(), prefix + "." + property.getName(), property.getDisplayName().toString());
            entityNode.setIsOpened(false);
            String prefixEntrty = prefix + "." + property.getName();
            for (IDataEntityProperty entryProperty : entryProperties) {
                String entryPropertyName = entryProperty.getName();
                if ("id".equals(entryPropertyName) || "seq".equals(entryPropertyName) || entryPropertyName.endsWith("_id") && entryProperty instanceof LongProp || !(entryProperty instanceof IFieldHandle) || ((IFieldHandle)entryProperty).isSysField() || StringUtils.isBlank((CharSequence)entryProperty.getAlias()) || !EntityFieldTreeUtil.isIncludeField(entryProperty).booleanValue() || entryProperty instanceof EntryProp) continue;
                TreeNode fldNode = EntityFieldTreeUtil.buildFldTreeNode(entryProperty, matchedProperty, matchedClassType, entityNode, prefixEntrty, isDynamicText);
                if (entryProperty instanceof BasedataProp) {
                    String prefix2;
                    BasedataProp bdProp2;
                    MainEntityType bdType2;
                    List<TreeNode> refNodes2;
                    if (fldNode == null) {
                        fldNode = EntityFieldTreeUtil.buildFldTreeNode(entryProperty, null, null, entityNode, prefixEntrty, isDynamicText);
                    }
                    if ((refNodes2 = EntityFieldTreeUtil.buildBDFldRefPropNodes(bdType2 = (MainEntityType)(bdProp2 = (BasedataProp)entryProperty).getComplexType(), matchedProperty, matchedClassType, fldNode, prefix2 = prefixEntrty + "." + entryProperty.getName(), isDynamicText, isShowId)).size() <= 0) continue;
                    fldNode.addChildren(refNodes2);
                    entityNode.addChild(fldNode);
                    continue;
                }
                if (fldNode == null) continue;
                entityNode.addChild(fldNode);
            }
            refNodes.add(entityNode);
        }
        return refNodes;
    }

    private static List<TreeNode> buildEntryFldRefPropNodes(MainEntityType bdType, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode bdFldNode, String prefix, boolean isDynamicText, boolean isShowId, String entryNumber) {
        ArrayList<TreeNode> refNodes = new ArrayList<TreeNode>();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)bdType.getName());
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof EntryProp)) continue;
            EntryProp entryProp = (EntryProp)property;
            if (!property.getName().equals(entryNumber) || entryProp.getParent().getName() != dataEntityType.getName()) continue;
            IDataEntityType entryEntitytype = entryProp.getItemType();
            DataEntityPropertyCollection entryProperties = entryEntitytype.getProperties();
            TreeNode entityNode = new TreeNode(bdFldNode.getId(), prefix + "." + property.getName(), property.getDisplayName().toString());
            entityNode.setIsOpened(false);
            String prefixEntrty = prefix + "." + property.getName();
            for (IDataEntityProperty entryProperty : entryProperties) {
                String entryPropertyName = entryProperty.getName();
                if ("id".equals(entryPropertyName) || "seq".equals(entryPropertyName) || entryPropertyName.endsWith("_id") && entryProperty instanceof LongProp || !(entryProperty instanceof IFieldHandle) || ((IFieldHandle)entryProperty).isSysField() || StringUtils.isBlank((CharSequence)entryProperty.getAlias()) || !EntityFieldTreeUtil.isIncludeField(entryProperty).booleanValue() || entryProperty instanceof EntryProp) continue;
                TreeNode fldNode = EntityFieldTreeUtil.buildFldTreeNode(entryProperty, matchedProperty, matchedClassType, entityNode, prefixEntrty, isDynamicText);
                if (entryProperty instanceof BasedataProp) {
                    String prefix2;
                    BasedataProp bdProp2;
                    MainEntityType bdType2;
                    List<TreeNode> refNodes2;
                    if (fldNode == null) {
                        fldNode = EntityFieldTreeUtil.buildFldTreeNode(entryProperty, null, null, entityNode, prefixEntrty, isDynamicText);
                    }
                    if ((refNodes2 = EntityFieldTreeUtil.buildBDFldRefPropNodes(bdType2 = (MainEntityType)(bdProp2 = (BasedataProp)entryProperty).getComplexType(), matchedProperty, matchedClassType, fldNode, prefix2 = prefixEntrty + "." + entryProperty.getName(), isDynamicText, isShowId)).size() <= 0) continue;
                    fldNode.addChildren(refNodes2);
                    entityNode.addChild(fldNode);
                    continue;
                }
                if (fldNode == null) continue;
                entityNode.addChild(fldNode);
            }
            refNodes.add(entityNode);
        }
        return refNodes;
    }

    private static Boolean isIncludeField(IDataEntityProperty entryProperty) {
        return entryProperty instanceof TextProp || entryProperty instanceof BasedataProp || entryProperty instanceof MuliLangTextProp;
    }

    private static List<TreeNode> buildBDFldRefPropNodes(MainEntityType bdType, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode bdFldNode, String prefix, boolean isDynamicText, boolean isShowId) {
        ArrayList<TreeNode> refNodes = new ArrayList<TreeNode>();
        if (!isShowId) {
            TreeNode idNode = new TreeNode(bdFldNode.getId(), prefix + ".id", "id");
            refNodes.add(idNode);
        }
        for (IDataEntityProperty property : bdType.getFields().values()) {
            if (!(property instanceof IFieldHandle) || ((IFieldHandle)property).isSysField() || StringUtils.isBlank((CharSequence)property.getAlias()) || !EntityFieldTreeUtil.isIncludeField(property).booleanValue() || property instanceof EntryProp || property instanceof MulBasedataProp) continue;
            TreeNode fldNode = EntityFieldTreeUtil.buildFldTreeNode(property, matchedProperty, matchedClassType, bdFldNode, prefix, isDynamicText);
            if (property instanceof BasedataProp) {
                if (fldNode == null) {
                    fldNode = EntityFieldTreeUtil.buildFldTreeNode(property, null, null, bdFldNode, prefix, isDynamicText);
                }
                BasedataProp bdProp2 = (BasedataProp)property;
                MainEntityType bdType2 = (MainEntityType)bdProp2.getComplexType();
                String prefix2 = prefix + "." + property.getName();
                if (bdType2 == null) continue;
                List<TreeNode> refNodes2 = EntityFieldTreeUtil.buildBDFldRefPropNodes(bdType2, matchedProperty, matchedClassType, fldNode, prefix2, isDynamicText, isShowId);
                if (refNodes2.size() > 0) {
                    fldNode.addChildren(refNodes2);
                }
                refNodes.add(fldNode);
                continue;
            }
            if (fldNode == null) continue;
            refNodes.add(fldNode);
        }
        return refNodes;
    }

    private static List<TreeNode> buildBDFieldPropNodes(MainEntityType bdType, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode bdFldNode, String prefix, boolean isDynamicText, String activityid, String propertyType, List<String> targetFieldList) {
        ArrayList<TreeNode> refNodes = new ArrayList<TreeNode>();
        for (IDataEntityProperty property : bdType.getFields().values()) {
            if (!(property instanceof IFieldHandle) || ((IFieldHandle)property).isSysField() || StringUtils.isBlank((CharSequence)property.getAlias()) || property instanceof EntryProp || property instanceof MulBasedataProp) continue;
            TreeNode fldNode = EntityFieldTreeUtil.buildFieldTreeNode(property, matchedProperty, matchedClassType, bdFldNode, prefix, isDynamicText, activityid);
            if (property instanceof BasedataProp) {
                String baseEntityId;
                if ("only".equals(propertyType) || !(baseEntityId = ((BasedataProp)property).getBaseEntityId()).equals(propertyType) && !"all".equals(propertyType)) continue;
                if (fldNode == null) {
                    fldNode = EntityFieldTreeUtil.buildFieldTreeNode(property, null, null, bdFldNode, prefix, isDynamicText, activityid);
                }
                BasedataProp bdProp2 = (BasedataProp)property;
                MainEntityType bdType2 = (MainEntityType)bdProp2.getComplexType();
                String prefix2 = prefix + "." + property.getName();
                if (bdType2 == null || EntityFieldTreeUtil.isSelectedField(targetFieldList, fldNode)) continue;
                refNodes.add(fldNode);
                continue;
            }
            String name = property.getPropertyType().getName();
            if (!name.equals(propertyType) && !"all".equals(propertyType) && !"only".equals(propertyType) || fldNode == null || EntityFieldTreeUtil.isSelectedField(targetFieldList, fldNode)) continue;
            refNodes.add(fldNode);
        }
        return refNodes;
    }

    private static boolean isSelectedField(List<String> targetFieldList, TreeNode fldNode) {
        try {
            String currentFieldName = EntityFieldTreeUtil.getCurrentFieldName(fldNode);
            if (CollectionUtils.isNotEmpty(targetFieldList) && targetFieldList.contains(currentFieldName)) {
                return true;
            }
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
        }
        return false;
    }

    private static String getCurrentFieldName(TreeNode fldNode) {
        String currNodeId;
        String currNode = currNodeId = fldNode.getId();
        if (currNodeId.contains("$")) {
            currNode = currNodeId.substring(0, currNodeId.indexOf("$"));
            currNode = currNode.substring(currNode.indexOf(".") + 1);
        }
        return currNode;
    }

    private static TreeNode buildFldTreeNode(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode parentNode, String prefix, boolean isDynamicText) {
        TreeNode fldNode = null;
        boolean isMatch = EntityFieldTreeUtil.isMatchType(fldProperty, matchedProperty, matchedClassType);
        DynamicProperty prop = (DynamicProperty)fldProperty;
        if (isMatch && prop != null) {
            String fullPropName;
            String fldNodeId = fullPropName = StringUtils.isBlank((CharSequence)prefix) ? prop.getName() : prefix + "." + prop.getName();
            if (isDynamicText) {
                fldNodeId = "{" + fullPropName + "}";
            }
            String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            fldNode = new TreeNode(parentNode.getId(), fldNodeId, fldNodeName);
            fldNode.setIsOpened(false);
        }
        return fldNode;
    }

    private static TreeNode buildFieldTreeNode(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType, TreeNode parentNode, String prefix, boolean isDynamicText, String activityid) {
        TreeNode fldNode = null;
        boolean isMatch = EntityFieldTreeUtil.isMatchType(fldProperty, matchedProperty, matchedClassType);
        DynamicProperty prop = (DynamicProperty)fldProperty;
        if (isMatch && prop != null) {
            String fullPropName;
            String fldNodeId = fullPropName = StringUtils.isBlank((CharSequence)prefix) ? prop.getName() : prefix + "." + prop.getName();
            if (isDynamicText) {
                fldNodeId = "{" + fullPropName + "}";
            }
            String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            fldNode = new TreeNode(parentNode.getId(), fldNodeId + "$" + activityid, fldNodeName);
            fldNode.setIsOpened(false);
        }
        return fldNode;
    }

    private static boolean isMatchType(IDataEntityProperty fldProperty, IDataEntityProperty matchedProperty, Class<?> matchedClassType) {
        boolean isMatch = true;
        if (matchedClassType != null && !matchedClassType.isInstance(fldProperty)) {
            isMatch = false;
        }
        if (matchedProperty != null) {
            if (matchedProperty instanceof BasedataProp) {
                if (!((BasedataProp)matchedProperty).isFromSampleMaster(fldProperty)) {
                    isMatch = false;
                }
            } else if (!matchedProperty.getClass().isInstance(fldProperty)) {
                isMatch = false;
            }
        }
        return isMatch;
    }

    public static String getDisplayNameContainsEntry(String rightProp, Boolean isEntityPrefix) {
        try {
            String localeValue;
            if (HRStringUtils.isEmpty((String)rightProp)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b57\u6bb5", (String)"TplVariableConfigPlugin_12", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
            String[] split = rightProp.split("\\.");
            if (split.length <= 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u89c4\u7684\u5b57\u6bb5\u3002", (String)"TplVariableConfigPlugin_18", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
            }
            int index = 1;
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)split[0]);
            String entityDisplayName = "";
            LocaleString entityLocaleString = dataEntityType.getDisplayName();
            if (null != entityLocaleString) {
                entityDisplayName = entityLocaleString.getLocaleValue();
            }
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)split[index]);
            if (split.length <= 1) {
                return entityDisplayName;
            }
            String displayName = null == iDataEntityProperty.getDisplayName() ? iDataEntityProperty.getName() : (localeValue = iDataEntityProperty.getDisplayName().getLocaleValue());
            if (split.length - 1 == index) {
                return displayName;
            }
            if (iDataEntityProperty instanceof EntryProp) {
                displayName = EntityFieldTreeUtil.entryEntity(split, index, displayName, iDataEntityProperty);
            } else if (iDataEntityProperty instanceof BasedataProp) {
                displayName = EntityFieldTreeUtil.baseDataEntity(split, index, displayName, iDataEntityProperty);
            }
            return displayName;
        }
        catch (Exception exception) {
            LOGGER.error((Throwable)exception);
            throw new KDBizException(exception.getMessage());
        }
    }

    private static String entryEntity(String[] split, int index, String displayName, IDataEntityProperty iDataEntityProperty) {
        DynamicObjectType dynamicCollectionItemPropertyType = ((EntryProp)iDataEntityProperty).getDynamicCollectionItemPropertyType();
        DynamicProperty property = dynamicCollectionItemPropertyType.getProperty(split[++index]);
        if (null == property.getDisplayName()) {
            displayName = displayName + "." + property.getName();
        } else {
            String localeValue = property.getDisplayName().getLocaleValue();
            displayName = displayName + "." + localeValue;
        }
        if (property instanceof EntryProp) {
            displayName = EntityFieldTreeUtil.entryEntity(split, index, displayName, (IDataEntityProperty)property);
        } else if (property instanceof BasedataProp) {
            displayName = EntityFieldTreeUtil.baseDataEntity(split, index, displayName, (IDataEntityProperty)property);
        }
        if (index == split.length - 1) {
            return displayName;
        }
        return displayName;
    }

    private static String baseDataEntity(String[] split, int index, String displayName, IDataEntityProperty iDataEntityProperty) {
        String baseEntityId = ((BasedataProp)iDataEntityProperty).getBaseEntityId();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        if (split.length == ++index) {
            return displayName;
        }
        IDataEntityProperty subEntityProperty = (IDataEntityProperty)properties.get((Object)split[index]);
        if (null == subEntityProperty.getDisplayName()) {
            displayName = displayName + "." + subEntityProperty.getName();
        } else {
            String localeValue = subEntityProperty.getDisplayName().getLocaleValue();
            displayName = displayName + "." + localeValue;
        }
        if (subEntityProperty instanceof EntryProp) {
            displayName = EntityFieldTreeUtil.entryEntity(split, index, displayName, subEntityProperty);
        } else if (subEntityProperty instanceof BasedataProp) {
            displayName = EntityFieldTreeUtil.baseDataEntity(split, index, displayName, subEntityProperty);
        }
        if (index == split.length - 1) {
            return displayName;
        }
        return displayName;
    }
}

