/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.common.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.hr.hbp.common.util.HRStringUtils;

public class FilterGridUtil {
    public static void refreshFilterGrid(IFormView view, String entityNum, String condition) {
        if (HRStringUtils.isEmpty((String)entityNum)) {
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        List filterColumns = EntityTypeUtil.getInstance().getFilterColumns((IDataEntityType)entityType);
        FilterGridUtil.removeExtraColumn(filterColumns, entityType);
        FilterGrid filterGrid = (FilterGrid)view.getControl("filtergridap");
        filterGrid.setEntityNumber(entityNum);
        filterGrid.setFilterColumns(filterColumns);
        if (HRStringUtils.isNotEmpty((String)condition)) {
            FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)condition, FilterCondition.class);
            filterGrid.SetValue(fc);
        }
        view.updateView("filtergridap");
    }

    private static void removeExtraColumn(List<Map<String, Object>> filterColumns, MainEntityType entityType) {
        Map allFields = entityType.getAllFields();
        Iterator<Map<String, Object>> iter = filterColumns.iterator();
        while (iter.hasNext()) {
            IDataEntityProperty dataEntityProperty;
            String alias;
            Map<String, Object> map = iter.next();
            String fieldName = (String)map.get("fieldName");
            if (fieldName.indexOf(46) != -1) {
                fieldName = fieldName.split("\\.")[0];
            }
            if (!HRStringUtils.isEmpty((String)(alias = (dataEntityProperty = (IDataEntityProperty)allFields.get(fieldName)).getAlias()))) continue;
            iter.remove();
        }
    }
}

