/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.common.util.function;

import com.google.common.collect.Lists;
import java.util.List;
import kd.hr.hbp.common.util.HRStringUtils;

public class FunctionCodeCheckUtils {
    private static final List<String> DB_KEY_WORDS = Lists.newArrayList((Object[])new String[]{"insert", "INSERT", "drop", "DROP", "delete", "DELETE", "update", "UPDATE", "alter", "ALTER", "grant", "GRANT", "revoke", "REVOKE", "create", "CREATE"});

    public static boolean checkIsLinuxExecProcess(String functionExp) {
        if (HRStringUtils.isEmpty((String)functionExp)) {
            return false;
        }
        if (functionExp.contains("Runtime.getRuntime()")) {
            return true;
        }
        if (functionExp.contains("new ProcessBuilder")) {
            return true;
        }
        if (functionExp.contains("OperatingSystemMXBean")) {
            return true;
        }
        if (functionExp.contains("ManagementFactory.getOperatingSystemMXBean")) {
            return true;
        }
        return functionExp.contains("execCommand");
    }

    public static boolean checkDBKey(String functionExp) {
        for (String dbKeyWord : DB_KEY_WORDS) {
            if (!functionExp.contains(dbKeyWord)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkJavaKeyMethod(String functionExp) {
        return functionExp.contains("System.exit");
    }
}

