/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.common.utils;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.user.UserService;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class DataRuleScriptUtil {
    public static String convertJsonToScript(MainEntityType entityType, String dataRuleJson) {
        if (HRStringUtils.isEmpty((String)dataRuleJson)) {
            return null;
        }
        FilterCondition fc = (FilterCondition)SerializationUtils.fromJsonString((String)dataRuleJson, FilterCondition.class);
        FilterBuilder builder = new FilterBuilder(entityType, fc);
        builder.setTimeService((ITimeService)new TimeService());
        builder.setUserService((IUserService)new UserService());
        builder.buildFilter();
        String[] buildFilterScript = builder.buildFilterScript();
        if (buildFilterScript == null || buildFilterScript.length == 0) {
            return null;
        }
        String dataRuleScript = buildFilterScript[0];
        return dataRuleScript;
    }

    public static String scriptAnd(String script1, String script2) {
        if (HRStringUtils.isEmpty((String)script1)) {
            return script2;
        }
        if (HRStringUtils.isEmpty((String)script2)) {
            return script1;
        }
        StringBuilder sb = new StringBuilder(" ( ");
        sb.append(script1).append(" and ").append(script2).append(" ) ");
        return sb.toString();
    }

    public static String scriptOr(String script1, String script2) {
        if (HRStringUtils.isEmpty((String)script1) || HRStringUtils.isEmpty((String)script2)) {
            return null;
        }
        StringBuilder sb = new StringBuilder(" ( ");
        sb.append(script1).append(" or ").append(script2).append(" ) ");
        return sb.toString();
    }

    public static String convertInQFiltet2Script(QFilter qFilter, String propType, String entityNumber) {
        if (qFilter == null) {
            return null;
        }
        if (!HRStringUtils.equals((String)qFilter.getCP(), (String)"in") || CollectionUtils.isNotEmpty((Collection)qFilter.getNests(true))) {
            return null;
        }
        String scriptPropKey = qFilter.getProperty();
        if (DataRuleScriptUtil.isBasedataProp(entityNumber, scriptPropKey)) {
            scriptPropKey = qFilter.getProperty() + ".id";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("( ");
        sb.append(scriptPropKey).append(" in (");
        Set ids = (Set)qFilter.getValue();
        StringJoiner joiner = new StringJoiner(", ");
        if (HRStringUtils.equalsIgnoreCase((String)propType, (String)"string") && CollectionUtils.isNotEmpty((Collection)ids)) {
            joiner = new StringJoiner("', '", "'", "'");
        }
        for (Object id : ids) {
            joiner.add(id.toString());
        }
        sb.append(joiner.toString());
        sb.append(") )");
        return sb.toString();
    }

    private static boolean isBasedataProp(String entityNumber, String scriptPropKey) {
        if (!scriptPropKey.contains(".")) {
            String firstEntityTypeNumber = DataRuleScriptUtil.getBaseEntityId(entityNumber, scriptPropKey);
            return !HRStringUtils.isEmpty((String)firstEntityTypeNumber);
        }
        String[] scriptPropKeyArr = scriptPropKey.split("\\.");
        if (scriptPropKeyArr.length == 2) {
            String firstEntityTypeNumber = DataRuleScriptUtil.getBaseEntityId(entityNumber, scriptPropKeyArr[0]);
            if (HRStringUtils.isEmpty((String)firstEntityTypeNumber)) {
                return false;
            }
            String secondEntityTypeNumber = DataRuleScriptUtil.getBaseEntityId(firstEntityTypeNumber, scriptPropKeyArr[1]);
            return !HRStringUtils.isEmpty((String)secondEntityTypeNumber);
        }
        return false;
    }

    private static String getBaseEntityId(String entityNumber, String propKey) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map entityMap = entityType.getAllFields();
        IDataEntityProperty property = (IDataEntityProperty)entityMap.get(propKey);
        if (property instanceof BasedataProp) {
            BasedataProp bdProp = (BasedataProp)property;
            return bdProp.getBaseEntityId();
        }
        return null;
    }
}

