/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.common.utils;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.util.DisCardUtil;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HRHttpClientUtils
extends HttpClientUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(HRHttpClientUtils.class);
    private static int default_connectionTimeout = Integer.getInteger("httpclient.connectionTimeout", 3000);
    private static int default_readTimeout = Integer.getInteger("httpclient.readTimeout", 5000);
    private static String SCHEME_HTTPS = "https";
    private static Boolean mstTls12 = Boolean.parseBoolean(System.getProperty("httpclient.tsl12.enable"));

    private static HttpClient createHttpClient(int connectionTimeout, int readTimeout) {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(connectionTimeout).setSocketTimeout(readTimeout).build();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        return client;
    }

    public static String post(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        return HRHttpClientUtils.post(url, header, body, default_connectionTimeout, default_readTimeout);
    }

    public static String post(String url, Map<String, String> header, Map<String, Object> body, int connectionTimeout, int readTimeout) throws IOException {
        String data = "";
        HttpClient client = null;
        HttpPost post = new HttpPost(url);
        URI uri = post.getURI();
        if (SCHEME_HTTPS.equals(uri.getScheme())) {
            client = HRHttpClientUtils.wrapperHttpClient((int)connectionTimeout, (int)readTimeout);
            if (client == null) {
                return data;
            }
        } else {
            client = HRHttpClientUtils.createHttpClient(connectionTimeout, readTimeout);
            HttpClientParams.setCookiePolicy((HttpParams)client.getParams(), (String)"compatibility");
        }
        try {
            HttpResponse response;
            if (header != null && header.size() != 0) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    post.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if (body != null && body.size() != 0) {
                ArrayList params = Lists.newArrayListWithCapacity((int)16);
                for (Map.Entry<String, Object> entry : body.entrySet()) {
                    params.add(new BasicNameValuePair(entry.getKey(), (String)entry.getValue()));
                }
                UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity((List)params, "UTF-8");
                post.setEntity((HttpEntity)urlEncodedFormEntity);
            }
            if ((response = client.execute((HttpUriRequest)post)).getStatusLine().getStatusCode() == 200) {
                HttpEntity httpEntity = response.getEntity();
                Header header2 = httpEntity.getContentEncoding();
                if (header2 != null && ("gzip".equalsIgnoreCase(header2.getValue()) || "x-gzip".equalsIgnoreCase(header2.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(httpEntity);
                    InputStream in = gzipEntity.getContent();
                    data = HRHttpClientUtils.getHTMLContent(in);
                } else {
                    data = EntityUtils.toString((HttpEntity)httpEntity);
                }
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Http post error", (Throwable)ex);
            throw ex;
        }
        finally {
            post.releaseConnection();
        }
        return data;
    }

    public static String postjson(String url, Map<String, String> header, String json) throws IOException {
        return HRHttpClientUtils.postjson(url, header, json, default_connectionTimeout, default_readTimeout);
    }

    public static String postjson(String url, Map<String, String> header, String json, int connectionTimeout, int readTimeout) throws IOException {
        String CONTENT_TYPE_TEXT_JSON = "text/json;";
        String data = "";
        HttpClient client = null;
        HttpPost post = new HttpPost(url);
        URI uri = post.getURI();
        if (SCHEME_HTTPS.equals(uri.getScheme())) {
            client = HRHttpClientUtils.wrapperHttpClient((int)connectionTimeout, (int)readTimeout);
            if (client == null) {
                return data;
            }
        } else {
            client = HRHttpClientUtils.createHttpClient(connectionTimeout, readTimeout);
            HttpParams httpParams = client.getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)connectionTimeout);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)readTimeout);
        }
        try {
            if (header != null && header.size() != 0) {
                for (Map.Entry entry : header.entrySet()) {
                    post.setHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            StringEntity se = new StringEntity(json, ContentType.APPLICATION_JSON);
            se.setContentType("text/json;");
            post.setEntity((HttpEntity)se);
            HttpResponse httpResponse = client.execute((HttpUriRequest)post);
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = httpResponse.getEntity();
                Header respHeader = resEntity.getContentEncoding();
                if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = HRHttpClientUtils.getHTMLContent(in);
                } else {
                    data = EntityUtils.toString((HttpEntity)resEntity);
                }
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Http postjson error", (Throwable)ex);
            throw ex;
        }
        finally {
            post.releaseConnection();
        }
        return data;
    }

    public static String postAppJson(String url, Map<String, String> header, Map<String, Object> body) throws IOException {
        return HRHttpClientUtils.postAppJson(url, header, body, default_connectionTimeout, default_readTimeout);
    }

    public static String postAppJson(String url, Map<String, String> header, Map<String, Object> body, int connectionTimeout, int readTimeout) throws IOException {
        String CONTENT_TYPE_TEXT_JSON = "application/json;";
        String data = "";
        HttpClient client = null;
        HttpPost post = new HttpPost(url);
        URI uri = post.getURI();
        if (SCHEME_HTTPS.equals(uri.getScheme())) {
            client = HRHttpClientUtils.wrapperHttpClient((int)connectionTimeout, (int)readTimeout);
            if (client == null) {
                return data;
            }
        } else {
            client = HRHttpClientUtils.createHttpClient(connectionTimeout, readTimeout);
        }
        try {
            if (header != null && header.size() != 0) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    post.setHeader(entry.getKey(), entry.getValue());
                }
            }
            String jsEntity = "{}";
            if (body != null) {
                jsEntity = JSONUtils.toString(body);
            }
            StringEntity se = new StringEntity(jsEntity, ContentType.APPLICATION_JSON);
            se.setContentType("application/json;");
            post.setEntity((HttpEntity)se);
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response == null) {
                LOGGER.info("request status error, response is error");
            } else if (response.getStatusLine() != null && response.getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                Header respHeader = resEntity.getContentEncoding();
                if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = HRHttpClientUtils.getHTMLContent(in);
                } else {
                    data = EntityUtils.toString((HttpEntity)resEntity);
                }
            } else {
                LOGGER.info("request status error, response StatusCode is : " + (response.getStatusLine() == null ? " statusline is null" : Integer.valueOf(response.getStatusLine().getStatusCode())));
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Http postjson error", (Throwable)ex);
            throw ex;
        }
        finally {
            post.releaseConnection();
        }
        return data;
    }

    public static String get(String url) throws Exception {
        return HRHttpClientUtils.get(url, default_connectionTimeout, default_readTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, int connectionTimeout, int readTimeout) throws Exception {
        BufferedReader in = null;
        String content = null;
        try {
            HttpClient client = null;
            URI uri = URI.create(url);
            if (SCHEME_HTTPS.equals(uri.getScheme())) {
                client = HRHttpClientUtils.wrapperHttpClient((int)connectionTimeout, (int)readTimeout);
                if (client == null) {
                    String string = content;
                    return string;
                }
            } else {
                client = HRHttpClientUtils.createHttpClient(connectionTimeout, readTimeout);
            }
            HttpGet request = new HttpGet();
            request.setURI(new URI(url));
            HttpResponse response = client.execute((HttpUriRequest)request);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuilder sb = new StringBuilder();
            String line = "";
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line).append(NL);
            }
            content = sb.toString();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    LOGGER.error("Http get error", (Throwable)e);
                }
            }
        }
        return content;
    }

    public static String get(String url, Map<String, Object> body) {
        return HRHttpClientUtils.get(url, body, default_connectionTimeout, default_readTimeout);
    }

    public static String get(String url, Map<String, String> header, Map<String, Object> body) {
        return HRHttpClientUtils.get(url, header, body, default_connectionTimeout, default_readTimeout);
    }

    public static String get(String url, Map<String, Object> body, int connectionTimeout, int readTimeout) {
        return HRHttpClientUtils.get(url, null, body, connectionTimeout, readTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, Map<String, String> headers, Map<String, Object> body, int connectionTimeout, int readTimeout) {
        String content = null;
        String strBody = "";
        if (body != null && body.size() != 0) {
            ArrayList params = Lists.newArrayListWithCapacity((int)16);
            for (Map.Entry<String, Object> entry : body.entrySet()) {
                params.add(new BasicNameValuePair(entry.getKey(), (String)entry.getValue()));
            }
            try {
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity((List)params, "UTF-8");
                strBody = EntityUtils.toString((HttpEntity)entity);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("Http get error", (Throwable)e);
            }
            catch (ParseException e) {
                LOGGER.error("Http get error", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error("Http get error", (Throwable)e);
            }
        }
        BufferedReader in = null;
        try {
            String destUrl = "";
            destUrl = StringUtils.isEmpty((String)strBody) ? url : url + "?" + strBody;
            HttpClient client = null;
            URI uri = URI.create(url);
            if (SCHEME_HTTPS.equals(uri.getScheme())) {
                client = HRHttpClientUtils.wrapperHttpClient((int)connectionTimeout, (int)readTimeout);
                if (client == null) {
                    String string = content;
                    return string;
                }
            } else {
                client = HRHttpClientUtils.createHttpClient(connectionTimeout, readTimeout);
            }
            HttpGet request = new HttpGet();
            if (headers != null && headers.size() != 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    request.setHeader(entry.getKey(), entry.getValue());
                }
            }
            request.setURI(new URI(destUrl));
            HttpResponse response = client.execute((HttpUriRequest)request);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuilder sb = new StringBuilder();
            String line = "";
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line).append(NL);
            }
            content = sb.toString();
        }
        catch (Exception e) {
            LOGGER.error("Http get error", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    DisCardUtil.discard();
                }
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHTMLContent(InputStream in) {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            LOGGER.error("getHTMLContent error", (Throwable)e);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                LOGGER.error("getHTMLContent error", (Throwable)e);
            }
        }
        return sb.toString();
    }

    public static String putjson(String url, Map<String, String> header, String json) throws Exception {
        return HRHttpClientUtils.putjson(url, header, json, default_connectionTimeout, default_readTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String putjson(String url, Map<String, String> header, String json, int connectionTimeout, int readTimeout) {
        String CONTENT_TYPE_TEXT_JSON = "text/json;";
        HttpClient client = HRHttpClientUtils.createHttpClient(connectionTimeout, readTimeout);
        HttpPut httpput = new HttpPut(url);
        String data = "";
        try {
            HttpResponse response;
            if (header != null && header.size() != 0) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    httpput.setHeader(entry.getKey(), entry.getValue());
                }
            }
            if (!StringUtils.isEmpty((String)json)) {
                StringEntity se = new StringEntity(json, ContentType.APPLICATION_JSON);
                se.setContentType("text/json;");
                httpput.setEntity((HttpEntity)se);
            }
            if ((response = client.execute((HttpUriRequest)httpput)).getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                Header respHeader = resEntity.getContentEncoding();
                if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue()))) {
                    GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
                    InputStream in = gzipEntity.getContent();
                    data = HRHttpClientUtils.getHTMLContent(in);
                } else {
                    data = EntityUtils.toString((HttpEntity)resEntity);
                }
            }
        }
        catch (IOException ex) {
            LOGGER.error("Http putjson error", (Throwable)ex);
        }
        finally {
            httpput.releaseConnection();
        }
        return data;
    }

    public static String postFormData(String url, Map<String, String> headers, List<HttpClientUtils.FormDataEntity> formDatas) {
        return HRHttpClientUtils.postFormData(url, headers, formDatas, default_connectionTimeout, default_readTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postFormData(String url, Map<String, String> headers, List<HttpClientUtils.FormDataEntity> formDatas, int connectionTimeout, int readTimeout) {
        HttpClient httpclient = null;
        HttpPost post = new HttpPost(url);
        URI uri = post.getURI();
        if (SCHEME_HTTPS.equals(uri.getScheme())) {
            httpclient = HRHttpClientUtils.wrapperHttpClient((int)connectionTimeout, (int)readTimeout);
            if (httpclient == null) {
                return "";
            }
        } else {
            httpclient = HRHttpClientUtils.createHttpClient(connectionTimeout, readTimeout);
        }
        try {
            String result;
            int statusCode;
            HttpResponse httpResponse;
            block18: {
                HttpPost httppost = new HttpPost(url);
                if (headers != null && headers.size() > 0) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        httppost.setHeader(entry.getKey(), entry.getValue());
                    }
                }
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.setCharset(Charset.forName("utf-8"));
                if (formDatas != null && !formDatas.isEmpty()) {
                    for (HttpClientUtils.FormDataEntity ent : formDatas) {
                        if (ent.getValueInputStream() != null) {
                            builder.addBinaryBody(ent.getKey(), ent.getValueInputStream(), ContentType.DEFAULT_BINARY, ent.getFileName());
                            continue;
                        }
                        String value = ent.getValueString();
                        if (!HRStringUtils.isNotEmpty((String)value)) continue;
                        builder.addTextBody(ent.getKey(), value, ContentType.create((String)"text/plain", (Charset)Consts.UTF_8));
                    }
                }
                httppost.setEntity(builder.build());
                httpResponse = httpclient.execute((HttpUriRequest)httppost);
                statusCode = httpResponse.getStatusLine().getStatusCode();
                result = null;
                if (statusCode != 200) break block18;
                HttpEntity resEntity = httpResponse.getEntity();
                result = EntityUtils.toString((HttpEntity)resEntity);
                EntityUtils.consume((HttpEntity)resEntity);
                String string = result;
                return string;
            }
            try {
                LOGGER.error("HRHttpClientUtils.postFormData error , statusCode  : {}", (Object)statusCode);
                try {
                    HttpEntity resEntity = httpResponse.getEntity();
                    result = EntityUtils.toString((HttpEntity)resEntity);
                    LOGGER.error("HRHttpClientUtils.postFormData error , result  : {}", (Object)result);
                    EntityUtils.consume((HttpEntity)resEntity);
                }
                catch (Exception exp) {
                    LOGGER.error(exp.getMessage());
                }
            }
            catch (ConnectTimeoutException connectException) {
                LOGGER.info(MessageFormat.format("ChargeRegisterPlugin http get connectException, result: {0}", new Object[]{connectException}));
                throw new KDBizException(new ErrorCode("1119", ResManager.loadKDString((String)"\u8bbf\u95ee\u7535\u5b50\u7b7e\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u7f51\u7edc\u73af\u5883\u662f\u5426\u901a\u7545\uff0c\u6216\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8fdb\u884c\u7f51\u7edc\u73af\u5883\u4f9d\u8d56\u68c0\u67e5\uff0c\u53c2\u89c1\u793e\u533a\u5e2e\u52a9\u6587\u6863\u300a\u7535\u5b50\u5408\u540c\u6574\u4f53\u6d41\u7a0b\u8bf4\u660e\u300b\u3002", (String)"HRHttpClientUtils_1", (String)"hrmp-hrcs-common", (Object[])new Object[0])), new Object[]{ResManager.loadKDString((String)"\u8bbf\u95ee\u7535\u5b50\u7b7e\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u7f51\u7edc\u73af\u5883\u662f\u5426\u901a\u7545\uff0c\u6216\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8fdb\u884c\u7f51\u7edc\u73af\u5883\u4f9d\u8d56\u68c0\u67e5\uff0c\u53c2\u89c1\u793e\u533a\u5e2e\u52a9\u6587\u6863\u300a\u7535\u5b50\u5408\u540c\u6574\u4f53\u6d41\u7a0b\u8bf4\u660e\u300b\u3002", (String)"HRHttpClientUtils_1", (String)"hrmp-hrcs-common", (Object[])new Object[0])});
            }
            catch (IOException e) {
                LOGGER.error("Failed to post formdata.", (Throwable)e);
                throw new KDBizException(new ErrorCode("1119", ResManager.loadKDString((String)"\u8bbf\u95ee\u7535\u5b50\u7b7e\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u7f51\u7edc\u73af\u5883\u662f\u5426\u901a\u7545\uff0c\u6216\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8fdb\u884c\u7f51\u7edc\u73af\u5883\u4f9d\u8d56\u68c0\u67e5\uff0c\u53c2\u89c1\u793e\u533a\u5e2e\u52a9\u6587\u6863\u300a\u7535\u5b50\u5408\u540c\u6574\u4f53\u6d41\u7a0b\u8bf4\u660e\u300b\u3002", (String)"HRHttpClientUtils_1", (String)"hrmp-hrcs-common", (Object[])new Object[0])), new Object[]{ResManager.loadKDString((String)"\u8bbf\u95ee\u7535\u5b50\u7b7e\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u7f51\u7edc\u73af\u5883\u662f\u5426\u901a\u7545\uff0c\u6216\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8fdb\u884c\u7f51\u7edc\u73af\u5883\u4f9d\u8d56\u68c0\u67e5\uff0c\u53c2\u89c1\u793e\u533a\u5e2e\u52a9\u6587\u6863\u300a\u7535\u5b50\u5408\u540c\u6574\u4f53\u6d41\u7a0b\u8bf4\u660e\u300b\u3002", (String)"HRHttpClientUtils_1", (String)"hrmp-hrcs-common", (Object[])new Object[0])});
            }
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
        return null;
    }
}

