/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.common.utils;

import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.IAttachmentService;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.bos.web.DispatchServiceHelper;
import kd.bos.web.actions.utils.FilePathUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.io.FileUtils;

public class ImportFileUtil {
    private static final Log logger = LogFactory.getLog(ImportFileUtil.class);

    public static String downloadTempFile(String tempUrl) throws IOException {
        File tempFile = File.createTempFile(UUID.randomUUID().toString(), ".xlsx");
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        String[] queryParams = new URL(tempUrl).getQuery().split("&");
        HashMap downloadFileParams = Maps.newHashMapWithExpectedSize((int)queryParams.length);
        for (String queryParam : queryParams) {
            String[] p = queryParam.split("=");
            downloadFileParams.put(p[0], p[1]);
        }
        TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
        try (InputStream in = content.getInputStream();){
            FileUtils.copyInputStreamToFile((InputStream)in, (File)tempFile);
        }
        return tempFile.getPath();
    }

    public static String downloadFile(String servePath) throws IOException {
        FileService service = FileServiceFactory.getAttachmentFileService();
        File tempFile = File.createTempFile(UUID.randomUUID().toString(), ".xlsx");
        try (InputStream in = service.getInputStream(servePath);){
            FileUtils.copyInputStreamToFile((InputStream)in, (File)tempFile);
        }
        return tempFile.getPath();
    }

    public static String checkUrl(String parent, String path) {
        if (HRStringUtils.isNotEmpty((String)parent)) {
            return path;
        }
        return parent;
    }

    public static Map<String, String> uploadFile(String fileName, String localPath) throws Exception {
        FileItem fileItem = null;
        InputStream inputStream = null;
        BufferedInputStream buffInputStream = null;
        try {
            File file = new File(ImportFileUtil.checkUrl("tempfile", localPath));
            inputStream = new FileInputStream(file);
            buffInputStream = new BufferedInputStream(inputStream);
            fileItem = new FileItem(fileName, localPath, (InputStream)buffInputStream);
            String serverUrl = ImportFileUtil.getNewFilePath(fileItem.getFileName(), fileItem.getFileName());
            serverUrl = FilePathUtil.dealPath((String)serverUrl, (String)"attach");
            if (serverUrl.contains("+")) {
                serverUrl = serverUrl.replace('+', '_');
            }
            fileItem.setPath(serverUrl);
            FileService service = FileServiceFactory.getAttachmentFileService();
            String uploadId = service.upload(fileItem);
            String clientUrl = UrlService.getAttachmentFullUrl((String)uploadId);
            HashMap result = Maps.newHashMapWithExpectedSize((int)2);
            result.put("uploadId", uploadId);
            result.put("serverUrl", serverUrl);
            result.put("clientUrl", clientUrl);
            HashMap hashMap = result;
            return hashMap;
        }
        catch (Throwable e) {
            logger.error(e);
            throw e;
        }
        finally {
            if (fileItem != null) {
                fileItem.close();
            }
            if (buffInputStream != null) {
                buffInputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static void deleteLocalTempFile(String localPath) throws IOException {
        Path path = Paths.get(localPath, new String[0]);
        Files.deleteIfExists(path);
    }

    private static String getNewFilePath(String oldPath, String fileName) {
        String selfPath = oldPath;
        boolean encrptyPath = Boolean.parseBoolean(String.valueOf(DispatchServiceHelper.invokeBOSService((String)IAttachmentService.class.getSimpleName(), (String)"isEncrptyPath", (Object[])new Object[0])));
        if (oldPath == null || !oldPath.contains("/")) {
            selfPath = ImportFileUtil.generateAttPath(fileName);
        }
        return !encrptyPath ? selfPath : ImportFileUtil.generateAttPath(fileName);
    }

    private static String generateAttPath(String fileName) {
        String rootPath = System.getProperty("attachment.rootpath", "/");
        if (!rootPath.startsWith("/")) {
            rootPath = "/" + rootPath;
        }
        if (rootPath.endsWith("/")) {
            rootPath = rootPath.substring(0, rootPath.length() - 1);
        }
        String uuid = UUID.randomUUID().toString().replace("-", "");
        RequestContext rc = RequestContext.get();
        return rootPath + FileNameUtils.getAttachmentFileName((String)rc.getTenantCode(), (String)rc.getAccountId(), (Object)uuid, (String)fileName);
    }
}

