/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.WarningSceneService;
import kd.hr.hrcs.common.constants.earlywarn.WarnSchemeBaseConditionConstants;
import kd.hr.hrcs.common.constants.earlywarn.WarnSchemeFieldConstants;
import kd.hr.hrcs.common.model.earlywarn.WarnBaseConditionBo;
import kd.hr.hrcs.common.model.earlywarn.WarnQueryFieldBo;
import kd.hr.hrcs.common.model.earlywarn.vo.WarnBaseConditionReturnVo;

@ExcludeFromJacocoGeneratedReport
public class WarnSchemeService
implements WarnSchemeFieldConstants,
WarnSchemeBaseConditionConstants {
    private static final Log LOGGER = LogFactory.getLog(WarnSchemeService.class);
    private static final HRBaseServiceHelper SCHEME_HELPER = new HRBaseServiceHelper("hrcs_warnscheme");
    private static final HRBaseServiceHelper MSG_CONF_HELPER = new HRBaseServiceHelper("hrcs_warnmsgconf");
    private static final HRBaseServiceHelper MSG_TABLE_HELPER = new HRBaseServiceHelper("hrcs_warnmsgtable");

    public static DynamicObject[] getSceneRefSchemeDys(Object sceneId) {
        return SCHEME_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("warnscene", "=", sceneId)});
    }

    public static DynamicObject[] getSchemeMsgConfDys(Object[] schemeIds) {
        return MSG_CONF_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("sourceid", "in", (Object)schemeIds)});
    }

    public static List<DynamicObject> getSchemeMsgTableDyList(Object schemeId) {
        DynamicObject[] msgTableDys = MSG_TABLE_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("sourceid", "=", schemeId)});
        if (msgTableDys == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(msgTableDys).sorted(Comparator.comparingInt(x -> x.getInt("fieldseq"))).collect(Collectors.toList());
    }

    public static List<String> getSceneRelSchemeNames(Object sceneId) {
        DynamicObject[] schemeDys = WarnSchemeService.getSceneRefSchemeDys(sceneId);
        ArrayList schemeNames = Lists.newArrayListWithExpectedSize((int)schemeDys.length);
        for (DynamicObject schemeDy : schemeDys) {
            Set<String> schemeDyBCRefFieldAlias = WarnSchemeService.getSchemeDyBCRefFieldAlias(schemeDy);
            if (!schemeDyBCRefFieldAlias.isEmpty()) {
                schemeNames.add(schemeDy.getString("name"));
                continue;
            }
            if (!WarnSchemeService.isSchemeDyMsgRefFieldAlias(schemeDy)) continue;
            schemeNames.add(schemeDy.getString("name"));
        }
        return schemeNames;
    }

    public static Set<String> getSchemeDyBCRefFieldAlias(DynamicObject schemeDy) {
        WarnBaseConditionReturnVo baseConditionInfo;
        List baseConditionBos;
        HashSet refFieldAlias = Sets.newHashSetWithExpectedSize((int)16);
        String baseConditionStr = schemeDy.getString("basecondition");
        if (HRStringUtils.isNotEmpty((String)baseConditionStr) && CollectionUtils.isNotEmpty((Collection)(baseConditionBos = (baseConditionInfo = (WarnBaseConditionReturnVo)SerializationUtils.fromJsonString((String)baseConditionStr, WarnBaseConditionReturnVo.class)).getBaseConditionBos()))) {
            for (WarnBaseConditionBo conditionBo : baseConditionBos) {
                if (!HRStringUtils.isNotEmpty((String)conditionBo.getSelectValue())) continue;
                refFieldAlias.add(conditionBo.getRuleValue());
            }
        }
        return refFieldAlias;
    }

    public static Set<String> getMsgConfigRefFieldAlias(DynamicObject msgConfDy) {
        HashSet refFieldAliasSet = Sets.newHashSetWithExpectedSize((int)16);
        if (msgConfDy == null) {
            return refFieldAliasSet;
        }
        refFieldAliasSet.addAll(WarnSchemeService.getTextRefQueryField(msgConfDy.getString("msgtitle")));
        refFieldAliasSet.addAll(WarnSchemeService.getTextRefQueryField(msgConfDy.getString("msgmain")));
        refFieldAliasSet.addAll(WarnSchemeService.getTextRefQueryField(msgConfDy.getString("msgconclusion")));
        return refFieldAliasSet;
    }

    public static DynamicObject[] queryMsgTableCollection(Long sourceId, String sourceType, String channel) {
        QFilter qFilter = new QFilter("sourceid", "=", (Object)sourceId);
        QFilter typeQFilter = new QFilter("sourcetype", "=", (Object)sourceType);
        if (StringUtils.isNotBlank((CharSequence)channel)) {
            QFilter channelQFilter = new QFilter("channel", "=", (Object)channel);
            return new HRBaseServiceHelper("hrcs_warnmsgtable").query("channel,localeid,titleline,dataline,seqrule", new QFilter[]{qFilter, typeQFilter, channelQFilter}, "fieldseq ASC");
        }
        return new HRBaseServiceHelper("hrcs_warnmsgtable").query("channel,localeid,titleline,dataline,seqrule", new QFilter[]{qFilter, typeQFilter}, "fieldseq ASC");
    }

    private static boolean isSchemeDyMsgRefFieldAlias(DynamicObject schemeDy) {
        DynamicObject msgConfDy = MSG_CONF_HELPER.loadDynamicObject(new QFilter("sourceid", "=", schemeDy.getPkValue()));
        List<WarnQueryFieldBo> queryFieldBos = WarningSceneService.getInstance().queryWarnQueryFieldsAndAssemble(schemeDy.getDynamicObject("warnscene"));
        Set<String> fieldAliasSet = queryFieldBos.stream().map(QueryFieldCommonBo::getFieldAlias).collect(Collectors.toSet());
        if (msgConfDy != null) {
            String msgTitle = msgConfDy.getString("msgtitle");
            String msgMain = msgConfDy.getString("msgmain");
            String msgConclusion = msgConfDy.getString("msgconclusion");
            if (WarnSchemeService.checkTextHasQueryField(msgTitle, fieldAliasSet)) {
                return true;
            }
            if (WarnSchemeService.checkTextHasQueryField(msgMain, fieldAliasSet)) {
                return true;
            }
            return WarnSchemeService.checkTextHasQueryField(msgConclusion, fieldAliasSet);
        }
        return false;
    }

    private static boolean checkTextHasQueryField(String text, Set<String> fieldAliasSet) {
        if (HRStringUtils.isEmpty((String)text) || fieldAliasSet.isEmpty()) {
            return false;
        }
        Set<String> textRefQueryField = WarnSchemeService.getTextRefQueryField(text);
        for (String queryFieldAlias : textRefQueryField) {
            if (!fieldAliasSet.contains(queryFieldAlias)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> getTextRefQueryField(String text) {
        HashSet refQueryFields = Sets.newHashSetWithExpectedSize((int)0);
        if (HRStringUtils.isEmpty((String)text)) {
            return refQueryFields;
        }
        StringBuilder fieldBuilder = new StringBuilder();
        boolean findLeftBracket = false;
        boolean findAllLeftKey = false;
        int leftBracketIndex = 0;
        for (int index = 0; index < text.length(); ++index) {
            char charValue = text.charAt(index);
            if (charValue == '[') {
                if (findLeftBracket) continue;
                findLeftBracket = true;
                leftBracketIndex = index;
                continue;
            }
            if (charValue == '#' && findLeftBracket && leftBracketIndex + 1 == index) {
                findAllLeftKey = true;
                continue;
            }
            if (charValue == ']' && findAllLeftKey) {
                findAllLeftKey = false;
                findLeftBracket = false;
                refQueryFields.add(fieldBuilder.toString());
                fieldBuilder = new StringBuilder();
                continue;
            }
            if (!findAllLeftKey) continue;
            fieldBuilder.append(charValue);
        }
        return refQueryFields;
    }
}

