/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.engine;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fulltext.common.util.CommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinEntityCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.WarnSchemeService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.WarningSceneService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.calfield.WarnCalcFieldService;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.action.CheckConfigAction;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.action.EngineLog;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.action.GetDataAction;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.action.IEarlyWarnAction;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.action.MessageAction;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.action.PermissionAction;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.action.ReceiverAction;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message.MessageBuilderHelper;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.EarlyWarnContext;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.message.MessageContentConfigBo;
import kd.hr.hrcs.common.constants.earlywarn.WarnRepeatPeriodEnum;
import kd.hr.hrcs.common.constants.earlywarn.WarningConstants;
import kd.hr.hrcs.common.constants.earlywarn.WarningSceneConstants;
import kd.hr.hrcs.common.model.earlywarn.WarnCalFieldBo;
import kd.hr.hrcs.common.model.earlywarn.WarnJoinEntityBo;
import kd.hr.hrcs.common.model.earlywarn.WarnQueryFieldBo;
import kd.hr.hrcs.common.model.earlywarn.log.WarnScheduleOperationType;

@ExcludeFromJacocoGeneratedReport
public class EarlyWarnEngine
implements WarningConstants,
WarningSceneConstants {
    private static Log logger = LogFactory.getLog(EarlyWarnEngine.class);
    private static final HRBaseServiceHelper SCHEME_HELPER = new HRBaseServiceHelper("hrcs_warnscheme");
    private static final HRBaseServiceHelper SCENE_HELPER = new HRBaseServiceHelper("hrcs_warnscene");
    private static final HRBaseServiceHelper WARNMSGCONF_HELPER = new HRBaseServiceHelper("hrcs_warnmsgconf");
    private static final HRBaseServiceHelper MONTH_EVENT_HELPER = new HRBaseServiceHelper("hrcs_warnmonthevent");
    private static final List<IEarlyWarnAction> actionChains = new ArrayList<IEarlyWarnAction>();
    private EarlyWarnContext context;
    private EngineLog log;
    private String operationType;

    private String getActionTag() {
        return ResManager.loadKDString((String)"\u9884\u8b66\u6267\u884c\u5f15\u64ce", (String)"EarlyWarnEngine_0", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]);
    }

    public EarlyWarnEngine(String warnSchemeId, String warnSceneId, EngineLog log, String operationType) {
        this.log = log;
        this.operationType = operationType;
        this.init(warnSchemeId, warnSceneId);
    }

    private void init(String warnSchemeId, String warnSceneId) {
        this.log.logRecord(this.getActionTag(), ResManager.loadKDString((String)"\u4e0a\u4e0b\u6587\u521d\u59cb\u5316...", (String)"EarlyWarnEngine_1", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]));
        DynamicObject warnScheme = SCHEME_HELPER.loadSingle((Object)warnSchemeId);
        if (null == warnScheme) {
            throw new KDException(new ErrorCode("engine_init", ResManager.loadKDString((String)"\u76d1\u63a7\u65b9\u6848\u83b7\u53d6\u5931\u8d25\u3002", (String)"EarlyWarnEngine_2", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0])), new Object[]{ResManager.loadKDString((String)"\u76d1\u63a7\u65b9\u6848\u83b7\u53d6\u5931\u8d25\u3002", (String)"EarlyWarnEngine_3", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0])});
        }
        DynamicObject warnScene = SCENE_HELPER.loadSingle((Object)warnSceneId);
        WarningSceneService sceneService = WarningSceneService.getInstance();
        List<WarnJoinEntityBo> joinEntities = sceneService.queryAllJoinEntitiesAndAssemble(warnScene);
        List<WarnQueryFieldBo> queryFields = sceneService.queryWarnQueryFieldsAndAssemble(warnScene);
        List<WarnCalFieldBo> allCalFields = WarnCalcFieldService.getInstance().loadAllSceneFieldCalFieldsForBo(warnScene);
        queryFields.addAll(allCalFields.stream().map(data -> {
            WarnQueryFieldBo warnQueryFieldBo = new WarnQueryFieldBo();
            warnQueryFieldBo.setFieldAlias(data.getFieldNumber());
            warnQueryFieldBo.setFieldPath(data.getFieldNumber());
            warnQueryFieldBo.setFieldNumber(data.getFieldNumber());
            warnQueryFieldBo.setValueType(data.getValueType());
            warnQueryFieldBo.setEntityNumber("");
            return warnQueryFieldBo;
        }).collect(Collectors.toList()));
        this.context = new EarlyWarnContext(warnScheme, warnScene, this.log.getEarlyWarnLogId(), EarlyWarnEngine.transferJoinEntityBos(joinEntities), EarlyWarnEngine.transferQueryFieldBos(queryFields));
        this.context.setCalFieldList(allCalFields);
        QFilter[] qFilters = new QFilter[]{new QFilter("sourceid", "=", (Object)warnScheme.getLong("id"))};
        DynamicObject[] warnMsgConfArr = WARNMSGCONF_HELPER.loadDynamicObjectArray(qFilters);
        Map<String, List<DynamicObject>> schemeTableConfigMap = this.getTableConfig(warnScheme.getLong("id"));
        List<MessageContentConfigBo> msgContentConfigList = MessageBuilderHelper.getInstance().buildMsgConf(schemeTableConfigMap, warnMsgConfArr);
        this.context.setMsgContentConfigList(msgContentConfigList);
        this.log.logRecord(this.getActionTag(), ResManager.loadKDString((String)"\u4e0a\u4e0b\u6587\u521d\u59cb\u5316\u6210\u529f...", (String)"EarlyWarnEngine_6", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]));
    }

    private Map<String, List<DynamicObject>> getTableConfig(Long sourceId) {
        HashMap<String, List<DynamicObject>> tableConfigMap = new HashMap<String, List<DynamicObject>>(16);
        DynamicObject[] warnMsgTableArr = WarnSchemeService.queryMsgTableCollection(sourceId, "hrcs_warnscheme", null);
        if (warnMsgTableArr != null && warnMsgTableArr.length > 0) {
            for (DynamicObject tableConfig : warnMsgTableArr) {
                if (!tableConfigMap.containsKey(tableConfig.getString("channel"))) {
                    tableConfigMap.put(tableConfig.getString("channel"), new ArrayList(10));
                }
                ((List)tableConfigMap.get(tableConfig.getString("channel"))).add(tableConfig);
            }
        }
        return tableConfigMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        DynamicObject dyScheme = this.context.getWarnScheme();
        if (dyScheme == null) {
            this.log.logRecord(this.getActionTag(), ResManager.loadKDString((String)"\u5f15\u64ce\u6267\u884c\u5931\u8d25\uff0c\u83b7\u53d6\u9884\u8b66\u65b9\u6848\u4e3a\u7a7a...", (String)"EarlyWarnEngine_9", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]));
            return;
        }
        Long schemeId = dyScheme.getLong("id");
        if (schemeId == null || schemeId == 0L) {
            this.log.logRecord(this.getActionTag(), ResManager.loadKDString((String)"\u5f15\u64ce\u6267\u884c\u5931\u8d25\uff0c\u83b7\u53d6\u9884\u8b66\u65b9\u6848\u4e3a\u7a7a...", (String)"EarlyWarnEngine_9", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]));
            return;
        }
        if (WarnScheduleOperationType.Task.toString().equals(this.operationType)) {
            String lockKey = "hr_warn_job_execute_lock_" + schemeId;
            DLock lock = DLock.create((String)lockKey);
            try {
                boolean locked = lock.tryLock();
                if (!locked) {
                    return;
                }
                this.executeAction(dyScheme, true, lock);
            }
            finally {
                try {
                    if (lock != null) {
                        lock.unlock();
                    }
                }
                catch (Exception ex) {
                    logger.error("lock.unlock()_occur_exception: {}", (Object)CommonUtil.getStackTrace((Exception)ex));
                }
            }
        }
        this.executeAction();
    }

    private void executeAction() {
        this.log.logRecord(this.getActionTag(), ResManager.loadKDString((String)"\u5f15\u64ce\u5f00\u59cb\u6267\u884c...", (String)"EarlyWarnEngine_7", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]));
        for (IEarlyWarnAction action : actionChains) {
            action.execute(this.context, this.log);
        }
        this.log.logRecord(this.getActionTag(), ResManager.loadKDString((String)"\u5f15\u64ce\u6267\u884c\u5b8c\u6210...", (String)"EarlyWarnEngine_8", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]));
    }

    private void executeAction(DynamicObject dyScheme, boolean isLocked, DLock lock) {
        if (isLocked) {
            if (this.needLockData(dyScheme)) {
                Long schemeId = dyScheme.getLong("id");
                if (this.isExecutedToday(schemeId)) {
                    this.log.logRecord(this.getActionTag(), ResManager.loadKDString((String)"\u8be5\u6267\u884c\u8ba1\u5212\u5f53\u5929\u5df2\u6267\u884c\uff0c\u65e0\u9700\u518d\u6b21\u6267\u884c...", (String)"EarlyWarnEngine_10", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]));
                    return;
                }
                this.executeAction();
                this.saveMonthEvent(schemeId);
                this.deleteMonthEventPreMonthData();
            } else {
                try {
                    if (lock != null) {
                        lock.unlock();
                    }
                    this.executeAction();
                }
                catch (Exception ex) {
                    logger.error("lock.unlock()_occur_exception: {}", (Object)CommonUtil.getStackTrace((Exception)ex));
                }
            }
        }
    }

    private boolean isExecutedToday(Long schemeId) {
        if (schemeId == null || schemeId == 0L) {
            return false;
        }
        Date today = HRDateTimeUtils.getSysTimeZoneToday();
        DynamicObject dynamicObject = MONTH_EVENT_HELPER.queryOne("executed", new QFilter[]{new QFilter("schemeid", "=", (Object)schemeId), new QFilter("executedate", "=", (Object)today)});
        if (dynamicObject == null) {
            return false;
        }
        Boolean isExecutedToday = dynamicObject.getBoolean("executed");
        return isExecutedToday == null ? false : isExecutedToday;
    }

    private void saveMonthEvent(Long schemeId) {
        if (schemeId == null || schemeId == 0L) {
            return;
        }
        Date today = HRDateTimeUtils.getSysTimeZoneToday();
        DynamicObject dynamicObject = MONTH_EVENT_HELPER.generateEmptyDynamicObject();
        dynamicObject.set("schemeid", (Object)schemeId);
        dynamicObject.set("executedate", (Object)today);
        dynamicObject.set("executed", (Object)Boolean.TRUE);
        MONTH_EVENT_HELPER.saveOne(dynamicObject);
    }

    private void deleteMonthEventPreMonthData() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.setTimeZone(KDDateUtils.getSysTimeZone());
        Date date = calendar.getTime();
        MONTH_EVENT_HELPER.deleteByFilter(new QFilter[]{new QFilter("executedate", "<=", (Object)date)});
    }

    private boolean needLockData(DynamicObject dyScheme) {
        String repeatPeriod = dyScheme.getString("repeatperiod");
        if (WarnRepeatPeriodEnum.ByMonths.getPeriod().equals(repeatPeriod)) {
            String monthDays = dyScheme.getString("monthday");
            if (StringUtils.isEmpty((String)monthDays)) {
                return false;
            }
            String[] stringsMonthDays = monthDays.split(",");
            if (stringsMonthDays == null || stringsMonthDays.length == 0) {
                return false;
            }
            Set setMonthDays = Arrays.stream(stringsMonthDays).filter(day -> StringUtils.isNotEmpty((String)day)).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(setMonthDays)) {
                return false;
            }
            if (setMonthDays.contains("L") && setMonthDays.size() > 1 && (setMonthDays.contains("28") || setMonthDays.contains("29") || setMonthDays.contains("30") || setMonthDays.contains("31"))) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeZone(KDDateUtils.getSysTimeZone());
                int day2 = calendar.get(5);
                return day2 == 27 || day2 == 28 || day2 == 29 || day2 == 30 || day2 == 31 || day2 == 1;
            }
        } else {
            return false;
        }
        return false;
    }

    public static List<JoinEntityCommonBo> transferJoinEntityBos(List<WarnJoinEntityBo> joinEntityBos) {
        return JSON.parseArray((String)SerializationUtils.toJsonString(joinEntityBos), JoinEntityCommonBo.class);
    }

    public static List<QueryFieldCommonBo> transferQueryFieldBos(List<WarnQueryFieldBo> queryFieldBos) {
        return JSON.parseArray((String)SerializationUtils.toJsonString(queryFieldBos), QueryFieldCommonBo.class);
    }

    static {
        actionChains.add(new CheckConfigAction());
        actionChains.add(new GetDataAction());
        actionChains.add(new ReceiverAction());
        actionChains.add(new PermissionAction());
        actionChains.add(new MessageAction());
    }
}

