/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.action;

import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.action.EngineLog;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.action.IEarlyWarnAction;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.EarlyWarnContext;

public class CheckConfigAction
implements IEarlyWarnAction {
    @ExcludeFromJacocoGeneratedReport
    private String getActionTag() {
        return ResManager.loadKDString((String)"\u914d\u7f6e\u6821\u9a8c\u52a8\u4f5c", (String)"CheckConfigAction_0", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]);
    }

    @Override
    public void execute(EarlyWarnContext context, EngineLog log) {
        this.checkReceiverPermDimConfig(context, log);
    }

    @ExcludeFromJacocoGeneratedReport
    private void checkReceiverPermDimConfig(EarlyWarnContext context, EngineLog log) {
        DynamicObject warnScene = context.getWarnScene();
        boolean isOpenRCPermCheck = warnScene.getBoolean("permrc");
        if (isOpenRCPermCheck) {
            log.logRecord(this.getActionTag(), ResManager.loadKDString((String)"\u5f00\u542f\u63a5\u6536\u4eba\u6743\u9650\u7ef4\u5ea6\u914d\u7f6e\u6821\u9a8c\u3002", (String)"CheckConfigAction_1", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]));
            DynamicObject warnFromEntity = warnScene.getDynamicObject("warnfromentiy");
            if (warnFromEntity == null) {
                String errorMsg = ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff0c\u5173\u8054\u7684\u9884\u8b66\u573a\u666f\u4e2d\u7684\u6d88\u606f\u63a5\u6536\u4eba\u7684\u5904\u7406\u9884\u8b66\u4e1a\u52a1\u529f\u80fd\u4e3a\u7a7a\u3002", (String)"CheckConfigAction_2", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]);
                log.logRecord(this.getActionTag(), errorMsg);
                throw new KDBizException(errorMsg);
            }
            HRBaseServiceHelper entityCtrlHelper = new HRBaseServiceHelper("hrcs_entityctrl");
            DynamicObject entityCtrlDyna = entityCtrlHelper.queryOne("entryentity.dimension,entryentity.propkey", new QFilter[]{new QFilter("entitytype.number", "=", (Object)warnFromEntity.getString("id"))});
            if (Objects.isNull(entityCtrlDyna)) {
                return;
            }
            DynamicObjectCollection entryDynaColl = entityCtrlDyna.getDynamicObjectCollection("entryentity");
            if (entryDynaColl.isEmpty()) {
                return;
            }
            DynamicObjectCollection warnRCPermEntry = warnScene.getDynamicObjectCollection("warnrcpermentryentity");
            HashSet dimIdSet = Sets.newHashSetWithExpectedSize((int)warnRCPermEntry.size());
            for (DynamicObject warnRCPermEntryDy : warnRCPermEntry) {
                DynamicObject permDimDy = warnRCPermEntryDy.getDynamicObject("warnentityperm");
                if (permDimDy == null) {
                    String errorMsg = ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff0c\u5173\u8054\u9884\u8b66\u573a\u666f\u4e2d\u7684\u6d88\u606f\u63a5\u6536\u4eba\u63a7\u6743\u8bbe\u7f6e\u5b58\u5728\u63a7\u6743\u7ef4\u5ea6\u4e3a\u7a7a\u3002", (String)"CheckConfigAction_3", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]);
                    log.logRecord(this.getActionTag(), errorMsg);
                    throw new KDBizException(errorMsg);
                }
                String fieldName = warnRCPermEntryDy.getString("fieldname");
                if (HRStringUtils.isEmpty((String)fieldName)) {
                    String errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff0c\u5173\u8054\u9884\u8b66\u573a\u666f\u4e2d\u7684\u6d88\u606f\u63a5\u6536\u4eba\u63a7\u6743\u8bbe\u7f6e\u7684\u63a7\u6743\u7ef4\u5ea6{0}\u6620\u5c04\u7684\u9884\u8b66\u5bf9\u8c61\u63a7\u6743\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"CheckConfigAction_4", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]), permDimDy.getString("name"));
                    log.logRecord(this.getActionTag(), errorMsg);
                    throw new KDBizException(errorMsg);
                }
                dimIdSet.add(permDimDy.getLong("id"));
            }
            for (DynamicObject entryDyna : entryDynaColl) {
                long dimId = entryDyna.getLong("dimension.id");
                if (dimIdSet.contains(dimId)) continue;
                String errorMsg = ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff0c\u5173\u8054\u9884\u8b66\u573a\u666f\u4e2d\u7684\u6d88\u606f\u63a5\u6536\u4eba\u63a7\u6743\u8bbe\u7f6e\u4e2d\u5b58\u5728\u672a\u914d\u7f6e\u7684\u6620\u5c04\u5173\u7cfb\u3002", (String)"CheckConfigAction_5", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]);
                log.logRecord(this.getActionTag(), errorMsg);
                throw new KDBizException(errorMsg);
            }
            log.logRecord(this.getActionTag(), ResManager.loadKDString((String)"\u7ed3\u675f\u63a5\u6536\u4eba\u6743\u9650\u7ef4\u5ea6\u914d\u7f6e\u6821\u9a8c\u3002", (String)"CheckConfigAction_6", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]));
        }
    }
}

