/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.helper;

import java.util.Date;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrcs.common.model.earlywarn.log.EarlyWarnDetailLog;
import kd.hr.hrcs.common.model.earlywarn.log.EarlyWarnLog;
import kd.hr.hrcs.common.model.earlywarn.log.WarnScheduleOperationType;
import kd.hr.hrcs.common.model.earlywarn.log.WarnScheduleStatus;

public class EarlyWarnLogHelper {
    private static final String WARN_MONITOR_LOG = "hrcs_earlywarn_log";

    public static long createLog(String warnSchemeId, String warnSceneId, WarnScheduleOperationType execType) {
        Long currentUserId = RequestContext.get().getCurrUserId();
        Date now = KDDateUtils.now();
        long id = DBServiceHelper.genGlobalLongId();
        EarlyWarnLog log = new EarlyWarnLog();
        log.setId(id).setWarnSchemeId(warnSchemeId).setWarnSceneId(warnSceneId).setStartTime(now).setEndTime(now).setExecStatus(WarnScheduleStatus.Running.toString()).setExecType(execType.toString()).setUserId(currentUserId.longValue());
        IDataEntityType type = OrmUtils.getDataEntityType(EarlyWarnLog.class);
        BusinessDataWriter.save((IDataEntityType)type, (Object[])new EarlyWarnLog[]{log});
        return id;
    }

    @ExcludeFromJacocoGeneratedReport
    public static boolean existLog(long id) {
        return EarlyWarnLogHelper.findById(id, "id") != null;
    }

    public static DynamicObject findById(long id, String fields) {
        try {
            return StringUtils.isNotBlank((CharSequence)fields) ? BusinessDataServiceHelper.loadSingle((Object)id, (String)WARN_MONITOR_LOG, (String)fields) : BusinessDataServiceHelper.loadSingle((Object)id, (String)WARN_MONITOR_LOG);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static EarlyWarnDetailLog createBlankDetailLog(long earlyWarnLogId, String execStep, String result) {
        String accountId;
        String cacheKey;
        long id = DBServiceHelper.genGlobalLongId();
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));
        Long seq = cache.inc(cacheKey = (accountId = RequestContext.get().getAccountId()) + "_EarlyWarnDetailLog:" + earlyWarnLogId, 28800);
        int seqValue = seq == null ? 1 : seq.intValue();
        EarlyWarnDetailLog log = new EarlyWarnDetailLog();
        log.setId(earlyWarnLogId).setEntryId(id).setSeq(seqValue).setExecStep(execStep).setEnStartTime(KDDateUtils.now()).setResult(StringUtils.isNotBlank((CharSequence)result) && result.length() > 720 ? result.substring(0, 710) : result);
        return log;
    }

    public static void saveDetailLog(long earlyWarnLogId, String execStep, String result) {
        EarlyWarnDetailLog log = EarlyWarnLogHelper.createBlankDetailLog(earlyWarnLogId, execStep, result);
        IDataEntityType type = OrmUtils.getDataEntityType(EarlyWarnDetailLog.class);
        BusinessDataWriter.save((IDataEntityType)type, (Object[])new EarlyWarnDetailLog[]{log});
    }

    public static void batchSaveDetailLogs(List<EarlyWarnDetailLog> detailLogs) {
        if (detailLogs.isEmpty()) {
            return;
        }
        IDataEntityType type = OrmUtils.getDataEntityType(EarlyWarnDetailLog.class);
        BusinessDataWriter.save((IDataEntityType)type, (Object[])detailLogs.toArray(new EarlyWarnDetailLog[detailLogs.size()]));
    }

    public static void endLog(long id, WarnScheduleStatus status) {
        DynamicObject obj = EarlyWarnLogHelper.findById(id, null);
        if (null == obj) {
            return;
        }
        obj.set("execstatus", (Object)status.getStatus());
        obj.set("endtime", (Object)KDDateUtils.now());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(WARN_MONITOR_LOG);
        serviceHelper.updateDataOne(obj);
    }
}

