/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.message.HRMessageInfo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message.MergeMsgHtmlContentBuilder;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message.MergeMsgPlainContentBuilder;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message.MessageBuilderHelper;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message.model.MsgFieldFormatBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message.model.MsgUserDateFormatBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message.systemparam.SystemParamCalc;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.message.IMessageBuilder;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.EarlyWarnContext;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.message.FixedValueSysParamBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.message.MessageContentConfigBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.message.WarnUserDataBo;
import kd.hr.hrcs.common.constants.earlywarn.WarnMsgSysParamEnum;

@ExcludeFromJacocoGeneratedReport
public abstract class AbstractMessageBuilder
implements IMessageBuilder {
    private static final String defaultMapKey = "nosplit";

    public void noParamBuildInfo(EarlyWarnContext context, MessageContentConfigBo messageContentConfigBo, List<HRMessageInfo> hrMessageInfoList) {
        HRMessageInfo hrMessageInfo = new HRMessageInfo();
        List<WarnUserDataBo> warnUserDataBoList = context.getWarnUserDataBoList();
        if (CollectionUtils.isEmpty(warnUserDataBoList)) {
            return;
        }
        hrMessageInfo.setReceiverUserIds(warnUserDataBoList.stream().map(WarnUserDataBo::getReceiverUserId).collect(Collectors.toList()));
        hrMessageInfo.setChannel(messageContentConfigBo.getChannel());
        hrMessageInfo.setTitle(messageContentConfigBo.getMsgTitle());
        String content = messageContentConfigBo.getMsgMain() + "  <br><br>  " + messageContentConfigBo.getMsgEnd();
        hrMessageInfo.setContent(content);
        hrMessageInfo.setMsgMain(messageContentConfigBo.getMsgMain());
        hrMessageInfo.setMsgEnd(messageContentConfigBo.getMsgEnd());
        hrMessageInfoList.add(hrMessageInfo);
    }

    public String buildFixedValueSysParams(String content, FixedValueSysParamBo fixedValueSysParamBo) {
        if (StringUtils.isEmpty((String)content) || fixedValueSysParamBo == null) {
            return StringUtils.getEmpty();
        }
        String sysDate = SystemParamCalc.getSysDate(fixedValueSysParamBo.getSysDate());
        content = MessageBuilderHelper.getInstance().commonReplaceAll(content, "\\[" + WarnMsgSysParamEnum.SYS_DATE.getName() + "\\]", sysDate);
        String sysTime = SystemParamCalc.getSysTime(fixedValueSysParamBo.getSysDate());
        content = MessageBuilderHelper.getInstance().commonReplaceAll(content, "\\[" + WarnMsgSysParamEnum.SYS_TIME.getName() + "\\]", sysTime);
        return content;
    }

    public void buildContent(List<HRMessageInfo> hrMessageInfoList) {
        MergeMsgHtmlContentBuilder mergeMsgHtmlContentBuilder = new MergeMsgHtmlContentBuilder();
        mergeMsgHtmlContentBuilder.buildContent(hrMessageInfoList);
        MergeMsgPlainContentBuilder mergeMsgPlainContentBuilder = new MergeMsgPlainContentBuilder();
        mergeMsgPlainContentBuilder.buildContent(hrMessageInfoList);
    }

    public Map<String, List<Row>> buildGroupBodyList(Map<String, String> commonFieldSNameTypes, List<Row> bodyList, EarlyWarnContext context, MsgUserDateFormatBo userDateFormat) {
        LinkedHashMap bodyListGroupMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        if (!context.isSplitMsg()) {
            bodyListGroupMap.put(defaultMapKey, bodyList);
            return bodyListGroupMap;
        }
        String splitDimension = context.getSplitDimension();
        if (StringUtils.isEmpty((String)splitDimension)) {
            bodyListGroupMap.put(defaultMapKey, bodyList);
        } else {
            this.buildGroupBodyListByDim(commonFieldSNameTypes, bodyList, splitDimension, bodyListGroupMap, context.getFieldFormatBoMap(), userDateFormat);
        }
        return bodyListGroupMap;
    }

    public void buildGroupBodyListByDim(Map<String, String> commonFieldSNameTypes, List<Row> bodyList, String splitDimension, Map<String, List<Row>> bodyListGroupMap, Map<String, MsgFieldFormatBo> fieldFormatMap, MsgUserDateFormatBo userDateFormat) {
        for (Row row : bodyList) {
            String fieldValue = MessageBuilderHelper.getInstance().getStringFieldName(commonFieldSNameTypes, splitDimension, row, fieldFormatMap, userDateFormat);
            ArrayList groupListRow = bodyListGroupMap.get(fieldValue);
            if (CollectionUtils.isEmpty(groupListRow)) {
                groupListRow = Lists.newArrayListWithExpectedSize((int)10);
                bodyListGroupMap.put(fieldValue, groupListRow);
            }
            groupListRow.add(row);
        }
    }

    public String buildCommonFieldMapWithOutTable(List<String> commonFields, String content, Map<String, String> commonFieldSNameTypes, List<Row> rowList, Map<String, MsgFieldFormatBo> dateFieldFormatMap, MsgUserDateFormatBo userDateFormat) {
        if (CollectionUtils.isEmpty(commonFields) || CollectionUtils.isEmpty(rowList)) {
            return content;
        }
        for (String fieldName : commonFields) {
            if (StringUtils.isEmpty((String)fieldName) || !commonFieldSNameTypes.containsKey(fieldName)) continue;
            StringBuilder sbValue = new StringBuilder();
            for (int i = 0; i < rowList.size(); ++i) {
                String tmpValue;
                String realFieldName = fieldName.replaceAll("#", "");
                String value = MessageBuilderHelper.getInstance().getStringFieldName(commonFieldSNameTypes, realFieldName, rowList.get(i), dateFieldFormatMap, userDateFormat);
                if (StringUtils.isBlank((String)value) || ((tmpValue = sbValue.toString()) + '\u3001').indexOf(value + '\u3001') > -1) continue;
                if (i != 0 && StringUtils.isNotEmpty((String)tmpValue)) {
                    sbValue.append('\u3001');
                }
                sbValue.append(value);
            }
            String strFieldValue = sbValue.toString();
            content = MessageBuilderHelper.getInstance().commonReplaceAll(content, "\\[" + fieldName + "\\]", strFieldValue);
        }
        return content;
    }
}

