/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message;

import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.message.HRMessageInfo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.message.IMergeMsgContentBuilder;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.message.MessageTableConfigBo;

@ExcludeFromJacocoGeneratedReport
public class MergeMsgHtmlContentBuilder
implements IMergeMsgContentBuilder {
    private int contentLength = 0;
    private int tableWidth = 0;

    @Override
    public void buildContent(List<HRMessageInfo> hrMessageInfoList) {
        for (HRMessageInfo hrMessageInfo : hrMessageInfoList) {
            List<List<MessageTableConfigBo>> messageTableConfigBoList = hrMessageInfo.getMsgTableLists();
            StringBuilder sbContent = new StringBuilder();
            sbContent.append("<br><br>");
            String main = hrMessageInfo.getMsgMain();
            if (StringUtils.isNotEmpty((CharSequence)main)) {
                main = main.replaceAll("\n", "<br>");
            }
            sbContent.append(main);
            sbContent.append("<br>");
            this.contentLength = this.getBitLength(sbContent.toString());
            if (this.contentLength > 520000) {
                hrMessageInfo.setContent(sbContent.toString());
                return;
            }
            String msgEnd = hrMessageInfo.getMsgEnd();
            if (StringUtils.isNotEmpty((CharSequence)msgEnd)) {
                msgEnd = msgEnd.replaceAll("\n", "<br>");
            }
            this.contentLength += this.getBitLength(msgEnd);
            if (this.contentLength > 520000) {
                sbContent.append(msgEnd);
                hrMessageInfo.setContent(sbContent.toString());
                return;
            }
            String tableContent = CollectionUtils.isEmpty(messageTableConfigBoList) ? "" : this.buildTableHtml(messageTableConfigBoList);
            sbContent.append(tableContent);
            sbContent.append("<br>");
            sbContent.append(msgEnd);
            hrMessageInfo.setContent(sbContent.toString());
        }
    }

    public String buildTableHtml(List<List<MessageTableConfigBo>> msgTableLists) {
        if (CollectionUtils.isEmpty(msgTableLists)) {
            return "";
        }
        StringBuilder tableHtml = new StringBuilder();
        String tableHeadHtml = this.getTableHeadHtml(msgTableLists);
        this.contentLength += this.getBitLength(tableHeadHtml);
        if (this.contentLength > 520000) {
            return "";
        }
        tableHtml.append("<table border=\"1\" style=\"width: ").append(Math.max(Math.min(3000, this.tableWidth), 200)).append("px;border: 1px solid #cccccc;\" align=\"center\">");
        tableHtml.append(tableHeadHtml);
        String tableBodyHtml = this.getTableBodyHtml(msgTableLists);
        tableHtml.append(tableBodyHtml);
        tableHtml.append("</table>");
        return tableHtml.toString();
    }

    private String getTableHeadHtml(List<List<MessageTableConfigBo>> msgTableLists) {
        if (CollectionUtils.isEmpty(msgTableLists)) {
            return "";
        }
        StringBuilder tableHeadHtml = new StringBuilder();
        List<MessageTableConfigBo> messageTableConfigBos = msgTableLists.get(0);
        if (CollectionUtils.isEmpty(messageTableConfigBos)) {
            return "";
        }
        tableHeadHtml.append("<thead><tr>");
        int maxColWidth = 0;
        for (MessageTableConfigBo messageTableConfigBo : messageTableConfigBos) {
            tableHeadHtml.append("<th>");
            String columnTitle = messageTableConfigBo.getLineTitle();
            tableHeadHtml.append(StringUtils.isBlank((CharSequence)columnTitle) ? "" : columnTitle);
            tableHeadHtml.append("</th>");
            maxColWidth = Math.max(maxColWidth, this.getBitLength(columnTitle));
        }
        tableHeadHtml.append("</tr></thead>");
        int totalWidth = maxColWidth * messageTableConfigBos.size() * 10;
        this.tableWidth = Math.max(this.tableWidth, totalWidth);
        return tableHeadHtml.toString();
    }

    private String getTableBodyHtml(List<List<MessageTableConfigBo>> msgTableLists) {
        if (CollectionUtils.isEmpty(msgTableLists)) {
            return "";
        }
        StringBuilder tableBodyHtml = new StringBuilder();
        tableBodyHtml.append("<tbody>");
        StringBuilder bodyRow = new StringBuilder();
        for (int rowNum = 0; rowNum < msgTableLists.size(); ++rowNum) {
            List<MessageTableConfigBo> messageTableConfigBos = msgTableLists.get(rowNum);
            bodyRow.append("<tr>");
            for (MessageTableConfigBo messageTableConfigBo : messageTableConfigBos) {
                String fieldValue = messageTableConfigBo.getFieldValue();
                if (fieldValue == null) {
                    fieldValue = "";
                }
                bodyRow.append("<td>").append(fieldValue).append("</td>");
            }
            bodyRow.append("</tr>");
            if (rowNum <= 2 || rowNum >= msgTableLists.size() - 1) continue;
            bodyRow.append("<tr>");
            for (int i = 0; i < messageTableConfigBos.size(); ++i) {
                bodyRow.append("<td>").append("......").append("</td>");
            }
            bodyRow.append("</tr>");
            break;
        }
        tableBodyHtml.append((CharSequence)bodyRow);
        tableBodyHtml.append("</tbody>");
        return tableBodyHtml.toString();
    }
}

