/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message;

import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.message.HRMessageInfo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.message.IMergeMsgContentBuilder;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.message.MessageTableConfigBo;

@ExcludeFromJacocoGeneratedReport
public class MergeMsgPlainContentBuilder
implements IMergeMsgContentBuilder {
    private int contentLength = 0;

    @Override
    public void buildContent(List<HRMessageInfo> hrMessageInfoList) {
        for (HRMessageInfo hrMessageInfo : hrMessageInfoList) {
            List<List<MessageTableConfigBo>> messageTableConfigBoList = hrMessageInfo.getMsgTableLists();
            StringBuilder sbContent = new StringBuilder();
            sbContent.append("  ");
            sbContent.append(hrMessageInfo.getMsgMain());
            sbContent.append("  ");
            this.contentLength = this.getBitLength(sbContent.toString());
            if (this.contentLength > 520000) {
                hrMessageInfo.setContent(sbContent.toString());
                return;
            }
            String msgEnd = hrMessageInfo.getMsgEnd();
            this.contentLength += this.getBitLength(msgEnd);
            if (this.contentLength > 520000) {
                sbContent.append(msgEnd);
                hrMessageInfo.setContent(sbContent.toString());
                return;
            }
            String tableContent = CollectionUtils.isEmpty(messageTableConfigBoList) ? "" : this.buildTable(messageTableConfigBoList);
            sbContent.append(tableContent);
            sbContent.append("  ");
            sbContent.append(msgEnd);
            hrMessageInfo.setPlainTextContent(sbContent.toString());
        }
    }

    public String buildTable(List<List<MessageTableConfigBo>> msgTableLists) {
        if (CollectionUtils.isEmpty(msgTableLists)) {
            return null;
        }
        StringBuilder tablePlainText = new StringBuilder();
        String tableHead = this.getTableHead(msgTableLists);
        this.contentLength += this.getBitLength(tableHead);
        if (this.contentLength > 520000) {
            return "";
        }
        tablePlainText.append(tableHead);
        String tableBody = this.getTableBody(msgTableLists);
        tablePlainText.append(tableBody);
        return tablePlainText.toString();
    }

    private String getTableHead(List<List<MessageTableConfigBo>> msgTableLists) {
        if (CollectionUtils.isEmpty(msgTableLists)) {
            return "";
        }
        StringBuilder tableHead = new StringBuilder();
        List<MessageTableConfigBo> messageTableConfigBos = msgTableLists.get(0);
        if (CollectionUtils.isEmpty(messageTableConfigBos)) {
            return "";
        }
        for (MessageTableConfigBo messageTableConfigBo : messageTableConfigBos) {
            tableHead.append(" ");
            String columnTitle = messageTableConfigBo.getLineTitle();
            tableHead.append(StringUtils.isBlank((CharSequence)columnTitle) ? "" : columnTitle);
            tableHead.append(" ");
        }
        return tableHead.toString();
    }

    private String getTableBody(List<List<MessageTableConfigBo>> msgTableLists) {
        StringBuilder tableBody = new StringBuilder();
        StringBuilder bodyRow = new StringBuilder();
        for (int rowNum = 0; rowNum < msgTableLists.size(); ++rowNum) {
            List<MessageTableConfigBo> messageTableConfigBos = msgTableLists.get(rowNum);
            bodyRow.append(" ");
            for (MessageTableConfigBo messageTableConfigBo : messageTableConfigBos) {
                String fieldValue = messageTableConfigBo.getFieldValue();
                if (fieldValue == null) {
                    fieldValue = "";
                }
                bodyRow.append(" ").append(fieldValue).append(" ");
            }
            if (rowNum <= 2 || rowNum >= msgTableLists.size() - 1) continue;
            bodyRow.append("......");
            break;
        }
        tableBody.append((CharSequence)bodyRow);
        return tableBody.toString();
    }
}

