/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageAttachment;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.message.HRMessageInfo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.EarlyWarnContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;

@ExcludeFromJacocoGeneratedReport
public class MessageSender {
    private static volatile MessageSender service = null;

    private MessageSender() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MessageSender getInstance() {
        if (service != null) return service;
        Class<MessageSender> clazz = MessageSender.class;
        synchronized (MessageSender.class) {
            if (service != null) return service;
            service = new MessageSender();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public Map<String, Object> sendMessage(EarlyWarnContext context) {
        ArrayList hrMessageInfos = context.getHrMessageInfoList();
        if (CollectionUtils.isEmpty(hrMessageInfos)) {
            hrMessageInfos = Lists.newArrayListWithCapacity((int)1);
            HRMessageInfo hrMessageInfo = new HRMessageInfo();
            hrMessageInfo.setTitle("glctest");
            hrMessageInfo.setContent("glctest");
            ArrayList receiverUserIds = Lists.newArrayListWithCapacity((int)10);
            receiverUserIds.add(RequestContext.get().getCurrUserId());
            hrMessageInfo.setReceiverUserIds(receiverUserIds);
            hrMessageInfos.add(hrMessageInfo);
        }
        return this.sendMessage(hrMessageInfos);
    }

    private Map<String, Object> sendMessage(List<HRMessageInfo> hrMessageInfos) {
        if (CollectionUtils.isEmpty(hrMessageInfos)) {
            return null;
        }
        ArrayList messageInfos = Lists.newArrayListWithCapacity((int)hrMessageInfos.size());
        Long currUserId = RequestContext.get().getCurrUserId();
        LocaleString messageTag = new LocaleString(ResManager.loadKDString((String)"\u9884\u8b66\u6d88\u606f\u901a\u77e5", (String)"MessageAction_10", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]));
        for (HRMessageInfo hrMessageInfo : hrMessageInfos) {
            if (CollectionUtils.isEmpty(hrMessageInfo.getReceiverUserIds()) || StringUtils.isBlank((CharSequence)hrMessageInfo.getTitle()) || StringUtils.isBlank((CharSequence)hrMessageInfo.getContent()) || StringUtils.isBlank((CharSequence)hrMessageInfo.getChannel())) continue;
            MessageInfo messageInfo = new MessageInfo();
            messageInfo.setMessageTitle((ILocaleString)new LocaleString(hrMessageInfo.getTitle()));
            messageInfo.setMessageContent((ILocaleString)new LocaleString("[" + hrMessageInfo.getTitle() + "]" + System.lineSeparator() + (StringUtils.isNotBlank((CharSequence)hrMessageInfo.getContent()) ? hrMessageInfo.getContent() : hrMessageInfo.getPlainTextContent())));
            messageInfo.setUserIds(hrMessageInfo.getReceiverUserIds());
            if (!HRMapUtils.isEmpty(hrMessageInfo.getCustomReceivers())) {
                messageInfo.setParams(new HashMap<String, List<String>>(hrMessageInfo.getCustomReceivers()));
            }
            messageInfo.setType("warning");
            messageInfo.setSource("hrcs");
            messageInfo.setMessageTag((ILocaleString)messageTag);
            messageInfo.setSenderId(currUserId);
            if ("msgcenter".equalsIgnoreCase(hrMessageInfo.getChannel())) {
                messageInfo.setNotifyType(MessageChannels.MC.getNumber());
            } else {
                messageInfo.setNotifyType(hrMessageInfo.getChannel());
            }
            if (StringUtils.isNotBlank((CharSequence)hrMessageInfo.getContentUrl())) {
                messageInfo.setContentUrl(hrMessageInfo.getContentUrl());
            }
            if (StringUtils.isNotBlank((CharSequence)hrMessageInfo.getMobContentUrl())) {
                messageInfo.setMobContentUrl(hrMessageInfo.getMobContentUrl());
            }
            messageInfos.add(messageInfo);
        }
        return MessageCenterServiceHelper.batchSendMessages((List)messageInfos);
    }

    private boolean verifyMessageAttachment(MessageAttachment attachment) {
        if (null == attachment) {
            return false;
        }
        if (null == attachment.getAttachments() || 0 == attachment.getAttachments().size()) {
            return false;
        }
        return null != attachment.getAttachmentNames() && 0 != attachment.getAttachmentNames().size();
    }

    public MessageAttachment getEmailMessageAttachment(EarlyWarnContext context) {
        try {
            DynamicObject warnScheme = context.getWarnScheme();
            List attachments = AttachmentServiceHelper.getAttachments((String)"hrcs_warnscheme", (Object)warnScheme.getPkValue(), (String)"attachmentfield");
            ArrayList files = Lists.newArrayListWithCapacity((int)10);
            ArrayList fileNames = Lists.newArrayListWithCapacity((int)10);
            MessageAttachment attachment = new MessageAttachment((List)files, (List)fileNames);
            for (Map attachment1 : attachments) {
                String url = String.valueOf(attachment1.get("url"));
                String name = String.valueOf(attachment1.get("name"));
                InputStream in = FileServiceFactory.getAttachmentFileService().getInputStream(url);
                byte[] bytes = IOUtils.toByteArray((InputStream)in);
                files.add(bytes);
                fileNames.add(name);
            }
            return attachment;
        }
        catch (IOException e) {
            return null;
        }
    }
}

