/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.message.store;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.action.EngineLog;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.message.HRMessageInfo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.message.IMessageStorage;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.EarlyWarnContext;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.msgpersist.MsgDataPersistBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.msgpersist.MsgDataReceiverBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.msgpersist.MsgDataRowBo;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.msgpersist.MsgFinalPersistObj;
import kd.hr.hrcs.common.constants.msgpersist.MsgPersistConstants;

public class DBMessageStorage
implements IMessageStorage<DynamicObject, DynamicObject>,
MsgPersistConstants {
    private static final Log LOGGER = LogFactory.getLog(DBMessageStorage.class);
    private final String ACTION_TAG_MESSAGE = ResManager.loadKDString((String)"\u5904\u7406\u6d88\u606f\u52a8\u4f5c", (String)"DBMessageStorage_0", (String)"hrmp-hrcs-warn-business", (Object[])new Object[0]);
    private final HRBaseServiceHelper msgDbHelper = new HRBaseServiceHelper("hrcs_warnmsgpersist");
    private final HRBaseServiceHelper msgRowDataDbHelper = new HRBaseServiceHelper("hrcs_warnmsgrowdata");
    private static volatile DBMessageStorage service = null;

    private DBMessageStorage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DBMessageStorage getInstance() {
        if (service != null) return service;
        Class<DBMessageStorage> clazz = DBMessageStorage.class;
        synchronized (DBMessageStorage.class) {
            if (service != null) return service;
            service = new DBMessageStorage();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMessage(EarlyWarnContext context, EngineLog log) {
        List<HRMessageInfo> hrMessageInfos = context.getHrMessageInfoList();
        if (hrMessageInfos != null && !hrMessageInfos.isEmpty()) {
            try (TXHandle required = TX.requiresNew();){
                DynamicObject[] dynamicObjects = new DynamicObject[hrMessageInfos.size()];
                long[] msgIds = ORM.create().genLongIds("hrcs_warnmsgpersist", hrMessageInfos.size());
                LinkedList rowDataList = Lists.newLinkedList();
                for (int index = 0; index < hrMessageInfos.size(); ++index) {
                    HRMessageInfo hrMessageInfo = hrMessageInfos.get(index);
                    MsgDataPersistBo msgDataPersistBo = MsgDataPersistBo.buildPersistBo(context, hrMessageInfos.get(index));
                    MsgFinalPersistObj<DynamicObject, DynamicObject> finalPersistObj = this.toStoreApiObj(msgIds[index], msgDataPersistBo);
                    dynamicObjects[index] = finalPersistObj.getMsgHeadObj();
                    rowDataList.addAll(finalPersistObj.getMsgRowDataObj());
                    String domainContextUrl = UrlService.getDomainContextUrl() + "/index.html?formId=hrcs_warnmsgpersist&operationStatus=view&pkId=" + msgIds[index];
                    String domainMobContextUrl = UrlService.getDomainContextUrl() + "/mobile.html?form=hrcs_warnmsgpersist_mob&pkId=" + msgIds[index];
                    hrMessageInfo.setContentUrl(domainContextUrl);
                    hrMessageInfo.setMobContentUrl(domainMobContextUrl);
                }
                this.msgDbHelper.save(dynamicObjects);
                if (!rowDataList.isEmpty()) {
                    this.msgRowDataDbHelper.save(rowDataList.toArray(new DynamicObject[0]));
                }
            }
        }
    }

    @Override
    public MsgFinalPersistObj<DynamicObject, DynamicObject> toStoreApiObj(Object msgId, MsgDataPersistBo msgDataPersistBo) {
        List<MsgDataReceiverBo> receiverBos;
        MsgFinalPersistObj<DynamicObject, DynamicObject> storeObj = new MsgFinalPersistObj<DynamicObject, DynamicObject>();
        DynamicObject newDy = this.msgDbHelper.generateEmptyDynamicObject();
        newDy.set("id", msgId);
        newDy.set("logid", (Object)msgDataPersistBo.getLogId());
        newDy.set("warnscheme", (Object)msgDataPersistBo.getWarnSchemeId());
        newDy.set("datahead", (Object)JSONObject.toJSONString(msgDataPersistBo.getMsgDataHeadFieldBos()));
        newDy.set("msgtitle", (Object)msgDataPersistBo.getMsgTitle());
        newDy.set("msgmain", (Object)msgDataPersistBo.getMsgMain());
        newDy.set("msgend", (Object)msgDataPersistBo.getMsgEnd());
        MainEntityType mainEntityType = (MainEntityType)newDy.getDynamicObjectType();
        List<MsgDataRowBo> msgDataRowBos = msgDataPersistBo.getMsgDataRowBos();
        if (msgDataRowBos != null && !msgDataRowBos.isEmpty()) {
            ArrayList rowDataList = Lists.newArrayListWithExpectedSize((int)msgDataRowBos.size());
            for (MsgDataRowBo msgDataRowBo : msgDataRowBos) {
                DynamicObject rowDataDy = this.msgRowDataDbHelper.generateEmptyDynamicObject();
                rowDataDy.set("msgpersist", msgId);
                rowDataDy.set("rowdata", (Object)JSONObject.toJSONString((Object)msgDataRowBo));
                rowDataList.add(rowDataDy);
            }
            storeObj.setMsgRowDataObj(rowDataList);
        }
        if ((receiverBos = msgDataPersistBo.getReceiverBos()) != null && !receiverBos.isEmpty()) {
            EntityType entityType = (EntityType)mainEntityType.getAllEntities().get("receiverentry");
            DynamicObjectCollection receiverEntry = new DynamicObjectCollection((DynamicObjectType)entityType, (Object)newDy);
            for (MsgDataReceiverBo receiverBo : receiverBos) {
                DynamicObject receiverDy = receiverEntry.addNew();
                receiverDy.set("receiverid", (Object)receiverBo.getReceiverId());
                receiverDy.set("receivername", (Object)receiverBo.getReceiverName());
            }
            newDy.set("receiverentry", (Object)receiverEntry);
        }
        storeObj.setMsgHeadObj(newDy);
        return storeObj;
    }
}

