/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.earlywarn.engine.serivce.impl.receiver;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.hr.hbp.business.openservicehelper.hrpi.HRPIDepempServiceHelper;
import kd.hr.hbp.business.openservicehelper.hrpi.HRPIWorkRoleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hrcs.bussiness.domain.service.earlywarn.model.receiver.ReceiverFieldResultBo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

@ExcludeFromJacocoGeneratedReport
public class ReceiverApiHelper {
    public static List<ReceiverFieldResultBo> getUserIdByPersonOrEmployee(List<ReceiverFieldResultBo> idLList, String key) {
        ArrayList employeeList = Lists.newArrayListWithExpectedSize((int)10);
        for (ReceiverFieldResultBo receiver : idLList) {
            employeeList.addAll(receiver.getSuperiorPersonMap().keySet());
        }
        HashMap idMaps = Maps.newHashMapWithExpectedSize((int)16);
        idMaps.put(key, employeeList);
        Map sysUserInfos = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getUserIdByPersonInfo", (Object[])new Object[]{idMaps});
        if (sysUserInfos == null) {
            return idLList;
        }
        if (!((Boolean)sysUserInfos.get("success")).booleanValue()) {
            return Collections.emptyList();
        }
        Map mapData = (Map)sysUserInfos.get("data");
        if (MapUtils.isEmpty((Map)mapData)) {
            return idLList;
        }
        block1: for (Map.Entry entry : mapData.entrySet()) {
            Map nestMapData = (Map)entry.getValue();
            for (ReceiverFieldResultBo receiver : idLList) {
                Map<Long, Long> superiorPersonMap = receiver.getSuperiorPersonMap();
                if (!superiorPersonMap.containsKey(entry.getKey())) continue;
                superiorPersonMap.put((Long)entry.getKey(), (Long)nestMapData.get("user"));
                continue block1;
            }
        }
        return idLList;
    }

    public static List<ReceiverFieldResultBo> getPersonIdByEmployeeId(List<ReceiverFieldResultBo> employeeList) {
        List idLList = employeeList.stream().map(bo -> bo.getFiledId()).collect(Collectors.toList());
        List sysUserInfos = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listEmployees", (Object[])new Object[]{idLList});
        if (sysUserInfos == null) {
            return employeeList;
        }
        block0: for (Map entry : sysUserInfos) {
            for (ReceiverFieldResultBo receiver : employeeList) {
                if (!receiver.getFiledId().equals(entry.get("id"))) continue;
                receiver.setPersonId((Long)entry.get("person"));
                continue block0;
            }
        }
        return employeeList;
    }

    public static List<ReceiverFieldResultBo> getUserIdByDepemp(List<ReceiverFieldResultBo> depmpIdLList) {
        List<ReceiverFieldResultBo> employeeIdList = ReceiverApiHelper.getEmployeeIdsByDepemp(depmpIdLList);
        List<ReceiverFieldResultBo> userIdList = ReceiverApiHelper.getUserIdByPersonOrEmployee(employeeIdList, "employee");
        return userIdList;
    }

    public static List<ReceiverFieldResultBo> getPersonIdsByDepempNew(List<ReceiverFieldResultBo> depmpIdLList) {
        for (ReceiverFieldResultBo receiver : depmpIdLList) {
            Map sysUserInfos = HRPIDepempServiceHelper.getDepempIds((Long)receiver.getFiledId());
            if (!MapUtils.isNotEmpty((Map)sysUserInfos)) continue;
            receiver.setPersonId((Long)sysUserInfos.get("person_id"));
        }
        return depmpIdLList;
    }

    public static List<ReceiverFieldResultBo> getEmployeeIdsByDepemp(List<ReceiverFieldResultBo> depmpIdLList) {
        return ReceiverApiHelper.getDepempModelIds(depmpIdLList, "employee_id");
    }

    private static List<ReceiverFieldResultBo> getDepempModelIds(List<ReceiverFieldResultBo> depmpIdLList, String key) {
        for (ReceiverFieldResultBo receiver : depmpIdLList) {
            Map sysUserInfos = HRPIDepempServiceHelper.getDepempIds((Long)receiver.getFiledId());
            HashMap superiorMap = Maps.newHashMapWithExpectedSize((int)16);
            if (!MapUtils.isNotEmpty((Map)sysUserInfos)) continue;
            superiorMap.put(sysUserInfos.get(key), null);
            receiver.setSuperiorPersonMap(superiorMap);
        }
        return depmpIdLList;
    }

    public static List<ReceiverFieldResultBo> getEmployeeOrPersonIdByUserId(List<ReceiverFieldResultBo> userIdList, String key) {
        List idLList = userIdList.stream().map(bo -> bo.getFiledId()).collect(Collectors.toList());
        Map employeeInfos = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"queryPersonInfoByUserIds", (Object[])new Object[]{idLList});
        if (employeeInfos == null) {
            return Collections.emptyList();
        }
        if (!((Boolean)employeeInfos.get("success")).booleanValue()) {
            return Collections.emptyList();
        }
        Map mapData = (Map)employeeInfos.get("data");
        if (MapUtils.isEmpty((Map)mapData)) {
            return Collections.emptyList();
        }
        block0: for (Map.Entry entry : mapData.entrySet()) {
            Map nestMapData = (Map)entry.getValue();
            for (ReceiverFieldResultBo userIdBo : userIdList) {
                if (!userIdBo.getFiledId().equals(entry.getKey())) continue;
                userIdBo.setPersonId((Long)nestMapData.get(key));
                continue block0;
            }
        }
        return userIdList;
    }

    public static List<ReceiverFieldResultBo> getEmployeeOrPersonIdByUserIdNew(List<ReceiverFieldResultBo> userIdList, String key) {
        List idLList = userIdList.stream().map(bo -> bo.getFiledId()).collect(Collectors.toList());
        Map employeeInfos = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"queryPersonInfoByUserIds", (Object[])new Object[]{idLList});
        if (employeeInfos == null) {
            return Collections.emptyList();
        }
        if (!((Boolean)employeeInfos.get("success")).booleanValue()) {
            return Collections.emptyList();
        }
        Map mapData = (Map)employeeInfos.get("data");
        if (MapUtils.isEmpty((Map)mapData)) {
            return Collections.emptyList();
        }
        block0: for (Map.Entry entry : mapData.entrySet()) {
            Map nestMapData = (Map)entry.getValue();
            for (ReceiverFieldResultBo userIdBo : userIdList) {
                if (!userIdBo.getFiledId().equals(entry.getKey())) continue;
                userIdBo.setPersonId((Long)nestMapData.get(key));
                continue block0;
            }
        }
        return userIdList;
    }

    public static List<ReceiverFieldResultBo> getLeaderByUserId(List<ReceiverFieldResultBo> userIdList) {
        List<ReceiverFieldResultBo> employeeList = ReceiverApiHelper.getEmployeeOrPersonIdByUserIdNew(userIdList, "person");
        return ReceiverApiHelper.getLeaderByEmployee(employeeList);
    }

    public static List<ReceiverFieldResultBo> getLeaderByPersonId(List<ReceiverFieldResultBo> personIdList) {
        List personIds = personIdList.stream().filter(e -> e.getPersonId() != null && e.getPersonId() > 0L).map(bo -> bo.getPersonId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(personIds)) {
            personIds = personIdList.stream().map(bo -> bo.getFiledId()).collect(Collectors.toList());
        }
        return ReceiverApiHelper.getLeaderUserId(personIdList, HRPIWorkRoleServiceHelper.getDirectSuperior(personIds));
    }

    public static List<ReceiverFieldResultBo> getLeaderByEmployee(List<ReceiverFieldResultBo> employeeIdList) {
        if (CollectionUtils.isEmpty(employeeIdList)) {
            return Collections.EMPTY_LIST;
        }
        List idList = employeeIdList.stream().map(bo -> bo.getPersonId()).collect(Collectors.toList());
        Map apiResult = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIWorkRoleService", (String)"getDirectSuperior", (Object[])new Object[]{idList});
        block0: for (Map.Entry entry : apiResult.entrySet()) {
            List dataList = (List)entry.getValue();
            HashMap superiorMap = Maps.newHashMapWithExpectedSize((int)16);
            for (Map mapData : dataList) {
                superiorMap.put((Long)mapData.get("person.id"), null);
            }
            for (ReceiverFieldResultBo receiver : employeeIdList) {
                if (!((Long)entry.getKey()).equals(receiver.getPersonId())) continue;
                receiver.setSuperiorPersonMap(superiorMap);
                continue block0;
            }
        }
        List<ReceiverFieldResultBo> superiorUserIdList = ReceiverApiHelper.getUserIdByPersonOrEmployee(employeeIdList, "person");
        return superiorUserIdList;
    }

    public static List<ReceiverFieldResultBo> getLeaderByDepemp(List<ReceiverFieldResultBo> depempIdList) {
        List depempIds = depempIdList.stream().map(bo -> bo.getFiledId()).collect(Collectors.toList());
        return ReceiverApiHelper.getLeaderUserId(depempIdList, HRPIWorkRoleServiceHelper.getDirectSuperiorByDepempId(depempIds));
    }

    private static List<ReceiverFieldResultBo> getLeaderUserId(List<ReceiverFieldResultBo> personIdList, Map<Long, List<Map<String, Object>>> map) {
        block0: for (Map.Entry<Long, List<Map<String, Object>>> entry : map.entrySet()) {
            for (ReceiverFieldResultBo receiverFieldResultBo : personIdList) {
                if (!entry.getKey().equals(receiverFieldResultBo.getFiledId())) continue;
                HashMap superiorPersonMap = Maps.newHashMapWithExpectedSize((int)16);
                List<Map<String, Object>> dataList = entry.getValue();
                for (Map<String, Object> mapData : dataList) {
                    superiorPersonMap.put((Long)mapData.get("person.id"), null);
                }
                receiverFieldResultBo.setSuperiorPersonMap(superiorPersonMap);
                continue block0;
            }
        }
        return ReceiverApiHelper.getUserIdByPersonOrEmployee(personIdList, "person");
    }
}

